/*
 * Decompiled with CFR 0.152.
 */
package asemon.gui;

import asemon.AseConfig;
import asemon.AseConfigText;
import asemon.GetCounters;
import asemon.MonTablesDictionary;
import asemon.Version;
import asemon.gui.ConnectionDialog;
import asemon.gui.ConnectionProgressCallback;
import asemon.hostmon.SshConnection;
import asemon.utils.AseConnectionFactory;
import asemon.utils.AseConnectionUtils;
import asemon.utils.AseUrlHelper;
import asemon.utils.StringUtil;
import asemon.utils.SwingUtils;
import asemon.utils.SwingWorker;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnExt;

public class ConnectionProgressDialog
extends JDialog
implements ActionListener,
ConnectionProgressCallback {
    private static Logger _logger = Logger.getLogger(ConnectionProgressDialog.class);
    private static final long serialVersionUID = 1L;
    private static final int TAB_POS_ICON = 0;
    private static final int TAB_POS_HOST_PORT = 1;
    private static final int TAB_POS_STATUS = 2;
    private static final int TAB_POS_INFO = 3;
    private static final String TASK_STATUS_CURRENT_TEXT = "Executing";
    private static final String TASK_STATUS_SUCCEEDED_TEXT = "Completed";
    private static final String TASK_STATUS_FAILED_TEXT = "Failed";
    private static final String TASK_STATUS_SKIPPED_TEXT = "Skipped";
    private static final String HIDE_DETAILS_STR = "<< Details";
    private static final String SHOW_DETAILS_STR = "Details >>";
    private ConnectionProgressDialog _thisDialog = this;
    private SwingWorker _doConnectWorker = null;
    private Connection _connection = null;
    private SshConnection _sshConnection = null;
    private Exception _exception = null;
    private ImageIcon _ase_icon = SwingUtils.readImageIcon(Version.class, "images/ase32.gif");
    private ImageIcon _task_current_icon = SwingUtils.readImageIcon(Version.class, "images/task_current.png");
    private ImageIcon _task_succeeded_icon = SwingUtils.readImageIcon(Version.class, "images/task_succeeded.png");
    private ImageIcon _task_skipped_icon = SwingUtils.readImageIcon(Version.class, "images/task_skipped.png");
    private ImageIcon _task_failed_icon = SwingUtils.readImageIcon(Version.class, "images/tak_failed.png");
    private JLabel _status_icon = new JLabel(this._ase_icon);
    private JLabel _server_lbl = new JLabel();
    private JLabel _status_lbl = new JLabel();
    private JLabel _progress_lbl = new JLabel();
    private JProgressBar _progress = new JProgressBar(0, 0, 100);
    private JButton _hide_but = new JButton("Hide");
    private JButton _stop_but = new JButton("Stop");
    private JButton _detailes_but = new JButton("<< Details");
    private JSeparator _separator = new JSeparator(0);
    private JXTable _task_tab = null;
    private JLabel _buttomStatus_lbl = new JLabel();
    private String _urlStr = null;
    private List<String> _taskList = new ArrayList<String>();
    private AseUrlHelper _urlHelper = null;
    private static final String TASK_SSH_CONNECT = "Host Monitor Connection, SSH";
    private static final String EXTRA_TASK_CHECK_MONITOR_CONFIG = "Check Monitor Configuration";
    private static final String EXTRA_TASK_INIT_MONITOR_DICT = "Init Monitor Dictionary";
    private static final String EXTRA_TASK_INIT_COUNTER_COLLECTOR = "Init Counter Collector";
    private boolean _doExtraTasks = true;
    private Timer _progressTimer = null;
    private Dimension _rememberShowMode = null;
    private static final int TIMER_INITIAL_WAIT = 200;
    private static final int TIMER_PROGRESS_WAIT = 200;
    private static String _fixme_jdbcDriver = null;
    private static String _fixme_rawUrl = null;
    private static Properties _fixme_props = null;

    public static Connection connectWithProgressDialog(Window owner, String driver, String rawUrl, Properties props, boolean doExtraTasks, SshConnection sshConn) throws Exception {
        _fixme_jdbcDriver = driver;
        _fixme_rawUrl = rawUrl;
        _fixme_props = props;
        return ConnectionProgressDialog.connectWithProgressDialog(owner, rawUrl, doExtraTasks, sshConn);
    }

    public static Connection connectWithProgressDialog(Window owner, String urlStr, boolean doExtraTasks, SshConnection sshConn) throws Exception {
        ConnectionProgressDialog cpd = null;
        if (owner instanceof Dialog) {
            cpd = new ConnectionProgressDialog((Dialog)owner, urlStr, doExtraTasks, sshConn);
        } else if (owner instanceof Frame) {
            cpd = new ConnectionProgressDialog((Frame)owner, urlStr, doExtraTasks, sshConn);
        } else {
            throw new IllegalAccessException("owner parameter can only be of the object types 'Dialog' or 'Frame'.");
        }
        cpd.doBackgroundConnect();
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException ignore) {
            // empty catch block
        }
        if (cpd._connection == null) {
            cpd.setVisible(true);
        }
        _logger.debug((Object)("hasConnection=" + (cpd._connection != null) + ", hasException=" + (cpd._exception != null)));
        if (cpd._connection != null) {
            return cpd._connection;
        }
        if (cpd._exception != null) {
            throw cpd._exception;
        }
        return null;
    }

    private ConnectionProgressDialog(Dialog owner, String urlStr, boolean doExtraTasks, SshConnection sshConn) {
        super(owner, true);
        this.init(owner, urlStr, doExtraTasks, sshConn);
    }

    private ConnectionProgressDialog(Frame owner, String urlStr, boolean doExtraTasks, SshConnection sshConn) {
        super(owner, true);
        this.init(owner, urlStr, doExtraTasks, sshConn);
    }

    private void init(Component owner, String urlStr, boolean doExtraTasks, SshConnection sshConn) {
        this._urlStr = urlStr;
        this._doExtraTasks = doExtraTasks;
        this._sshConnection = sshConn;
        String[] extraTasks = new String[]{EXTRA_TASK_CHECK_MONITOR_CONFIG, EXTRA_TASK_INIT_MONITOR_DICT, EXTRA_TASK_INIT_COUNTER_COLLECTOR};
        if (!this._doExtraTasks) {
            extraTasks = null;
        }
        try {
            if (this._sshConnection != null) {
                this.addTask(TASK_SSH_CONNECT);
            }
            this._urlHelper = AseUrlHelper.parseUrl(this._urlStr);
            this.addTask(this._urlHelper.getHostPortArr());
            this.addTask(extraTasks);
            String server = this._urlHelper.getServerName();
            if (server != null) {
                this._server_lbl.setText("<html>Connecting to Server: <b>" + server + "</b></html>");
            } else {
                this._server_lbl.setText("<html><center>Server is not in the interfaces file<br>Instead, the host:port model will be used.</center></html>");
            }
            int ticksPerSecond = 5;
            int timeoutInSecPerEntry = 10;
            int hostPortCount = this._urlHelper.getHostPortCount();
            this._progress.setMaximum(ticksPerSecond * timeoutInSecPerEntry * hostPortCount);
            _logger.debug((Object)("_progress.getMaximum()=" + this._progress.getMaximum()));
        }
        catch (ParseException ignore) {
            // empty catch block
        }
        this._status_lbl.setText("");
        this._progressTimer = new Timer(200, this);
        this._progressTimer.setInitialDelay(200);
        this._progressTimer.setDelay(200);
        this.initComponents();
        this.pack();
        Dimension size = this.getPreferredSize();
        size.width = 490;
        size.height = 320;
        this.setPreferredSize(size);
        this.setSize(size);
        this.setLocationRelativeTo(owner);
    }

    protected void initComponents() {
        this.setTitle("Connection Progress");
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("ins 0", "[fill]", ""));
        panel.add((Component)this.getProgressPanel(), "push, grow");
        panel.add((Component)this.getButtomPanel(), "wrap 20");
        panel.add((Component)this._separator, "span 2, push, grow, wrap");
        panel.add((Component)this.getTaskPanel(), "span 2, push, grow, wrap");
        panel.add((Component)this._buttomStatus_lbl, "span 2, bottom, push, grow, wrap");
        this.setContentPane(panel);
    }

    protected JPanel getProgressPanel() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout());
        panel.add((Component)this._status_icon, "gapleft 20, spany 3");
        panel.add((Component)this._server_lbl, "align 50%, push, grow, wrap");
        panel.add((Component)this._status_lbl, "align 50%, push, grow, wrap");
        panel.add((Component)this._progress_lbl, "align 50%, push, grow, wrap");
        panel.add((Component)this._progress, "gapleft 10, span 2, push, grow, wrap");
        return panel;
    }

    protected JPanel getButtomPanel() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout());
        panel.add((Component)this._hide_but, "push, grow, wrap");
        panel.add((Component)this._stop_but, "push, grow, wrap");
        panel.add((Component)this._detailes_but, "push, grow, wrap");
        this._hide_but.setEnabled(false);
        this._stop_but.setEnabled(true);
        this._hide_but.addActionListener(this);
        this._stop_but.addActionListener(this);
        this._detailes_but.addActionListener(this);
        return panel;
    }

    protected JPanel getTaskPanel() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout());
        this._task_tab = this.createTable();
        this._task_tab.setModel(this.createTableModel());
        this.calcTabWidth();
        panel.add((Component)new JScrollPane((Component)this._task_tab), "push, grow");
        return panel;
    }

    protected JXTable createTable() {
        final JXTable tab = new JXTable(){
            private static final long serialVersionUID = 1L;

            public String getToolTipText(MouseEvent e) {
                String tip = null;
                Point p = e.getPoint();
                int row = super.convertRowIndexToModel(this.rowAtPoint(p) < 0 ? 0 : this.rowAtPoint(p));
                int col = super.convertColumnIndexToModel(this.columnAtPoint(p));
                if (col == 3 && row >= 0) {
                    Object o = this.getModel().getValueAt(row, col);
                    if (o instanceof SQLException) {
                        SQLException sqlex = (SQLException)o;
                        String msg = "";
                        msg = msg + "-- BEGIN - SQLWarning/SQLException chain ----------------\n";
                        msg = msg + AseConnectionUtils.getMessageFromSQLException(sqlex) + "\n";
                        msg = msg + "-- END - SQLWarning/SQLException chain ------------------\n";
                        msg = msg + "Stacktrace:\n";
                        tip = "<pre>" + msg + StringUtil.stackTraceToString(sqlex) + "</pre>";
                    } else if (o instanceof Exception) {
                        Exception ex = (Exception)o;
                        tip = "<pre>" + StringUtil.stackTraceToString(ex) + "</pre>";
                    }
                }
                if (tip == null) {
                    return null;
                }
                return "<html>" + tip + "</html>";
            }
        };
        tab.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    Object o;
                    Point p = e.getPoint();
                    int row = tab.rowAtPoint(p);
                    int col = tab.columnAtPoint(p);
                    if (row >= 0 && col >= 0 && (o = tab.getModel().getValueAt(row, 3)) instanceof Exception) {
                        SwingUtils.showErrorMessage(ConnectionProgressDialog.this._thisDialog, "Problems Connecting", "Problems when connecting to the data server.\n\n" + ((Exception)o).getMessage(), (Exception)o);
                    }
                }
            }
        });
        tab.setShowGrid(false);
        tab.setSortable(false);
        tab.setSelectionMode(0);
        tab.setAutoResizeMode(0);
        tab.setColumnControlVisible(false);
        return tab;
    }

    protected TableModel createTableModel() {
        String[] colHeader = new String[]{"", "Host and Port", "Status", "Message"};
        Vector<String> columns = new Vector<String>();
        for (int i = 0; i < colHeader.length; ++i) {
            columns.add(colHeader[i]);
        }
        Vector rows = new Vector();
        Vector<String> row = null;
        for (int i = 0; i < this._taskList.size(); ++i) {
            row = new Vector<String>();
            row.add(null);
            row.add(this._taskList.get(i));
            row.add("");
            row.add("");
            rows.add(row);
        }
        DefaultTableModel model = new DefaultTableModel(rows, columns){
            private static final long serialVersionUID = 1L;

            @Override
            public Class<?> getColumnClass(int column) {
                if (column == 0) {
                    return Icon.class;
                }
                return Object.class;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        return model;
    }

    private void calcTabWidth() {
        this._task_tab.packAll();
        Dimension wind = this.getPreferredSize();
        int firstColWidth = -1;
        int lastColWidth = -1;
        int cols = this._task_tab.getColumnCount();
        for (int c = 0; c < cols; ++c) {
            TableColumnExt tce = this._task_tab.getColumnExt(c);
            lastColWidth = tce.getPreferredWidth();
            if (c < cols - 1) {
                firstColWidth += lastColWidth;
            }
            if (c != cols - 1) continue;
            tce.setPreferredWidth(Math.max(wind.width - 25 - firstColWidth, lastColWidth));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (this._hide_but.equals(source)) {
            _logger.debug((Object)"button: HIDE was pressed");
            this.setVisible(false);
        }
        if (this._stop_but.equals(source)) {
            _logger.debug((Object)"button: STOP was pressed");
            if (this._doConnectWorker != null) {
                this._doConnectWorker.interrupt();
            }
        }
        if (this._detailes_but.equals(source)) {
            _logger.debug((Object)"button: DETAILES was pressed");
            if (this._detailes_but.getText().equals(HIDE_DETAILS_STR)) {
                this._rememberShowMode = this.getSize();
                Point p = this._separator.getLocation();
                int height = p.y + 20;
                this.setSize(this._rememberShowMode.width, height);
                this._detailes_but.setText(SHOW_DETAILS_STR);
            } else {
                this.setSize(this.getSize().width, this._rememberShowMode.height);
                this._detailes_but.setText(HIDE_DETAILS_STR);
            }
        }
        if (this._progressTimer.equals(source)) {
            this.incProgress();
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible && this._doConnectWorker == null) {
            this.doBackgroundConnect();
        }
        super.setVisible(visible);
    }

    public void incProgress() {
        int max;
        int now = this._progress.getValue();
        if (now >= (max = this._progress.getMaximum())) {
            now = 0;
        }
        this._progress.setValue(now + 1);
    }

    @Override
    public void setFinalStatus(int status) {
        this.setFinalStatus(status, null);
    }

    @Override
    public void setFinalStatus(int status, Object infoObj) {
        if (status != 1 && status != 2) {
            String msg = "setFinalStatus: Unknown status '" + status + "'. know statuses 'FINAL_STATUS_SUCCEEDED | FINAL_STATUS_FAILED'.";
            _logger.error((Object)msg);
            throw new IllegalArgumentException(msg);
        }
        if (status == 1) {
            this._buttomStatus_lbl.setText("SUCCESS");
        }
        if (status == 2) {
            String msg = infoObj + "";
            if (infoObj instanceof SQLException) {
                msg = ((SQLException)infoObj).getMessage();
            }
            this._buttomStatus_lbl.setText("<html><font color=\"red\"><b>FAILURE:</b> " + msg + "</font></html>");
        }
        this._progress.setValue(this._progress.getMaximum());
        if (this._progressTimer.isRunning()) {
            this._progressTimer.stop();
        }
    }

    public void addTask(String[] taskStrArr) {
        if (taskStrArr == null) {
            return;
        }
        if (taskStrArr.length <= 0) {
            return;
        }
        for (String taskStr : taskStrArr) {
            this.addTask(taskStr);
        }
    }

    public void addTask(String taskStr) {
        this._taskList.add(taskStr);
    }

    @Override
    public void setTaskStatus(String hostPortStr, int status) {
        this.setTaskStatus(hostPortStr, status, "");
    }

    @Override
    public void setTaskStatus(String taskName, int status, Object infoObj) {
        if (!SwingUtils.isEventQueueThread()) {
            final String finalTaskName = taskName;
            final int finalStatus = status;
            final Object finalInfoObj = infoObj;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ConnectionProgressDialog.this.setTaskStatus(finalTaskName, finalStatus, finalInfoObj);
                }
            });
            return;
        }
        String urlStartTemplate = "jdbc:sybase:Tds:";
        if (taskName.startsWith(urlStartTemplate)) {
            taskName = taskName.substring(urlStartTemplate.length());
        }
        if (taskName.indexOf("/") >= 0) {
            taskName = taskName.substring(0, taskName.indexOf("/"));
        }
        if (taskName.indexOf("?") >= 0) {
            taskName = taskName.substring(0, taskName.indexOf("?"));
        }
        TableModel tm = this._task_tab.getModel();
        int rowForTaskCheckMonitorConfig = -1;
        for (int r = 0; r < tm.getRowCount(); ++r) {
            String thisTaskName = (String)tm.getValueAt(r, 1);
            if (!thisTaskName.equals(EXTRA_TASK_CHECK_MONITOR_CONFIG)) continue;
            rowForTaskCheckMonitorConfig = r;
        }
        boolean foundTask = false;
        for (int r = 0; r < tm.getRowCount(); ++r) {
            String hostPort = (String)tm.getValueAt(r, 1);
            _logger.debug((Object)("-in-hostPort='" + taskName + "', -row-" + r + "-hostPort='" + hostPort + "'."));
            if (!hostPort.equals(taskName)) continue;
            foundTask = true;
            if (status == 0) {
                if (!this._progressTimer.isRunning()) {
                    this._progressTimer.start();
                }
                if (EXTRA_TASK_CHECK_MONITOR_CONFIG.equals(taskName)) {
                    for (int x = 0; x < rowForTaskCheckMonitorConfig; ++x) {
                        Object iconObj = tm.getValueAt(x, 0);
                        if (iconObj != null) continue;
                        tm.setValueAt(this._task_skipped_icon, x, 0);
                        tm.setValueAt(TASK_STATUS_SKIPPED_TEXT, x, 2);
                    }
                }
                _logger.debug((Object)("Setting: '" + hostPort + "', to='" + TASK_STATUS_CURRENT_TEXT + "', ICON=" + this._task_current_icon));
                tm.setValueAt(this._task_current_icon, r, 0);
                tm.setValueAt(TASK_STATUS_CURRENT_TEXT, r, 2);
                tm.setValueAt(infoObj, r, 3);
                this._progress_lbl.setText("<html>Trying entry: <b>" + taskName + "</b></html>");
                continue;
            }
            if (status == 1) {
                _logger.debug((Object)("Setting: '" + hostPort + "', to='" + TASK_STATUS_SUCCEEDED_TEXT + "', ICON=" + this._task_succeeded_icon));
                tm.setValueAt(this._task_succeeded_icon, r, 0);
                tm.setValueAt(TASK_STATUS_SUCCEEDED_TEXT, r, 2);
                tm.setValueAt(infoObj, r, 3);
                this._progress_lbl.setText("<html>Succeeded connecting to: <b>" + taskName + "</b></html>");
                this._progress.setValue(this._progress.getMaximum());
                if (!this._progressTimer.isRunning()) continue;
                this._progressTimer.stop();
                continue;
            }
            if (status == 2) {
                _logger.debug((Object)("Setting: '" + hostPort + "', to='" + TASK_STATUS_SKIPPED_TEXT + "', ICON=" + this._task_skipped_icon));
                tm.setValueAt(this._task_skipped_icon, r, 0);
                tm.setValueAt(TASK_STATUS_SKIPPED_TEXT, r, 2);
                tm.setValueAt(infoObj, r, 3);
                this._progress_lbl.setText("<html>Skipping task: <b>" + taskName + "</b></html>");
                continue;
            }
            if (status == 3 || status == 4) {
                _logger.debug((Object)("Setting: '" + hostPort + "', to='" + 3 + "', ICON=" + this._task_failed_icon));
                tm.setValueAt(this._task_failed_icon, r, 0);
                tm.setValueAt(TASK_STATUS_FAILED_TEXT, r, 2);
                tm.setValueAt(infoObj, r, 3);
                this._progress_lbl.setText("<html>Failed connection to: <b>" + taskName + "</b></html>");
                if (r != tm.getRowCount() - 1 && status != 4) continue;
                this._progress_lbl.setText("");
                this._status_lbl.setText("<html>Connection to <b>ALL</b> host:port entries <b><font color=\"red\">FAILED</font></b></html>");
                this._progress.setValue(this._progress.getMaximum());
                if (!this._progressTimer.isRunning()) continue;
                this._progressTimer.stop();
                continue;
            }
            _logger.error((Object)("hostPort='" + taskName + "', UNKNOWN STATUS=" + status));
        }
        this.calcTabWidth();
        if (!foundTask) {
            _logger.warn((Object)("in-hostPort='" + taskName + "', was NOT found in tab."));
        }
    }

    private void doBackgroundConnect() {
        this._doConnectWorker = new SwingWorker(){

            @Override
            public Object construct() {
                Thread.currentThread().setName("ConnectionProgressDialog");
                try {
                    block12: {
                        if (ConnectionProgressDialog.this._sshConnection != null) {
                            try {
                                ConnectionProgressDialog.this.setTaskStatus(ConnectionProgressDialog.TASK_SSH_CONNECT, 0);
                                ConnectionProgressDialog.this._sshConnection.connect();
                                ConnectionProgressDialog.this.setTaskStatus(ConnectionProgressDialog.TASK_SSH_CONNECT, 1);
                            }
                            catch (Exception ex) {
                                int answer;
                                ConnectionProgressDialog.this.setTaskStatus(ConnectionProgressDialog.TASK_SSH_CONNECT, 3, ex);
                                String hostmonMsg = "Error message from the Host Monitor Connection attempt:<BR>" + ex.getMessage() + "<BR>";
                                Throwable cause = ex.getCause();
                                if (cause != null) {
                                    hostmonMsg = hostmonMsg + "<BR><b>Reason:</b> " + cause;
                                }
                                if ((answer = JOptionPane.showConfirmDialog(ConnectionProgressDialog.this._thisDialog, "<html>Errors when trying to get a Host Monitoring Connection<BR>Do you want to <b>continue</b> the connection to the ASE Server, with the <b>Host Monitoring option disabled?</b><BR><BR>" + hostmonMsg + "</html>", ConnectionProgressDialog.TASK_SSH_CONNECT, 0, 0)) == 0) break block12;
                                throw ex;
                            }
                        }
                    }
                    _logger.debug((Object)("SwingWorker.construct(): fixme_jdbcDriver='" + _fixme_jdbcDriver + "', fixme_rawUrl='" + _fixme_rawUrl + "', fixme_props='" + _fixme_props + "'."));
                    if (_fixme_jdbcDriver != null && _fixme_rawUrl != null) {
                        _logger.debug((Object)"SwingWorker.construct() does: RAW_URL: AseConnectionFactory.getConnection(fixme_jdbcDriver, _fixme_rawUrl, fixme_props, thisDialog)");
                        Connection conn = AseConnectionFactory.getConnection(_fixme_jdbcDriver, _fixme_rawUrl, _fixme_props, ConnectionProgressDialog.this._thisDialog);
                        ConnectionProgressDialog.this._connection = conn;
                    } else {
                        _logger.debug((Object)"SwingWorker.construct() does: NORMAL: AseConnectionFactory.getConnection(thisDialog)");
                        Connection conn = AseConnectionFactory.getConnection(ConnectionProgressDialog.this._thisDialog);
                        if (conn != null && ConnectionProgressDialog.this._doExtraTasks) {
                            Exception ex;
                            ConnectionProgressDialog.this.setTaskStatus(ConnectionProgressDialog.EXTRA_TASK_CHECK_MONITOR_CONFIG, 0);
                            boolean monCheckOk = AseConnectionUtils.checkForMonitorOptions(conn, null, true, ConnectionProgressDialog.this._thisDialog, "enable monitoring");
                            if (!monCheckOk) {
                                ex = new Exception("The system is not properly configured for monitoring.");
                                ConnectionProgressDialog.this.setTaskStatus(ConnectionProgressDialog.EXTRA_TASK_CHECK_MONITOR_CONFIG, 3, ex);
                                ConnectionProgressDialog.this.setTaskStatus(ConnectionProgressDialog.EXTRA_TASK_INIT_MONITOR_DICT, 2);
                                ConnectionProgressDialog.this.setTaskStatus(ConnectionProgressDialog.EXTRA_TASK_INIT_COUNTER_COLLECTOR, 2);
                                throw ex;
                            }
                            ConnectionProgressDialog.this.setTaskStatus(ConnectionProgressDialog.EXTRA_TASK_CHECK_MONITOR_CONFIG, 1);
                            ConnectionProgressDialog.this.setTaskStatus(ConnectionProgressDialog.EXTRA_TASK_INIT_MONITOR_DICT, 0);
                            if (!ConnectionDialog.checkReconnectVersion(conn)) {
                                ex = new Exception("Connecting to a different ASE Version, This is NOT supported now...");
                                ConnectionProgressDialog.this.setTaskStatus(ConnectionProgressDialog.EXTRA_TASK_INIT_MONITOR_DICT, 3, ex);
                                ConnectionProgressDialog.this.setTaskStatus(ConnectionProgressDialog.EXTRA_TASK_INIT_COUNTER_COLLECTOR, 2);
                                throw ex;
                            }
                            MonTablesDictionary.getInstance().initialize(conn, true);
                            GetCounters.initExtraMonTablesDictionary();
                            AseConfig aseCfg = AseConfig.getInstance();
                            if (!aseCfg.isInitialized()) {
                                aseCfg.initialize(conn, true, false, null);
                            }
                            AseConfigText.initializeAll(conn, true, false, null);
                            ConnectionProgressDialog.this.setTaskStatus(ConnectionProgressDialog.EXTRA_TASK_INIT_MONITOR_DICT, 1);
                            ConnectionProgressDialog.this.setTaskStatus(ConnectionProgressDialog.EXTRA_TASK_INIT_COUNTER_COLLECTOR, 0);
                            GetCounters.getInstance().initCounters(conn, true, MonTablesDictionary.getInstance().aseVersionNum, MonTablesDictionary.getInstance().isClusterEnabled, MonTablesDictionary.getInstance().montablesVersionNum);
                            ConnectionProgressDialog.this.setTaskStatus(ConnectionProgressDialog.EXTRA_TASK_INIT_COUNTER_COLLECTOR, 1);
                        }
                        ConnectionProgressDialog.this._connection = conn;
                    }
                    return ConnectionProgressDialog.this._connection;
                }
                catch (Exception e) {
                    ConnectionProgressDialog.this._exception = e;
                    return e;
                }
            }

            @Override
            public void finished() {
                ConnectionProgressDialog.this._hide_but.setEnabled(true);
                ConnectionProgressDialog.this._stop_but.setEnabled(false);
                Object output = this.get();
                _logger.debug((Object)("Worker OUT: " + output));
                if (output != null) {
                    if (output instanceof Connection) {
                        Connection conn = (Connection)output;
                        _logger.debug((Object)("Worker OUT-Connection: " + conn));
                        ConnectionProgressDialog.this._connection = conn;
                        ConnectionProgressDialog.this.setFinalStatus(1);
                        ConnectionProgressDialog.this.setVisible(false);
                    } else if (output instanceof Exception) {
                        Exception ex = (Exception)output;
                        _logger.debug((Object)("Worker OUT-Exception: " + ex), (Throwable)ex);
                        ConnectionProgressDialog.this._exception = ex;
                        ConnectionProgressDialog.this.setFinalStatus(2, ex);
                    } else {
                        _logger.error((Object)("Unknown output from the background swing worker was found. type=" + output.getClass().getName() + ", object.toString='" + output.toString() + "'."));
                    }
                } else {
                    ConnectionProgressDialog.this.setFinalStatus(2, "The output from the worker thread was 'null'. This can't be right.");
                }
            }

            @Override
            public void interrupt() {
            }
        };
        this._doConnectWorker.start();
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ignore) {
            // empty catch block
        }
        String server = "AAA_CE_DS";
        String hostPortStr = AseConnectionFactory.getIHostPortStr(server);
        AseConnectionFactory.setUser("sa");
        AseConnectionFactory.setPassword("");
        AseConnectionFactory.setServer(server);
        System.out.println("Connectiong to server='" + server + "'. Which is located on '" + hostPortStr + "'.");
        String urlStr = "jdbc:sybase:Tds:" + AseConnectionFactory.getHostPortStr();
        TestFrame frame = new TestFrame(urlStr);
        ((Window)frame).setVisible(true);
    }

    private static class TestFrame
    extends JFrame
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        private int _dummyCounter = 0;
        private String _hostPortUrl = "";
        private JLabel _hostPortUrl_lbl = new JLabel();
        private JLabel _dummyCounter_lbl = new JLabel();
        private JButton _connect_but = new JButton("Connect");
        private Timer _dummyTimer = new Timer(100, this);

        public TestFrame(String url) {
            this.setSize(500, 500);
            this.setDefaultCloseOperation(3);
            this._hostPortUrl = url;
            this._hostPortUrl_lbl.setText(this._hostPortUrl);
            JPanel panel = new JPanel();
            panel.setLayout((LayoutManager)new MigLayout());
            panel.add((Component)this._hostPortUrl_lbl, "wrap");
            panel.add((Component)this._dummyCounter_lbl, "wrap");
            panel.add((Component)this._connect_but, "wrap");
            this.setContentPane(panel);
            this._connect_but.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (this._dummyTimer.equals(source)) {
                ++this._dummyCounter;
                this._dummyCounter_lbl.setText("Dummy counter at: " + this._dummyCounter);
            }
            if (this._connect_but.equals(source)) {
                System.out.println("CONNECT WAS Pressed...");
                this.tryConnect();
            }
        }

        @Override
        public void setVisible(boolean visible) {
            if (visible) {
                this._dummyTimer.start();
            } else {
                this._dummyTimer.stop();
            }
            super.setVisible(visible);
        }

        private void tryConnect() {
            try {
                Connection conn = ConnectionProgressDialog.connectWithProgressDialog(this, this._hostPortUrl, true, null);
                System.out.println("Connection returned. conn=" + conn);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

