/*
 * Decompiled with CFR 0.152.
 */
package asemon.gui;

import asemon.gui.Log4jLogRecord;
import asemon.gui.Log4jTableModel;
import java.util.Enumeration;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Logger;
import org.apache.log4j.lf5.LogLevel;
import org.apache.log4j.lf5.LogLevelFormatException;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;

public class GuiLogAppender
extends AppenderSkeleton {
    private Log4jTableModel _logTable = new Log4jTableModel();
    private static GuiLogAppender _instance = null;

    public GuiLogAppender() {
        this.setName("GuiLogAppender");
        _instance = this;
        boolean isInstalled = false;
        Enumeration en = Logger.getRootLogger().getAllAppenders();
        while (en.hasMoreElements()) {
            Appender a = (Appender)en.nextElement();
            if (!a.equals((Object)this)) continue;
            isInstalled = true;
        }
        if (!isInstalled) {
            Logger.getRootLogger().addAppender((Appender)this);
        }
    }

    protected void append(LoggingEvent event) {
        String category = event.getLoggerName();
        String logMessage = event.getRenderedMessage();
        String nestedDiagnosticContext = event.getNDC();
        String threadDescription = event.getThreadName();
        String level = event.getLevel().toString();
        long time = event.timeStamp;
        LocationInfo locationInfo = event.getLocationInformation();
        Log4jLogRecord record = new Log4jLogRecord();
        record.setCategory(category);
        record.setMessage(logMessage);
        record.setLocation(locationInfo.fullInfo);
        record.setMillis(time);
        record.setThreadDescription(threadDescription);
        if (nestedDiagnosticContext != null) {
            record.setNDC(nestedDiagnosticContext);
        } else {
            record.setNDC("");
        }
        if (event.getThrowableInformation() != null) {
            record.setThrownStackTrace(event.getThrowableInformation());
        }
        try {
            record.setLevel(LogLevel.valueOf((String)level));
        }
        catch (LogLevelFormatException e) {
            record.setLevel(LogLevel.WARN);
        }
        if (this._logTable != null) {
            this._logTable.addMessage(record);
        }
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return false;
    }

    public static synchronized GuiLogAppender getInstance() {
        if (_instance == null) {
            _instance = new GuiLogAppender();
        }
        return _instance;
    }

    public static Log4jTableModel getTableModel() {
        if (_instance == null) {
            return null;
        }
        return GuiLogAppender.getInstance()._logTable;
    }

    static {
        LogLevel.register((LogLevel)new LogLevel("TRACE", 5));
    }
}

