/*
 * Decompiled with CFR 0.152.
 */
package asemon.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.AbstractBorder;

public class LineNumberedBorder
extends AbstractBorder {
    private static final long serialVersionUID = -2029404543137395812L;
    public static int LEFT_SIDE = -2;
    public static int RIGHT_SIDE = -1;
    public static int RIGHT_JUSTIFY = 0;
    public static int LEFT_JUSTIFY = 1;
    private int lineNumberJustification = RIGHT_JUSTIFY;
    private int location = LEFT_SIDE;

    public static void main(String[] args) {
        JFrame frame = new JFrame("Line Numbers (as Borders)...");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ev) {
                System.exit(0);
            }
        });
        Container contentPane = frame.getContentPane();
        contentPane.setLayout(new GridLayout(0, 2));
        int[] sides = new int[]{LEFT_SIDE, LEFT_SIDE, RIGHT_SIDE, RIGHT_SIDE};
        int[] justified = new int[]{LEFT_JUSTIFY, RIGHT_JUSTIFY, LEFT_JUSTIFY, RIGHT_JUSTIFY};
        String[] labels = new String[]{"Left Side/Left Justified", "Left Side/Right Justified", "Right Side/Left Justified", "Right Side/Right Justified"};
        boolean useMultipleBorders = false;
        if (args.length > 0 && "multiple".equals(args[0])) {
            useMultipleBorders = true;
        }
        for (int idx = 0; idx < labels.length; ++idx) {
            JTextArea textArea = new JTextArea(10, 10);
            LineNumberedBorder lnb = new LineNumberedBorder(sides[idx], justified[idx]);
            if (useMultipleBorders) {
                textArea.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.red, 1), BorderFactory.createCompoundBorder(lnb, BorderFactory.createLineBorder(Color.blue, 1)))));
            } else {
                textArea.setBorder(lnb);
            }
            JPanel subpanel = new JPanel(new BorderLayout());
            subpanel.add((Component)new JLabel(labels[idx]), "North");
            subpanel.add((Component)new JScrollPane(textArea), "Center");
            contentPane.add(subpanel);
        }
        frame.setSize(800, 600);
        frame.setVisible(true);
    }

    public LineNumberedBorder(int location, int justify) {
        this.setLocation(location);
        this.setLineNumberJustification(justify);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        if (c instanceof JTextArea) {
            int width = this.lineNumberWidth((JTextArea)c);
            if (this.location == LEFT_SIDE) {
                insets.left = width;
            } else {
                insets.right = width;
            }
        }
        return insets;
    }

    public int getLineNumberJustification() {
        return this.lineNumberJustification;
    }

    public void setLineNumberJustification(int justify) {
        if (justify == RIGHT_JUSTIFY || justify == LEFT_JUSTIFY) {
            this.lineNumberJustification = justify;
        }
    }

    public int getLocation() {
        return this.location;
    }

    public void setLocation(int loc) {
        if (loc == RIGHT_SIDE || loc == LEFT_SIDE) {
            this.location = loc;
        }
    }

    private int lineNumberWidth(JTextArea textArea) {
        int lineCount = Math.max(textArea.getRows(), textArea.getLineCount() + 1);
        return textArea.getFontMetrics(textArea.getFont()).stringWidth(lineCount + " ");
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        int yend;
        Rectangle clip = g.getClipBounds();
        FontMetrics fm = g.getFontMetrics();
        int fontHeight = fm.getHeight();
        int ybaseline = y + fm.getAscent();
        int startingLineNumber = clip.y / fontHeight + 1;
        if (ybaseline < clip.y) {
            ybaseline = y + startingLineNumber * fontHeight - (fontHeight - fm.getAscent());
        }
        if ((yend = ybaseline + height) > y + height) {
            yend = y + height;
        }
        JTextArea jta = (JTextArea)c;
        int lineWidth = this.lineNumberWidth(jta);
        int lnxstart = x;
        lnxstart = this.location == LEFT_SIDE ? (this.lineNumberJustification == LEFT_JUSTIFY ? x : x + lineWidth) : (this.lineNumberJustification == LEFT_JUSTIFY ? y + width - lineWidth : y + width);
        g.setColor(c.getForeground());
        int length = ("" + Math.max(jta.getRows(), jta.getLineCount() + 1)).length();
        while (ybaseline < yend) {
            if (this.lineNumberJustification == LEFT_JUSTIFY) {
                g.drawString(startingLineNumber + " ", lnxstart, ybaseline);
            } else {
                String label = LineNumberedBorder.padLabel(startingLineNumber, length, true);
                g.drawString(label, lnxstart - fm.stringWidth(label), ybaseline);
            }
            ybaseline += fontHeight;
            ++startingLineNumber;
        }
    }

    private static String padLabel(int lineNumber, int length, boolean addSpace) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(lineNumber);
        for (int count = length - buffer.length(); count > 0; --count) {
            buffer.insert(0, ' ');
        }
        if (addSpace) {
            buffer.append(' ');
        }
        return buffer.toString();
    }
}

