/*
 * Decompiled with CFR 0.152.
 */
package asemon.gui;

import asemon.utils.StringUtil;
import java.sql.Timestamp;
import org.apache.log4j.lf5.LogLevel;
import org.apache.log4j.lf5.LogRecord;
import org.apache.log4j.spi.ThrowableInformation;

public class Log4jLogRecord
extends LogRecord {
    private static final long serialVersionUID = -4711707672226871758L;

    public boolean isSevereLevel() {
        boolean isSevere = false;
        if (LogLevel.ERROR.equals((Object)this.getLevel()) || LogLevel.FATAL.equals((Object)this.getLevel())) {
            isSevere = true;
        }
        return isSevere;
    }

    public void setThrownStackTrace(ThrowableInformation throwableInfo) {
        String[] stackTraceArray = throwableInfo.getThrowableStrRep();
        StringBuffer stackTrace = new StringBuffer();
        for (int i = 0; i < stackTraceArray.length; ++i) {
            String nextLine = stackTraceArray[i] + "\n";
            stackTrace.append(nextLine);
        }
        this._thrownStackTrace = stackTrace.toString();
    }

    public String getToolTipText() {
        StringBuffer tt = new StringBuffer("<html>");
        tt.append("    <b>Sequence id: </b>");
        tt.append(this.getSequenceNumber());
        tt.append("<br><b>Time: </b>");
        tt.append(new Timestamp(this.getMillis()));
        tt.append("<br><b>Level: </b>");
        tt.append(this.getLevel());
        tt.append("<br><b>Class Name: </b>");
        tt.append(this.getCategory());
        tt.append("<br><b>Location: </b>");
        tt.append(this.getLocation());
        tt.append("<br><b>Message: </b>");
        tt.append(StringUtil.makeApproxLineBreak(this.getMessage(), 100, 2, "<BR>"));
        if (this.getThrownStackTrace() != null) {
            tt.append("<br><b>Exception: </b><br>");
            tt.append(this.getThrownStackTrace().replaceAll("\\n", "<br>"));
        }
        tt.append("</html>");
        return tt.toString();
    }
}

