/*
 * Decompiled with CFR 0.152.
 */
package asemon.gui;

import asemon.GetCounters;
import asemon.TrendGraphDataPoint;
import asemon.Version;
import asemon.cm.CountersModel;
import asemon.gui.MainFrame;
import asemon.gui.ParameterDialog;
import asemon.gui.SummaryPanel;
import asemon.gui.TrendGraphColors;
import asemon.gui.TrendGraphPanelReorderDialog;
import asemon.gui.swing.AbstractComponentDecorator;
import asemon.utils.Configuration;
import asemon.utils.StringUtil;
import asemon.utils.SwingUtils;
import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.IAxis;
import info.monitorenter.gui.chart.IAxisLabelFormatter;
import info.monitorenter.gui.chart.IPointPainter;
import info.monitorenter.gui.chart.IRangePolicy;
import info.monitorenter.gui.chart.IToolTipType;
import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.ITracePainter;
import info.monitorenter.gui.chart.ITracePoint2D;
import info.monitorenter.gui.chart.TracePoint2D;
import info.monitorenter.gui.chart.ZoomableChart;
import info.monitorenter.gui.chart.events.PopupListener;
import info.monitorenter.gui.chart.labelformatters.LabelFormatterDate;
import info.monitorenter.gui.chart.labelformatters.LabelFormatterSimple;
import info.monitorenter.gui.chart.pointpainters.APointPainter;
import info.monitorenter.gui.chart.rangepolicies.RangePolicyFixedViewport;
import info.monitorenter.gui.chart.rangepolicies.RangePolicyMinimumViewport;
import info.monitorenter.gui.chart.traces.Trace2DLtd;
import info.monitorenter.gui.chart.traces.painters.ATracePainter;
import info.monitorenter.gui.chart.views.ChartPanel;
import info.monitorenter.util.Range;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.log4j.Logger;

public class TrendGraph
implements ActionListener,
MouseListener {
    private static Logger _logger = Logger.getLogger(TrendGraph.class);
    public static final int TYPE_BY_COL = 1;
    public static final int TYPE_BY_ROW = 2;
    private static final int PANEL_MIN_HEIGHT_DEFAULT = 113;
    private static final int PANEL_MIN_HEIGHT_NOT_USED = -1;
    private int _udGraphType = 1;
    private int _colorPtr = 0;
    private ITrace2D[] _series;
    private ITrace2D _dummySeries = null;
    private ChartPanel _chartPanel;
    private String _graphName;
    private String _labelName;
    private String[] _seriesNames = null;
    private String[] _dataColNames = new String[0];
    private String[] _dataMethods = new String[0];
    private Chart2D _chart;
    private boolean _pctGraph;
    private Date _oldTs = null;
    private static int _chartMaxSaveTimeInSec = 600;
    private JCheckBoxMenuItem _chkboxMenuItem = null;
    private JPanel _panel = null;
    private JPopupMenu _panelPopupMenu = null;
    private int _panelMinHeight = -1;
    private CountersModel _cm = null;
    private boolean _initialVisible = true;
    SimpleDateFormat _sdf = new SimpleDateFormat("H:mm:ss.SSS");
    private Watermark _watermark = null;
    private MyTracePainter _tracePainter = null;
    private MyTracePoint2D _currentTimeLinePoint = null;
    private JPanel _labelPanel = null;
    private ITracePoint2D _lastToolTipPoint = null;
    boolean _loadProps_menuItem_checkbox = true;

    public TrendGraph(String name, String chkboxText, String label, String[] seriesNames, boolean pct, CountersModel cm, boolean initialVisible, int panelMinHeight) {
        this._graphName = name;
        this._labelName = label;
        this._seriesNames = seriesNames;
        this._cm = cm;
        this._initialVisible = initialVisible;
        this._panelMinHeight = panelMinHeight;
        Configuration aseMonProps = Configuration.getCombinedConfiguration();
        boolean showToolTip = aseMonProps.getBooleanProperty("TrendGraph.showToolTip", false);
        this._pctGraph = pct;
        this._chart = new ZoomableChart();
        this._series = new ITrace2D[1];
        this._dummySeries = new Trace2DLtd(1);
        this._tracePainter = new MyTracePainter();
        this._chart.setUseAntialiasing(true);
        this._chart.getAxisX().setFormatter((IAxisLabelFormatter)new LabelFormatterDate((SimpleDateFormat)DateFormat.getTimeInstance()));
        this._chart.getAxisY().setFormatter((IAxisLabelFormatter)new LabelFormatterSimple());
        this._chart.getAxisX().getAxisTitle().setTitle(null);
        this._chart.getAxisY().getAxisTitle().setTitle(null);
        this._chart.getAxisX().setPaintGrid(true);
        this._chart.getAxisY().setPaintGrid(true);
        this._chart.addMouseListener((MouseListener)this);
        this._chartPanel = new ChartPanel(this._chart);
        this._watermark = new Watermark((JComponent)this._chartPanel, this._labelName);
        _logger.debug((Object)("showToolTip = " + showToolTip));
        if (showToolTip) {
            this._chart.setToolTipType((IToolTipType)new MyTooltip());
            this._chart.enablePointHighlighting(true);
        }
        if (chkboxText != null && !chkboxText.equals("")) {
            this._chkboxMenuItem = new JCheckBoxMenuItem(chkboxText, true);
            this._chkboxMenuItem.addActionListener(this);
        }
        if (this._pctGraph) {
            this._chart.getAxisY().setRangePolicy((IRangePolicy)new RangePolicyFixedViewport(new Range(0.0, 100.0)));
        } else {
            this._chart.getAxisY().setRangePolicy((IRangePolicy)new RangePolicyMinimumViewport(new Range(0.0, 1.0)));
        }
        this._dummySeries.setName(".");
        this._chart.addTrace(this._dummySeries);
        this._dummySeries.addPoint((ITracePoint2D)new MyTracePoint2D(new Date().getTime(), 0.0));
        this.loadProps();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this._lastToolTipPoint = null;
        this._chart.setRequestedRepaint(true);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this._lastToolTipPoint = null;
        this._chart.setRequestedRepaint(true);
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e)) {
            if (e.getClickCount() == 1) {
                _logger.debug((Object)"SINGLE-RIGHT-CLICK");
            }
        } else if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() != 1) {
            ITracePoint2D tp = this._chart.translateMousePosition(e);
            MainFrame.getInstance().setTimeLinePoint((long)tp.getX());
        }
    }

    public String getName() {
        return this._graphName;
    }

    public String getLabel() {
        return this._labelName;
    }

    public void setLabel(String label) {
        this._labelName = label;
        this._watermark.setWatermarkText(this._labelName);
    }

    private Color nextColor() {
        if (this._colorPtr % TrendGraphColors._colors.length == 0) {
            this._colorPtr = 0;
        }
        return TrendGraphColors._colors[this._colorPtr++];
    }

    public static int getChartMaxHistoryTimeInMinutes() {
        return _chartMaxSaveTimeInSec / 60;
    }

    public void setTimeLineMarker(Timestamp time) {
        if (time == null) {
            this.setTimeLineMarker(0L);
        } else {
            this.setTimeLineMarker(time.getTime());
        }
    }

    public void setTimeLineMarker(long time) {
        _logger.trace((Object)("setTimeLineMarker(time=" + time + "): name='" + this._graphName + "'."));
        if (this._currentTimeLinePoint != null) {
            this._currentTimeLinePoint.setTimeLineMarked(false);
        }
        this._currentTimeLinePoint = null;
        if (time == 0L) {
            return;
        }
        if (this._series.length == 0) {
            return;
        }
        ITrace2D s = this._series[0];
        if (s != null) {
            MyTracePoint2D tpSmaller = null;
            MyTracePoint2D tpBigger = null;
            for (MyTracePoint2D p : s) {
                double graphPoint = p.getX();
                if (graphPoint == (double)time) {
                    this._currentTimeLinePoint = p;
                    break;
                }
                if (graphPoint < (double)time) {
                    tpSmaller = p;
                    continue;
                }
                if (tpBigger != null) continue;
                tpBigger = p;
            }
            if (this._currentTimeLinePoint == null && tpSmaller != null && tpBigger != null) {
                this._currentTimeLinePoint = tpSmaller;
                if (_logger.isTraceEnabled()) {
                    _logger.trace((Object)("TrendGraph='" + this._labelName + "', no '" + time + "' was found, Choosing a SMALLER timeLinePoint"));
                }
            }
        }
        if (this._currentTimeLinePoint != null) {
            _logger.trace((Object)("TrendGraph='" + this._labelName + "', setTimeLineMarked(true)"));
            this._currentTimeLinePoint.setTimeLineMarked(true);
        } else {
            _logger.trace((Object)("TrendGraph='" + this._labelName + "', did not find point " + time));
        }
    }

    public void setChartMaxHistoryTimeInMinutes(int minutes) {
        _chartMaxSaveTimeInSec = minutes * 60;
        int refreshIntervalInSec = MainFrame.getRefreshInterval();
        int chartMaxSamples = _chartMaxSaveTimeInSec / refreshIntervalInSec;
        if (this._series != null) {
            for (int i = 0; i < this._series.length; ++i) {
                Date starttime;
                if (this._series[i] == null) continue;
                ((Trace2DLtd)this._series[i]).setMaxSize(chartMaxSamples);
                if (this._series[i].getMinX() != 0.0) {
                    starttime = new Date((long)this._series[i].getMaxX());
                } else {
                    starttime = new Date();
                    _logger.warn((Object)"Using local system time as starttime.");
                }
                if (this._series[i].getSize() < chartMaxSamples) {
                    ITrace2D prevTrace = this._series[i];
                    Trace2DLtd newTrace = new Trace2DLtd(chartMaxSamples);
                    this._series[i] = newTrace;
                    newTrace.setColor(prevTrace.getColor());
                    newTrace.setName(prevTrace.getName());
                    newTrace.setZIndex(prevTrace.getZIndex());
                    newTrace.addTracePainter((ITracePainter)this._tracePainter);
                    this._chart.removeTrace(prevTrace);
                    this._chart.addTrace((ITrace2D)newTrace);
                    long pointTime = 0L;
                    Iterator iter = prevTrace.iterator();
                    int cnt = chartMaxSamples;
                    boolean firstTP = true;
                    while (true) {
                        if ((pointTime = starttime.getTime() - (long)(refreshIntervalInSec * cnt * 1000)) >= (long)prevTrace.getMinX()) {
                            if (!iter.hasNext()) break;
                            ITracePoint2D tp = (ITracePoint2D)iter.next();
                            if (_logger.isDebugEnabled() && firstTP && (long)prevTrace.getMinX() != (long)tp.getX()) {
                                _logger.debug((Object)(this._series[i].getName() + "-Series[" + i + "] DiffTimeSec=" + ((long)tp.getX() - (long)prevTrace.getMinX()) / 1000L + " MinX != tp.getX()" + " PointTime:" + this._sdf.format(new Date(pointTime)) + " Cnt:" + cnt));
                            }
                            firstTP = false;
                            newTrace.addPoint(tp);
                        } else {
                            newTrace.addPoint((ITracePoint2D)new MyTracePoint2D(pointTime, 0.0));
                        }
                        --cnt;
                    }
                }
                if (_logger.isDebugEnabled() && this._series[i].getMaxSize() != this._series[i].getSize()) {
                    _logger.debug((Object)(this._series[i].getName() + "-Series[" + i + "] maxSize=" + this._series[i].getMaxSize() + " size=" + this._series[i].getSize()));
                }
                if (!_logger.isDebugEnabled() || Math.abs(((long)this._series[i].getMaxX() - (long)this._series[i].getMinX()) / 1000L - (long)_chartMaxSaveTimeInSec) <= (long)refreshIntervalInSec) continue;
                _logger.debug((Object)(this._series[i].getName() + "-Series[" + i + "] " + "Incorrect timespan:" + ((long)this._series[i].getMaxX() - (long)this._series[i].getMinX()) / 1000L + " " + "chartMaxSaveTimeInSec:" + _chartMaxSaveTimeInSec + " " + "PrevMaxX:" + this._sdf.format(starttime) + " " + "Started at:" + this._sdf.format(new Date(starttime.getTime() - (long)(refreshIntervalInSec * chartMaxSamples * 1000))) + " " + "Min:" + this._sdf.format(new Date((long)this._series[i].getMinX())) + " " + "Max:" + this._sdf.format(new Date((long)this._series[i].getMaxX()))));
            }
        }
    }

    public ChartPanel getChartPanel() {
        return this._chartPanel;
    }

    public String[] getDataColNames() {
        return this._dataColNames;
    }

    public String[] getDataMethods() {
        return this._dataMethods;
    }

    public String[] getDataLabels() {
        return this._seriesNames;
    }

    public void setGraphCalculations(String[] dataCols, String[] dataOpers) {
        this._dataColNames = dataCols;
        this._dataMethods = dataOpers;
    }

    public int getGraphType() {
        return this._udGraphType;
    }

    public void setGraphType(int type) {
        if (type != 1 && type != 2) {
            throw new IllegalArgumentException("Graph type can only be 'TYPE_BY_COL/byCol' or 'TYPE_BY_ROW/byRow'.");
        }
        this._udGraphType = type;
    }

    public void addPoint(TrendGraphDataPoint tgdp) {
        if (tgdp == null) {
            return;
        }
        this.addPoint(tgdp.getDate(), tgdp.getData(), tgdp.getLabel());
    }

    public void addPoint(Date s, Double[] val) {
        this.addPoint(s, val, null);
    }

    public void addPoint(Date s, Double[] val, String[] name) {
        int refreshIntervalInSec = MainFrame.getRefreshInterval();
        int chartMaxSamples = _chartMaxSaveTimeInSec / refreshIntervalInSec;
        this.addPoint(s, val, name, chartMaxSamples, -1L);
    }

    public void addPoint(Date s, Double[] val, String[] name, Timestamp startPeriod, Timestamp endPeriod) {
        int refreshIntervalInSec = MainFrame.getRefreshInterval();
        int secondsInSamplpe = (int)(endPeriod.getTime() - startPeriod.getTime()) / 1000;
        int chartMaxSamples = secondsInSamplpe / refreshIntervalInSec;
        this.addPoint(s, val, name, chartMaxSamples, endPeriod.getTime());
    }

    public void addPoint(Date s, Double[] val, String[] name, int chartMaxSamples, long startTime) {
        boolean graphNeedInit = false;
        if (s == null) {
            return;
        }
        if (this._oldTs != null && this._oldTs.equals(s)) {
            return;
        }
        this._oldTs = s;
        ITrace2D[] prevSeries = null;
        if (val.length > this._series.length) {
            _logger.debug((Object)("Resize the series array from " + this._series.length + " to " + val.length + "."));
            prevSeries = this._series;
            this._series = new ITrace2D[val.length];
            _logger.debug((Object)("AFTER Resize the series array is " + this._series.length + "."));
        }
        for (int i = 0; i < val.length; ++i) {
            if (this._series[i] == null) {
                String seriesName = null;
                if (seriesName == null && name != null && name.length > i) {
                    seriesName = name[i];
                }
                if (seriesName == null && prevSeries != null && prevSeries.length > i && prevSeries[i] != null) {
                    seriesName = prevSeries[i].getName();
                }
                if (seriesName == null && this._seriesNames != null && this._seriesNames.length > i) {
                    seriesName = this._seriesNames[i];
                }
                if (seriesName == null) {
                    seriesName = "Unknown";
                }
                this._series[i] = new Trace2DLtd(chartMaxSamples);
                this._series[i].setRenderer(this._chart);
                this._series[i].setZIndex(new Integer(this._colorPtr));
                this._series[i].setColor(this.nextColor());
                this._series[i].setName(seriesName);
                if (i == 0) {
                    this._series[i].addTracePainter((ITracePainter)this._tracePainter);
                }
                this._chart.addTrace(this._series[i]);
                graphNeedInit = true;
                Set highlighters = this._series[i].getPointHighlighters();
                highlighters.clear();
                this._series[i].addPointHighlighter((IPointPainter)new TooltipPointPainter());
            }
            MyTracePoint2D tp = new MyTracePoint2D(s.getTime(), val[i] == null ? 0.0 : val[i]);
            this._series[i].addPoint((ITracePoint2D)tp);
            if (!graphNeedInit || i != 0) continue;
            _logger.debug((Object)(this._series[i].getName() + "-Series[" + i + "] graphNeedInit=" + graphNeedInit));
            int refreshIntervalInSec = MainFrame.getRefreshInterval();
            this.initGraph(this._series[i], refreshIntervalInSec, startTime);
        }
    }

    private void initGraph(ITrace2D trace, int refreshIntervalInSec, long time) {
        String threadName = Thread.currentThread().getName();
        _logger.debug((Object)("initGraph() was called from threadName='" + threadName + "'."));
        if (!SwingUtils.isEventQueueThread()) {
            Runnable eventQueueExec = new Runnable(){

                @Override
                public void run() {
                    if (TrendGraph.this._dummySeries != null) {
                        TrendGraph.this._dummySeries.removeAllPoints();
                        TrendGraph.this._chart.removeTrace(TrendGraph.this._dummySeries);
                        TrendGraph.this._dummySeries = null;
                    }
                }
            };
            try {
                SwingUtilities.invokeAndWait(eventQueueExec);
            }
            catch (Exception ignore) {}
        } else if (this._dummySeries != null) {
            this._dummySeries.removeAllPoints();
            this._chart.removeTrace(this._dummySeries);
            this._dummySeries = null;
        }
        Iterator iter = trace.iterator();
        ITracePoint2D tp = null;
        if (iter.hasNext()) {
            tp = (ITracePoint2D)iter.next();
        }
        if (tp != null && tp.getX() != trace.getMinX()) {
            _logger.warn((Object)"Trace minimal value is different from the only datapoint expected");
        }
        if (time < 0L) {
            if (tp != null) {
                time = (long)tp.getX();
            } else {
                time = new Date().getTime();
                _logger.warn((Object)"Using local system time as starttime.");
            }
        }
        int maxSize = trace.getMaxSize();
        int bigThreshold = 1000;
        int bigDivider = 10;
        for (int cnt = maxSize; cnt > 0; --cnt) {
            long pointtime = time - (long)(refreshIntervalInSec * cnt * 1000);
            if (maxSize > bigThreshold || cnt == maxSize || cnt == 1) {
                if (cnt % bigDivider != 0) continue;
                trace.addPoint((ITracePoint2D)new MyTracePoint2D(pointtime, 0.0));
                continue;
            }
            trace.addPoint((ITracePoint2D)new MyTracePoint2D(pointtime, 0.0));
        }
        trace.addPoint(tp);
        Component[] comp = this._chartPanel.getComponents();
        for (int i = 0; i < comp.length; ++i) {
            if (!comp[i].getClass().getName().equals("javax.swing.JPanel") || this._labelPanel != null) continue;
            this._labelPanel = (JPanel)comp[i];
        }
    }

    public void clearGraph() {
        Runnable doWork = new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < TrendGraph.this._series.length; ++i) {
                    if (TrendGraph.this._series[i] != null) {
                        TrendGraph.this._series[i].removeAllPoints();
                    }
                    ((TrendGraph)TrendGraph.this)._series[i] = null;
                }
                TrendGraph.this._chart.removeAllTraces();
                TrendGraph.this._colorPtr = 0;
                TrendGraph.this._dummySeries = (ITrace2D)new Trace2DLtd(1);
                TrendGraph.this._dummySeries.setName(".");
                TrendGraph.this._chart.addTrace(TrendGraph.this._dummySeries);
                TrendGraph.this._dummySeries.addPoint((ITracePoint2D)new MyTracePoint2D(new Date().getTime(), 0.0));
            }
        };
        if (!SwingUtils.isEventQueueThread()) {
            try {
                SwingUtilities.invokeAndWait(doWork);
            }
            catch (Exception exception) {}
        } else {
            doWork.run();
        }
    }

    public JCheckBoxMenuItem getViewMenuItem() {
        return this._chkboxMenuItem;
    }

    public boolean isGraphEnabled() {
        if (this._chkboxMenuItem != null) {
            return this._chkboxMenuItem.isSelected();
        }
        return false;
    }

    public void setEnable(Boolean enabled) {
        boolean isEnabled = this.isGraphEnabled();
        if (enabled != isEnabled && this._chkboxMenuItem != null) {
            this._chkboxMenuItem.doClick();
        }
    }

    public JPopupMenu getPanelPopupMenu() {
        return this._panelPopupMenu;
    }

    public JPopupMenu createPanelPopupMenu() {
        _logger.debug((Object)"createDataTablePopupMenu(): called.");
        JPopupMenu popup = new JPopupMenu();
        for (JComponent comp : this.createPopupMenuComponents()) {
            popup.add(comp);
        }
        if (popup.getComponentCount() == 0) {
            _logger.warn((Object)("No PopupMenu has been assigned for the Graph in the panel '" + this._graphName + "'."));
            return null;
        }
        return popup;
    }

    private List<JComponent> createPopupMenuComponents() {
        ArrayList<JComponent> list = new ArrayList<JComponent>();
        JMenuItem mi = new JMenuItem("Set Graph Minimum Height");
        list.add(mi);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String key1 = "Minimum Height";
                LinkedHashMap<String, String> in = new LinkedHashMap<String, String>();
                in.put(key1, Integer.toString(TrendGraph.this._panelMinHeight <= 0 ? 113 : TrendGraph.this._panelMinHeight));
                Map<String, String> results = ParameterDialog.showParameterDialog(MainFrame.getInstance(), "Graph Sizing", in, false);
                if (results != null) {
                    TrendGraph.this._panelMinHeight = Integer.parseInt(results.get(key1));
                    TrendGraph.this._panel.setMinimumSize(new Dimension(-1, TrendGraph.this._panelMinHeight));
                    TrendGraph.this._panel.setSize(new Dimension(-1, TrendGraph.this._panelMinHeight));
                    TrendGraph.this.saveProps();
                }
            }
        });
        mi = new JMenuItem("Set Graph Minimum Height to DEFAULT");
        list.add(mi);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrendGraph.this._panelMinHeight = -1;
                int panelMinHeight = TrendGraph.this._panelMinHeight <= 0 ? 113 : TrendGraph.this._panelMinHeight;
                TrendGraph.this._panel.setMinimumSize(new Dimension(-1, panelMinHeight));
                TrendGraph.this._panel.setSize(new Dimension(-1, panelMinHeight));
                TrendGraph.this.saveProps();
            }
        });
        mi = new JMenuItem("Change the Graph Order Layout...");
        list.add(mi);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int ret = TrendGraphPanelReorderDialog.showDialog(MainFrame.getInstance(), SummaryPanel.getInstance().getGraphPanel());
                if (ret == 0) {
                    // empty if block
                }
            }
        });
        list.add(new JSeparator());
        mi = new JMenuItem("Disable this graph");
        list.add(mi);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TrendGraph.this.isGraphEnabled()) {
                    TrendGraph.this.getViewMenuItem().doClick();
                }
            }
        });
        JMenu menu = new JMenu("Enable other graphs");
        list.add(menu);
        final JPopupMenu popupMenu = menu.getPopupMenu();
        popupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                popupMenu.removeAll();
                for (CountersModel cm : GetCounters.getCmList()) {
                    for (String name : cm.getTrendGraphNames()) {
                        final TrendGraph tg = cm.getTrendGraph(name);
                        JCheckBoxMenuItem mi = new JCheckBoxMenuItem();
                        mi.setText(tg.getLabel());
                        mi.setSelected(tg.isGraphEnabled());
                        mi.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                tg.getViewMenuItem().doClick();
                            }
                        });
                        popupMenu.add(mi);
                    }
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        return list;
    }

    public static JButton createGraphAccessButton(JButton button, final String cmName) {
        if (cmName == null || cmName != null && cmName.trim().equals("")) {
            throw new IllegalArgumentException("createGraphAccessButton() cmName can't be null or empty.");
        }
        if (button == null) {
            button = new JButton();
        }
        button.setToolTipText("<html>What Trend Graphs are attached to this Performance Counter. Also enable/disable the graph(s).</html>");
        button.setIcon(SwingUtils.readImageIcon(Version.class, "images/summary_tab.png"));
        button.setText("");
        button.setContentAreaFilled(false);
        button.setMargin(new Insets(0, 0, 0, 0));
        final JPopupMenu trendGraphPopupMenu = new JPopupMenu();
        trendGraphPopupMenu.add(new JMenuItem("No Trend Graphs's is Available"));
        button.setComponentPopupMenu(trendGraphPopupMenu);
        trendGraphPopupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                trendGraphPopupMenu.removeAll();
                CountersModel cm = GetCounters.getCmByName(cmName);
                if (cm == null) {
                    cm = GetCounters.getCmByDisplayName(cmName);
                }
                if (cm == null) {
                    trendGraphPopupMenu.add(new JMenuItem("Performance Counter named '" + cmName + "' couldn't be found."));
                } else {
                    for (String name : cm.getTrendGraphNames()) {
                        final TrendGraph tg = cm.getTrendGraph(name);
                        JCheckBoxMenuItem mi = new JCheckBoxMenuItem();
                        mi.setText(tg.getLabel());
                        mi.setSelected(tg.isGraphEnabled());
                        mi.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                tg.getViewMenuItem().doClick();
                            }
                        });
                        trendGraphPopupMenu.add(mi);
                    }
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object source = e.getSource();
                if (source instanceof JButton) {
                    JButton but = (JButton)source;
                    JPopupMenu pm = but.getComponentPopupMenu();
                    pm.show(but, 14, 14);
                    pm.setLocation(MouseInfo.getPointerInfo().getLocation());
                }
            }
        });
        return button;
    }

    public JPanel getPanel() {
        if (this._panel == null) {
            this._panel = new JPanel();
            this._panelPopupMenu = this.createPanelPopupMenu();
            this._panel.setComponentPopupMenu(this._panelPopupMenu);
            for (MouseListener ml : this._chartPanel.getChart().getMouseListeners()) {
                PopupListener cpl;
                JPopupMenu chartPopupMenu;
                if (!(ml instanceof PopupListener) || (chartPopupMenu = (cpl = (PopupListener)ml).getPopup()) == null) continue;
                chartPopupMenu.add(new JSeparator());
                JMenu aseMonMenu = new JMenu(Version.getAppName() + " Menu");
                chartPopupMenu.add(aseMonMenu);
                for (JComponent comp : this.createPopupMenuComponents()) {
                    aseMonMenu.add(comp);
                }
            }
            this._panel.setLayout(new BorderLayout());
            this._panel.setMinimumSize(new Dimension(-1, this._panelMinHeight <= 0 ? 113 : this._panelMinHeight));
            this._panel.setBorder(BorderFactory.createLoweredBevelBorder());
            this._panel.add((Component)this.getChartPanel(), null);
            if (!this._loadProps_menuItem_checkbox) {
                this._chkboxMenuItem.doClick();
            }
        }
        return this._panel;
    }

    public CountersModel getCm() {
        return this._cm;
    }

    public void setCm(CountersModel cm) {
        this._cm = cm;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object s = e.getSource();
        _logger.trace((Object)("TrendGraphAction.actionPerformed(), ActionEvent(classname)=" + s.getClass().getName()));
        if (s instanceof JMenuItem) {
            JMenuItem source = (JMenuItem)s;
            _logger.trace((Object)("Action event detected. Event source: " + source.getText() + " (an instance of " + source.getClass().getName() + ")"));
            if (this._panel != null && this._chkboxMenuItem != null) {
                boolean isSelected = this._chkboxMenuItem.isSelected();
                this._panel.setVisible(isSelected);
                this.saveProps();
            }
        }
    }

    private void saveProps() {
        Configuration tempProps = Configuration.getInstance("USER_TEMP");
        String graphName = this.getName();
        if (tempProps != null) {
            tempProps.setProperty("MainFrame.menu." + graphName + ".checkbox", this._chkboxMenuItem.isSelected());
            tempProps.setProperty("Graph." + graphName + ".minHeight", this._panelMinHeight);
            tempProps.save();
        }
    }

    private void loadProps() {
        Configuration tempProps = Configuration.getCombinedConfiguration();
        String graphName = this.getName();
        if (tempProps != null) {
            this._loadProps_menuItem_checkbox = tempProps.getBooleanProperty("MainFrame.menu." + graphName + ".checkbox", this._initialVisible);
            this._panelMinHeight = tempProps.getIntProperty("Graph." + graphName + ".minHeight", this._panelMinHeight);
        }
    }

    private class TooltipPointPainter
    extends APointPainter {
        private static final long serialVersionUID = 1L;

        private TooltipPointPainter() {
        }

        public void paintPoint(int absoluteX, int absoluteY, int nextX, int nextY, Graphics g, ITracePoint2D original) {
            if (original != null && original.equals(TrendGraph.this._lastToolTipPoint)) {
                int discSize = 4;
                int halfDiscSize = 2;
                g.drawOval(absoluteX - halfDiscSize, absoluteY - halfDiscSize, discSize, discSize);
            }
        }
    }

    private class MyTooltip
    implements IToolTipType {
        private MyTooltip() {
        }

        public String getDescription() {
            return "Show the label title and it's value.";
        }

        public String getToolTipText(Chart2D chart, MouseEvent me) {
            ITracePoint2D point = chart.getNearestPointManhattan(me);
            TrendGraph.this._lastToolTipPoint = point;
            ITrace2D trace = point.getListener();
            IAxis xAxis = chart.getAxisX(trace);
            IAxis yAxis = chart.getAxisY(trace);
            chart.setRequestedRepaint(true);
            StringBuffer buffer = new StringBuffer();
            buffer.append("<html>");
            String yAxisName = yAxis.getAxisTitle().getTitle();
            if (yAxisName == null) {
                yAxisName = trace.getName();
            }
            if (yAxisName == null) {
                yAxisName = "Value";
            }
            buffer.append(yAxisName).append(": ");
            buffer.append(yAxis.getFormatter().format(point.getY()));
            buffer.append("<br>");
            buffer.append("Time: ");
            buffer.append(xAxis.getFormatter().format(point.getX()));
            buffer.append("<br>");
            buffer.append("</html>");
            String result = buffer.toString();
            return result;
        }
    }

    private class PointPainterTimeLineMark
    extends APointPainter {
        private static final long serialVersionUID = -6317473632026920774L;

        public void paintPoint(int absoluteX, int absoluteY, int nextX, int nextY, Graphics g, ITracePoint2D original) {
            MyTracePoint2D my;
            if (original instanceof MyTracePoint2D && (my = (MyTracePoint2D)original).isTimeLineMarked()) {
                if (_logger.isTraceEnabled()) {
                    _logger.trace((Object)("PointPainterTimeLineMark.paintPoint(): graphName=" + StringUtil.left(TrendGraph.this._graphName, 15) + ", absoluteX=" + absoluteX + ", absoluteY=" + absoluteY + ", nextX=" + nextX + ", nextY=" + nextY + "."));
                }
                Color saveColor = g.getColor();
                g.setColor(Color.DARK_GRAY);
                g.fillRect(nextX, 0, 3, 999);
                g.setColor(saveColor);
            }
        }
    }

    private class MyTracePainter
    extends ATracePainter {
        private static final long serialVersionUID = 1L;
        private PointPainterTimeLineMark m_pointPainter;

        public MyTracePainter() {
            this.m_pointPainter = new PointPainterTimeLineMark();
        }

        public void endPaintIteration(Graphics g2d) {
            if (g2d != null) {
                this.m_pointPainter.paintPoint(this.getPreviousX(), this.getPreviousY(), 0, 0, g2d, this.getPreviousPoint());
            }
            this.m_pointPainter.endPaintIteration(g2d);
        }

        public void startPaintIteration(Graphics g2d) {
            this.m_pointPainter.startPaintIteration(g2d);
        }

        public void paintPoint(int absoluteX, int absoluteY, int nextX, int nextY, Graphics g, ITracePoint2D original) {
            super.paintPoint(absoluteX, absoluteY, nextX, nextY, g, original);
            this.m_pointPainter.paintPoint(absoluteX, absoluteY, nextX, nextY, g, original);
        }
    }

    private class MyTracePoint2D
    extends TracePoint2D {
        private static final long serialVersionUID = 1L;
        private boolean _timelineMarked;

        public MyTracePoint2D(double value, double value2) {
            super(value, value2);
            this._timelineMarked = false;
        }

        public boolean isTimeLineMarked() {
            return this._timelineMarked;
        }

        public void setTimeLineMarked(boolean b) {
            this._timelineMarked = b;
        }
    }

    private class Watermark
    extends AbstractComponentDecorator {
        private String _text;
        private Graphics2D g;
        private Rectangle r;

        public Watermark(JComponent target, String text) {
            super(target);
            this._text = "";
            this.g = null;
            this.r = null;
            if (text != null) {
                this._text = text;
            }
        }

        @Override
        public void paint(Graphics graphics) {
            if (this._text == null || this._text != null && this._text.equals("")) {
                return;
            }
            this.r = this.getDecorationBounds();
            this.g = (Graphics2D)graphics;
            Font f = UIManager.getDefaults().getFont("Label.font").deriveFont(14.0f).deriveFont(1);
            this.g.setFont(f);
            this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            FontMetrics fm = this.g.getFontMetrics();
            int strWidth = fm.stringWidth(this._text);
            int xPos = (this.r.width - strWidth) / 2;
            int yPos = fm.getHeight() - 2;
            this.g.drawString(this._text, xPos, yPos);
        }

        public void setWatermarkText(String text) {
            this._text = text;
            _logger.debug((Object)("setWatermarkText: to '" + this._text + "'."));
            this.repaint();
        }
    }
}

