/*
 * Decompiled with CFR 0.152.
 */
package asemon.gui;

import asemon.Version;
import asemon.gui.TrendGraph;
import asemon.pcs.InMemoryCounterHandler;
import asemon.utils.Configuration;
import asemon.utils.StringUtil;
import asemon.utils.SwingUtils;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import org.apache.log4j.Logger;

public class TrendGraphDashboardPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    static Logger _logger = Logger.getLogger(TrendGraphDashboardPanel.class);
    private final String GRAPH_LAYOUT_PROP = "push, grow, hidemode 3, wrap";
    private final String FACEBOOK_URL = "http://www.facebook.com/pages/AseTune/223112614400980";
    private final String SOURCEFORGE_URL = "http://sourceforge.net/projects/asetune/";
    private JLabel _maxChartHistoryInMinutes_lbl = new JLabel();
    private SpinnerNumberModel _maxChartHistoryInMinutes_spm = new SpinnerNumberModel(TrendGraph.getChartMaxHistoryTimeInMinutes(), 1, 999, 1);
    private JSpinner _maxChartHistoryInMinutes_sp = new JSpinner(this._maxChartHistoryInMinutes_spm);
    private JLabel _maxInMemHistoryInMinutes_lbl = new JLabel();
    private SpinnerNumberModel _maxInMemHistoryInMinutes_spm = new SpinnerNumberModel(TrendGraph.getChartMaxHistoryTimeInMinutes(), 1, 999, 1);
    private JSpinner _maxInMemHistoryInMinutes_sp = new JSpinner(this._maxInMemHistoryInMinutes_spm);
    private JCheckBox _maxInMemHistoryInMinutes_chk = new JCheckBox("Same as Graph History", true);
    private JButton _sourceforge_but = new JButton();
    private JButton _facebook_but = new JButton();
    private List<String> _savedGraphNameOrder = new ArrayList<String>();
    private LinkedHashMap<String, TrendGraph> _graphOriginOrderMap = new LinkedHashMap();
    private LinkedHashMap<String, TrendGraph> _graphCurrentOrderMap = new LinkedHashMap();
    private Desktop _desktop = null;

    public TrendGraphDashboardPanel() {
        if (Desktop.isDesktopSupported()) {
            this._desktop = Desktop.getDesktop();
            if (!this._desktop.isSupported(Desktop.Action.BROWSE)) {
                this._desktop = null;
            }
        }
        this.initComponents();
        this.loadProps();
        this.initComponentActions();
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("insets 0 0 0 0", "", ""));
        this._maxChartHistoryInMinutes_lbl.setText("Trends Graph History in Minutes");
        this._maxChartHistoryInMinutes_lbl.setToolTipText("How many minutes should be represented in the graphs.");
        this._maxChartHistoryInMinutes_sp.setToolTipText("How many minutes should be represented in the graphs.");
        this._maxInMemHistoryInMinutes_lbl.setText("In-Memory History in Minutes");
        this._maxInMemHistoryInMinutes_lbl.setToolTipText("<html>How many minutes should be available in the in-memory history.<br>To view in-memory history, click the magnifying/db button on the tool bar.</html>");
        this._maxInMemHistoryInMinutes_sp.setToolTipText("<html>How many minutes should be available in the in-memory history.<br>To view in-memory history, click the magnifying/db button on the tool bar.</html>");
        this._maxInMemHistoryInMinutes_chk.setToolTipText("Use same value for 'In-Memory History' as for 'Trends Graph History'.");
        this._sourceforge_but.setToolTipText("<html>Goto " + Version.getAppName() + " at Sourceforge. Here you can: <UL> <LI>Recommend " + Version.getAppName() + " to others</LI> <LI>Make comments/recommendations</LI> <LI>Add: Support Questions</LI> <LI>Add: Bug Reports</LI> <LI>Add: Feature Requests</LI> </UL>" + "http://sourceforge.net/projects/asetune/" + "<html>");
        this._sourceforge_but.setIcon(SwingUtils.readImageIcon(Version.class, "images/sourceforge_logo.png"));
        this._sourceforge_but.setContentAreaFilled(false);
        this._sourceforge_but.setMargin(new Insets(0, 0, 0, 0));
        this._facebook_but.setToolTipText("<html>Goto " + Version.getAppName() + " Facebook Page <UL> <LI>Press 'like' to get information about upcoming changes.</LI> <LI>Or write something on the wall.</LI> </UL>" + "http://www.facebook.com/pages/AseTune/223112614400980" + "</html>");
        this._facebook_but.setIcon(SwingUtils.readImageIcon(Version.class, "images/facebook_button.png"));
        this._facebook_but.setContentAreaFilled(false);
        this._facebook_but.setMargin(new Insets(0, 0, 0, 0));
        if (this._desktop == null) {
            this._sourceforge_but.setVisible(false);
            this._facebook_but.setVisible(false);
        }
        JPanel topPanel = new JPanel((LayoutManager)new MigLayout("insets 0 0 0 0", "", ""));
        topPanel.add((Component)this._maxChartHistoryInMinutes_lbl, "split 5, center, gaptop 10");
        topPanel.add((Component)this._maxChartHistoryInMinutes_sp, "");
        topPanel.add((Component)this._maxInMemHistoryInMinutes_lbl, "gap 10");
        topPanel.add((Component)this._maxInMemHistoryInMinutes_sp, "gap 5");
        topPanel.add((Component)this._maxInMemHistoryInMinutes_chk, "pushx");
        topPanel.add((Component)this._sourceforge_but, "hidemode 2, right");
        topPanel.add((Component)this._facebook_but, "hidemode 2, right");
        this.add((Component)topPanel, "push, grow, hidemode 3, wrap");
        String tooltip = "";
        this.setToolTipText(tooltip);
    }

    private void initComponentActions() {
        this._maxChartHistoryInMinutes_spm.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                int minutes = TrendGraphDashboardPanel.this._maxChartHistoryInMinutes_spm.getNumber().intValue();
                _logger.debug((Object)("maxChartHistoryInMinutes: " + minutes));
                TrendGraphDashboardPanel.this.setChartMaxHistoryTimeInMinutes(minutes);
                TrendGraphDashboardPanel.this.saveProps();
            }
        });
        this._maxInMemHistoryInMinutes_spm.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                int minutes = TrendGraphDashboardPanel.this._maxInMemHistoryInMinutes_spm.getNumber().intValue();
                _logger.debug((Object)("maxInMemHistoryInMinutes: " + minutes));
                TrendGraphDashboardPanel.this.setInMemMaxHistoryTimeInMinutes(minutes);
                TrendGraphDashboardPanel.this.saveProps();
            }
        });
        this._maxInMemHistoryInMinutes_chk.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                boolean inSync = TrendGraphDashboardPanel.this._maxInMemHistoryInMinutes_chk.isSelected();
                TrendGraphDashboardPanel.this._maxInMemHistoryInMinutes_sp.setEnabled(!inSync);
                if (inSync) {
                    int minutes = TrendGraphDashboardPanel.this._maxChartHistoryInMinutes_spm.getNumber().intValue();
                    TrendGraphDashboardPanel.this.setInMemMaxHistoryTimeInMinutes(minutes);
                }
                TrendGraphDashboardPanel.this.saveProps();
            }
        });
        this._facebook_but.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TrendGraphDashboardPanel.this._desktop == null) {
                    return;
                }
                try {
                    TrendGraphDashboardPanel.this._desktop.browse(new URI("http://www.facebook.com/pages/AseTune/223112614400980"));
                }
                catch (Exception ex) {
                    _logger.error((Object)("Problems when open the Facebook page 'http://www.facebook.com/pages/AseTune/223112614400980'. Caught: " + e));
                }
            }
        });
        this._sourceforge_but.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TrendGraphDashboardPanel.this._desktop == null) {
                    return;
                }
                try {
                    TrendGraphDashboardPanel.this._desktop.browse(new URI("http://sourceforge.net/projects/asetune/"));
                }
                catch (Exception ex) {
                    _logger.error((Object)("Problems when open the SourceForge page 'http://sourceforge.net/projects/asetune/'. Caught: " + e));
                }
            }
        });
    }

    private void setChartMaxHistoryTimeInMinutes(int minutes) {
        _logger.debug((Object)("set-Chart-MaxHistoryTimeInMinutes(minutes=" + minutes + ")"));
        this._maxChartHistoryInMinutes_spm.setValue(new Integer(minutes));
        for (TrendGraph tg : this._graphCurrentOrderMap.values()) {
            if (tg == null) continue;
            tg.setChartMaxHistoryTimeInMinutes(minutes);
        }
        if (this._maxInMemHistoryInMinutes_chk.isSelected()) {
            this.setInMemMaxHistoryTimeInMinutes(minutes);
        }
    }

    private void setInMemMaxHistoryTimeInMinutes(int minutes) {
        _logger.debug((Object)("set-In-Mem-MaxHistoryTimeInMinutes(minutes=" + minutes + ")"));
        this._maxInMemHistoryInMinutes_spm.setValue(new Integer(minutes));
        InMemoryCounterHandler imch = InMemoryCounterHandler.getInstance();
        if (imch != null) {
            imch.setHistoryLengthInMinutes(minutes);
        }
    }

    public void refreshHistoryTimeInMinutes() {
        Integer minutes = (Integer)this._maxChartHistoryInMinutes_spm.getValue();
        this.setChartMaxHistoryTimeInMinutes(minutes);
    }

    public void clearGraph() {
        for (TrendGraph tg : this._graphCurrentOrderMap.values()) {
            if (tg == null) continue;
            tg.clearGraph();
        }
    }

    public void add(TrendGraph tg) {
        this._graphOriginOrderMap.put(tg.getName(), tg);
        this._graphCurrentOrderMap.put(tg.getName(), tg);
        Integer minutes = (Integer)this._maxChartHistoryInMinutes_spm.getValue();
        tg.setChartMaxHistoryTimeInMinutes(minutes);
        if (this._savedGraphNameOrder.contains(tg.getName())) {
            this.setGraphOrder(this._savedGraphNameOrder, false);
        } else {
            this.add((Component)tg.getPanel(), "push, grow, hidemode 3, wrap");
        }
    }

    private void saveProps() {
        Configuration conf = Configuration.getInstance("USER_TEMP");
        String str = this._maxChartHistoryInMinutes_spm.getNumber().toString();
        conf.setProperty("graph.history", str);
        str = this._maxInMemHistoryInMinutes_spm.getNumber().toString();
        conf.setProperty("in-memory.history", str);
        str = this._maxInMemHistoryInMinutes_chk.isSelected() + "";
        conf.setProperty("in-memory.history.in-sync-with-graph-history", str);
        str = StringUtil.toCommaStr(this.getGraphOrderStrList());
        conf.setProperty("graph.order", str);
        conf.save();
    }

    private void loadProps() {
        int hist;
        Configuration conf = Configuration.getCombinedConfiguration();
        boolean inMemHistSync = conf.getBooleanProperty("in-memory.history.in-sync-with-graph-history", true);
        this._maxInMemHistoryInMinutes_chk.setSelected(inMemHistSync);
        this._maxInMemHistoryInMinutes_sp.setEnabled(!inMemHistSync);
        int inMemHist = conf.getIntProperty("in-memory.history", -1);
        if (inMemHist != -1) {
            this.setInMemMaxHistoryTimeInMinutes(inMemHist);
        }
        if ((hist = conf.getIntProperty("graph.history", -1)) != -1) {
            this.setChartMaxHistoryTimeInMinutes(hist);
        }
        String str = conf.getProperty("graph.order", "");
        this._savedGraphNameOrder = StringUtil.parseCommaStrToList(str);
    }

    public void setEnableGraph(String graphName, Boolean enabled) {
        TrendGraph tg = this._graphCurrentOrderMap.get(graphName);
        if (tg == null) {
            throw new RuntimeException("Couldn't find graph name '" + graphName + "' in the list of graphs: " + this._graphCurrentOrderMap);
        }
        tg.setEnable(enabled);
    }

    public void setGraphOrder(Collection<String> newGraphOrder, boolean printWarnings) {
        for (TrendGraph tg : this._graphCurrentOrderMap.values()) {
            this.remove(tg.getPanel());
        }
        this._graphCurrentOrderMap.clear();
        for (String graphName : newGraphOrder) {
            TrendGraph tg = this._graphOriginOrderMap.get(graphName);
            if (tg == null) {
                if (!printWarnings) continue;
                _logger.warn((Object)("Graph name '" + graphName + "' could not be found in the original map."));
                continue;
            }
            this._graphCurrentOrderMap.put(tg.getName(), tg);
            if (!tg.isGraphEnabled()) continue;
            this.add((Component)tg.getPanel(), "push, grow, hidemode 3, wrap");
        }
    }

    public void setGraphOrder(LinkedHashMap<String, Boolean> newGraphOrderMap) {
        for (TrendGraph trendGraph : this._graphCurrentOrderMap.values()) {
            this.remove(trendGraph.getPanel());
        }
        this._graphCurrentOrderMap.clear();
        for (Map.Entry entry : newGraphOrderMap.entrySet()) {
            String graphName = (String)entry.getKey();
            boolean enabled = (Boolean)entry.getValue();
            TrendGraph tg = this._graphOriginOrderMap.get(graphName);
            if (tg == null) {
                _logger.warn((Object)("Graph name '" + graphName + "' could not be found in the original map."));
                continue;
            }
            this._graphCurrentOrderMap.put(tg.getName(), tg);
            tg.setEnable(enabled);
            if (!enabled) continue;
            this.add((Component)tg.getPanel(), "push, grow, hidemode 3, wrap");
        }
    }

    public List<String> getGraphOrderStrList() {
        return this.getGraphOrder(this._graphCurrentOrderMap);
    }

    public List<String> getOriginGraphOrderStrList() {
        return this.getGraphOrder(this._graphOriginOrderMap);
    }

    private List<String> getGraphOrder(Map<String, TrendGraph> in) {
        ArrayList<String> list = new ArrayList<String>();
        for (TrendGraph tg : in.values()) {
            list.add(tg.getName());
        }
        return list;
    }

    public Collection<TrendGraph> getGraphOrder() {
        return this._graphCurrentOrderMap.values();
    }

    public Collection<TrendGraph> getOriginGraphOrder() {
        return this._graphOriginOrderMap.values();
    }

    public void saveOrderAndVisibility() {
        this.saveProps();
    }

    public void removeOrderAndVisibility() {
        this.setGraphOrder(this.getOriginGraphOrderStrList(), true);
        Configuration conf = Configuration.getInstance("USER_TEMP");
        if (conf != null) {
            conf.remove("graph.order");
            conf.save();
        }
    }
}

