/*
 * Decompiled with CFR 0.152.
 */
package asemon.gui;

import asemon.Version;
import asemon.cm.CountersModel;
import asemon.gui.MainFrame;
import asemon.gui.TrendGraph;
import asemon.gui.TrendGraphDashboardPanel;
import asemon.gui.swing.MultiLineLabel;
import asemon.utils.SwingUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTable;

public class TrendGraphPanelReorderDialog
extends JDialog
implements ActionListener,
TableModelListener {
    private static final long serialVersionUID = 1L;
    private ImageIcon _iconDialog = new ImageIcon(Version.class.getResource("images/graph.png"));
    private ImageIcon _iconUp = new ImageIcon(Version.class.getResource("images/up.png"));
    private ImageIcon _iconDown = new ImageIcon(Version.class.getResource("images/down.png"));
    private MultiLineLabel _description1 = new MultiLineLabel("Choose in what order the Graphs will be arranged.");
    private MultiLineLabel _description2 = new MultiLineLabel("You can also enable or disable Graphs from here.");
    private JButton _up = new JButton();
    private JButton _down = new JButton();
    private JButton _toStartOrder = new JButton("To Start Order");
    private JButton _toOriginOrder = new JButton("To Original Order");
    private JButton _rmOrderAndVis = new JButton("Clear saved info");
    private DefaultTableModel _tableModel = null;
    private JXTable _table = null;
    private TrendGraphDashboardPanel _trendGraphPanel = null;
    private List<String> _originOrder = new ArrayList<String>();
    private List<String> _orderAtStart = new ArrayList<String>();
    private DefaultTableModel _tableModelAtStart = null;
    private JButton _ok = new JButton("OK");
    private JButton _cancel = new JButton("Cancel");
    private JButton _apply = new JButton("Apply");
    private int _dialogReturnSt = 2;
    private String[] _tabHeadArr = new String[]{"Icon", "Enabled", "Graph Owner", "Graph Label", "Graph Name"};

    private TrendGraphPanelReorderDialog(Frame owner, TrendGraphDashboardPanel trendGraphPanel) {
        super(owner, "Change Graph Order", true);
        this._trendGraphPanel = trendGraphPanel;
        this._originOrder = this._trendGraphPanel.getOriginGraphOrderStrList();
        this._orderAtStart = this._trendGraphPanel.getGraphOrderStrList();
        this.initComponents();
        this._tableModelAtStart = SwingUtils.copyTableModel(this._tableModel);
        this.pack();
        Dimension size = this.getSize();
        size.height += (this._table.getRowCount() - 6) * 18;
        size.width = Math.min(size.width, 645);
        this.setSize(size);
    }

    public static int showDialog(Frame owner, TrendGraphDashboardPanel trendGraphPanel) {
        TrendGraphPanelReorderDialog dialog = new TrendGraphPanelReorderDialog(owner, trendGraphPanel);
        dialog.setLocationRelativeTo(owner);
        dialog.setVisible(true);
        dialog.dispose();
        return dialog._dialogReturnSt;
    }

    protected void initComponents() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout());
        panel.add((Component)this._description1, "grow, wrap");
        panel.add((Component)this._description2, "grow, wrap 10");
        this._table = this.createTable();
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView((Component)this._table);
        panel.add((Component)jScrollPane, "span, grow, height 100%, push, wrap");
        panel.add((Component)this._up, "tag left, span, split");
        panel.add((Component)this._down, "tag left");
        panel.add((Component)this._toStartOrder, "tag left");
        panel.add((Component)this._toOriginOrder, "tag left");
        panel.add((Component)this._rmOrderAndVis, "tag right, wrap push");
        panel.add((Component)this.createOkPanel(), "gap top 20, right");
        this._apply.setEnabled(false);
        this.setContentPane(panel);
        this._up.addActionListener(this);
        this._down.addActionListener(this);
        this._toStartOrder.addActionListener(this);
        this._toOriginOrder.addActionListener(this);
        this._rmOrderAndVis.addActionListener(this);
        this._up.setToolTipText("Move the Graph up");
        this._down.setToolTipText("Move the Graph down)");
        this._toStartOrder.setToolTipText("Restore the Graphs to the order it had when this dialog was opened.");
        this._toOriginOrder.setToolTipText("Restore the Graphs to the order it originally was created as (restore to factory setting).");
        this._rmOrderAndVis.setToolTipText("<html>Remove/clear the persisted values for Graph order and the visibility.<br>This is usually stored in the configuration or properties file.</html>");
        this._up.setIcon(this._iconUp);
        this._down.setIcon(this._iconDown);
        if (this._iconDialog != null) {
            this.setIconImage(this._iconDialog.getImage());
        }
        if (this._up.getIcon() == null) {
            this._up.setText("Move Up");
        }
        if (this._down.getIcon() == null) {
            this._down.setText("Move Down");
        }
        this.pack();
    }

    JPanel createOkPanel() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("insets 0 0", "", ""));
        panel.add((Component)this._ok, "tag ok");
        panel.add((Component)this._cancel, "tag cancel");
        panel.add((Component)this._apply, "tag apply");
        this._ok.addActionListener(this);
        this._cancel.addActionListener(this);
        this._apply.addActionListener(this);
        return panel;
    }

    private void apply() {
        this._table.clearSelection();
        LinkedHashMap<String, Boolean> newGraphOrder = new LinkedHashMap<String, Boolean>();
        for (int r = 0; r < this._table.getRowCount(); ++r) {
            String graphName = (String)this._table.getValueAt(r, TabPos.GraphName.ordinal());
            Boolean enabled = (Boolean)this._table.getValueAt(r, TabPos.Enabled.ordinal());
            newGraphOrder.put(graphName, enabled);
        }
        this._trendGraphPanel.setGraphOrder(newGraphOrder);
        this._trendGraphPanel.saveOrderAndVisibility();
        this._apply.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DefaultTableModel dtm;
        int toRow;
        int row;
        Object source = e.getSource();
        if (this._up.equals(source)) {
            row = this._table.getSelectedRow();
            if (row < 0) {
                SwingUtils.showInfoMessage(this, "Select a row", "No row in the table is selected.");
                return;
            }
            toRow = row - 1;
            dtm = (DefaultTableModel)this._table.getModel();
            if (toRow >= 0) {
                dtm.moveRow(row, row, toRow);
                this._table.getSelectionModel().setSelectionInterval(toRow, toRow);
            }
        }
        if (this._down.equals(source)) {
            row = this._table.getSelectedRow();
            if (row < 0) {
                SwingUtils.showInfoMessage(this, "Select a row", "No row in the table is selected.");
                return;
            }
            toRow = row + 1;
            dtm = (DefaultTableModel)this._table.getModel();
            if (toRow < dtm.getRowCount()) {
                dtm.moveRow(row, row, toRow);
                this._table.getSelectionModel().setSelectionInterval(toRow, toRow);
            }
        }
        if (this._toStartOrder.equals(source)) {
            this.toGraphOrder(this._tableModel, this._orderAtStart);
        }
        if (this._toOriginOrder.equals(source)) {
            this.toGraphOrder(this._tableModel, this._originOrder);
        }
        if (this._rmOrderAndVis.equals(source)) {
            this._trendGraphPanel.removeOrderAndVisibility();
        }
        if (this._ok.equals(source)) {
            this.apply();
            this._dialogReturnSt = 0;
            this.setVisible(false);
        }
        if (this._cancel.equals(source)) {
            this._dialogReturnSt = 2;
            this.setVisible(false);
        }
        if (this._apply.equals(source)) {
            this.apply();
        }
    }

    private void toGraphOrder(DefaultTableModel tm, List<String> originGraphOrder) {
        for (int oi = 0; oi < originGraphOrder.size(); ++oi) {
            String graphName = originGraphOrder.get(oi);
            int moveRow = -1;
            for (int tr = 0; tr < tm.getRowCount(); ++tr) {
                if (!graphName.equals(tm.getValueAt(tr, TabPos.GraphName.ordinal()))) continue;
                moveRow = tr;
                break;
            }
            if (moveRow < 0 || oi == moveRow) continue;
            tm.moveRow(moveRow, moveRow, oi);
        }
    }

    private void checkForChanges() {
        boolean enabled = false;
        for (int r = 0; r < this._table.getRowCount(); ++r) {
            String rowGraphName = (String)this._table.getValueAt(r, TabPos.GraphName.ordinal());
            Boolean rowEnabled = (Boolean)this._table.getValueAt(r, TabPos.Enabled.ordinal());
            String startGraphName = (String)this._tableModelAtStart.getValueAt(r, TabPos.GraphName.ordinal());
            Boolean startEnabled = (Boolean)this._tableModelAtStart.getValueAt(r, TabPos.Enabled.ordinal());
            if (!rowGraphName.equals(startGraphName)) {
                enabled = true;
            }
            if (!rowEnabled.equals(startEnabled)) {
                enabled = true;
            }
            if (enabled) break;
        }
        this._apply.setEnabled(enabled);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.checkForChanges();
    }

    public JXTable createTable() {
        Vector<String> tabHead = new Vector<String>();
        tabHead.setSize(TabPos.values().length);
        tabHead.set(TabPos.Icon.ordinal(), this._tabHeadArr[TabPos.Icon.ordinal()]);
        tabHead.set(TabPos.Enabled.ordinal(), this._tabHeadArr[TabPos.Enabled.ordinal()]);
        tabHead.set(TabPos.CmOwner.ordinal(), this._tabHeadArr[TabPos.CmOwner.ordinal()]);
        tabHead.set(TabPos.GraphLabel.ordinal(), this._tabHeadArr[TabPos.GraphLabel.ordinal()]);
        tabHead.set(TabPos.GraphName.ordinal(), this._tabHeadArr[TabPos.GraphName.ordinal()]);
        Vector<Vector<Object>> tabData = this.populateTable();
        this._tableModel = new DefaultTableModel(tabData, tabHead){
            private static final long serialVersionUID = 1L;

            @Override
            public Class<?> getColumnClass(int column) {
                if (column == TabPos.Icon.ordinal()) {
                    return Icon.class;
                }
                if (column == TabPos.Enabled.ordinal()) {
                    return Boolean.class;
                }
                return Object.class;
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return col == TabPos.Enabled.ordinal();
            }
        };
        this.toGraphOrder(this._tableModel, this._orderAtStart);
        this._tableModel.addTableModelListener(this);
        JXTable table = new JXTable((TableModel)this._tableModel);
        table.setSortable(false);
        table.setAutoResizeMode(0);
        table.setShowGrid(false);
        table.setSelectionMode(0);
        SwingUtils.calcColumnWidths((JTable)table);
        return table;
    }

    private Vector<Vector<Object>> populateTable() {
        Vector<Vector<Object>> tab = new Vector<Vector<Object>>();
        Vector<Object> row = new Vector<Object>();
        for (TrendGraph tg : this._trendGraphPanel.getGraphOrder()) {
            row = new Vector();
            row.setSize(TabPos.values().length);
            CountersModel cm = tg.getCm();
            String cmDisplayName = cm.getDisplayName();
            int tabIndex = MainFrame.getTabbedPane().indexOfTab(cmDisplayName);
            Icon icon = MainFrame.getTabbedPane().getIconAt(tabIndex);
            row.set(TabPos.Icon.ordinal(), icon);
            row.set(TabPos.Enabled.ordinal(), tg.isGraphEnabled());
            row.set(TabPos.CmOwner.ordinal(), cmDisplayName);
            row.set(TabPos.GraphLabel.ordinal(), tg.getLabel());
            row.set(TabPos.GraphName.ordinal(), tg.getName());
            tab.add(row);
        }
        return tab;
    }

    private static enum TabPos {
        Icon,
        Enabled,
        CmOwner,
        GraphLabel,
        GraphName;

    }
}

