/*
 * Decompiled with CFR 0.152.
 */
package asemon.gui.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public final class JColorComboBox
extends JComboBox {
    private static final long serialVersionUID = 9029315930996566434L;
    public static final int LINE = 0;
    public static final int RECT = 1;
    public static final int TEXT_ONLY = 2;
    private static final int DEFAULT_LINE_THICKNESS = 2;
    private static final int DEFAULT_RECT_THICKNESS = 10;
    private static final int DEFAULT_HEIGHT = 16;
    private static final int DEFAULT_MARGINS = 6;
    private static final int DEFAULT_WIDTH = 80;
    private static final Color[] DEFAULT_COLORS = new Color[]{Color.black, Color.blue, Color.cyan, Color.darkGray, Color.gray, Color.green, Color.lightGray, Color.magenta, Color.orange, Color.pink, Color.red, Color.white, Color.yellow};
    private static final String[] DEFAULT_COLOR_NAMES = new String[]{"Black", "Blue", "Cyan", "Dark gray", "Gray", "Green", "Light gray", "Magenta", "Orange", "Pink", "Red", "White", "Yellow"};
    private static final Pair[] DEFAULT_PAIRS = new Pair[DEFAULT_COLORS.length];
    private int type;
    private boolean showText;
    private int thickness;
    private int height;
    private int width;

    public JColorComboBox(int type) {
        this.init(type, false, new DefaultComboBoxModel<Pair>(DEFAULT_PAIRS));
    }

    public JColorComboBox(int type, boolean showText) {
        if (type == 2 && !showText) {
            System.out.println("JColorComboBox: constructor called with (type == TEXT_ONLY) and (showText == false), assuming (showText == true).");
        }
        this.init(type, showText, new DefaultComboBoxModel<Pair>(DEFAULT_PAIRS));
    }

    public JColorComboBox(int type, Color[] colors) {
        if (type == 2) {
            System.out.println("JColorComboBox: constructor called with (type == TEXT_ONLY) and no text info, ignored.");
            type = 0;
        }
        Pair[] pairs = new Pair[colors.length];
        for (int i = 0; i < pairs.length; ++i) {
            pairs[i] = new Pair(colors[i], null);
        }
        this.init(type, false, new DefaultComboBoxModel<Pair>(pairs));
    }

    public JColorComboBox(int type, Color[] colors, String[] colorNames) {
        Pair[] pairs = new Pair[colors.length];
        for (int i = 0; i < pairs.length; ++i) {
            pairs[i] = new Pair(colors[i], colorNames[i]);
        }
        this.init(type, true, new DefaultComboBoxModel<Pair>(pairs));
    }

    public void setShowText(boolean showText) {
        if (this.type == 2 && !showText) {
            System.out.println("JColorComboBox: setShowText(false) called with (type == TEXT_ONLY), ignored.");
            return;
        }
        this.showText = showText;
    }

    public boolean getShowText() {
        return this.showText;
    }

    public void setType(int type) {
        if (type == this.type) {
            return;
        }
        if (type == 2) {
            if (this.getModel().getSize() > 0 && ((Pair)this.getModel().getElementAt((int)0)).name != null) {
                System.out.println("JColorComboBox: setType(TEXT_ONLY) called with no text info, ignored.");
                return;
            }
            this.showText = true;
        }
        this.type = type;
        this.thickness = type == 0 ? 2 : 10;
        this.height = 16;
        this.width = 80;
        this.setRenderer(new ComboBoxRenderer(this, this.thickness, 16, 80));
    }

    public int getType() {
        return this.type;
    }

    public void setColorThickness(int thickness) {
        int def_thickness;
        if (thickness == this.thickness) {
            return;
        }
        if (thickness < 1) {
            thickness = 1;
        }
        int n = def_thickness = this.type == 0 ? 2 : 10;
        if (thickness < def_thickness) {
            thickness = def_thickness;
        }
        this.thickness = thickness;
        this.height = thickness + 6;
        if (this.height < 16) {
            this.height = 16;
        }
        this.setRenderer(new ComboBoxRenderer(this, thickness, this.height, this.width));
    }

    public int getColorThickness() {
        return this.thickness;
    }

    public void setItemHeight(int height) {
        if (height == this.height) {
            return;
        }
        if (height < this.thickness) {
            height = this.thickness;
        }
        this.setRenderer(new ComboBoxRenderer(this, this.thickness, height, this.width));
    }

    public int getItemHeight() {
        return this.height;
    }

    public void setColorWidth(int width) {
        if (width == this.width) {
            return;
        }
        if (width < 1) {
            width = 1;
        }
        this.width = width;
        this.setRenderer(new ComboBoxRenderer(this, this.thickness, this.height, width));
    }

    public int getColorWidth() {
        return this.width;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.setRenderer(new ComboBoxRenderer(this, this.thickness, this.height, this.width));
    }

    public Color getSelectedColor() {
        return ((Pair)this.getSelectedItem()).color;
    }

    public void setSelectedColor(Color color) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            Pair p = (Pair)model.getElementAt(i);
            if (!p.color.equals(color)) continue;
            this.setSelectedIndex(i);
            break;
        }
    }

    public void setSelectedText(String text) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            Pair p = (Pair)model.getElementAt(i);
            if (p.name == null || !p.name.equals(text)) continue;
            this.setSelectedIndex(i);
            break;
        }
    }

    @Override
    public void setSelectedItem(Object color) {
        System.out.println("JColorComboBox.setSelectedItem(Object): color.getClass='" + color.getClass().getName() + "', color.toString='" + color + "'.");
        if (color instanceof Pair) {
            super.setSelectedItem(color);
            return;
        }
        if (color instanceof Color) {
            this.setSelectedColor((Color)color);
            return;
        }
        if (color != null) {
            this.setSelectedText(color.toString());
        }
        super.setSelectedItem(color);
    }

    private void init(int type, boolean showText, ComboBoxModel model) {
        this.type = type;
        if (type == 2) {
            showText = true;
        }
        this.showText = showText;
        this.setModel(model);
        this.setEditable(false);
        this.thickness = type == 0 ? 2 : 10;
        this.height = 16;
        this.width = 80;
        this.setRenderer(new ComboBoxRenderer(this, this.thickness, 16, 80));
    }

    static {
        for (int i = 0; i < DEFAULT_PAIRS.length; ++i) {
            JColorComboBox.DEFAULT_PAIRS[i] = new Pair(DEFAULT_COLORS[i], DEFAULT_COLOR_NAMES[i]);
        }
    }

    private final class ComboBoxRenderer
    extends JPanel
    implements ListCellRenderer {
        private static final long serialVersionUID = 1276567177059308897L;
        private Color color;
        private int width;
        private int thickness;
        private int height;
        private int disp;
        JPanel textPanel;
        JLabel text;

        public ComboBoxRenderer(JComboBox combo, int thickness, int height, int width) {
            this.thickness = thickness;
            this.width = width;
            this.height = height;
            this.disp = height / 2 - thickness / 2;
            this.textPanel = new JPanel();
            this.textPanel.setLayout(new FlowLayout(0, 1, 0));
            this.textPanel.add(this);
            this.text = new JLabel();
            this.text.setOpaque(true);
            this.text.setFont(combo.getFont());
            this.textPanel.add(this.text);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
            } else {
                this.setBackground(JColorComboBox.super.getBackground());
            }
            this.color = ((Pair)value).color;
            if (JColorComboBox.this.showText) {
                this.text.setText(((Pair)value).name);
                this.text.setForeground(this.color);
                this.text.setBackground(this.getBackground());
                if (JColorComboBox.this.type == 2) {
                    return this.text;
                }
                this.textPanel.setBackground(this.getBackground());
                return this.textPanel;
            }
            return this;
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.setColor(this.color);
            g.fillRect(2, this.disp, this.getWidth() - 4, this.thickness);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.width, this.height);
        }
    }

    private static final class Pair {
        Color color;
        String name;

        public Pair(Color color, String name) {
            this.color = color;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

