/*
 * Decompiled with CFR 0.152.
 */
package asemon.gui.swing;

import java.lang.reflect.Constructor;
import java.text.Collator;
import java.util.regex.Pattern;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;

public class RowFilterValueAndOp
extends RowFilter<TableModel, Integer> {
    private static Logger _logger = Logger.getLogger(RowFilterValueAndOp.class);
    public static final int FILTER_OP_EQ = 0;
    public static final int FILTER_OP_NE = 1;
    public static final int FILTER_OP_GT = 2;
    public static final int FILTER_OP_LT = 3;
    private int _filterOp = -1;
    private String _filterVal = null;
    private int _colId = -1;
    private boolean _filterIsActive = false;
    private Pattern _strPattern = null;
    private Object _filterObj = null;
    private JTable _table = null;

    public RowFilterValueAndOp(JTable table) {
        this._table = table;
    }

    public void resetFilter() {
        _logger.debug((Object)"Resetting filter, all data will be shown in table.");
        this._filterIsActive = false;
        this._filterOp = -1;
        this._colId = -1;
        this._filterVal = null;
        this._filterObj = null;
        this._strPattern = null;
        if (this._table.getRowSorter() != null) {
            this._table.getRowSorter().allRowsChanged();
        }
    }

    public void setFilter(int op, int col, String val) {
        _logger.debug((Object)("Setting filter: op=" + op + ", col=" + col + ", val='" + val + "'."));
        this._filterIsActive = true;
        this._filterOp = op;
        this._colId = col;
        this._filterVal = val;
        this._filterObj = null;
        this._strPattern = this._filterVal == null || this._filterVal != null && this._filterVal.trim().equals("") ? Pattern.compile(".*") : Pattern.compile(this._filterVal);
        if (this._table.getRowSorter() != null) {
            this._table.getRowSorter().allRowsChanged();
        }
    }

    private int compare(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1.getClass() == String.class && o2.getClass() == String.class) {
            return Collator.getInstance().compare((String)o1, (String)o2);
        }
        if (o1.getClass().isInstance(o2) && o1 instanceof Comparable) {
            Comparable c1 = (Comparable)o1;
            return c1.compareTo(o2);
        }
        if (o2.getClass().isInstance(o1) && o2 instanceof Comparable) {
            Comparable c2 = (Comparable)o2;
            return -c2.compareTo(o1);
        }
        return Collator.getInstance().compare(o1.toString(), o2.toString());
    }

    private boolean showInView(RowFilter.Entry<? extends TableModel, ? extends Integer> entry) {
        Object cellValue = entry.getValue(this._colId);
        if (cellValue == null) {
            return true;
        }
        if (this._filterObj == null) {
            try {
                if (cellValue instanceof Number) {
                    String className = cellValue.getClass().getName();
                    Class<?> clazz = Class.forName(className);
                    Constructor<?> constr = clazz.getConstructor(String.class);
                    this._filterObj = constr.newInstance(this._filterVal);
                } else {
                    this._filterObj = this._filterVal;
                }
            }
            catch (Exception e) {
                _logger.info((Object)("Problems create a Number of the string '" + this._filterVal + "' for filtering, using String matching instead. " + e.getMessage()));
                this._filterObj = this._filterVal;
            }
        }
        if (this._filterOp == 0) {
            if (this._filterObj instanceof String) {
                return this._strPattern.matcher(cellValue.toString()).find();
            }
            return this.compare(cellValue, this._filterObj) == 0;
        }
        if (this._filterOp == 1) {
            if (this._filterObj instanceof String) {
                return !this._strPattern.matcher(cellValue.toString()).find();
            }
            return this.compare(cellValue, this._filterObj) != 0;
        }
        if (this._filterOp == 3) {
            return this.compare(cellValue, this._filterObj) < 0;
        }
        if (this._filterOp == 2) {
            return this.compare(cellValue, this._filterObj) > 0;
        }
        _logger.warn((Object)("Unknown _filterOp = " + this._filterOp));
        return true;
    }

    @Override
    public boolean include(RowFilter.Entry<? extends TableModel, ? extends Integer> entry) {
        if (!this._filterIsActive) {
            return true;
        }
        return this.showInView(entry);
    }
}

