/*
 * Decompiled with CFR 0.152.
 */
package asemon.gui.wizard;

import asemon.Asemon;
import asemon.gui.swing.MultiLineLabel;
import asemon.gui.wizard.WizardOffline;
import asemon.utils.AseConnectionFactory;
import asemon.utils.StringUtil;
import com.sybase.util.ds.interfaces.SyInterfacesDriver;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.log4j.Logger;
import org.netbeans.spi.wizard.WizardPage;

public class WizardOfflinePage1
extends WizardPage
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static Logger _logger = Logger.getLogger(WizardOfflinePage1.class);
    private static final String WIZ_NAME = "ase-info";
    private static final String WIZ_DESC = "ASE information";
    private static final String WIZ_HELP = "Connection information about the ASE server to sample statistics from.";
    private JComboBox _aseName = new JComboBox();
    private JTextField _aseHost = new JTextField("");
    private JTextField _asePort = new JTextField("");
    private JTextField _aseUsername = new JTextField("");
    private JTextField _asePassword = new JPasswordField();
    private SyInterfacesDriver _interfacesDriver = null;

    public static String getDescription() {
        return WIZ_DESC;
    }

    public Dimension getPreferredSize() {
        return WizardOffline.preferredSize;
    }

    public WizardOfflinePage1() {
        super(WIZ_NAME, WIZ_DESC);
        this.setLayout((LayoutManager)new MigLayout("", "[] [grow] []", ""));
        this._aseName.setName("aseName");
        this._aseHost.setName("aseHost");
        this._asePort.setName("asePort");
        this._aseUsername.setName("aseUsername");
        this._asePassword.setName("asePassword");
        this.add(new MultiLineLabel(WIZ_HELP), "wmin 100, span, growx, gapbottom 15, wrap");
        this.add(new JLabel("ASE Name"));
        this.add(this._aseName, "growx, wrap");
        this._aseName.putClientProperty("NAME", "ASE_NAME");
        this._aseName.addActionListener(this);
        this.add(new JLabel("Host Name"));
        this.add(this._aseHost, "growx, wrap");
        this.add(new JLabel("Port Number"));
        this.add(this._asePort, "growx, wrap");
        this.add(new JLabel("Username"));
        this.add(this._aseUsername, "growx, wrap");
        this.add(new JLabel("Password"));
        this.add(this._asePassword, "growx, wrap");
        JButton button = new JButton("Test Connection");
        button.addActionListener(this);
        button.putClientProperty("NAME", "BUTTON_CONN_TEST_ASE");
        this.add(button, "span, align right");
        this.initData();
    }

    private void initData() {
        try {
            this._interfacesDriver = new SyInterfacesDriver();
            this._interfacesDriver.open();
        }
        catch (Exception ex) {
            _logger.error((Object)"Problems reading interfaces or sql.ini file.", (Throwable)ex);
        }
        if (this._interfacesDriver != null) {
            _logger.debug((Object)("Just opened the interfaces file '" + this._interfacesDriver.getBundle() + "'."));
            Object[] servers = this._interfacesDriver.getServers();
            if (servers != null) {
                Arrays.sort(servers);
                for (int i = 0; i < servers.length; ++i) {
                    _logger.debug((Object)("Adding server '" + (String)servers[i] + "' to serverListCB."));
                    this._aseName.addItem(servers[i]);
                }
            }
        }
        if (Asemon.getCounterCollector().isMonConnected()) {
            String servername = "";
            try {
                servername = AseConnectionFactory.getServer();
                this._aseName.setSelectedItem(servername);
            }
            catch (RuntimeException e) {
                _logger.warn((Object)("Problems getting info about server '" + servername + "' from the interfaces or sql.ini file."));
            }
            this._aseUsername.setText(AseConnectionFactory.getUser());
            this._asePassword.setText(AseConnectionFactory.getPassword());
        }
    }

    protected String validateContents(Component comp, Object event) {
        String problem = "";
        if (this._aseHost.getText().trim().length() <= 0) {
            problem = problem + "Host Name, ";
        }
        if (this._asePort.getText().trim().length() <= 0) {
            problem = problem + "Port Number, ";
        }
        if (this._aseUsername.getText().trim().length() <= 0) {
            problem = problem + "Username, ";
        }
        if (this._asePort.getText().trim().length() > 0) {
            String portStr = this._asePort.getText();
            String[] sa = StringUtil.commaStrToArray(portStr);
            for (int i = 0; i < sa.length; ++i) {
                try {
                    Integer.parseInt(sa[i]);
                    continue;
                }
                catch (NumberFormatException e) {
                    return "Port Number '" + sa[i] + "' needs to be a number.";
                }
            }
        }
        if (problem.length() > 0) {
            problem = problem.substring(0, problem.length() - 2);
        }
        return problem.length() == 0 ? null : "Following fields cant be empty: " + problem;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        JComponent src = (JComponent)ae.getSource();
        String name = (String)src.getClientProperty("NAME");
        if (name == null) {
            name = "-null-";
        }
        if (name.equals("ASE_NAME")) {
            String srv = (String)this._aseName.getSelectedItem();
            this._aseHost.setText(AseConnectionFactory.getIHosts(srv));
            this._asePort.setText(AseConnectionFactory.getIPorts(srv));
        }
        if (name.equals("BUTTON_CONN_TEST_ASE")) {
            this.testAseConnection("testConnect", this._aseUsername.getText(), this._asePassword.getText(), this._aseHost.getText(), this._asePort.getText());
        }
    }

    private boolean testAseConnection(String appname, String user, String passwd, String host, String port) {
        try {
            Connection conn = AseConnectionFactory.getConnection(host, port, null, user, passwd, appname, "", null);
            String aseVersionStr = "unknown";
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("select @@version");
            while (rs.next()) {
                aseVersionStr = rs.getString(1);
            }
            rs.close();
            conn.close();
            JOptionPane.showMessageDialog((Component)((Object)this), "Connection succeeded.\n\n" + aseVersionStr, "asemon - connect check", 1);
            return true;
        }
        catch (SQLException e) {
            StringBuffer sb = new StringBuffer();
            while (e != null) {
                sb.append("\n");
                sb.append(e.getMessage());
                e = e.getNextException();
            }
            JOptionPane.showMessageDialog((Component)((Object)this), "Connection FAILED.\n\n" + sb.toString(), "asemon - connect check", 0);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Connection FAILED.\n\n" + e.toString(), "asemon - connect check", 0);
        }
        return false;
    }
}

