/*
 * Decompiled with CFR 0.152.
 */
package asemon.gui.wizard;

import asemon.gui.swing.MultiLineLabel;
import asemon.gui.wizard.WizardOffline;
import asemon.utils.StringUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.netbeans.spi.wizard.WizardPage;

public class WizardOfflinePage4
extends WizardPage
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final String WIZ_NAME = "SshConnection";
    private static final String WIZ_DESC = "Host Monitor Connection information";
    private static final String WIZ_HELP = "If you selected any Performance Counter Module in the previous page that was of the type 'Host Monitor'\nThen you need to specify SSH (Secure Shell) information, otherwise we can't connect to it when polling for Performance Counters.";
    private JLabel _noHostMonWasSelected = new JLabel("<html><b>No Host Monitor, Performance Counter was selected.</b> Just press <b>Next</b> to continue.</b></html>");
    private JTextField _sshHostname = new JTextField();
    private JTextField _sshPort = new JTextField();
    private JTextField _sshUsername = new JTextField();
    private JTextField _sshPassword = new JPasswordField();

    public static String getDescription() {
        return WIZ_DESC;
    }

    public Dimension getPreferredSize() {
        return WizardOffline.preferredSize;
    }

    public WizardOfflinePage4() {
        super(WIZ_NAME, WIZ_DESC);
        this.setLayout((LayoutManager)new MigLayout("", "[] [grow] []", ""));
        this._sshHostname.setName("sshHostname");
        this._sshPort.setName("sshPort");
        this._sshUsername.setName("sshUsername");
        this._sshPassword.setName("sshPassword");
        this._sshHostname.setToolTipText("What host name should we connect to when polling for Performance Counters.");
        this._sshPort.setToolTipText("Port number, the SSH server runs on.");
        this._sshUsername.setToolTipText("User name to be used when logging on the the above host name.");
        this._sshPassword.setToolTipText("Password, you can override this with the '-p' command line switch when starting AseMon in no-gui mode, and yes the stored value is encrypted.");
        this._noHostMonWasSelected.setToolTipText("");
        this._noHostMonWasSelected.setVisible(false);
        this.add(new MultiLineLabel(WIZ_HELP), "wmin 100, span, growx, gapbottom 15, wrap");
        this.add(this._noHostMonWasSelected, "span 2, growx, hidemode 3, wrap 20");
        this.add(new JLabel("SSH Hostname"));
        this.add(this._sshHostname, "growx, wrap");
        this.add(new JLabel("SSH Port"));
        this.add(this._sshPort, "growx, wrap");
        this.add(new JLabel("Username"));
        this.add(this._sshUsername, "growx, wrap");
        this.add(new JLabel("Password"));
        this.add(this._sshPassword, "growx, wrap");
        this.initData();
    }

    private void initData() {
    }

    protected void renderingPage() {
        boolean hasHostMonSelection;
        String val = (String)this.getWizardData("to-be-discarded.HostMonitorIsSelected");
        boolean bl = hasHostMonSelection = val != null && val.trim().equalsIgnoreCase("true");
        if (hasHostMonSelection) {
            this._noHostMonWasSelected.setVisible(false);
            this._sshHostname.setEnabled(true);
            this._sshPort.setEnabled(true);
            this._sshUsername.setEnabled(true);
            this._sshPassword.setEnabled(true);
            if (this._sshHostname.getText().trim().length() == 0) {
                String aseHost = this.getWizardData("aseHost").toString();
                if (aseHost != null && !aseHost.equals("")) {
                    String[] hosts;
                    String oshostname = "";
                    for (String host : hosts = StringUtil.commaStrToArray(aseHost)) {
                        if (host.equals("localhost") || host.equals("127.0.0.1")) continue;
                        oshostname = host;
                        break;
                    }
                    this._sshHostname.setText(oshostname);
                }
                this._sshPort.setText("22");
                this._sshUsername.setText("sybase");
            }
        } else {
            this._noHostMonWasSelected.setVisible(true);
            this._sshHostname.setEnabled(false);
            this._sshPort.setEnabled(false);
            this._sshUsername.setEnabled(false);
            this._sshPassword.setEnabled(false);
        }
    }

    protected String validateContents(Component comp, Object event) {
        if (this._noHostMonWasSelected.isVisible()) {
            return null;
        }
        String problem = "";
        if (this._sshHostname.getText().trim().length() <= 0) {
            problem = problem + "Hostname, ";
        }
        if (this._sshPort.getText().trim().length() <= 0) {
            problem = problem + "Port, ";
        }
        if (this._sshUsername.getText().trim().length() <= 0) {
            problem = problem + "User, ";
        }
        if (this._sshPassword.getText().trim().length() <= 0) {
            problem = problem + "Password, ";
        }
        if (problem.length() > 0 && problem.endsWith(", ")) {
            problem = problem.substring(0, problem.length() - 2);
        }
        if (problem.length() > 0) {
            return "Following fields can't be empty: " + problem;
        }
        try {
            Integer.parseInt(this._sshPort.getText());
        }
        catch (NumberFormatException e) {
            return "Port must be a NUMBER, current value is '" + this._sshPort.getText() + "'.";
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
    }
}

