/*
 * Decompiled with CFR 0.152.
 */
package asemon.gui.wizard;

import asemon.GetCounters;
import asemon.MonTablesDictionary;
import asemon.cm.CountersModel;
import asemon.cm.SamplingCnt;
import asemon.gui.swing.MultiLineLabel;
import asemon.gui.wizard.WizardUserDefinedCm;
import asemon.utils.StringUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.AbstractHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.Highlighter;
import org.netbeans.spi.wizard.Wizard;
import org.netbeans.spi.wizard.WizardPage;
import org.netbeans.spi.wizard.WizardPanelNavResult;

public class WizardUserDefinedCmPage5
extends WizardPage
implements ActionListener,
TableModelListener {
    private static final long serialVersionUID = 1L;
    private static final String WIZ_NAME = "PctColls";
    private static final String WIZ_DESC = "Percentage Calculation Columns";
    private static final String WIZ_HELP = "What Columns do you want to do Percentage calculation on.";
    private static final String[] TAB_HEADER = new String[]{"PK", "Diff", "Pct", "Column Name", "Data Type", "Column Num"};
    private static final int TAB_POS_COL_PK = 0;
    private static final int TAB_POS_COL_DIFF = 1;
    private static final int TAB_POS_CHECK = 2;
    private static final int TAB_POS_COL_NAME = 3;
    private static final int TAB_POS_DATA_TYPE = 4;
    private static final int TAB_POS_COL_NUM = 5;
    private boolean _firtsTimeRender = true;
    private String[] _toolTipMonTables = new String[0];
    private JCheckBox _data_chk = new JCheckBox("Specify Percentage Column(s)", false);
    private JXTable _table = null;
    private JButton _selectAll_but = new JButton("Select All");
    private JButton _deSelectAll_but = new JButton("Deselect All");

    public static String getDescription() {
        return WIZ_DESC;
    }

    public Dimension getPreferredSize() {
        return WizardUserDefinedCm.preferredSize;
    }

    public WizardUserDefinedCmPage5() {
        super(WIZ_NAME, WIZ_DESC);
        this.setLayout((LayoutManager)new MigLayout("", "[] [grow] []", ""));
        this.add(new MultiLineLabel(WIZ_HELP), "wmin 100, span, pushx, growx, wrap");
        this.add(this._data_chk, "grow, span");
        Vector<String> tabHead = new Vector<String>();
        tabHead.add(TAB_HEADER[0]);
        tabHead.add(TAB_HEADER[1]);
        tabHead.add(TAB_HEADER[2]);
        tabHead.add(TAB_HEADER[3]);
        tabHead.add(TAB_HEADER[4]);
        tabHead.add(TAB_HEADER[5]);
        Vector tabData = new Vector();
        AbstractHighlighter disableSomeRows = new AbstractHighlighter(){

            protected Component doHighlight(Component comp, ComponentAdapter adapter) {
                if (WizardUserDefinedCmPage5.this._data_chk.isSelected()) {
                    if (adapter.column < 2) {
                        comp.setEnabled(false);
                    } else {
                        comp.setEnabled(WizardUserDefinedCmPage5.this._table.isCellEditable(adapter.row, 2));
                    }
                } else {
                    comp.setEnabled(false);
                }
                return comp;
            }
        };
        DefaultTableModel defaultTabModel = new DefaultTableModel(tabData, tabHead){
            private static final long serialVersionUID = 1L;

            @Override
            public Class<?> getColumnClass(int column) {
                if (column == 0) {
                    return Boolean.class;
                }
                if (column == 1) {
                    return Boolean.class;
                }
                if (column == 2) {
                    return Boolean.class;
                }
                return Object.class;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                if (column == 2) {
                    Object o = this.getValueAt(row, 0);
                    if (o instanceof Boolean && ((Boolean)o).booleanValue()) {
                        return false;
                    }
                    String datatype = (String)this.getValueAt(row, 4);
                    return SamplingCnt.isDiffAllowedForDatatype(datatype);
                }
                return false;
            }
        };
        defaultTabModel.addTableModelListener(this);
        this._table = new JXTable(){
            private static final long serialVersionUID = 0L;

            public String getToolTipText(MouseEvent e) {
                String tip = null;
                Point p = e.getPoint();
                int row = this.rowAtPoint(p);
                int col = this.columnAtPoint(p);
                if (row > 0 && col > 0) {
                    TableModel model;
                    Object cellVal;
                    col = this.convertColumnIndexToModel(col);
                    row = this.convertRowIndexToModel(row);
                    if (col == 3 && (cellVal = (model = this.getModel()).getValueAt(row, col)) instanceof String) {
                        tip = MonTablesDictionary.getInstance().getDescription(WizardUserDefinedCmPage5.this._toolTipMonTables, (String)cellVal);
                    }
                }
                return tip;
            }
        };
        this._table.setHighlighters(new Highlighter[]{disableSomeRows});
        this._table.setModel((TableModel)defaultTabModel);
        this._table.setShowGrid(false);
        this._table.setSortable(true);
        this._table.setSelectionMode(0);
        this._table.setAutoResizeMode(0);
        this._table.packAll();
        this._table.setSortable(true);
        this._table.setColumnControlVisible(true);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView((Component)this._table);
        this.add(jScrollPane, "push, grow, height 100%, wrap");
        this.add(this._selectAll_but, "split");
        this.add(this._deSelectAll_but, "");
        this._data_chk.addActionListener(this);
        this._selectAll_but.addActionListener(this);
        this._deSelectAll_but.addActionListener(this);
    }

    private void refreshTable() {
        Vector<Object> row = new Vector<Object>();
        DefaultTableModel tm = (DefaultTableModel)this._table.getModel();
        SamplingCnt sc = (SamplingCnt)this.getWizardData("SamplingCnt");
        if (sc != null) {
            int r;
            List<String> names = sc.getColNames();
            boolean refresh = false;
            if (tm.getRowCount() == names.size()) {
                for (r = 0; r < tm.getRowCount(); ++r) {
                    String cntName;
                    String colName = (String)tm.getValueAt(r, 3);
                    if (colName.equals(cntName = names.get(r))) continue;
                    refresh = true;
                    break;
                }
            } else {
                refresh = true;
            }
            if (refresh) {
                while (tm.getRowCount() > 0) {
                    tm.removeRow(0);
                }
                r = 0;
                for (String col : names) {
                    ++r;
                    if (col == null) continue;
                    String datatype = sc.getColSqlTypeName(r - 1);
                    row = new Vector();
                    row.add(new Boolean(false));
                    row.add(new Boolean(false));
                    row.add(new Boolean(false));
                    row.add(col);
                    row.add(datatype);
                    row.add(new Integer(r));
                    tm.addRow(row);
                }
            }
            String pkStr = (String)this.getWizardData("pk") + ", ";
            String diffStr = (String)this.getWizardData("diff") + ", ";
            String pctStr = (String)this.getWizardData("pct") + ", ";
            for (int r2 = 0; r2 < tm.getRowCount(); ++r2) {
                String colName = (String)tm.getValueAt(r2, 3);
                boolean isPkCol = pkStr.indexOf(colName + ", ") != -1;
                boolean isDiffCol = diffStr.indexOf(colName + ", ") != -1;
                boolean isPctCol = pctStr.indexOf(colName + ", ") != -1;
                tm.setValueAt(new Boolean(isPkCol), r2, 0);
                tm.setValueAt(new Boolean(isDiffCol), r2, 1);
                tm.setValueAt(new Boolean(isPctCol), r2, 2);
            }
        }
        this._table.packAll();
    }

    private void applyFromTemplate() {
        String cmName = (String)this.getWizardData("cmTemplate");
        if (cmName == null) {
            return;
        }
        CountersModel cm = GetCounters.getCmByName(cmName);
        if (cm != null) {
            boolean hasPct = false;
            TableModel tm = this._table.getModel();
            for (int r = 0; r < tm.getRowCount(); ++r) {
                String colName = (String)tm.getValueAt(r, 3);
                if (!cm.isPctColumn(cm.findColumn(colName))) continue;
                tm.setValueAt(new Boolean(true), r, 2);
                hasPct = true;
            }
            if (hasPct) {
                this._data_chk.setSelected(true);
            }
        }
    }

    protected void renderingPage() {
        this.refreshTable();
        if (this._firtsTimeRender) {
            this.applyFromTemplate();
        }
        this._toolTipMonTables = StringUtil.commaStrToArray((String)this.getWizardData("toolTipMonTables"));
        this._firtsTimeRender = false;
    }

    protected String validateContents(Component comp, Object event) {
        boolean enable = this._data_chk.isSelected();
        this._table.setEnabled(enable);
        this._selectAll_but.setEnabled(enable);
        this._deSelectAll_but.setEnabled(enable);
        if (this._data_chk.isSelected()) {
            int rows = 0;
            TableModel tm = this._table.getModel();
            for (int r = 0; r < tm.getRowCount(); ++r) {
                if (!((Boolean)tm.getValueAt(r, 2)).booleanValue()) continue;
                ++rows;
            }
            return rows > 0 ? null : "Atleast one session needs to be checked.";
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        int r;
        TableModel tm;
        JComponent src = (JComponent)ae.getSource();
        String name = (String)src.getClientProperty("NAME");
        if (name == null) {
            name = "-null-";
        }
        if (this._selectAll_but.equals(src)) {
            tm = this._table.getModel();
            for (r = 0; r < tm.getRowCount(); ++r) {
                if (!tm.isCellEditable(r, 2)) continue;
                tm.setValueAt(new Boolean(true), r, 2);
            }
        }
        if (this._deSelectAll_but.equals(src)) {
            tm = this._table.getModel();
            for (r = 0; r < tm.getRowCount(); ++r) {
                if (!tm.isCellEditable(r, 2)) continue;
                tm.setValueAt(new Boolean(false), r, 2);
            }
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.setProblem(this.validateContents(null, null));
    }

    private void saveWizardData() {
        if (this._data_chk.isSelected()) {
            String pkStr = "";
            TableModel tm = this._table.getModel();
            for (int r = 0; r < tm.getRowCount(); ++r) {
                if (!((Boolean)tm.getValueAt(r, 2)).booleanValue()) continue;
                pkStr = pkStr + tm.getValueAt(r, 3) + ", ";
            }
            if (pkStr.length() > 0) {
                pkStr = pkStr.substring(0, pkStr.length() - 2);
            }
            this.putWizardData("pct", pkStr);
        }
    }

    public WizardPanelNavResult allowBack(String stepName, Map settings, Wizard wizard) {
        this.saveWizardData();
        return WizardPanelNavResult.PROCEED;
    }

    public WizardPanelNavResult allowNext(String stepName, Map settings, Wizard wizard) {
        this.saveWizardData();
        return WizardPanelNavResult.PROCEED;
    }
}

