/*
 * Decompiled with CFR 0.152.
 */
package asemon.hostmon;

import asemon.hostmon.HostMonitorMetaData;
import asemon.hostmon.MonitorIo;
import asemon.utils.Configuration;

public class MonitorIoLinux
extends MonitorIo {
    private int _pos_readsPerSec;
    private int _pos_writesPerSec;

    @Override
    public String getModuleName() {
        return "MonitorIoLinux";
    }

    @Override
    public String getCommand() {
        String cmd = super.getCommand();
        return cmd != null ? cmd : "iostat -xdk " + this.getSleepTime();
    }

    @Override
    public HostMonitorMetaData createMetaData() {
        HostMonitorMetaData md = new HostMonitorMetaData();
        md.setTableName(this.getModuleName());
        md.addStrColumn("device", 1, 1, false, 30, "Disk device name");
        md.addIntColumn("samples", 2, 0, true, "Number of 'sub' sample entries of iostat this value is based on");
        md.addStatColumn("rrqmPerSec", 3, 2, true, 5, 1, "The number of read requests merged per second that were queued to the device");
        md.addStatColumn("wrqmPerSec", 4, 3, true, 5, 1, "The number of write requests merged per second that were queued to the device.");
        md.addStatColumn("readsPerSec", 5, 4, true, 10, 1, "The number of read requests that were issued to the device per second.");
        md.addStatColumn("writesPerSec", 6, 5, true, 10, 1, "The number of write requests that were issued to the device per second.");
        md.addStatColumn("kbReadPerSec", 7, 6, true, 10, 1, "The number of kilobytes read from the device per second.");
        md.addStatColumn("kbWritePerSec", 8, 7, true, 10, 1, "The number of kilobytes writ to the device per second.");
        md.addStatColumn("avgrq-sz", 9, 8, true, 5, 1, "The average size (in  sectors) of the requests that were issued to the device.");
        md.addStatColumn("avgqu-sz", 10, 9, true, 5, 1, "The average queue length of the requests that were issued to the device.");
        md.addStatColumn("await", 11, 10, true, 5, 1, "The average time (in milliseconds) for I/O requests issued to the device to be served. This includes the time spent by the requests in queue and the time spent servicing them.");
        md.addStatColumn("svctm", 12, 11, true, 5, 1, "The average service time (in milliseconds) for I/O requests that were issued to the device.");
        md.addStatColumn("utilPct", 13, 12, true, 4, 1, "Percentage of CPU time during which I/O requests were issued to the device (bandwidth utilization for the device). Device saturation occurs when this value is close to 100%.");
        md.setPkCol("device");
        md.setStatusCol("samples", 1);
        md.setPercentCol("utilPct");
        md.setParseRegexp("\\s+");
        md.setSkipRows("device", "Device:");
        md.setSkipAndAllowRows(null, Configuration.getCombinedConfiguration());
        md.setSkipAndAllowRows("hostmon.MonitorIo.", Configuration.getCombinedConfiguration());
        this._pos_readsPerSec = md.getParseColumnArrayPos("readsPerSec");
        this._pos_writesPerSec = md.getParseColumnArrayPos("writesPerSec");
        return md;
    }

    @Override
    public String[] parseRow(HostMonitorMetaData md, String row, String[] preParsed, int type) {
        if (preParsed.length == md.getParseColumnCount()) {
            if (this.skipRow(md, row, preParsed, type)) {
                return null;
            }
            if (!this.allowRow(md, row, preParsed, type)) {
                return null;
            }
            if (this.isFirstTimeSample()) {
                return preParsed;
            }
            if ("0.00".equals(preParsed[this._pos_readsPerSec]) && "0.00".equals(preParsed[this._pos_writesPerSec])) {
                return null;
            }
            return preParsed;
        }
        return null;
    }
}

