/*
 * Decompiled with CFR 0.152.
 */
package asemon.hostmon;

import asemon.hostmon.HostMonitorMetaData;
import asemon.hostmon.OsRecordParseException;
import java.sql.Timestamp;

public class OsTableRow {
    protected HostMonitorMetaData _md = null;
    protected Object[] _values = null;
    protected String _pkStr = "";

    public OsTableRow() {
    }

    public OsTableRow(HostMonitorMetaData md, String[] inValues) throws OsRecordParseException {
        this._md = md;
        int parseCols = this._md.getParseColumnCount();
        int sqlCols = this._md.getColumnCount();
        if (parseCols != inValues.length) {
            throw new OsRecordParseException("MetaData ParseColumnCount=" + parseCols + ", and input records is '" + inValues.length + "'.");
        }
        this._values = new Object[sqlCols];
        for (HostMonitorMetaData.ColumnEntry ce : this._md.getColumns()) {
            int ip = ce._parseColNum - 1;
            int dp = ce._sqlColNum - 1;
            if (ce._parseColNum > 0) {
                String val = inValues[ip].trim();
                if (ce._isPartOfPk) {
                    this._pkStr = this._pkStr + val + ":";
                }
                this._values[dp] = this._md.newObject(ce, val);
                continue;
            }
            if (ce._status != 2) continue;
            this._values[dp] = new Timestamp(System.currentTimeMillis());
        }
        if (this._pkStr.endsWith(":")) {
            this._pkStr = this._pkStr.substring(0, this._pkStr.length() - 1);
        }
    }

    public String getPk() {
        return this._pkStr;
    }

    public Object getValue(int col) {
        return this._values[col - 1];
    }

    public String toTraceString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PK='").append(this._pkStr).append("', ");
        for (HostMonitorMetaData.ColumnEntry ce : this._md.getColumns()) {
            int dp = ce._sqlColNum - 1;
            sb.append("colName='").append(ce._colName).append("', ");
            sb.append("sqlColNum='").append(ce._sqlColNum).append("', ");
            sb.append("dp='").append(dp).append("', ");
            sb.append("data='").append(this._values[dp]).append("', ");
            sb.append(".\n");
        }
        return sb.toString();
    }
}

