/*
 * Decompiled with CFR 0.152.
 */
package asemon.pcs;

import asemon.cm.CountersModel;
import asemon.cm.CountersModelAppend;
import asemon.pcs.PersistContainer;
import asemon.pcs.PersistWriterBase;
import asemon.utils.Configuration;
import asemon.utils.MandatoryPropertyException;
import asemon.utils.OSCommand;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class PersistWriterToBcpFiles
extends PersistWriterBase {
    private static Logger _logger = Logger.getLogger(PersistWriterToBcpFiles.class);
    private String COL_SEP = "\t";
    private String ROW_SEP = "\n";
    private String _name = "PersistWriterToBcpFiles";
    private int _moveFilesAfterXSeconds = 3600;
    private String _saveToDir = null;
    private String _moveFilesOsCmd = null;
    private String _moveFilesDateFormat = "yyyyMMdd.HHmmss";
    private String _ddlFilesOsCmd = null;
    private long _lastCounterFileCloseTime = System.currentTimeMillis();
    private List<String> _bcpFiles = new LinkedList<String>();
    private List<String> _ddlFiles = new LinkedList<String>();

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public void close() {
    }

    @Override
    public void startServices() {
    }

    @Override
    public void stopServices() {
    }

    @Override
    public void init(Configuration props) throws Exception {
        String propPrefix = "PersistWriterToBcpFiles.";
        String propname = null;
        propname = propPrefix + "name";
        this._name = props.getProperty(propname, this._name);
        _logger.info((Object)("Initializing the PersistentCounterHandler.WriterClass component named '" + this._name + "'."));
        this._saveToDir = props.getProperty(propPrefix + "saveToDir");
        if (this._saveToDir == null) {
            this._saveToDir = System.getProperty("ASEMON_SAVE_DIR");
            if (this._saveToDir == null) {
                this._saveToDir = System.getProperty("ASEMON_HOME");
                if (this._saveToDir == null) {
                    String err = "Directory 'PersistWriterToBcpFiles.saveToDir' name was not specified and ASEMON_SAVE_DIR or ASEMON_HOME was not set, can't save information about DDL table creation for CounterModel '" + this.getName() + "'.";
                    _logger.error((Object)err);
                    throw new MandatoryPropertyException(err);
                }
            }
        }
        this._moveFilesAfterXSeconds = props.getIntProperty(propPrefix + "moveFilesAfterXSeconds", this._moveFilesAfterXSeconds);
        this._moveFilesOsCmd = props.getProperty(propPrefix + "moveFilesOsCmd");
        this._moveFilesDateFormat = props.getProperty(propPrefix + "moveFilesDateFormat", this._moveFilesDateFormat);
        this._ddlFilesOsCmd = props.getProperty(propPrefix + "ddlFilesOsCmd");
        String configStr = "saveToDir='" + this._saveToDir + "', moveFilesAfterXSeconds='" + this._moveFilesAfterXSeconds + "', moveFilesOsCmd='" + this._moveFilesOsCmd + "', moveFilesDateFormat='" + this._moveFilesDateFormat + "', ddlFilesOsCmd='" + this._ddlFilesOsCmd + "'.";
        _logger.info((Object)("Configuration for PersistentCounterHandler.WriterClass component named '" + this._name + "': " + configStr));
    }

    public void beginOfSample() {
    }

    public void endOfSample(boolean caughtErrors) {
        int secondsSinceLastFileClose;
        if (this._ddlFiles.size() > 0) {
            _logger.info((Object)"Calling installation/creation scripts for all the DDL files.");
            for (String ddlFile : this._ddlFiles) {
                if (ddlFile == null) continue;
                this.installDdlFile(ddlFile);
            }
            this._ddlFiles.clear();
        }
        if ((secondsSinceLastFileClose = (int)(System.currentTimeMillis() - this._lastCounterFileCloseTime) / 1000) > this._moveFilesAfterXSeconds) {
            this._lastCounterFileCloseTime = System.currentTimeMillis();
            SimpleDateFormat dateFormater = new SimpleDateFormat(this._moveFilesDateFormat);
            String dateStamp = dateFormater.format(new Date(System.currentTimeMillis()));
            _logger.info((Object)"Moving all files into a 'final' state where they are ready to be BCP:ed into a table.");
            for (String bcpFile : this._bcpFiles) {
                if (bcpFile == null) continue;
                this.moveCounterDataFile(bcpFile, dateStamp);
            }
            this._bcpFiles.clear();
        }
    }

    @Override
    public void saveSample(PersistContainer cont) {
        Timestamp parentSampleTime = cont.getMainSampleTime();
        String aseServerName = cont.getServerName();
        try {
            String tabName = PersistWriterToBcpFiles.getTableName(1, null, false);
            if (!this.isDdlCreated(tabName)) {
                String sql = this.getTableDdlString(1, null);
                sql = sql + "\n";
                sql = sql + "go";
                sql = sql + "\n";
                BufferedWriter ddlTabWriter = null;
                String ddlFileName = this._saveToDir + "/ddl_" + tabName + ".sql";
                try {
                    ddlTabWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(ddlFileName)));
                    _logger.info((Object)("Writing table DDL information for '" + tabName + "'."));
                    ddlTabWriter.write(sql);
                    ddlTabWriter.close();
                    this._ddlFiles.add(ddlFileName);
                }
                catch (FileNotFoundException e) {
                    _logger.warn((Object)("Problems opening/creating the a file. " + e));
                    return;
                }
                catch (IOException e) {
                    _logger.warn((Object)"Error writing to file.", (Throwable)e);
                    return;
                }
                this.markDdlAsCreated(tabName);
            }
            BufferedWriter sessWriter = null;
            String sessFileName = this._saveToDir + "/tmp_" + tabName + ".bcp.appender";
            sessWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(sessFileName, true)));
            _logger.debug((Object)("Writing Counter information for CounterModel '" + tabName + "'."));
            sessWriter.write(parentSampleTime.toString());
            sessWriter.write(this.COL_SEP);
            sessWriter.write(aseServerName);
            sessWriter.write(this.ROW_SEP);
            sessWriter.close();
            if (!this._bcpFiles.contains(sessFileName)) {
                this._bcpFiles.add(sessFileName);
            }
            for (CountersModel cm : cont._counterObjects) {
                this.saveCounterData(cm, parentSampleTime, aseServerName);
            }
        }
        catch (FileNotFoundException e) {
            _logger.warn((Object)("Problems opening/creating the a file. " + e));
            return;
        }
        catch (IOException e) {
            _logger.warn((Object)"Error writing to file.", (Throwable)e);
            return;
        }
        catch (SQLException e) {
            _logger.warn((Object)"Problems with SQL stuff.", (Throwable)e);
            return;
        }
    }

    @Override
    public boolean saveDdl(CountersModel cm) {
        BufferedWriter ddlTabWriter = null;
        String ddlFileName = this._saveToDir + "/ddl_" + cm.getName() + ".sql";
        _logger.info((Object)("Writing table DDL information for CounterModel '" + cm.getName() + "'."));
        try {
            ddlTabWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(ddlFileName)));
            ddlTabWriter.write(this.getTableDdlString(100, cm));
            ddlTabWriter.write("go\n");
            ddlTabWriter.write("\n");
            ddlTabWriter.write(this.getIndexDdlString(100, cm));
            ddlTabWriter.write("go\n");
            ddlTabWriter.write("\n");
            ddlTabWriter.write("\n\n\n\n\n\n");
            ddlTabWriter.write(this.getTableDdlString(101, cm));
            ddlTabWriter.write("go\n");
            ddlTabWriter.write("\n");
            ddlTabWriter.write(this.getIndexDdlString(101, cm));
            ddlTabWriter.write("go\n");
            ddlTabWriter.write("\n");
            ddlTabWriter.write("\n\n\n\n\n\n");
            ddlTabWriter.write(this.getTableDdlString(102, cm));
            ddlTabWriter.write("go\n");
            ddlTabWriter.write("\n");
            ddlTabWriter.write(this.getIndexDdlString(102, cm));
            ddlTabWriter.write("go\n");
            ddlTabWriter.write("\n");
            ddlTabWriter.write("\n\n\n\n\n\n");
            if (ddlTabWriter != null) {
                ddlTabWriter.close();
            }
            this._ddlFiles.add(ddlFileName);
            return true;
        }
        catch (FileNotFoundException e) {
            _logger.warn((Object)("Problems opening/creating the a file. " + e));
            return false;
        }
        catch (IOException e) {
            _logger.warn((Object)"Error writing to file.", (Throwable)e);
            return false;
        }
        catch (SQLException e) {
            _logger.warn((Object)"Problems with SQL stuff.", (Throwable)e);
            return false;
        }
    }

    private void saveCounterData(CountersModel cm, Timestamp parentSampleTime, String aseServerName) {
        if (cm == null) {
            _logger.debug((Object)"saveCounterData: cm == null.");
            return;
        }
        if (cm instanceof CountersModelAppend) {
            return;
        }
        if (!cm.hasDiffData()) {
            _logger.info((Object)("No diffData is available, skipping writing Counters for name='" + cm.getName() + "'."));
            return;
        }
        BufferedWriter absWriter = null;
        BufferedWriter diffWriter = null;
        BufferedWriter rateWriter = null;
        String absFileName = this._saveToDir + "/tmp_" + cm.getName() + ".abs.bcp.appender";
        String diffFileName = this._saveToDir + "/tmp_" + cm.getName() + ".diff.bcp.appender";
        String rateFileName = this._saveToDir + "/tmp_" + cm.getName() + ".rate.bcp.appender";
        try {
            absWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(absFileName, true)));
            diffWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(diffFileName, true)));
            rateWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(rateFileName, true)));
            _logger.debug((Object)("Writing Counter information for CounterModel '" + cm.getName() + "'."));
            this.save(cm, 1, absWriter, parentSampleTime, aseServerName);
            this.save(cm, 2, diffWriter, parentSampleTime, aseServerName);
            this.save(cm, 3, rateWriter, parentSampleTime, aseServerName);
            if (!this._bcpFiles.contains(absFileName)) {
                this._bcpFiles.add(absFileName);
            }
            if (!this._bcpFiles.contains(diffFileName)) {
                this._bcpFiles.add(diffFileName);
            }
            if (!this._bcpFiles.contains(rateFileName)) {
                this._bcpFiles.add(rateFileName);
            }
            if (absWriter != null) {
                absWriter.close();
            }
            if (diffWriter != null) {
                diffWriter.close();
            }
            if (rateWriter != null) {
                rateWriter.close();
            }
        }
        catch (FileNotFoundException e) {
            _logger.warn((Object)("Problems opening/creating the a file. " + e));
            return;
        }
        catch (IOException e) {
            _logger.warn((Object)"Error writing or closing file.", (Throwable)e);
        }
    }

    private void save(CountersModel cm, int whatData, BufferedWriter writer, Timestamp parentSampleTime, String aseServerName) throws IOException {
        Object colObj = null;
        StringBuffer rowSb = new StringBuffer();
        List<List<Object>> rows = cm.getDataCollection(whatData);
        List<String> cols = cm.getColNames(whatData);
        if (rows == null || cols == null) {
            _logger.error((Object)("Rows or Columns cant be null. rows='" + rows + "', cols='" + cols + "'"));
            return;
        }
        int rowsCount = rows.size();
        int colsCount = cols.size();
        for (int r = 0; r < rowsCount; ++r) {
            rowSb.setLength(0);
            rowSb.append(parentSampleTime.toString());
            rowSb.append(this.COL_SEP);
            rowSb.append(cm.getTimestamp() + "");
            rowSb.append(this.COL_SEP);
            rowSb.append(cm.getLastSampleInterval());
            rowSb.append(this.COL_SEP);
            rowSb.append(aseServerName);
            rowSb.append(this.COL_SEP);
            for (int c = 0; c < colsCount; ++c) {
                colObj = rows.get(r).get(c);
                if (colObj != null) {
                    rowSb.append(colObj);
                } else {
                    rowSb.append("");
                }
                if (c + 1 == colsCount) continue;
                rowSb.append(this.COL_SEP);
            }
            if (rowSb.length() <= 0 || writer == null) continue;
            writer.write(rowSb.toString());
            writer.newLine();
        }
    }

    private boolean moveCounterDataFile(String bcpFile, String dateStamp) {
        File f = new File(bcpFile);
        if (!f.exists()) {
            _logger.warn((Object)("The file '" + bcpFile + "' does not exists."));
            return false;
        }
        String newFileName = "";
        newFileName = bcpFile.replaceFirst("tmp_", "final_" + dateStamp + "_");
        newFileName = newFileName.replaceFirst(".bcp.appender", ".bcp");
        f.renameTo(new File(newFileName));
        if (this._moveFilesOsCmd != null) {
            String osCmdStr = this._moveFilesOsCmd + " " + newFileName;
            try {
                OSCommand osCmd = OSCommand.execute(osCmdStr);
                int retCode = osCmd.returnCode();
                if (retCode != 0) {
                    String retStr = osCmd.getOutput();
                    _logger.error((Object)("Problems when executing the OS Command '" + osCmdStr + "'. The following output was received: " + retStr));
                }
            }
            catch (IOException e) {
                _logger.error((Object)("Problems when executing the OS Command '" + osCmdStr + "'. Caught: " + e));
            }
        }
        return true;
    }

    private boolean installDdlFile(String ddlFile) {
        File f = new File(ddlFile);
        if (!f.exists()) {
            _logger.warn((Object)("The file '" + ddlFile + "' does not exists."));
            return false;
        }
        if (this._ddlFilesOsCmd != null) {
            String osCmdStr = this._ddlFilesOsCmd + " " + ddlFile;
            try {
                OSCommand osCmd = OSCommand.execute(osCmdStr);
                int retCode = osCmd.returnCode();
                if (retCode != 0) {
                    String retStr = osCmd.getOutput();
                    _logger.error((Object)("Problems when executing the OS Command '" + osCmdStr + "'. The following output was received: " + retStr));
                }
            }
            catch (IOException e) {
                _logger.error((Object)("Problems when executing the OS Command '" + osCmdStr + "'. Caught: " + e));
            }
        }
        return true;
    }
}

