/*
 * Decompiled with CFR 0.152.
 */
package asemon.test;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class BusyCusorTest
extends JFrame {
    JPanel panel = new JPanel();
    JButton wait1 = new JButton("Wait 1/3 of a second");
    JButton wait2 = new JButton("Wait 2/3 of a second");
    JButton wait3 = new JButton("Wait 1 second");
    JButton execWait = new JButton("Exec Wait");
    JButton startWait = new JButton("Start Wait");
    JButton stopWait = new JButton("Stop Wait");

    public BusyCusorTest() {
        this.setTitle("Busy Cursor Test");
        this.setSize(400, 400);
        this.setDefaultCloseOperation(2);
        GridLayout layout = new GridLayout(3, 1);
        this.panel.setLayout(layout);
        this.panel.add(this.wait1);
        this.panel.add(this.wait2);
        this.panel.add(this.wait3);
        this.panel.add(this.execWait);
        this.panel.add(this.startWait);
        this.panel.add(this.stopWait);
        this.getContentPane().add(this.panel);
        ActionListener wait1ActionListener = this.delayActionListener(333);
        ActionListener wait2ActionListener = this.delayActionListener(666);
        ActionListener wait3ActionListener = this.delayActionListener(1000);
        ActionListener busy1ActionListener = CursorController.createListener(this, wait1ActionListener);
        ActionListener busy2ActionListener = CursorController.createListener(this, wait2ActionListener);
        ActionListener busy3ActionListener = CursorController.createListener(this, wait3ActionListener);
        this.wait1.addActionListener(busy1ActionListener);
        this.wait2.addActionListener(busy2ActionListener);
        this.wait3.addActionListener(busy3ActionListener);
        this.execWait.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Frame.getFrames()[0].setCursor(Cursor.getPredefinedCursor(3));
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Frame.getFrames()[0].setCursor(Cursor.getDefaultCursor());
            }
        });
        this.startWait.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Frame.getFrames()[0].setCursor(Cursor.getPredefinedCursor(3));
            }
        });
        this.stopWait.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Frame.getFrames()[0].setCursor(Cursor.getDefaultCursor());
            }
        });
        this.setVisible(true);
    }

    private ActionListener delayActionListener(final int delay) {
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                try {
                    System.out.printf("Waiting for %d milliseconds\n", new Integer(delay));
                    Thread.sleep(delay);
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
            }
        };
        return listener;
    }

    public static void main(String[] args) {
        BusyCusorTest cursorTest = new BusyCusorTest();
    }

    public static class CursorController {
        public static final Cursor busyCursor = new Cursor(3);
        public static final Cursor defaultCursor = new Cursor(0);
        public static final int delay = 500;

        private CursorController() {
        }

        public static ActionListener createListener(final Component component, final ActionListener mainActionListener) {
            ActionListener actionListener = new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent ae) {
                    TimerTask timerTask = new TimerTask(){

                        @Override
                        public void run() {
                            component.setCursor(busyCursor);
                        }
                    };
                    Timer timer = new Timer();
                    try {
                        timer.schedule(timerTask, 500L);
                        mainActionListener.actionPerformed(ae);
                    }
                    finally {
                        timer.cancel();
                        component.setCursor(defaultCursor);
                    }
                }
            };
            return actionListener;
        }
    }
}

