/*
 * Decompiled with CFR 0.152.
 */
package asemon.test;

import asemon.test.CloseableTabbedPaneListener;
import com.sun.java.swing.plaf.windows.WindowsTabbedPaneUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.TabbedPaneUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.plaf.metal.MetalTabbedPaneUI;
import javax.swing.text.View;

public class CloseableTabbedPane
extends JTabbedPane
implements MouseListener,
MouseMotionListener {
    private EventListenerList listenerList = null;
    private JViewport headerViewport = null;
    private Icon normalCloseIcon = null;
    private Icon hooverCloseIcon = null;
    private Icon pressedCloseIcon = null;

    public CloseableTabbedPane() {
        this.init(2);
    }

    public CloseableTabbedPane(int horizontalTextPosition) {
        this.init(horizontalTextPosition);
    }

    private void init(int horizontalTextPosition) {
        this.listenerList = new EventListenerList();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        if (this.getUI() instanceof MetalTabbedPaneUI) {
            this.setUI(new CloseableMetalTabbedPaneUI(horizontalTextPosition));
        } else if (this.getUI() instanceof WindowsTabbedPaneUI) {
            this.setUI((TabbedPaneUI)((Object)new CloseableWindowsTabbedPaneUI(horizontalTextPosition)));
        } else {
            this.setUI(new CloseableTabbedPaneUI(horizontalTextPosition));
        }
    }

    public void setCloseIcons(Icon normal, Icon hoover, Icon pressed) {
        this.normalCloseIcon = normal;
        this.hooverCloseIcon = hoover;
        this.pressedCloseIcon = pressed;
    }

    @Override
    public void addTab(String title, Component component) {
        this.addTab(title, component, null);
    }

    public void addTab(String title, Component component, Icon extraIcon) {
        boolean doPaintCloseIcon = true;
        try {
            Object prop = null;
            prop = ((JComponent)component).getClientProperty("isClosable");
            if (prop != null) {
                doPaintCloseIcon = Boolean.parseBoolean((String)prop);
            }
        }
        catch (Exception ignored) {
            // empty catch block
        }
        super.addTab(title, doPaintCloseIcon ? new CloseTabIcon(extraIcon) : null, component);
        if (this.headerViewport == null) {
            Component[] ca = this.getComponents();
            for (int i = 0; i < ca.length; ++i) {
                Component c = ca[i];
                if (!"TabbedPane.scrollableViewport".equals(c.getName())) continue;
                this.headerViewport = (JViewport)c;
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.processMouseEvents(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            CloseTabIcon icon = (CloseTabIcon)this.getIconAt(i);
            if (icon == null) continue;
            icon.mouseover = false;
        }
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.processMouseEvents(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.processMouseEvents(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.processMouseEvents(e);
    }

    private void processMouseEvents(MouseEvent e) {
        block11: {
            Rectangle drawRect;
            Point pos;
            Rectangle rect;
            CloseTabIcon icon;
            block13: {
                block12: {
                    int tabNumber = this.getUI().tabForCoordinate(this, e.getX(), e.getY());
                    if (tabNumber < 0) {
                        return;
                    }
                    icon = (CloseTabIcon)this.getIconAt(tabNumber);
                    if (icon == null) break block11;
                    rect = icon.getBounds();
                    pos = this.headerViewport == null ? new Point() : this.headerViewport.getViewPosition();
                    drawRect = new Rectangle(rect.x - pos.x, rect.y - pos.y, rect.width, rect.height);
                    if (e.getID() != 501) break block12;
                    icon.mousepressed = e.getModifiers() == 16;
                    this.repaint(drawRect);
                    break block11;
                }
                if (e.getID() == 503) break block13;
                if (e.getID() == 506) break block13;
                if (e.getID() != 500) break block11;
            }
            pos.x += e.getX();
            pos.y += e.getY();
            if (rect.contains(pos)) {
                if (e.getID() == 500) {
                    int selIndex = this.getSelectedIndex();
                    if (this.fireCloseTab(selIndex)) {
                        if (selIndex > 0) {
                            Rectangle rec = this.getUI().getTabBounds(this, selIndex - 1);
                            MouseEvent event = new MouseEvent((Component)e.getSource(), e.getID() + 1, System.currentTimeMillis(), e.getModifiers(), rec.x, rec.y, e.getClickCount(), e.isPopupTrigger(), e.getButton());
                            this.dispatchEvent(event);
                        }
                        this.remove(selIndex);
                    } else {
                        icon.mouseover = false;
                        icon.mousepressed = false;
                        this.repaint(drawRect);
                    }
                } else {
                    icon.mouseover = true;
                    icon.mousepressed = e.getModifiers() == 16;
                }
            } else {
                icon.mouseover = false;
            }
            this.repaint(drawRect);
        }
    }

    public void addCloseableTabbedPaneListener(CloseableTabbedPaneListener l) {
        this.listenerList.add(CloseableTabbedPaneListener.class, l);
    }

    public void removeCloseableTabbedPaneListener(CloseableTabbedPaneListener l) {
        this.listenerList.remove(CloseableTabbedPaneListener.class, l);
    }

    protected boolean fireCloseTab(int tabIndexToClose) {
        boolean closeit = true;
        Object[] listeners = this.listenerList.getListenerList();
        for (int c = 0; c < listeners.length; ++c) {
            Object i = listeners[c];
            if (!(i instanceof CloseableTabbedPaneListener) || ((CloseableTabbedPaneListener)i).closeTab(tabIndexToClose)) continue;
            closeit = false;
            break;
        }
        return closeit;
    }

    class CloseableWindowsTabbedPaneUI
    extends WindowsTabbedPaneUI {
        private int horizontalTextPosition = 2;

        public CloseableWindowsTabbedPaneUI() {
        }

        public CloseableWindowsTabbedPaneUI(int horizontalTextPosition) {
            this.horizontalTextPosition = horizontalTextPosition;
        }

        protected void layoutLabel(int tabPlacement, FontMetrics metrics, int tabIndex, String title, Icon icon, Rectangle tabRect, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
            iconRect.y = 0;
            iconRect.x = 0;
            textRect.y = 0;
            textRect.x = 0;
            View v = this.getTextViewForTab(tabIndex);
            if (v != null) {
                this.tabPane.putClientProperty("html", v);
            }
            SwingUtilities.layoutCompoundLabel(this.tabPane, metrics, title, icon, 0, 0, 0, this.horizontalTextPosition, tabRect, iconRect, textRect, this.textIconGap + 2);
            this.tabPane.putClientProperty("html", null);
            int xNudge = this.getTabLabelShiftX(tabPlacement, tabIndex, isSelected);
            int yNudge = this.getTabLabelShiftY(tabPlacement, tabIndex, isSelected);
            iconRect.x += xNudge;
            iconRect.y += yNudge;
            textRect.x += xNudge;
            textRect.y += yNudge;
        }
    }

    class CloseableMetalTabbedPaneUI
    extends MetalTabbedPaneUI {
        private int horizontalTextPosition = 2;

        public CloseableMetalTabbedPaneUI() {
        }

        public CloseableMetalTabbedPaneUI(int horizontalTextPosition) {
            this.horizontalTextPosition = horizontalTextPosition;
        }

        @Override
        protected void layoutLabel(int tabPlacement, FontMetrics metrics, int tabIndex, String title, Icon icon, Rectangle tabRect, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
            iconRect.y = 0;
            iconRect.x = 0;
            textRect.y = 0;
            textRect.x = 0;
            View v = this.getTextViewForTab(tabIndex);
            if (v != null) {
                this.tabPane.putClientProperty("html", v);
            }
            SwingUtilities.layoutCompoundLabel(this.tabPane, metrics, title, icon, 0, 0, 0, this.horizontalTextPosition, tabRect, iconRect, textRect, this.textIconGap + 2);
            this.tabPane.putClientProperty("html", null);
            int xNudge = this.getTabLabelShiftX(tabPlacement, tabIndex, isSelected);
            int yNudge = this.getTabLabelShiftY(tabPlacement, tabIndex, isSelected);
            iconRect.x += xNudge;
            iconRect.y += yNudge;
            textRect.x += xNudge;
            textRect.y += yNudge;
        }
    }

    class CloseableTabbedPaneUI
    extends BasicTabbedPaneUI {
        private int horizontalTextPosition = 2;

        public CloseableTabbedPaneUI() {
        }

        public CloseableTabbedPaneUI(int horizontalTextPosition) {
            this.horizontalTextPosition = horizontalTextPosition;
        }

        @Override
        protected void layoutLabel(int tabPlacement, FontMetrics metrics, int tabIndex, String title, Icon icon, Rectangle tabRect, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
            iconRect.y = 0;
            iconRect.x = 0;
            textRect.y = 0;
            textRect.x = 0;
            View v = this.getTextViewForTab(tabIndex);
            if (v != null) {
                this.tabPane.putClientProperty("html", v);
            }
            SwingUtilities.layoutCompoundLabel(this.tabPane, metrics, title, icon, 0, 0, 0, this.horizontalTextPosition, tabRect, iconRect, textRect, this.textIconGap + 2);
            this.tabPane.putClientProperty("html", null);
            int xNudge = this.getTabLabelShiftX(tabPlacement, tabIndex, isSelected);
            int yNudge = this.getTabLabelShiftY(tabPlacement, tabIndex, isSelected);
            iconRect.x += xNudge;
            iconRect.y += yNudge;
            textRect.x += xNudge;
            textRect.y += yNudge;
        }
    }

    class CloseTabIcon
    implements Icon {
        private int x_pos;
        private int y_pos;
        private int width;
        private int height;
        private Icon fileIcon;
        private boolean mouseover = false;
        private boolean mousepressed = false;

        public CloseTabIcon(Icon fileIcon) {
            this.fileIcon = fileIcon;
            this.width = 16;
            this.height = 16;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            boolean doPaintCloseIcon = true;
            try {
                JTabbedPane tabbedpane = (JTabbedPane)c;
                int tabNumber = tabbedpane.getUI().tabForCoordinate(tabbedpane, x, y);
                JComponent curPanel = (JComponent)tabbedpane.getComponentAt(tabNumber);
                Object prop = null;
                prop = curPanel.getClientProperty("isClosable");
                if (prop != null) {
                    doPaintCloseIcon = Boolean.parseBoolean((String)prop);
                }
            }
            catch (Exception ignored) {
                // empty catch block
            }
            if (doPaintCloseIcon) {
                this.x_pos = x;
                this.y_pos = y;
                int y_p = y + 1;
                if (CloseableTabbedPane.this.normalCloseIcon != null && !this.mouseover) {
                    CloseableTabbedPane.this.normalCloseIcon.paintIcon(c, g, x, y_p);
                } else if (CloseableTabbedPane.this.hooverCloseIcon != null && this.mouseover && !this.mousepressed) {
                    CloseableTabbedPane.this.hooverCloseIcon.paintIcon(c, g, x, y_p);
                } else if (CloseableTabbedPane.this.pressedCloseIcon != null && this.mousepressed) {
                    CloseableTabbedPane.this.pressedCloseIcon.paintIcon(c, g, x, y_p);
                } else {
                    ++y_p;
                    Color col = g.getColor();
                    if (this.mousepressed && this.mouseover) {
                        g.setColor(Color.WHITE);
                        g.fillRect(x + 1, y_p, 12, 13);
                    }
                    g.setColor(Color.black);
                    g.drawLine(x + 1, y_p, x + 12, y_p);
                    g.drawLine(x + 1, y_p + 13, x + 12, y_p + 13);
                    g.drawLine(x, y_p + 1, x, y_p + 12);
                    g.drawLine(x + 13, y_p + 1, x + 13, y_p + 12);
                    g.drawLine(x + 3, y_p + 3, x + 10, y_p + 10);
                    if (this.mouseover) {
                        g.setColor(Color.GRAY);
                    }
                    g.drawLine(x + 3, y_p + 4, x + 9, y_p + 10);
                    g.drawLine(x + 4, y_p + 3, x + 10, y_p + 9);
                    g.drawLine(x + 10, y_p + 3, x + 3, y_p + 10);
                    g.drawLine(x + 10, y_p + 4, x + 4, y_p + 10);
                    g.drawLine(x + 9, y_p + 3, x + 3, y_p + 9);
                    g.setColor(col);
                    if (this.fileIcon != null) {
                        this.fileIcon.paintIcon(c, g, x + this.width, y_p);
                    }
                }
            }
        }

        @Override
        public int getIconWidth() {
            return this.width + (this.fileIcon != null ? this.fileIcon.getIconWidth() : 0);
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }

        public Rectangle getBounds() {
            return new Rectangle(this.x_pos, this.y_pos, this.width, this.height);
        }
    }
}

