/*
 * Decompiled with CFR 0.152.
 */
package asemon.test;

import com.sybase.jdbcx.Debug;
import com.sybase.jdbcx.DynamicClassLoader;
import com.sybase.jdbcx.EedInfo;
import com.sybase.jdbcx.SybDriver;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class IsqlApp {
    static final int DB_BASE_ERR = 11;
    static final String TAG_SEPARATOR = ":";
    static final String DEFAULT_USER = "sa";
    static final String DEFAULT_PASSWORD = "";
    static final String DEFAULT_SERVER = "jdbc:sybase:Tds:127.0.0.1:5000";
    static Connection _con = null;
    static Statement _stmt = null;
    static ResultSet _rs = null;
    static ResultSetMetaData _rsmd = null;
    static BufferedReader _dis = null;
    static String _user = "sa";
    static String _password = "";
    static String _server = "jdbc:sybase:Tds:127.0.0.1:5000";
    static String _gateway = null;
    static String _charset = null;
    static String _protocol = null;
    static String _language = null;
    static String _sessionID = null;
    static String _version = null;
    static String _inputFile = null;
    static String _tagStart = null;
    static String _tagEnd = null;
    static String _sectionName = null;
    static boolean _inSection = false;
    static String _commandTerminator = null;
    static boolean _verbose = false;
    static Properties _tagList = null;
    static boolean _noexit = false;
    static boolean _escapeProcessing = true;
    static boolean _dynamicLoader = false;
    private static String _propValue = null;
    private static Debug _debug = null;

    public static void main(String[] args) {
        int exitCode = IsqlApp.doIsql(args);
        if (!_noexit) {
            System.exit(exitCode);
        }
    }

    private static int doIsql(String[] args) {
        IsqlApp.resetOptions();
        _tagList = new Properties();
        try {
            SybDriver sybDriver = null;
            try {
                sybDriver = (SybDriver)Class.forName("com.sybase.jdbc3.jdbc.SybDriver").newInstance();
            }
            catch (Exception ex41) {
                if (ex41 instanceof InstantiationException || ex41 instanceof ClassNotFoundException) {
                    sybDriver = (SybDriver)Class.forName("com.sybase.jdbc.SybDriver").newInstance();
                }
                throw ex41;
            }
            _debug = sybDriver.getDebug();
            if (!IsqlApp.processCommandline(args)) {
                System.out.println("Syntax:\n\tIsqlApp [-U <username>] [-P <password>] [-S <servername>]\n\t\t[-G <gateway>] [-p <http|https>] [-D <debug-class-list>]\n\t\t[-C <charset>] [-L <language>] [-T <sessionID>] \n\t\t[-v] [-I <input command file>] [-c <command terminator>] \n\t\t[-s <starting tag/section marker>] [-e <ending tag/section marker>] \n\t\t[-t <tag name> <new value>] [-n <section name to execute>] \n\t\t[-N] [-V <version {2,3,4,5}] -d\n");
                return 1;
            }
            if (_inputFile != null) {
                try {
                    _dis = new BufferedReader(new FileReader(_inputFile));
                }
                catch (FileNotFoundException fnfe) {
                    System.out.println("Unable to open " + _inputFile + "\n\t" + fnfe.toString());
                    return 1;
                }
            } else {
                _dis = new BufferedReader(new InputStreamReader(System.in));
            }
            Properties props = new Properties();
            props.put("user", _user);
            props.put("password", _password);
            if (_charset != null) {
                props.put("CHARSET", _charset);
            }
            if (_protocol != null) {
                props.put("CONNECT_PROTOCOL", _protocol);
            }
            if (_language != null) {
                props.put("LANGUAGE", _language);
            }
            if (_gateway != null) {
                props.put("proxy", _gateway);
            }
            if (_sessionID != null) {
                props.put("SESSION_ID", _sessionID);
            }
            if (_version != null) {
                props.put("JCONNECT_VERSION", _version);
            }
            if (_dynamicLoader) {
                Properties p2 = (Properties)props.clone();
                String dlServer = _server;
                p2.remove("PROTOCOL_CAPTURE");
                int start = _server.indexOf("PROTOCOL_CAPTURE");
                if (start != -1) {
                    dlServer = _server.substring(0, start);
                    int end = _server.indexOf("&", start);
                    if (end != -1) {
                        String remainder = _server.substring(end + 1);
                        dlServer = dlServer + remainder;
                    }
                    if (dlServer.endsWith("?") || dlServer.endsWith("&")) {
                        dlServer = dlServer.substring(0, dlServer.length() - 1);
                    }
                }
                DynamicClassLoader dl = sybDriver.getClassLoader(_server, p2);
                props.put("CLASS_LOADER", dl);
            }
            _con = DriverManager.getConnection(_server, props);
            IsqlApp.printExceptions(_con.getWarnings());
            _stmt = _con.createStatement();
            _stmt.setEscapeProcessing(_escapeProcessing);
            _con.clearWarnings();
            while (true) {
                int linecount = 1;
                try {
                    StringBuffer query = new StringBuffer();
                    if (_inputFile == null) {
                        System.out.print("\nEnter a query:\n");
                    }
                    while (true) {
                        String line;
                        if (_inputFile == null) {
                            System.out.print(linecount++ + " > ");
                            System.out.flush();
                        }
                        if ((line = _dis.readLine()) == null || line.equals("quit")) {
                            IsqlApp.close();
                            return 0;
                        }
                        if (_commandTerminator == null) {
                            IsqlApp.appendLine(query, line);
                            break;
                        }
                        if (line.trim().equals(_commandTerminator.trim())) break;
                        IsqlApp.appendLine(query, "\n");
                        IsqlApp.appendLine(query, line);
                    }
                    if (query.toString().length() == 0) continue;
                    if (_inputFile != null || _verbose) {
                        System.out.println("executing: " + query.toString());
                    }
                    boolean results = _stmt.execute(query.toString());
                    int rsnum = 0;
                    int rowsAffected = 0;
                    do {
                        IsqlApp.printExceptions(_stmt.getWarnings());
                        _stmt.clearWarnings();
                        if (results) {
                            ++rsnum;
                            _rs = _stmt.getResultSet();
                            IsqlApp.printExceptions(_rs.getWarnings());
                            _rs.clearWarnings();
                            _rsmd = _rs.getMetaData();
                            int numColumns = _rsmd.getColumnCount();
                            System.out.println("\n------------------ Result set " + rsnum + " -----------------------\n");
                            StringBuffer column = new StringBuffer("Columns:");
                            for (int i = 1; i <= numColumns; ++i) {
                                column.append("\t" + _rsmd.getColumnName(i));
                            }
                            System.out.println(column.toString());
                            int rowNum = 1;
                            while (_rs.next()) {
                                IsqlApp.printExceptions(_rs.getWarnings());
                                _rs.clearWarnings();
                                column = new StringBuffer("[ " + rowNum + "]");
                                for (int i = 1; i <= numColumns; ++i) {
                                    column.append("\t" + _rs.getString(i));
                                }
                                System.out.println(column.toString());
                                ++rowNum;
                            }
                            int rowsSelected = _stmt.getUpdateCount();
                            if (rowsSelected < 0) continue;
                            System.out.println(rowsSelected + " rows Affected.");
                            continue;
                        }
                        rowsAffected = _stmt.getUpdateCount();
                        IsqlApp.printExceptions(_stmt.getWarnings());
                        _stmt.clearWarnings();
                        if (rowsAffected < 0) continue;
                        System.out.println(rowsAffected + " rows Affected.");
                    } while ((results = _stmt.getMoreResults()) || rowsAffected != -1);
                }
                catch (SQLException sqe) {
                    IsqlApp.printExceptions(sqe);
                    _stmt.cancel();
                    _stmt.clearWarnings();
                }
            }
        }
        catch (SQLException sqe) {
            IsqlApp.printExceptions(sqe);
            IsqlApp.close();
            return 1;
        }
        catch (Exception e) {
            System.out.println("Unexpected exception : " + e.toString());
            e.printStackTrace();
            IsqlApp.close();
            return 1;
        }
    }

    private static void close() {
        try {
            if (_con != null) {
                _con.close();
                _con = null;
            }
        }
        catch (SQLException sqe) {
            System.out.println("Unexpected exception : " + sqe.toString() + ", sqlstate = " + sqe.getSQLState());
            sqe.printStackTrace();
        }
    }

    private static boolean processCommandline(String[] args) {
        int errorCount = 0;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.regionMatches(0, "-", 0, 1)) {
                try {
                    switch (arg.charAt(1)) {
                        case 'D': {
                            i += IsqlApp.parseArguments(args, i);
                            try {
                                if (_propValue != null) {
                                    _debug.debug(true, _propValue);
                                    break;
                                }
                                ++errorCount;
                            }
                            catch (IOException ioe) {}
                            break;
                        }
                        case 'c': {
                            i += IsqlApp.parseArguments(args, i);
                            if (_propValue != null) {
                                _commandTerminator = _propValue;
                                break;
                            }
                            ++errorCount;
                            break;
                        }
                        case 'a': {
                            _escapeProcessing = false;
                            break;
                        }
                        case 'd': {
                            _dynamicLoader = true;
                            break;
                        }
                        case 'U': {
                            i += IsqlApp.parseArguments(args, i);
                            if (_propValue != null) {
                                _user = _propValue;
                                break;
                            }
                            ++errorCount;
                            break;
                        }
                        case 'P': {
                            i += IsqlApp.parseArguments(args, i);
                            _password = _propValue == null ? DEFAULT_PASSWORD : _propValue;
                            break;
                        }
                        case 'G': {
                            i += IsqlApp.parseArguments(args, i);
                            if (_propValue != null) {
                                _gateway = _propValue;
                                break;
                            }
                            ++errorCount;
                            break;
                        }
                        case 'C': {
                            i += IsqlApp.parseArguments(args, i);
                            if (_propValue != null) {
                                _charset = _propValue;
                                break;
                            }
                            ++errorCount;
                            break;
                        }
                        case 'L': {
                            i += IsqlApp.parseArguments(args, i);
                            if (_propValue != null) {
                                _language = _propValue;
                                break;
                            }
                            ++errorCount;
                            break;
                        }
                        case 'S': {
                            i += IsqlApp.parseArguments(args, i);
                            if (_propValue != null) {
                                _server = _propValue;
                                break;
                            }
                            ++errorCount;
                            break;
                        }
                        case 'T': {
                            i += IsqlApp.parseArguments(args, i);
                            if (_propValue != null) {
                                _sessionID = _propValue;
                                break;
                            }
                            ++errorCount;
                            break;
                        }
                        case 'I': {
                            i += IsqlApp.parseArguments(args, i);
                            if (_propValue != null) {
                                _inputFile = _propValue;
                                break;
                            }
                            ++errorCount;
                            break;
                        }
                        case 'p': {
                            i += IsqlApp.parseArguments(args, i);
                            if (_propValue != null) {
                                _protocol = _propValue;
                                break;
                            }
                            ++errorCount;
                            break;
                        }
                        case 'V': {
                            i += IsqlApp.parseArguments(args, i);
                            if (_propValue != null) {
                                _version = _propValue;
                                break;
                            }
                            ++errorCount;
                            break;
                        }
                        case 'v': {
                            _verbose = true;
                            break;
                        }
                        case 'N': {
                            _noexit = true;
                            break;
                        }
                        case 's': {
                            i += IsqlApp.parseArguments(args, i);
                            if (_propValue != null) {
                                _tagStart = _propValue;
                                break;
                            }
                            ++errorCount;
                            break;
                        }
                        case 'e': {
                            i += IsqlApp.parseArguments(args, i);
                            if (_propValue != null) {
                                _tagEnd = _propValue;
                                break;
                            }
                            ++errorCount;
                            break;
                        }
                        case 'n': {
                            i += IsqlApp.parseArguments(args, i);
                            if (_propValue != null) {
                                _sectionName = _propValue;
                                break;
                            }
                            ++errorCount;
                            break;
                        }
                        case 't': {
                            _tagList.put(args[++i], args[++i]);
                            break;
                        }
                        default: {
                            System.out.println("Invalid command line option: " + arg);
                            ++errorCount;
                        }
                    }
                }
                catch (ArrayIndexOutOfBoundsException aioobe) {
                    System.out.println("missing option argument");
                    ++errorCount;
                }
                continue;
            }
            ++errorCount;
        }
        return errorCount == 0;
    }

    private static void appendLine(StringBuffer query, String line) {
        if (_tagStart != null && _tagEnd != null) {
            String tagName;
            String newValue;
            int indexSeparator;
            if (_sectionName != null) {
                String lookFor = _tagStart + "SECTION " + (_inSection ? "END: " : "BEGIN: ") + _sectionName + _tagEnd;
                if (line.trim().equals(lookFor)) {
                    boolean bl = _inSection = !_inSection;
                }
                if (!_inSection) {
                    return;
                }
            }
            int indexStart = line.indexOf(_tagStart);
            int indexEnd = line.indexOf(_tagEnd);
            if (indexStart != -1 && indexEnd > indexStart && (indexSeparator = line.indexOf(TAG_SEPARATOR, indexStart)) != -1 && indexSeparator > indexStart + _tagStart.length() && indexEnd > indexSeparator + 1 && (newValue = (String)_tagList.get(tagName = line.substring(indexStart + _tagStart.length(), indexSeparator))) != null) {
                int indexSearch;
                String replaceSearch = line.substring(indexSeparator + 1, indexEnd);
                int indexLast = -1;
                while ((indexSearch = line.indexOf(replaceSearch)) != -1 && indexSearch > indexLast) {
                    indexLast = indexSearch;
                    line = (indexSearch == 0 ? DEFAULT_PASSWORD : line.substring(0, indexSearch)) + newValue + (indexSearch + replaceSearch.length() > line.length() ? DEFAULT_PASSWORD : line.substring(indexSearch + replaceSearch.length(), line.length()));
                }
            }
        }
        query.append(line);
    }

    private static void printExceptions(SQLException sqe) {
        while (sqe != null) {
            if (sqe instanceof EedInfo) {
                EedInfo eedi = (EedInfo)sqe;
                if (eedi.getSeverity() >= 11) {
                    boolean firstOnLine = true;
                    System.out.println("Msg " + sqe.getErrorCode() + ", Level " + eedi.getSeverity() + ", State " + eedi.getState() + TAG_SEPARATOR);
                    if (eedi.getServerName() != null) {
                        System.out.print(", Server " + eedi.getServerName());
                        firstOnLine = false;
                    }
                    if (eedi.getProcedureName() != null) {
                        System.out.print((firstOnLine ? DEFAULT_PASSWORD : ", ") + "Procedure " + eedi.getProcedureName());
                        firstOnLine = false;
                    }
                    System.out.println((firstOnLine ? DEFAULT_PASSWORD : ", ") + "Line " + eedi.getLineNumber() + ", Status " + eedi.getStatus() + ", TranState " + eedi.getTranState() + TAG_SEPARATOR);
                }
                System.out.println(sqe.getMessage());
            } else {
                System.out.println("Unexpected exception : SqlState: " + sqe.getSQLState() + " " + sqe.toString() + ", ErrorCode: " + sqe.getErrorCode());
            }
            sqe = sqe.getNextException();
        }
    }

    public static void resetOptions() {
        _user = DEFAULT_USER;
        _password = DEFAULT_PASSWORD;
        _server = DEFAULT_SERVER;
        _gateway = null;
        _charset = null;
        _protocol = null;
        _language = null;
        _sessionID = null;
        _version = null;
        _inputFile = null;
        _tagStart = null;
        _tagEnd = null;
        _sectionName = null;
        _inSection = false;
        _commandTerminator = null;
        _verbose = false;
        _tagList = null;
        _noexit = false;
    }

    private static int parseArguments(String[] argv, int pos) {
        int argc = argv.length - 1;
        String arg = argv[pos].substring(1);
        int argLen = arg.length();
        int incrementValue = 0;
        if (argLen > 1) {
            _propValue = arg.substring(1);
        } else if (pos == argc || argv[pos + 1].regionMatches(0, "-", 0, 1)) {
            _propValue = null;
        } else {
            _propValue = argv[pos + 1];
            incrementValue = 1;
        }
        return incrementValue;
    }
}

