/*
 * Decompiled with CFR 0.152.
 */
package asemon.utils;

import java.io.File;
import org.h2.constant.SysProperties;

public class H2UrlHelper {
    private static String _h2UrlStart = "jdbc:h2:";
    private String _urlType = "file";
    private String _originUrl = null;
    private String _urlOptions = null;
    private String _rawFileName = null;
    private String _extFileName = null;

    public H2UrlHelper(String url) {
        this._originUrl = url;
        this.parse(url);
    }

    private void parse(String url) {
        if (url == null) {
            return;
        }
        if (!url.startsWith(_h2UrlStart)) {
            return;
        }
        this._urlType = "file";
        String urlVal = url.substring(_h2UrlStart.length());
        if (urlVal.indexOf(59) >= 0) {
            int index = urlVal.indexOf(59);
            this._urlOptions = urlVal.substring(index);
            urlVal = urlVal.substring(0, index);
        }
        if (urlVal.startsWith("file:")) {
            this._urlType = "file";
            urlVal = urlVal.substring("file:".length());
        } else if (urlVal.startsWith("mem:")) {
            this._urlType = "mem";
            urlVal = urlVal.substring("mem:".length());
        } else if (urlVal.startsWith("tcp:")) {
            this._urlType = "tcp";
            urlVal = urlVal.substring("tcp:".length());
        } else if (urlVal.startsWith("ssl:")) {
            this._urlType = "ssl";
            urlVal = urlVal.substring("ssl:".length());
        } else if (urlVal.startsWith("zip:")) {
            this._urlType = "zip";
            urlVal = urlVal.substring("zip:".length());
        }
        this._rawFileName = urlVal.trim();
        if ("file".equals(this._urlType)) {
            urlVal = urlVal.replace("[<path>]", "");
            urlVal = urlVal.replace("<dbname>", "");
        }
        if (urlVal.startsWith("~")) {
            String homeDir = SysProperties.USER_HOME;
            urlVal = homeDir + SysProperties.FILE_SEPARATOR + urlVal.substring(1);
        }
        this._extFileName = urlVal.trim();
    }

    public String getOriginUrl() {
        return this._originUrl;
    }

    public String getRawFileString() {
        return this._rawFileName;
    }

    public File getFile() {
        return new File(this._extFileName);
    }

    public File getDir() {
        return this.getDir(null);
    }

    public File getDir(String defaultDir) {
        if ("".equals(this._extFileName)) {
            if (defaultDir != null) {
                return new File(defaultDir);
            }
            return null;
        }
        File f = new File(this._extFileName);
        if (!f.isDirectory()) {
            f = f.getParentFile();
        }
        return f;
    }

    public String getUrlOptions() {
        return this._urlOptions;
    }

    public String getNewUrl(String newDbFile) {
        String url;
        if (newDbFile.indexOf(".h2.db") >= 0) {
            newDbFile = newDbFile.replace(".h2.db", "");
        }
        if (newDbFile.indexOf(".trace.db") >= 0) {
            newDbFile = newDbFile.replace(".trace.db", "");
        }
        if (newDbFile.indexOf(".data.db") >= 0) {
            newDbFile = newDbFile.replace(".data.db", "");
        }
        if (newDbFile.indexOf(".index.db") >= 0) {
            newDbFile = newDbFile.replace(".index.db", "");
        }
        if (newDbFile.matches(".*\\.[0-9]*\\.log\\.db.*")) {
            newDbFile = newDbFile.replaceAll("\\.[0-9]*\\.log\\.db", "");
        }
        if ((url = this._originUrl).startsWith("jdbc:h2:zip:") || newDbFile.toLowerCase().endsWith(".zip")) {
            File f = new File(newDbFile);
            String dbname = f.getName();
            dbname = dbname.toLowerCase().endsWith(".zip") ? dbname.substring(0, dbname.length() - ".zip".length()) : "offlineDb";
            if (!url.startsWith("jdbc:h2:zip:") && newDbFile.toLowerCase().endsWith(".zip")) {
                url = "jdbc:h2:zip:" + newDbFile + "!/" + dbname;
            } else if (url.matches(".*<zipFileName>!/<dbname>.*")) {
                url = url.replaceFirst("<zipFileName>", newDbFile);
                url = url.replaceFirst("<dbname>", dbname);
            } else {
                url = url.replace(this._rawFileName, newDbFile);
            }
        } else {
            url = url.indexOf("[<path>]<dbname>") >= 0 ? url.replace("[<path>]<dbname>", newDbFile) : url.replace(this._rawFileName, newDbFile);
        }
        return url;
    }
}

