/*
 * Decompiled with CFR 0.152.
 */
package asemon.utils;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class Memory {
    private static Logger _logger = Logger.getLogger(Memory.class);
    private static Thread _checkThread = null;
    private static int _memLimitInMb = 10;
    private static ArrayList<MemoryListener> _memListeners = new ArrayList();

    public void setMemoryLimit(int memoryLeftInMB) {
        _memLimitInMb = memoryLeftInMB;
    }

    public static void addMemoryListener(MemoryListener l) {
        if (!_memListeners.contains(l)) {
            _memListeners.add(l);
        }
    }

    public static void removeMemoryListener(MemoryListener l) {
        _memListeners.remove(l);
    }

    public static List<MemoryListener> getMemoryListener() {
        return _memListeners;
    }

    public static void fireOutOfMemory() {
        for (MemoryListener ml : Memory.getMemoryListener()) {
            ml.outOfMemoryHandler();
        }
    }

    public static void fireMemoryConsumption(int memoryLeftInMB) {
        for (MemoryListener ml : Memory.getMemoryListener()) {
            ml.memoryConsumption(memoryLeftInMB);
        }
    }

    public static void start() {
        if (_checkThread != null) {
            _logger.info((Object)"There is already a memory check thread running, I will NOT start another one.");
            return;
        }
        _checkThread = new Thread(){

            @Override
            public void run() {
                _logger.info((Object)"Starting memory checker thread.");
                try {
                    while (true) {
                        int mbLeftAtStart = Memory.getMemoryLeftInMB();
                        Memory.fireMemoryConsumption(mbLeftAtStart);
                        if (mbLeftAtStart <= _memLimitInMb) {
                            System.gc();
                            int mbLeftAfterGc = Memory.getMemoryLeftInMB();
                            _logger.info((Object)("Free memory seems to be less that " + mbLeftAtStart + " MB. After Garbage Collection we got " + mbLeftAfterGc + " MB." + Memory.getMemoryInfoMB()));
                            if (mbLeftAfterGc <= _memLimitInMb) {
                                Memory.fireOutOfMemory();
                            }
                        }
                        Thread.sleep(2000L);
                    }
                }
                catch (InterruptedException ignore) {
                    _logger.info((Object)"Received 'interrupted', so I will stop the memory checker thread.");
                }
                catch (Throwable t) {
                    _logger.info((Object)("Caught '" + t + "', so I will stop the memory checker thread."), t);
                }
                _logger.info((Object)"Ending memory checker thread.");
                _checkThread = null;
            }
        };
        _checkThread.setName("MemoryCheckThread");
        _checkThread.setDaemon(true);
        _checkThread.start();
    }

    public static void shutdown() {
        if (_checkThread == null) {
            _logger.info((Object)"The memory check thread isn't running, so no need to shut it down.");
            return;
        }
        _logger.info((Object)"Sending an 'interrupt' to the memory check thread.");
        _checkThread.interrupt();
    }

    public static boolean checkMemoryUsage(int thresholdMbLeft) {
        int mbLeftAtStart = Memory.getMemoryLeftInMB();
        _logger.debug((Object)Memory.getMemoryInfoMB());
        if (mbLeftAtStart <= thresholdMbLeft) {
            System.gc();
            int mbLeftAfterGc = Memory.getMemoryLeftInMB();
            _logger.info((Object)("Free memory seems to be less that " + mbLeftAtStart + " MB. After Garbage Collection we got " + mbLeftAfterGc + " MB." + Memory.getMemoryInfoMB()));
            if (mbLeftAfterGc <= thresholdMbLeft) {
                Memory.fireOutOfMemory();
                return true;
            }
        }
        return false;
    }

    public static long getMemoryLeftInKB() {
        return Memory.getMaxMemoryInKB() - Memory.getAllocatedMemoryInKB() + Memory.getFreeMemoryInKB();
    }

    public static long getUsedMemoryInKB() {
        return (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L;
    }

    public static long getFreeMemoryInKB() {
        return Runtime.getRuntime().freeMemory() / 1024L;
    }

    public static long getAllocatedMemoryInKB() {
        return Runtime.getRuntime().totalMemory() / 1024L;
    }

    public static long getMaxMemoryInKB() {
        return Runtime.getRuntime().maxMemory() / 1024L;
    }

    public static String getMemoryInfoKB() {
        return "Memory usage: TotalFreeMemory=" + Memory.getMemoryLeftInKB() + " KB, " + "UsedMemory=" + Memory.getUsedMemoryInKB() + " KB, " + "FreeMemory=" + Memory.getFreeMemoryInKB() + " KB, " + "AllocatedMemory=" + Memory.getAllocatedMemoryInKB() + " KB, " + "MaxMemory=" + Memory.getMaxMemoryInKB() + " KB.";
    }

    public static int getMemoryLeftInMB() {
        return Memory.getMaxMemoryInMB() - Memory.getAllocatedMemoryInMB() + Memory.getFreeMemoryInMB();
    }

    public static int getUsedMemoryInMB() {
        return (int)(Memory.getUsedMemoryInKB() / 1024L);
    }

    public static int getFreeMemoryInMB() {
        return (int)(Memory.getFreeMemoryInKB() / 1024L);
    }

    public static int getAllocatedMemoryInMB() {
        return (int)(Memory.getAllocatedMemoryInKB() / 1024L);
    }

    public static int getMaxMemoryInMB() {
        return (int)(Memory.getMaxMemoryInKB() / 1024L);
    }

    public static String getMemoryInfoMB() {
        return "Memory usage: TotalFreeMemory=" + Memory.getMemoryLeftInMB() + " MB, " + "UsedMemory=" + Memory.getUsedMemoryInMB() + " MB, " + "FreeMemory=" + Memory.getFreeMemoryInMB() + " MB, " + "AllocatedMemory=" + Memory.getAllocatedMemoryInMB() + " MB, " + "MaxMemory=" + Memory.getMaxMemoryInMB() + " MB.";
    }

    public static interface MemoryListener {
        public void outOfMemoryHandler();

        public void memoryConsumption(int var1);
    }
}

