/*
 * Decompiled with CFR 0.152.
 */
package asemon.xmenu;

import asemon.gui.LineNumberedPaper;
import asemon.xmenu.XmenuActionBase;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ProcedureCallStack
extends XmenuActionBase {
    private Connection _conn = null;
    private int _spid = -1;
    private boolean _closeConnOnExit;

    @Override
    public void doWork() {
        this._conn = this.getConnection();
        this._spid = Integer.parseInt(this.getParamValue(0));
        this._closeConnOnExit = this.isCloseConnOnExit();
        this.showCallStack();
    }

    public void getCallStack(JTextArea procText) {
        String sqlStatement = "select ContextID, DBName, ObjectName, ObjectType \nfrom master..monProcessProcedures \nwhere SPID = " + this._spid + " \n" + "order by ContextID";
        procText.setText("");
        boolean rows = false;
        try {
            Statement statement = this._conn.createStatement();
            ResultSet rs = statement.executeQuery(sqlStatement);
            while (rs.next()) {
                rows = true;
                String DBName = rs.getString(2);
                String ObjectName2 = rs.getString(3);
                String ObjectType = rs.getString(4);
                String row = DBName + " " + ObjectName2 + " " + ObjectType + "\n";
                procText.append(row);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Executing SQL command '" + sqlStatement + "'. Found the following error:\n." + e, "Error", 0);
        }
        if (!rows) {
            procText.setText("NO Procedure is currentley executing.");
        }
    }

    public void showCallStack() {
        JPanel textPanel = new JPanel();
        final LineNumberedPaper procText = new LineNumberedPaper(0, 0);
        final JFrame textFrame = new JFrame("Procedure Call stack for SPID " + this._spid);
        textFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (ProcedureCallStack.this._closeConnOnExit) {
                    try {
                        if (ProcedureCallStack.this._conn != null) {
                            ProcedureCallStack.this._conn.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
            }
        });
        ActionListener action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("Refresh")) {
                    ProcedureCallStack.this.getCallStack(procText);
                } else {
                    if (ProcedureCallStack.this._closeConnOnExit) {
                        try {
                            if (ProcedureCallStack.this._conn != null) {
                                ProcedureCallStack.this._conn.close();
                            }
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    textFrame.dispose();
                }
            }
        };
        JScrollPane scrollPane = new JScrollPane(procText);
        textPanel.setLayout(new BorderLayout());
        procText.setBackground(Color.white);
        procText.setEnabled(true);
        procText.setEditable(false);
        textPanel.add("Center", scrollPane);
        JPanel buttonPanel = new JPanel();
        JButton refreshButton = new JButton("Refresh");
        JButton closeButton = new JButton("Close");
        refreshButton.addActionListener(action);
        closeButton.addActionListener(action);
        buttonPanel.add(refreshButton);
        buttonPanel.add(closeButton);
        textPanel.add("South", buttonPanel);
        textFrame.getContentPane().add("Center", textPanel);
        textFrame.setSize(500, 300);
        this.getCallStack(procText);
        textFrame.setVisible(true);
    }

    public void setCaretToLineNumber(JTextArea text, int linenumber) {
        String s;
        text.setCaretPosition(0);
        if (linenumber < 2) {
            return;
        }
        StringTokenizer st = new StringTokenizer(text.getText(), "\n", true);
        int count = 0;
        int countRowAfter = 0;
        while (st.hasMoreTokens() & linenumber > 1) {
            s = st.nextToken();
            count += s.length();
            if (!s.equals("\n")) continue;
            --linenumber;
        }
        if (st.hasMoreTokens()) {
            s = st.nextToken();
            countRowAfter = count + s.length();
        }
        text.setCaretPosition(count);
        text.select(count, countRowAfter);
    }
}

