/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util.ds.interfaces;

import com.sybase.util.ds.interfaces.InterfacesBaseParser;
import com.sybase.util.ds.interfaces.InterfacesException;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.StringTokenizer;

public class IniFileParser
extends InterfacesBaseParser {
    private String _fileName;

    protected boolean probe(URL uRL) throws Exception, InterfacesException {
        InputStream inputStream = uRL.openStream();
        this._fileName = uRL.getFile();
        return this.probe(inputStream);
    }

    protected boolean probe(String string) throws Exception, InterfacesException {
        FileInputStream fileInputStream = new FileInputStream(string);
        this._fileName = string;
        return this.probe(fileInputStream);
    }

    protected boolean probe(InputStream inputStream) throws Exception, InterfacesException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        bufferedReader.mark(1);
        if (-1 == bufferedReader.read()) {
            bufferedReader.close();
            InterfacesException interfacesException = new InterfacesException("ERR_EMPTY_FILE", "MSG_INTERFACES", this._fileName);
            throw interfacesException;
        }
        bufferedReader.reset();
        Enumeration enumeration = this.nextSubject(bufferedReader);
        while (enumeration != null && enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (this.isAttributes(string)) continue;
            bufferedReader.close();
            return false;
        }
        bufferedReader.close();
        return enumeration != null;
    }

    protected boolean createFile(String string) {
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(string));
            dataOutputStream.writeBytes(";INI File: " + string + System.getProperty("line.separator"));
            dataOutputStream.close();
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    protected boolean isAttributes(String string) {
        return string != null && string.length() > 0 && (string = string.trim()).indexOf("=") != -1 && !string.startsWith(";") && this.startsWith(string, InterfacesBaseParser.cTypesSet);
    }

    protected boolean addAttributes(String string, String string2, String[] stringArray) {
        int n = string2.indexOf("=");
        String string3 = string2.substring(0, n);
        String string4 = string2.substring(n + 1, string2.length());
        if ((string4 = this.removeWhiteSpaceCharacters(string4)).length() == 0 || string3.length() == 0) {
            return false;
        }
        stringArray[0] = string3.toLowerCase();
        stringArray[1] = string4;
        return true;
    }

    protected boolean isCommentLine(String string) {
        return this.isBlankLine(string) ? false : string.startsWith(";");
    }

    protected boolean isaSubject(String string) {
        return string != null && !this.isCommentLine(string) && string.length() > 0 && string.startsWith("[") && string.endsWith("]");
    }

    protected String getSubject(String string) {
        return string.substring(1, string.length() - 1);
    }

    protected String refineSubject(String string) {
        return string;
    }

    protected boolean startsWith(String string, String[] stringArray) {
        String[] stringArray2 = stringArray;
        int n = 0;
        while (n < stringArray2.length) {
            if (string.startsWith(stringArray2[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected boolean isTLIStyle(String string) {
        return false;
    }

    protected boolean TLI2TCP(String string, String[] stringArray) {
        return false;
    }

    protected boolean TCP2TLI(String string, String[] stringArray) {
        return false;
    }

    private String removeWhiteSpaceCharacters(String string) {
        String string2 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t ");
        while (stringTokenizer.hasMoreTokens()) {
            string2 = string2 + stringTokenizer.nextToken().trim();
        }
        return string2;
    }
}

