/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util.ds.interfaces;

import com.sybase.util.ds.interfaces.InterfacesBaseParser;
import com.sybase.util.ds.interfaces.InterfacesException;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;

public class InterfacesFileParser
extends InterfacesBaseParser {
    private String _fileName;

    protected boolean probe(URL uRL) throws Exception, InterfacesException {
        InputStream inputStream = uRL.openStream();
        this._fileName = uRL.getFile();
        return this.probe(inputStream);
    }

    protected boolean probe(String string) throws Exception, InterfacesException {
        FileInputStream fileInputStream = new FileInputStream(string);
        this._fileName = string;
        return this.probe(fileInputStream);
    }

    protected boolean probe(InputStream inputStream) throws Exception, InterfacesException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        bufferedReader.mark(1);
        if (-1 == bufferedReader.read()) {
            bufferedReader.close();
            InterfacesException interfacesException = new InterfacesException("ERR_EMPTY_FILE", "MSG_INTERFACES", this._fileName);
            throw interfacesException;
        }
        bufferedReader.reset();
        Enumeration enumeration = this.nextSubject(bufferedReader);
        while (enumeration != null && enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (this.isAttributes(string)) continue;
            bufferedReader.close();
            return false;
        }
        bufferedReader.close();
        return enumeration != null;
    }

    protected boolean createFile(String string) {
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(string));
            Date date = new Date();
            dataOutputStream.writeBytes("#Interfaces File: " + string + " created " + date.toString() + System.getProperty("line.separator"));
            dataOutputStream.close();
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    protected boolean isAttributes(String string) {
        if (string != null && string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string = string.trim());
            return stringTokenizer.countTokens() > 0 && this.hasIt(string.trim(), InterfacesBaseParser.cTypesSet);
        }
        return false;
    }

    protected boolean addAttributes(String string, String string2, String[] stringArray) {
        String string3;
        String[] stringArray2;
        if (this.isTLIStyle(string2) && this.TLI2TCP(string2, stringArray2 = new String[1])) {
            String string4 = string2;
            string2 = stringArray2[0];
            String[] stringArray3 = new String[1];
            if (!this.TCP2TLI(string2, stringArray3) || !string4.equals(string2.substring(0, string2.indexOf("/dev/tcp")) + stringArray3[0])) {
                // empty if block
            }
        }
        stringArray2 = new StringTokenizer(string2);
        String string5 = stringArray2.nextToken();
        if (stringArray2.hasMoreTokens()) {
            string3 = stringArray2.nextToken();
            while (stringArray2.hasMoreTokens()) {
                string3 = string3 + " ";
                string3 = string3 + stringArray2.nextToken();
            }
        } else {
            string3 = null;
        }
        if (string3 == null || string3.length() == 0 || string5.length() == 0) {
            return false;
        }
        stringArray[0] = string5.toLowerCase();
        stringArray[1] = string3;
        return true;
    }

    protected boolean isCommentLine(String string) {
        return this.isBlankLine(string) ? false : string.startsWith("#");
    }

    protected boolean isaSubject(String string) {
        if (string != null && !this.isCommentLine(string) && string.length() > 0) {
            return !this.isAttributes(string);
        }
        return false;
    }

    protected String getSubject(String string) {
        return this.refineSubject(string);
    }

    protected String refineSubject(String string) {
        int n = 0;
        String string2 = new String();
        while (n < string.length() && n < 32 && (Character.isLetter(string.charAt(n)) || Character.isDigit(string.charAt(n)) || string.charAt(n) == '_')) {
            string2 = string2 + string.charAt(n);
            ++n;
        }
        return string2;
    }

    protected boolean startsWith(String string, String[] stringArray) {
        return this.isAttributes(string);
    }

    protected boolean isTLIStyle(String string) {
        int n = string.indexOf("tli");
        if (n > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string.substring(n, string.length() - 1), "\t ");
            stringTokenizer.nextToken();
            while (stringTokenizer.hasMoreElements()) {
                if (!stringTokenizer.nextToken().equals("tcp")) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    protected boolean TLI2TCP(String string, String[] stringArray) {
        int n = string.indexOf(92);
        if (n >= 0 && string.charAt(n + 1) == 'x') {
            int n2 = n + 6;
            StringBuffer stringBuffer = new StringBuffer(string.substring(n2, string.length()));
            int[] nArray = new int[12];
            StringBuffer stringBuffer2 = new StringBuffer(1);
            stringBuffer2.append('\u0000');
            int n3 = 0;
            while (n3 <= 11) {
                stringBuffer2.setCharAt(0, stringBuffer.charAt(n3));
                String string2 = new String(stringBuffer2);
                nArray[n3] = Integer.parseInt(string2, 16);
                ++n3;
            }
            int n4 = 0;
            while (n4 < 3) {
                int n5 = n4 + 1;
                nArray[n5] = nArray[n5] + (nArray[n4] << 4);
                ++n4;
            }
            int n6 = 4;
            while (n6 < 12) {
                int n7 = n6 + 1;
                nArray[n7] = nArray[n7] + (nArray[n6] << 4);
                n6 += 2;
            }
            String string3 = new Integer(nArray[3]).toString();
            String string4 = new Integer(nArray[5]).toString() + "." + new Integer(nArray[7]).toString() + "." + new Integer(nArray[9]).toString() + "." + new Integer(nArray[11]).toString();
            stringArray[0] = string.substring(0, n) + string4 + " " + string3;
            return true;
        }
        return false;
    }

    protected boolean TCP2TLI(String string, String[] stringArray) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t .\n\r");
        while (stringTokenizer.hasMoreElements()) {
            int[] nArray = new int[12];
            String string2 = stringTokenizer.nextToken();
            if (string2.indexOf("/dev/tcp") < 0) continue;
            int n = 0;
            while (n < 5 && stringTokenizer.hasMoreElements()) {
                nArray[n] = Integer.valueOf(stringTokenizer.nextToken());
                nArray[n + 5] = nArray[n] & 0xF;
                int n2 = n++;
                nArray[n2] = nArray[n2] >> 4;
            }
            nArray[10] = nArray[4] & 0xF;
            nArray[4] = nArray[4] >> 4;
            nArray[11] = nArray[4] & 0xF;
            nArray[4] = nArray[4] >> 4;
            stringArray[0] = "/dev/tcp \\x0002" + Integer.toHexString(nArray[4]) + Integer.toHexString(nArray[11]) + Integer.toHexString(nArray[10]) + Integer.toHexString(nArray[9]) + Integer.toHexString(nArray[0]) + Integer.toHexString(nArray[5]) + Integer.toHexString(nArray[1]) + Integer.toHexString(nArray[6]) + Integer.toHexString(nArray[2]) + Integer.toHexString(nArray[7]) + Integer.toHexString(nArray[3]) + Integer.toHexString(nArray[8]) + "0000000000000000";
            return true;
        }
        return false;
    }
}

