/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util.ds.interfaces;

import com.sybase.util.ds.interfaces.InterfacesException;
import com.sybase.util.ds.interfaces.SyInterfacesDriverBase;
import com.sybase.util.ds.interfaces.SyInterfacesEntry;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class SyInterfacesDriver
extends SyInterfacesDriverBase {
    private Hashtable _lookup = new Hashtable();
    private static final char OPTION = '-';
    private static final char PROPERTY_OPTION = 'D';
    private static final char TRACE_OPTION = 'T';

    public SyInterfacesDriver() {
    }

    public SyInterfacesDriver(String string) throws Exception, InterfacesException {
        super(string);
        this.fetch();
    }

    public SyInterfacesDriver(String string, boolean bl) throws Exception, InterfacesException {
        super(string, bl);
        this.fetch();
    }

    public void setBundle(String string) {
        this._fileName = string;
    }

    public String getBundle() {
        return this._fileName;
    }

    public void setSaveOnChange(boolean bl) {
        this._saveOnChange = bl;
    }

    public boolean getSaveOnChange() {
        return this._saveOnChange;
    }

    public void open() throws Exception, InterfacesException {
        Object object;
        String string = null;
        String string2 = System.getProperty("interfaces.file");
        if (string2 != null) {
            string = this._fileName = string2;
        } else {
            String string3 = System.getProperty("sybase.home");
            if (string3 != null) {
                object = System.getProperty("os.name");
                string = ((String)object).indexOf("Windows") != -1 ? string3 + System.getProperty("file.separator") + "ini" + System.getProperty("file.separator") + "sql.ini" : string3 + System.getProperty("file.separator") + "interfaces";
            } else {
                this._fileName = null;
                InterfacesException interfacesException = new InterfacesException("ERR_SYBASE_ENV_NOT_DEFINED", "MSG_INTERFACES");
                throw interfacesException;
            }
        }
        if (string == null) {
            this._fileName = null;
            object = new InterfacesException("ERR_SYBASE_ENV_NOT_DEFINED", "MSG_INTERFACES");
            throw object;
        }
        super.load(string);
        this.fetch();
    }

    public synchronized void refresh() throws IOException, InterfacesException {
        this.loadFile();
        this.parseLines();
        this.fetch();
    }

    public Enumeration servers() {
        return this._lookup.keys();
    }

    public String[] getServers() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this._lookup.keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement((String)enumeration.nextElement());
        }
        if (vector.size() > 0) {
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    public String[] getServers(int n) {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this._lookup.keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement((String)enumeration.nextElement());
        }
        if (vector.size() > 0) {
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    public Enumeration entries() {
        return this._lookup.elements();
    }

    public Vector getEntries() {
        Vector<SyInterfacesEntry> vector = new Vector<SyInterfacesEntry>();
        Enumeration enumeration = this._lookup.elements();
        while (enumeration.hasMoreElements()) {
            SyInterfacesEntry syInterfacesEntry = (SyInterfacesEntry)enumeration.nextElement();
            vector.addElement(syInterfacesEntry);
        }
        return vector;
    }

    public synchronized boolean contains(SyInterfacesEntry syInterfacesEntry) {
        String string;
        this.fetch();
        if (syInterfacesEntry != null && (string = syInterfacesEntry.getName()) != null) {
            return this._lookup.contains(string);
        }
        return false;
    }

    public synchronized boolean containsServer(String string) {
        if (string != null) {
            return this._lookup.contains(string);
        }
        return false;
    }

    public SyInterfacesEntry getEntry(String string) {
        return (SyInterfacesEntry)this._lookup.get(string);
    }

    public synchronized boolean addEntry(SyInterfacesEntry syInterfacesEntry) {
        if (syInterfacesEntry == null || syInterfacesEntry.getName() == null) {
            return false;
        }
        if (!this.contains(syInterfacesEntry)) {
            this._lookup.put(syInterfacesEntry.getName(), syInterfacesEntry);
            this.addSubjectLine(syInterfacesEntry.getName());
            String[] stringArray = syInterfacesEntry.getKeys();
            int n = 0;
            while (n < stringArray.length) {
                this.addValue(syInterfacesEntry.getName(), stringArray[n], syInterfacesEntry.getValue(stringArray[n]), true);
                ++n;
            }
            return true;
        }
        return false;
    }

    private void fetch() {
        String[] stringArray = this.getSubjects();
        int n = 0;
        while (n < stringArray.length) {
            SyInterfacesEntry syInterfacesEntry = new SyInterfacesEntry(stringArray[n]);
            String[] stringArray2 = this.getVariables(stringArray[n]);
            int n2 = 0;
            while (n2 < stringArray2.length) {
                syInterfacesEntry.setValue(stringArray2[n2], this.getValue(stringArray[n], stringArray2[n2]));
                this._lookup.put(stringArray[n], syInterfacesEntry);
                ++n2;
            }
            ++n;
        }
    }

    public String toString() {
        Enumeration enumeration = this.entries();
        StringBuffer stringBuffer = new StringBuffer();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(enumeration.nextElement().toString() + "\n");
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        try {
            SyInterfacesDriver.parseArgs(stringArray);
        }
        catch (InterfacesException interfacesException) {
            System.out.println(interfacesException.getMessage());
        }
        SyInterfacesDriver syInterfacesDriver = null;
        try {
            syInterfacesDriver = new SyInterfacesDriver();
        }
        catch (Exception exception) {
            System.out.println(exception.getLocalizedMessage());
        }
        if (syInterfacesDriver == null) {
            syInterfacesDriver = new SyInterfacesDriver();
            try {
                syInterfacesDriver.open();
            }
            catch (InterfacesException interfacesException) {
                System.out.println(interfacesException.getMessage());
                System.exit(1);
            }
            catch (Exception exception) {
                System.out.println(exception.getLocalizedMessage());
                System.exit(1);
            }
        }
        if (syInterfacesDriver != null) {
            System.out.println("----- Start unit test: toString()");
            System.out.println(syInterfacesDriver.toString());
            System.out.println("----- End of unit test\n");
            try {
                syInterfacesDriver.open();
            }
            catch (InterfacesException interfacesException) {
                System.out.println(interfacesException.getMessage());
                System.exit(1);
            }
            catch (Exception exception) {
                System.out.println(exception.getLocalizedMessage());
                System.exit(1);
            }
            System.out.println("----- Start unit test: getServers(), getEntry()");
            String[] stringArray2 = syInterfacesDriver.getServers();
            int n = 0;
            while (n < stringArray2.length) {
                SyInterfacesEntry syInterfacesEntry = syInterfacesDriver.getEntry(stringArray2[n]);
                System.out.println(syInterfacesEntry.toString());
                ++n;
            }
            System.out.println("----- End of unit test\n");
        }
    }

    private static void parseArgs(String[] stringArray) throws InterfacesException {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].startsWith(String.valueOf('-'))) {
                switch (stringArray[n].charAt(1)) {
                    case 'D': {
                        SyInterfacesDriver.processPropertyOption(stringArray[n].substring(2));
                        break;
                    }
                }
            }
            ++n;
        }
    }

    private static void processPropertyOption(String string) throws InterfacesException {
        SyInterfacesDriver.setProperty(string);
    }

    public static String setProperty(String string) throws InterfacesException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
        String string2 = "";
        String string3 = "";
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
                return System.setProperty(string2, string3);
            }
            InterfacesException interfacesException = new InterfacesException("ERR_PARAM_PARSE_ERROR", new String[]{string});
            throw interfacesException;
        }
        InterfacesException interfacesException = new InterfacesException(string);
        throw interfacesException;
    }
}

