/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util.ds.ldap;

import com.sybase.util.ds.ldap.LDAPException;
import com.sybase.util.ds.ldap.LDAPWarning;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;

public class LDAPConfigFileParser {
    private String _fileName;
    private static final String[] LDAP_STRINGS = new String[]{"ldap:", "LDAP:", "dc", "DC", "cn", "CN"};

    protected boolean probe(URL uRL) throws IOException, LDAPException {
        InputStream inputStream = uRL.openStream();
        this._fileName = uRL.getFile();
        return this.probe(inputStream);
    }

    protected boolean probe(String string) throws IOException, LDAPException {
        FileInputStream fileInputStream = new FileInputStream(string);
        this._fileName = string;
        return this.probe(fileInputStream);
    }

    /*
     * Unable to fully structure code
     */
    protected boolean probe(InputStream var1_1) throws IOException, LDAPException {
        var2_2 = new BufferedReader(new InputStreamReader(var1_1));
        var2_2.mark(1);
        if (-1 == var2_2.read()) {
            var2_2.close();
            throw new LDAPException("ERR_EMPTY_FILE", "MSG_LDAP_CONFIG", this._fileName);
        }
        var2_2.reset();
        var3_3 = this.nextSubject(var2_2);
        if (var3_3 != null) ** GOTO lbl14
        throw new LDAPWarning("ERR_NO_LDAP_ENTIRES", "MSG_LDAP_CONFIG", this._fileName);
lbl-1000:
        // 1 sources

        {
            var4_4 = (String)var3_3.nextElement();
            if (this.isAttributes(var4_4)) continue;
            var2_2.close();
            return false;
lbl14:
            // 2 sources

            ** while (var3_3 != null && var3_3.hasMoreElements())
        }
lbl15:
        // 1 sources

        var2_2.close();
        return true;
    }

    protected Enumeration nextSubject(BufferedReader bufferedReader) throws IOException {
        Vector<String> vector = new Vector<String>();
        String string = bufferedReader.readLine();
        if (string == null) {
            return null;
        }
        string = string.trim();
        while (!this.isaSubject(string)) {
            string = bufferedReader.readLine();
            if (string != null) continue;
            if (string == null) {
                return null;
            }
            string = string.trim();
        }
        boolean bl = false;
        while (!bl) {
            if (!this.isEndOfSubject(string)) {
                if (!this.isBlankLine(string) && !this.isCommentLine(string)) {
                    vector.addElement(string);
                }
            } else {
                bl = true;
            }
            if ((string = bufferedReader.readLine()) == null) continue;
            string = string.trim();
        }
        return !vector.isEmpty() ? vector.elements() : null;
    }

    protected boolean isAttributes(String string) {
        if (string != null && string.length() > 0) {
            return (string.startsWith("LDAP") || string.startsWith("ldap")) && this.hasIt(string);
        }
        return false;
    }

    protected boolean isBlankLine(String string) {
        if (string == null) {
            return true;
        }
        return string.trim().length() == 0;
    }

    protected boolean isCommentLine(String string) {
        boolean bl = false;
        if (string != null) {
            if (string.startsWith("#")) {
                bl = true;
            } else if (string.startsWith(";")) {
                bl = true;
            }
        }
        return this.isBlankLine(string) ? false : bl;
    }

    protected boolean isaSubject(String string) {
        return string != null && !this.isCommentLine(string) && string.length() > 0 && this.isAttributes(string);
    }

    protected boolean isEndOfSubject(String string) {
        if (string == null) {
            return true;
        }
        if (this.isBlankLine(string)) {
            return true;
        }
        if (this.isCommentLine(string)) {
            return true;
        }
        return !this.startsWith(string, LDAP_STRINGS);
    }

    protected boolean startsWith(String string, String[] stringArray) {
        return this.isAttributes(string);
    }

    protected boolean hasIt(String string) {
        if (string != null && string.length() > 0) {
            int n = 0;
            while (n < LDAP_STRINGS.length) {
                if (string.indexOf(LDAP_STRINGS[n]) >= 0) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }
}

