/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util.ds.ldap;

import com.sybase.util.ds.ldap.LDAPConfigFileParser;
import com.sybase.util.ds.ldap.LDAPException;
import com.sybase.util.ds.ldap.SyLDAPServer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.Vector;

public class LibctlDriver {
    private Vector _lines;
    private String _fileName;
    private String _fileName64;
    private LDAPConfigFileParser _ldapConfigFileParser;
    private long _nextLine = 0L;
    private Vector _ldapServerNamesList = new Vector();
    private Vector _syLDAPServers = new Vector();
    private String[] _ldapServerNames;
    private final String LIBTCL = "libtcl.cfg";
    private final String LIBTCL64 = "libtcl64.cfg";
    private final String CONFIG = "config";
    private final String INI = "ini";
    private final String _smallLDAP = "ldap://";
    private final String _bigLDAP = "LDAP://";

    public LibctlDriver() throws FileNotFoundException, IOException, SecurityException, LDAPException {
        Properties properties = System.getProperties();
        String string = properties.getProperty("sybase.home");
        String string2 = properties.getProperty("ocs.home");
        String string3 = properties.getProperty("file.separator");
        String string4 = properties.getProperty("os.name");
        boolean bl = false;
        if (string == null) {
            throw new LDAPException("ERR_SYBASE_ENV_NOT_DEFINED", "MSG_LDAP_CONFIG");
        }
        if (string.equals("")) {
            throw new LDAPException("ERR_SYBASE_ENV_DEFINED_BLANK", "MSG_LDAP_CONFIG");
        }
        if (string2 == null) {
            throw new LDAPException("ERR_OCS_HOME_ENV_NOT_DEFINED");
        }
        if (string2.equals("")) {
            throw new LDAPException("ERR_OCS_HOME_ENV_DEFINED_BLANK");
        }
        String string5 = string + string3 + string2 + string3;
        string5 = string4.indexOf("Windows") != -1 ? string5 + "ini" + string3 : string5 + "config" + string3;
        this._fileName = string5 + "libtcl.cfg";
        this._fileName64 = string5 + "libtcl64.cfg";
        if (new File(this._fileName).exists()) {
            this.parseFile(this._fileName);
            bl = true;
        }
        if (new File(this._fileName64).exists()) {
            this.parseFile(this._fileName64);
            bl = true;
        }
        if (!bl) {
            LDAPException lDAPException = new LDAPException("ERR_LDAP_FILE_NOT_FOUND");
            throw new FileNotFoundException(lDAPException.getMessage());
        }
    }

    public LibctlDriver(String string) throws FileNotFoundException, IOException, SecurityException, LDAPException {
        this._fileName = string;
        this.parseFile(string);
    }

    private void parseFile(String string) throws FileNotFoundException, SecurityException, IOException, LDAPException {
        try {
            URL uRL = new URL(string);
            this._ldapConfigFileParser = new LDAPConfigFileParser();
            if (!this._ldapConfigFileParser.probe(uRL)) {
                throw new LDAPException("ERR_FORMAT_ERROR", "MSG_LDAP_CONFIG", string);
            }
            this.loadFile(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            if (!new File(string).exists()) {
                this._fileName = null;
                LDAPException lDAPException = new LDAPException("ERR_LDAP_FILE_NOT_FOUND");
                throw new FileNotFoundException(lDAPException.getMessage());
            }
            this._ldapConfigFileParser = new LDAPConfigFileParser();
            if (!this._ldapConfigFileParser.probe(string)) {
                this._fileName = null;
                throw new LDAPException("ERR_FORMAT_ERROR", "MSG_LDAP_CONFIG", string);
            }
            this.loadFile(string);
        }
        this.parseLines();
    }

    public void loadFile(URL uRL) throws IOException {
        InputStream inputStream = uRL.openStream();
        this.loadFile(inputStream);
    }

    public void loadFile(String string) throws IOException {
        this.loadFile(new FileInputStream(string));
    }

    public void loadFile(InputStream inputStream) throws IOException {
        this._lines = new Vector();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string = "";
        while ((string = bufferedReader.readLine()) != null) {
            this._lines.addElement(string);
        }
        bufferedReader.close();
    }

    private void parseLines() throws LDAPException {
        String string = null;
        int n = 0;
        while (n < this._lines.size()) {
            string = (String)this._lines.elementAt(n);
            if (!this._ldapConfigFileParser.isBlankLine(string) && !this._ldapConfigFileParser.isCommentLine(string) && this.isaSubject(string)) {
                this.parseLDAPLine(string);
            }
            ++n;
        }
        this.fillLDAPServerNames();
    }

    private void parseLDAPLine(String string) throws LDAPException {
        try {
            String string2 = string.indexOf("ldap://") != -1 ? "ldap://" : "LDAP://";
            String string3 = string.substring(string.indexOf(string2) + 7);
            String string4 = "ldap://" + string3;
            String string5 = string3.substring(0, string3.indexOf("/"));
            this._ldapServerNamesList.addElement(string5);
            int n = string5.indexOf(":");
            String string6 = n != -1 ? string5.substring(0, n).trim() : string5;
            String string7 = null;
            if (string5 != null && n != -1) {
                string7 = string5.substring(n + 1).trim();
            }
            SyLDAPServer syLDAPServer = new SyLDAPServer(string5, string6, string7, string4);
            this._syLDAPServers.addElement(syLDAPServer);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new LDAPException("ERR_LDAP_FILE_IS_CORRUPT");
        }
        catch (NullPointerException nullPointerException) {
            throw new LDAPException("ERR_LDAP_FILE_IS_CORRUPT");
        }
    }

    private void fillLDAPServerNames() {
        this._ldapServerNames = new String[this._ldapServerNamesList.size()];
        this._ldapServerNamesList.copyInto(this._ldapServerNames);
    }

    public String[] getLDAPServerNames() {
        return (String[])this._ldapServerNames.clone();
    }

    public Vector getLDAPServers() {
        return (Vector)this._syLDAPServers.clone();
    }

    public boolean containsLDAPServerName(String string) {
        int n = 0;
        while (n < this._ldapServerNames.length) {
            if (string.equals(this._ldapServerNames[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public SyLDAPServer getLDAPServer(String string) {
        int n = 0;
        while (n < this._syLDAPServers.size()) {
            if (string.equals(((SyLDAPServer)this._syLDAPServers.elementAt(n)).getServerName())) {
                return (SyLDAPServer)this._syLDAPServers.elementAt(n);
            }
            ++n;
        }
        return null;
    }

    private boolean isaSubject(String string) {
        return this._ldapConfigFileParser.isaSubject(string);
    }

    private void addSubjectLine(String string) {
        this._lines.addElement("[" + string + "]");
    }

    protected int findSubjectLine(String string) {
        String string2 = "[" + string + "]";
        int n = 0;
        while (n < this._lines.size()) {
            String string3 = (String)this._lines.elementAt(n);
            if (string2.equals(string3)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static void main(String[] stringArray) {
        try {
            LibctlDriver libctlDriver = new LibctlDriver();
            Vector vector = libctlDriver.getLDAPServers();
            int n = 0;
            while (n < vector.size()) {
                System.out.println(((SyLDAPServer)vector.elementAt(n)).getServerName());
                System.out.println(((SyLDAPServer)vector.elementAt(n)).getHost());
                System.out.println(((SyLDAPServer)vector.elementAt(n)).getPort());
                System.out.println(((SyLDAPServer)vector.elementAt(n)).getRootEntry());
                System.out.println(((SyLDAPServer)vector.elementAt(n)).getUserName());
                ++n;
            }
            if (libctlDriver.containsLDAPServerName("wisteria:901e1")) {
                System.out.println(true);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getLDAP32FileName() {
        return this._fileName;
    }

    public String getLDAP64FileName() {
        return this._fileName64;
    }
}

