/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util.ds.ldap;

import com.sybase.util.ds.ldap.SyASEServer;
import com.sybase.util.ds.ldap.SyServer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class SyLDAPServer
extends SyServer {
    public static final String DEFAULT_LDAP_PORT = "389";
    private String _rootEntry;
    private Hashtable _lookup = new Hashtable();
    private final String INITCTX = "com.sun.jndi.ldap.LdapCtxFactory";
    private final String MY_FILTER = "(1.3.6.1.4.1.897.4.2.2=*)";
    private final String SYBASE_SERVER_NAME = "sybaseServername";
    private final String SYBASE_ADDRESS = "sybaseAddress";
    private NamingEnumeration results = null;
    private byte status = (byte)-1;

    public SyLDAPServer(String string, String string2, String string3, String string4, String string5, String string6) {
        this._serverName = string;
        this._hostName = string2;
        this._portNumber = string3 != null ? string3 : DEFAULT_LDAP_PORT;
        this._rootEntry = string4;
        this._userName = string5;
        this._passwd = string6;
    }

    public SyLDAPServer(String string, String string2, String string3, String string4) {
        this._serverName = string;
        this._hostName = string2;
        this._portNumber = string3 != null ? string3 : DEFAULT_LDAP_PORT;
        this._rootEntry = string4;
    }

    public String getHost() {
        return this._hostName;
    }

    public String getPort() {
        return this._portNumber;
    }

    public String getUserName() {
        return this._userName;
    }

    public String getPassword() {
        return this._passwd;
    }

    public String getRootEntry() {
        return this._rootEntry;
    }

    public String getServerName() {
        return this._serverName;
    }

    public void connectLDAP() {
        try {
            this.results = null;
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            if (this._portNumber == null || this._portNumber.length() == 0) {
                this._portNumber = DEFAULT_LDAP_PORT;
            }
            hashtable.put("java.naming.provider.url", "ldap://" + this._hostName + ":" + this._portNumber);
            if (this._userName != null) {
                hashtable.put("user", this._userName);
            }
            if (this._passwd != null) {
                hashtable.put("password", this._passwd);
            }
            InitialDirContext initialDirContext = new InitialDirContext(hashtable);
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            this.results = initialDirContext.search(this._rootEntry, "(1.3.6.1.4.1.897.4.2.2=*)", searchControls);
            this.status = 1;
        }
        catch (NamingException namingException) {
            this.status = 0;
        }
    }

    public boolean connectLDAP(int n) {
        long l = n * 1000;
        Thread thread = new Thread(){

            public void run() {
                SyLDAPServer.this.connectLDAP();
            }
        };
        thread.start();
        long l2 = 0L;
        while (l2 < l && this.status == -1) {
            try {
                Thread.sleep(3000L);
                l2 += 3000L;
            }
            catch (InterruptedException interruptedException) {
                InterruptedException interruptedException2 = interruptedException;
            }
        }
        return this.status == 1;
    }

    public void initASEEntries() throws NamingException {
        while (this.results != null && this.results.hasMore()) {
            Attribute attribute;
            SearchResult searchResult = (SearchResult)this.results.next();
            String string = "";
            String string2 = "";
            String string3 = "";
            Attributes attributes = searchResult.getAttributes();
            Attribute attribute2 = attributes.get("sybaseServername");
            if (attribute2 == null && (attribute2 = attributes.get("sybaseServername".toLowerCase())) == null) continue;
            if (attribute2.size() > 0) {
                string = (String)attribute2.get(0);
            }
            if ((attribute = attributes.get("sybaseAddress")) == null && (attribute = attributes.get("sybaseAddress".toLowerCase())) == null) continue;
            NamingEnumeration<?> namingEnumeration = attribute.getAll();
            while (namingEnumeration.hasMoreElements()) {
                String[] stringArray = this.retrieveASEProperties((String)namingEnumeration.nextElement());
                if (stringArray != null) {
                    if (stringArray.length == 2) {
                        string2 = stringArray[0];
                        string3 = stringArray[1];
                    } else if (stringArray.length == 1) {
                        string2 = stringArray[0];
                    }
                }
                SyASEServer syASEServer = new SyASEServer(string, string2, string3);
                if (this.containsASEServerName(string)) {
                    this._lookup.put(string + " [" + string2 + ":" + string3 + "]", syASEServer);
                    continue;
                }
                this._lookup.put(string, syASEServer);
            }
        }
    }

    public String[] retrieveASEProperties(String string) {
        int n = string.lastIndexOf(35);
        StringTokenizer stringTokenizer = new StringTokenizer(string.substring(n + 1));
        int n2 = stringTokenizer.countTokens();
        String[] stringArray = new String[n2];
        int n3 = 0;
        while (stringTokenizer.hasMoreTokens() && n3 < n2) {
            stringArray[n3++] = stringTokenizer.nextToken().trim();
        }
        return stringArray;
    }

    public Enumeration getKeys() {
        return this._lookup.keys();
    }

    public String[] getASEServerNames() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this._lookup.keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement((String)enumeration.nextElement());
        }
        if (vector.size() > 0) {
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    public Enumeration getElements() {
        return this._lookup.elements();
    }

    public Vector getASEServers() {
        Vector<SyASEServer> vector = new Vector<SyASEServer>();
        Enumeration enumeration = this._lookup.elements();
        while (enumeration.hasMoreElements()) {
            SyASEServer syASEServer = (SyASEServer)enumeration.nextElement();
            vector.addElement(syASEServer);
        }
        return vector;
    }

    public synchronized boolean contains(SyASEServer syASEServer) {
        if (syASEServer != null) {
            return this._lookup.contains(syASEServer);
        }
        return false;
    }

    public synchronized boolean containsASEServerName(String string) {
        if (string != null) {
            return this._lookup.containsKey(string);
        }
        return false;
    }

    public SyASEServer getASEServer(String string) {
        return (SyASEServer)this._lookup.get(string);
    }

    public String toString() {
        Enumeration enumeration = this.getElements();
        StringBuffer stringBuffer = new StringBuffer();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(enumeration.nextElement().toString() + "\n");
        }
        return stringBuffer.toString();
    }

    public Hashtable getLookup() {
        return this._lookup;
    }
}

