/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.archive;

import com.installshield.archive.ApplicationArchiveListener;
import com.installshield.archive.ArchiveBuildInfo;
import com.installshield.archive.ArchiveWriterEntry;
import com.installshield.archive.ArchiveWriterOutputStream;
import com.installshield.archive.MediaInf;
import com.installshield.archive.index.ArchiveIndexEntry;
import com.installshield.archive.index.ArchiveIndexWriter;
import com.installshield.util.FileAttributes;
import com.installshield.util.FileUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Date;
import java.util.Vector;
import java.util.zip.Deflater;

public abstract class AbstractArchiveWriterOutputStream
extends OutputStream
implements ArchiveWriterOutputStream,
ArchiveBuildInfo {
    private ArchiveIndexWriter indexWriter;
    private String archiveRootFolder;
    private String archiveMediaRootName;
    private String archiveName;
    private int currentMediaNumber;
    private ArchiveWriterEntry currentEntry;
    private boolean finalized;
    private boolean fixedResourcesFinalized;
    private String externalResourceLocation = "";
    private Deflater def = null;
    private String currentExternalName = "";
    private OutputStream out = null;
    private boolean newExternalResource = false;
    private Vector applicationArchiveListeners = new Vector();

    protected AbstractArchiveWriterOutputStream(String string, String string2, String string3, ArchiveIndexWriter archiveIndexWriter) {
        this.indexWriter = archiveIndexWriter;
        this.archiveRootFolder = string;
        this.archiveMediaRootName = "disk";
        this.archiveName = string2;
        this.externalResourceLocation = string3;
        this.initialize();
    }

    protected AbstractArchiveWriterOutputStream(String string, String string2, String string3, String string4, ArchiveIndexWriter archiveIndexWriter) {
        this.indexWriter = archiveIndexWriter;
        this.archiveRootFolder = string;
        this.archiveMediaRootName = string2;
        this.archiveName = string3;
        this.externalResourceLocation = string4;
        this.initialize();
    }

    public void addApplicationArchiveListener(ApplicationArchiveListener applicationArchiveListener) {
        this.applicationArchiveListeners.addElement(applicationArchiveListener);
    }

    public ArchiveIndexEntry addExternalFileToArchiveIndex(URL uRL, int n, String string, FileAttributes fileAttributes, long l, String string2, byte[] byArray, int n2) throws IOException {
        return this.getArchiveIndexWriter().createExternalIndexEntry(uRL, n, string, fileAttributes, l, string2, byArray, n2);
    }

    public ArchiveIndexEntry addIndexedFileToArchiveIndex(URL uRL, int n, String string, FileAttributes fileAttributes, long l, byte[] byArray) throws IOException {
        return this.getArchiveIndexWriter().createMD5IndexEntry(uRL, n, string, fileAttributes, l, byArray);
    }

    public ArchiveIndexEntry addNormalFileToArchiveIndex(String string) throws IOException {
        return this.getArchiveIndexWriter().createIndexEntry(string);
    }

    public void close() throws IOException {
        if (!this.isFixedFinalized()) {
            throw new IOException("Fixed resources have not been finalized.");
        }
        if (!this.isFinalized()) {
            throw new IOException("OutputStream has not been finalized.");
        }
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer("Exceptions thrown:\n");
        try {
            this.closeExternalArchive();
        }
        catch (IOException iOException) {
            bl = false;
            stringBuffer.append("Could not close OutputStream: " + this.currentExternalName + "\n");
        }
        try {
            this.closeInternalArchive();
        }
        catch (IOException iOException) {
            bl = false;
            stringBuffer.append(String.valueOf(iOException.getMessage()) + "\n");
        }
        this.closeDeflater();
        if (!bl) {
            throw new IOException(stringBuffer.toString());
        }
    }

    private void closeDeflater() {
        if (this.def != null) {
            this.def.end();
        }
        this.def = null;
    }

    public void closeEntry() throws IOException {
        block3: {
            try {
                ArchiveWriterEntry archiveWriterEntry = this.getCurrentEntry();
                if (archiveWriterEntry == null) break block3;
                if (archiveWriterEntry.getEntryType() == 0) {
                    this.closeExternalEntry(archiveWriterEntry);
                    break block3;
                }
                this.closeInternalEntry(archiveWriterEntry);
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                this.setCurrentEntry(null);
                throw throwable;
            }
        }
        Object var2_2 = null;
        this.setCurrentEntry(null);
    }

    private void closeExternalArchive() throws IOException {
        if (this.out != null) {
            this.out.close();
            this.out = null;
        }
    }

    protected void closeExternalEntry(ArchiveWriterEntry archiveWriterEntry) throws IOException {
        if (this.out != null) {
            this.out.close();
        }
        this.out = null;
        if (this.isNewExternalResource()) {
            Date date = null;
            File file = new File(archiveWriterEntry.getId());
            if (file.isFile()) {
                date = new Date(file.lastModified());
            }
            archiveWriterEntry.setDate(date);
        }
    }

    abstract void closeInternalArchive() throws IOException;

    abstract void closeInternalEntry(ArchiveWriterEntry var1) throws IOException;

    protected String createArchiveFileName(String string, int n) {
        String string2 = FileUtils.createFileName((String)this.archiveRootFolder, (String)(String.valueOf(this.getArchiveMediaRootName()) + n));
        return FileUtils.createFileName((String)string2, (String)string);
    }

    protected void createDirs(String string) throws IOException {
        FileUtils.createDirs((File)new File(string));
    }

    protected void createDirsForArchive(String string) throws IOException {
        File file = new File(string);
        if (file.getParent() != null) {
            this.createDirs(file.getParent());
        }
    }

    protected void createMediaInf(int n) throws IOException {
        String string;
        File file;
        if (this.requireMediaInfs() && !(file = new File(string = FileUtils.createFileName((String)this.createArchiveFileName("", n), (String)"media.inf"))).exists()) {
            if (file.getParent() != null) {
                this.createDirs(file.getParent());
            }
            MediaInf mediaInf = new MediaInf(n);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            mediaInf.write((OutputStream)fileOutputStream);
            fileOutputStream.close();
        }
    }

    protected void finalizeFixedResources() throws IOException {
    }

    public void finish() throws IOException {
        if (!this.isFinalized()) {
            this.finishFixedResources();
            this.prepareForArchiveIndex();
            ArchiveIndexWriter archiveIndexWriter = this.getArchiveIndexWriter();
            if (archiveIndexWriter != null) {
                archiveIndexWriter.close();
                this.putNextEntry(new ArchiveWriterEntry(1, archiveIndexWriter.getIndexName()));
                String string = archiveIndexWriter.getTempIndexName();
                FileInputStream fileInputStream = new FileInputStream(string);
                FileUtils.copy((InputStream)fileInputStream, (OutputStream)this);
                this.closeEntry();
                fileInputStream.close();
                try {
                    File file = new File(string);
                    file.delete();
                    FileUtils.clearTempFile((String)string);
                }
                catch (Exception exception) {}
            }
            this.setFinalized(true);
        }
    }

    public void finishFixedResources() throws IOException {
        if (!this.isFixedFinalized()) {
            try {
                this.finalizeFixedResources();
            }
            finally {
                Object var2_1 = null;
                this.setFixedFinalized(true);
            }
        }
    }

    public void fireApplicationArchiveFinished() {
        int n = 0;
        while (n < this.applicationArchiveListeners.size()) {
            ((ApplicationArchiveListener)this.applicationArchiveListeners.elementAt(n)).applicationArchiveFinished((ArchiveBuildInfo)this);
            ++n;
        }
    }

    public void fireApplicationArchiveStarted() {
        int n = 0;
        while (n < this.applicationArchiveListeners.size()) {
            ((ApplicationArchiveListener)this.applicationArchiveListeners.elementAt(n)).applicationArchiveStarted((ArchiveBuildInfo)this);
            ++n;
        }
    }

    public void flush() throws IOException {
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer("Exceptions thrown:\n");
        try {
            this.flushExternalArchive();
        }
        catch (IOException iOException) {
            bl = false;
            stringBuffer.append("Could not flush OutputStream: " + this.currentExternalName + "\n");
        }
        try {
            this.flushInternalArchive();
        }
        catch (IOException iOException) {
            bl = false;
            stringBuffer.append(String.valueOf(iOException.getMessage()) + "\n");
        }
        if (!bl) {
            throw new IOException(stringBuffer.toString());
        }
    }

    private void flushExternalArchive() throws IOException {
        if (this.out != null) {
            this.out.flush();
        }
    }

    abstract void flushInternalArchive() throws IOException;

    public String getApplicationArchiveHome() {
        return this.getApplicationArchiveName();
    }

    public abstract String getApplicationArchiveName();

    public long getApplicationArchiveSize() throws IOException {
        throw new IOException("Application archive size is unavailable");
    }

    protected ArchiveIndexWriter getArchiveIndexWriter() throws IOException {
        return this.indexWriter;
    }

    public String getArchiveMediaRootName() {
        return this.archiveMediaRootName;
    }

    public String getArchiveName() {
        return this.archiveName;
    }

    public String getArchiveRootFolder() {
        return this.archiveRootFolder;
    }

    public int getCurrentArchiveIndexOffset() throws IOException {
        return this.getArchiveIndexWriter().getCurrentOffset();
    }

    public ArchiveWriterEntry getCurrentEntry() {
        return this.currentEntry;
    }

    public int getCurrentMediaNumber() {
        return this.currentMediaNumber;
    }

    protected Deflater getDeflater() {
        if (this.def == null) {
            this.def = new Deflater();
        }
        return this.def;
    }

    public String getExternalResourceLocation() {
        return this.externalResourceLocation;
    }

    public String getMediaArchiveName() {
        return null;
    }

    protected void incrementCurrentMediaNumber() {
        ++this.currentMediaNumber;
    }

    private void initExternalStream(String string, int n) throws IOException {
        boolean bl = true;
        if (this.out != null) {
            throw new IOException("Could not start new external stream:  Previous stream was not closed.");
        }
        this.currentExternalName = this.createArchiveFileName(this.externalResourceLocation, n);
        this.currentExternalName = FileUtils.createFileName((String)this.currentExternalName, (String)string);
        if (this.currentExternalName != null && new File(this.currentExternalName).exists()) {
            this.out = new NoopOutputStream();
            bl = false;
        } else if (string.endsWith(File.separator) || string.endsWith("/")) {
            this.createDirs(this.currentExternalName);
            this.out = new ByteArrayOutputStream();
        } else {
            this.createDirsForArchive(this.currentExternalName);
            this.out = new FileOutputStream(this.currentExternalName);
        }
        this.createMediaInf(n);
        this.setNewExternalResource(bl);
    }

    private void initialize() {
        this.finalized = false;
        this.fixedResourcesFinalized = false;
        this.currentMediaNumber = 1;
    }

    public boolean isFinalized() {
        return this.finalized;
    }

    protected boolean isFixedFinalized() {
        return this.fixedResourcesFinalized;
    }

    protected boolean isNewExternalResource() {
        return this.newExternalResource;
    }

    public OutputStream open() {
        this.fireApplicationArchiveStarted();
        return this;
    }

    protected void prepareForArchiveIndex() throws IOException {
    }

    public void putNextEntry(ArchiveWriterEntry archiveWriterEntry) throws IOException {
        if (this.getCurrentEntry() != null) {
            throw new IOException("New entry added before old entry was closed.");
        }
        if (archiveWriterEntry.isSpannable() && !this.isFixedFinalized()) {
            throw new IOException("Spannable entry added before fixed resources are finalized");
        }
        if (archiveWriterEntry.getEntryType() == 0) {
            this.putNextExternalEntry(archiveWriterEntry);
        } else {
            this.putNextInternalEntry(archiveWriterEntry);
        }
        this.setCurrentEntry(archiveWriterEntry);
    }

    protected void putNextExternalEntry(ArchiveWriterEntry archiveWriterEntry) throws IOException {
        try {
            this.initExternalStream(archiveWriterEntry.getId(), archiveWriterEntry.getMediaNumber());
        }
        catch (IOException iOException) {
            throw new IOException("Could not start new external entry:  Previous entry was not closed.");
        }
    }

    abstract void putNextInternalEntry(ArchiveWriterEntry var1) throws IOException;

    public void removeApplicationArchiveListener(ApplicationArchiveListener applicationArchiveListener) {
        this.applicationArchiveListeners.removeElement(applicationArchiveListener);
    }

    protected boolean requireMediaInfs() {
        return true;
    }

    public void reserveMediaDiskSize(int n, long l) {
    }

    public void reserveMediaDiskSize(long l) {
        this.reserveMediaDiskSize(1, l);
    }

    protected void resetDeflater() {
        block2: {
            if (this.def == null) break block2;
            try {
                this.def.reset();
            }
            catch (Exception exception) {
                this.closeDeflater();
            }
        }
    }

    protected void setCurrentEntry(ArchiveWriterEntry archiveWriterEntry) {
        this.currentEntry = archiveWriterEntry;
    }

    private void setFinalized(boolean bl) {
        this.finalized = bl;
    }

    private void setFixedFinalized(boolean bl) {
        this.fixedResourcesFinalized = bl;
    }

    protected void setNewExternalResource(boolean bl) {
        this.newExternalResource = bl;
    }

    public void write(byte by) throws IOException {
        this.write(new byte[]{by}, 0, 1);
    }

    public void write(int n) throws IOException {
        this.write((byte)n);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        ArchiveWriterEntry archiveWriterEntry = this.getCurrentEntry();
        if (archiveWriterEntry == null) {
            throw new IOException("Write error: No entry has been put to OutputStream.");
        }
        if (archiveWriterEntry.getEntryType() == 0) {
            this.writeToExternalArchive(byArray, n, n2);
        } else {
            this.writeToInternalArchive(archiveWriterEntry, byArray, n, n2);
        }
    }

    protected void writeToExternalArchive(byte[] byArray, int n, int n2) throws IOException {
        if (this.out == null) {
            throw new IOException("Could not write to external entry:  External entry is not initialized.");
        }
        this.out.write(byArray, n, n2);
    }

    abstract void writeToInternalArchive(ArchiveWriterEntry var1, byte[] var2, int var3, int var4) throws IOException;

    class NoopOutputStream
    extends OutputStream {
        NoopOutputStream() {
        }

        public void close() throws IOException {
        }

        public void flush() throws IOException {
        }

        public void write(byte by) throws IOException {
        }

        public void write(int n) throws IOException {
        }

        public void write(byte[] byArray) throws IOException {
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
        }
    }
}

