/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.archive;

import com.installshield.archive.ApplicationArchiveListener;
import com.installshield.archive.ArchiveBuildInfo;
import com.installshield.archive.ArchiveResourceWriter;
import com.installshield.archive.ArchiveWriterEntry;
import com.installshield.archive.ArchiveWriterOutputStream;
import com.installshield.archive.DefaultResourceWriterFactory;
import com.installshield.archive.IndexedResourceWriter;
import com.installshield.archive.ResourceWriter;
import com.installshield.archive.index.ArchiveIndexEntry;
import com.installshield.util.FileAttributes;
import com.installshield.util.FileUtils;
import com.installshield.util.MD5;
import com.installshield.util.URLUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;

public class ArchiveResourceWriterFactory
extends DefaultResourceWriterFactory {
    private ArchiveWriterOutputStream out;

    public ArchiveResourceWriterFactory(ArchiveWriterOutputStream archiveWriterOutputStream, String string) throws IOException {
        super(string);
        this.out = archiveWriterOutputStream;
    }

    public void addApplicationArchiveListener(ApplicationArchiveListener applicationArchiveListener) {
        this.out.addApplicationArchiveListener(applicationArchiveListener);
    }

    public ResourceWriter createApplicationResourceWriter(String string) {
        return new ArchiveResourceWriter(this.out, new ArchiveWriterEntry(1, string));
    }

    public IndexedResourceWriter createExternalResourceWriter(URL uRL, int n, String string, FileAttributes fileAttributes, long l, String string2, byte[] byArray, int n2) throws IOException {
        String string3;
        ArchiveIndexEntry archiveIndexEntry = this.out.addExternalFileToArchiveIndex(uRL, n, string, fileAttributes, l, string2, byArray, n2);
        String string4 = string;
        String string5 = uRL.getProtocol();
        if (string5.equals("file") || string5.equals("ismpfile")) {
            string3 = uRL.getFile();
            if (string5.equals("ismpfile")) {
                string3 = URLUtils.decode((String)string3);
            }
            if (new File(string3).isDirectory()) {
                string4 = FileUtils.appendSeparator((String)string4);
            }
        }
        if (string2 != null && string2.length() > 0) {
            string4 = FileUtils.createFileName((String)string2, (String)string4);
        }
        string3 = new ArchiveWriterEntry(0, string4, ArchiveResourceWriterFactory.getIndexRef(archiveIndexEntry));
        string3.setArchiveIndex(archiveIndexEntry.entryNumber);
        string3.setMediaNumber(n2);
        return new IndexedResourceWriter((ResourceWriter)new ArchiveResourceWriter(this.out, (ArchiveWriterEntry)string3), archiveIndexEntry);
    }

    public IndexedResourceWriter createIndexedResourceWriter(URL uRL, int n, String string, FileAttributes fileAttributes, long l, byte[] byArray) throws IOException {
        ArchiveIndexEntry archiveIndexEntry = this.out.addIndexedFileToArchiveIndex(uRL, n, string, fileAttributes, l, byArray);
        String string2 = MD5.toHex((byte[])archiveIndexEntry.digest);
        String string3 = this.createFileName(String.valueOf(this.getResourceRoot()) + File.separatorChar + "md5", string2);
        ArchiveWriterEntry archiveWriterEntry = new ArchiveWriterEntry(3, string3, ArchiveResourceWriterFactory.getIndexRef(archiveIndexEntry));
        archiveWriterEntry.setArchiveIndex(archiveIndexEntry.entryNumber);
        return new IndexedResourceWriter((ResourceWriter)new ArchiveResourceWriter(this.out, archiveWriterEntry), archiveIndexEntry);
    }

    public IndexedResourceWriter createNormalResourceWriter(String string) throws IOException {
        ArchiveIndexEntry archiveIndexEntry = this.out.addNormalFileToArchiveIndex(string);
        String string2 = this.createFileName(this.getResourceRoot(), string);
        ArchiveWriterEntry archiveWriterEntry = new ArchiveWriterEntry(2, string2, ArchiveResourceWriterFactory.getIndexRef(archiveIndexEntry));
        archiveWriterEntry.setArchiveIndex(archiveIndexEntry.entryNumber);
        return new IndexedResourceWriter((ResourceWriter)new ArchiveResourceWriter(this.out, archiveWriterEntry), archiveIndexEntry);
    }

    public void finishFixedResources() throws IOException {
        this.out.finishFixedResources();
    }

    public ArchiveBuildInfo getArchiveBuildInfo() {
        return (ArchiveBuildInfo)this.out;
    }

    public int getCurrentArchiveIndexOffset() throws IOException {
        return this.out.getCurrentArchiveIndexOffset();
    }

    public static String getIndexRef(ArchiveIndexEntry archiveIndexEntry) throws IOException {
        String string;
        switch (archiveIndexEntry.resourceType) {
            case 1: {
                string = "1:" + MD5.toHex((byte[])archiveIndexEntry.digest);
                break;
            }
            case 2: {
                string = "2:" + archiveIndexEntry.startMediaNumber + "|" + archiveIndexEntry.source + "|" + archiveIndexEntry.fileName;
                break;
            }
            case 0: {
                string = "0:" + archiveIndexEntry.fileName;
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    public void removeApplicationArchiveListener(ApplicationArchiveListener applicationArchiveListener) {
        this.out.removeApplicationArchiveListener(applicationArchiveListener);
    }
}

