/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product;

import com.installshield.product.BaseProductTreeIterator;
import com.installshield.product.GenericSoftwareObject;
import com.installshield.product.ProductBean;
import com.installshield.product.ProductBeanFilter;
import com.installshield.product.ProductTree;
import com.installshield.product.SoftwareObject;
import com.installshield.product.SoftwareObjectKey;
import com.installshield.product.SoftwareObjectReference;
import java.util.Enumeration;
import java.util.Vector;

public class StandardProductTreeIterator
implements BaseProductTreeIterator {
    private ProductBean root;
    private ProductBean begin = new Marker();
    private ProductBean end = new Marker();
    private Vector filters = new Vector();
    private boolean visitRequired = false;

    public StandardProductTreeIterator(ProductBean productBean) {
        this(productBean, false);
    }

    public StandardProductTreeIterator(ProductBean productBean, boolean bl) {
        this.root = productBean;
        this.visitRequired = bl;
    }

    public StandardProductTreeIterator(ProductTree productTree) {
        this(productTree.getRoot(), false);
    }

    public StandardProductTreeIterator(ProductTree productTree, boolean bl) {
        this(productTree.getRoot(), bl);
    }

    protected final boolean accept(ProductBean productBean) {
        if (this.visitRequired && this.duplicateChild(productBean)) {
            return false;
        }
        Vector vector = this.filters;
        synchronized (vector) {
            int n = this.filters.size();
            int n2 = 0;
            while (n2 < n) {
                if (!((ProductBeanFilter)this.filters.elementAt(n2)).accept(productBean)) {
                    boolean bl = false;
                    Object var4_6 = null;
                    return bl;
                }
                ++n2;
            }
        }
        return true;
    }

    public void addFilter(ProductBeanFilter productBeanFilter) {
        this.filters.addElement(productBeanFilter);
    }

    public ProductBean begin() {
        return this.begin;
    }

    private boolean duplicateChild(ProductBean productBean) {
        boolean bl = false;
        if (productBean instanceof SoftwareObjectReference && productBean.getProductTree() instanceof GenericSoftwareObject.RequiredTree) {
            SoftwareObjectKey softwareObjectKey = ((SoftwareObjectReference)productBean).getKey();
            ProductBean productBean2 = productBean.getProductTree().getParent(productBean);
            Enumeration enumeration = productBean2.getProductTree().children(productBean2);
            while (!bl && enumeration.hasMoreElements()) {
                SoftwareObjectKey softwareObjectKey2 = null;
                Object e = enumeration.nextElement();
                if (e instanceof SoftwareObject) {
                    softwareObjectKey2 = ((SoftwareObject)e).getKey();
                } else if (e instanceof SoftwareObjectReference) {
                    softwareObjectKey2 = ((SoftwareObjectReference)e).getKey();
                }
                if (softwareObjectKey2 == null || !softwareObjectKey2.equals((Object)softwareObjectKey)) continue;
                bl = true;
            }
        }
        return bl;
    }

    public ProductBean end() {
        return this.end;
    }

    private ProductBean getFirst() {
        return this.accept(this.root) ? this.root : this.end();
    }

    private ProductBean getLast() {
        ProductBean productBean = null;
        if (this.accept(this.root)) {
            ProductTree productTree;
            productBean = this.root;
            ProductBean productBean2 = this.root.getProductTree().getLastChild(this.root);
            while (productBean2 != null && !this.accept(productBean2)) {
                productBean2 = productBean2.getProductTree().getPreviousSibling(productBean2);
            }
            if (productBean2 == null && this.visitRequired && this.root instanceof GenericSoftwareObject) {
                productTree = ((GenericSoftwareObject)this.root).getRequiredTree();
                productBean2 = productTree.getLastChild(productTree.getRoot());
                while (productBean2 != null && !this.accept(productBean2)) {
                    productBean2 = productBean2.getProductTree().getPreviousSibling(productBean2);
                }
            }
            while (productBean2 != null) {
                productBean = productBean2;
                productBean2 = productBean2.getProductTree().getLastChild(productBean2);
                while (productBean2 != null && !this.accept(productBean2)) {
                    productBean2 = productBean2.getProductTree().getPreviousSibling(productBean2);
                }
                if (productBean2 != null || !this.visitRequired || !(productBean instanceof GenericSoftwareObject)) continue;
                productTree = ((GenericSoftwareObject)productBean).getRequiredTree();
                productBean2 = productTree.getLastChild(productTree.getRoot());
                while (productBean2 != null && !this.accept(productBean2)) {
                    productBean2 = productBean2.getProductTree().getPreviousSibling(productBean2);
                }
            }
        }
        return productBean != null ? productBean : this.begin();
    }

    private ProductBean getLastChild(ProductBean productBean) {
        ProductBean productBean2 = null;
        ProductBean productBean3 = productBean.getProductTree().getLastChild(productBean);
        while (productBean3 != null && !this.accept(productBean3)) {
            productBean3 = productBean3.getProductTree().getPreviousSibling(productBean3);
        }
        if (productBean3 == null && this.visitRequired && !(productBean.getProductTree() instanceof GenericSoftwareObject.RequiredTree) && productBean instanceof GenericSoftwareObject) {
            GenericSoftwareObject genericSoftwareObject = (GenericSoftwareObject)productBean;
            ProductTree productTree = genericSoftwareObject.getRequiredTree();
            productBean3 = productTree.getLastChild(productTree.getRoot());
            while (productBean3 != null && !this.accept(productBean3)) {
                productBean3 = productBean3.getProductTree().getPreviousSibling(productBean3);
            }
        }
        if (productBean3 != null && (productBean2 = this.getLastChild(productBean3)) == null) {
            productBean2 = productBean3;
        }
        return productBean2;
    }

    public ProductBean getNext(ProductBean productBean) {
        ProductBean productBean2;
        if (productBean == null || productBean == this.end()) {
            return null;
        }
        if (productBean == this.begin()) {
            return this.getFirst();
        }
        ProductBean productBean3 = null;
        if (this.visitRequired && productBean instanceof GenericSoftwareObject) {
            ProductTree productTree = ((GenericSoftwareObject)productBean).getRequiredTree();
            productBean3 = productTree.getFirstChild(productTree.getRoot());
            while (productBean3 != null) {
                if (this.accept(productBean3)) {
                    return productBean3;
                }
                productBean3 = productBean3.getProductTree().getNextSibling(productBean3);
            }
        }
        productBean3 = productBean.getProductTree().getFirstChild(productBean);
        while (productBean3 != null) {
            if (this.accept(productBean3)) {
                return productBean3;
            }
            productBean3 = productBean3.getProductTree().getNextSibling(productBean3);
        }
        if (productBean == this.root) {
            return this.end();
        }
        productBean3 = productBean.getProductTree().getNextSibling(productBean);
        while (productBean3 != null) {
            if (this.accept(productBean3)) {
                return productBean3;
            }
            productBean3 = productBean3.getProductTree().getNextSibling(productBean3);
        }
        if (productBean.getProductTree() instanceof GenericSoftwareObject.RequiredTree) {
            productBean2 = productBean.getProductTree().getParent(productBean);
            productBean3 = productBean2.getProductTree().getFirstChild(productBean2);
            while (productBean3 != null) {
                if (this.accept(productBean3)) {
                    return productBean3;
                }
                productBean3 = productBean3.getProductTree().getNextSibling(productBean3);
            }
        }
        productBean2 = productBean.getProductTree().getParent(productBean);
        while (productBean2 != null && productBean2 != this.root) {
            productBean3 = productBean.getProductTree().getNextSibling(productBean2);
            while (productBean3 != null) {
                if (this.accept(productBean3)) {
                    return productBean3;
                }
                productBean3 = productBean3.getProductTree().getNextSibling(productBean3);
            }
            productBean2 = productBean.getProductTree().getParent(productBean2);
        }
        return this.end();
    }

    public ProductBean getPrevious(ProductBean productBean) {
        ProductBean productBean2;
        if (productBean == null || productBean == this.begin()) {
            return null;
        }
        if (productBean == this.end()) {
            return this.getLast();
        }
        if (productBean == this.root) {
            return this.begin();
        }
        ProductBean productBean3 = productBean.getProductTree().getPreviousSibling(productBean);
        while (productBean3 != null && !this.accept(productBean3)) {
            productBean3 = productBean3.getProductTree().getPreviousSibling(productBean3);
        }
        if (productBean3 == null && this.visitRequired && !(productBean.getProductTree() instanceof GenericSoftwareObject.RequiredTree) && productBean.getProductTree().getParent(productBean) instanceof GenericSoftwareObject) {
            productBean2 = (GenericSoftwareObject)productBean.getProductTree().getParent(productBean);
            ProductTree productTree = productBean2.getRequiredTree();
            productBean3 = productTree.getLastChild(productTree.getRoot());
            while (productBean3 != null && !this.accept(productBean3)) {
                productBean3 = productBean3.getProductTree().getPreviousSibling(productBean3);
            }
        }
        if (productBean3 != null && (productBean2 = this.getLastChild(productBean3)) != null) {
            productBean3 = productBean2;
        }
        if (productBean3 == null) {
            productBean3 = productBean.getProductTree().getParent(productBean);
        }
        if (productBean3 != null) {
            return productBean3;
        }
        return this.begin();
    }

    public ProductBean getRoot() {
        return this.root;
    }

    public void removeFilter(ProductBeanFilter productBeanFilter) {
        this.filters.removeElement(productBeanFilter);
    }

    public void setRoot(ProductBean productBean) {
        this.root = productBean;
    }

    class Marker
    extends ProductBean {
        Marker() {
        }
    }
}

