/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.iterators;

import com.installshield.product.FilteredProductTreeIterator;
import com.installshield.product.ProductBean;
import com.installshield.product.ProductBeanFilter;
import com.installshield.product.SoftwareObject;
import com.installshield.product.SoftwareObjectReference;

public class ActiveForUninstallProductTreeIterator
implements FilteredProductTreeIterator,
ProductBeanFilter {
    private FilteredProductTreeIterator iter;

    public ActiveForUninstallProductTreeIterator(FilteredProductTreeIterator filteredProductTreeIterator) {
        this.iter = filteredProductTreeIterator;
        filteredProductTreeIterator.addFilter(this);
    }

    public boolean accept(ProductBean productBean) {
        boolean bl = true;
        if (productBean instanceof SoftwareObjectReference) {
            SoftwareObjectReference softwareObjectReference = (SoftwareObjectReference)productBean;
            SoftwareObject softwareObject = productBean.getProductTree().resolveKey(softwareObjectReference.getKey());
            if (softwareObject != null) {
                bl = softwareObject.isActiveForUninstall();
            }
        } else if (productBean instanceof SoftwareObject) {
            bl = ((SoftwareObject)productBean).isActiveForUninstall();
        }
        return bl;
    }

    public void addFilter(ProductBeanFilter productBeanFilter) {
        this.iter.addFilter(productBeanFilter);
    }

    public ProductBean begin() {
        return this.iter.begin();
    }

    public ProductBean end() {
        return this.iter.end();
    }

    public ProductBean getNext(ProductBean productBean) {
        return this.iter.getNext(productBean);
    }

    public ProductBean getPrevious(ProductBean productBean) {
        return this.iter.getPrevious(productBean);
    }

    public void removeFilter(ProductBeanFilter productBeanFilter) {
        this.iter.removeFilter(productBeanFilter);
    }
}

