/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.iterators;

import com.installshield.product.FilteredProductTreeIterator;
import com.installshield.product.ProductBean;
import com.installshield.product.ProductBeanFilter;
import com.installshield.product.ProductTree;
import com.installshield.product.SoftwareObject;
import com.installshield.product.SoftwareObjectKey;
import com.installshield.product.SoftwareObjectReference;
import java.util.Vector;

public class VisitedComponentTreeIterator
implements FilteredProductTreeIterator,
ProductBeanFilter {
    private Vector firstVisits = new Vector();
    private Vector multipleVisits = new Vector();
    private FilteredProductTreeIterator iter;

    public VisitedComponentTreeIterator(FilteredProductTreeIterator filteredProductTreeIterator) {
        this.iter = filteredProductTreeIterator;
        filteredProductTreeIterator.addFilter(this);
    }

    public boolean accept(ProductBean productBean) {
        boolean bl = false;
        ProductBean productBean2 = productBean.getProductTree().getParent(productBean);
        SoftwareObjectKey softwareObjectKey = null;
        if (productBean2 != null) {
            if (productBean2 instanceof SoftwareObject) {
                softwareObjectKey = ((SoftwareObject)productBean2).getKey();
            } else if (productBean2 instanceof SoftwareObjectReference) {
                softwareObjectKey = ((SoftwareObjectReference)productBean2).getKey();
            }
            if (softwareObjectKey != null) {
                bl = this.multipleVisits.contains(softwareObjectKey);
            }
        }
        return bl ^ true;
    }

    public void addFilter(ProductBeanFilter productBeanFilter) {
        this.iter.addFilter(productBeanFilter);
    }

    public ProductBean begin() {
        return this.iter.begin();
    }

    public ProductBean end() {
        return this.iter.end();
    }

    public ProductBean getNext(ProductBean productBean) {
        ProductBean productBean2 = this.iter.getNext(productBean);
        SoftwareObject softwareObject = null;
        SoftwareObjectKey softwareObjectKey = null;
        SoftwareObjectReference softwareObjectReference = null;
        ProductTree productTree = productBean.getProductTree();
        if (productBean2 instanceof SoftwareObject) {
            softwareObjectKey = ((SoftwareObject)productBean2).getKey();
        } else if (productBean2 instanceof SoftwareObjectReference && (softwareObject = productTree.resolveKey((softwareObjectReference = (SoftwareObjectReference)productBean2).getKey())) != null) {
            softwareObjectKey = softwareObject.getKey();
        }
        if (softwareObjectKey != null) {
            if (this.firstVisits.contains(softwareObjectKey)) {
                if (!this.multipleVisits.contains(softwareObjectKey)) {
                    this.multipleVisits.addElement(softwareObjectKey);
                }
            } else {
                this.firstVisits.addElement(softwareObjectKey);
            }
        }
        return productBean2;
    }

    public ProductBean getPrevious(ProductBean productBean) {
        return this.iter.getPrevious(productBean);
    }

    public void removeFilter(ProductBeanFilter productBeanFilter) {
        this.iter.removeFilter(productBeanFilter);
    }
}

