/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.win32.win32service;

import com.installshield.wizard.WizardBeanCondition;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizard.platform.win32.Win32Service;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.WizardServices;
import java.util.Dictionary;

public class WindowsServiceExistsWizardBeanCondition
extends WizardBeanCondition {
    private String name = "";

    public void build(WizardBuilderSupport wizardBuilderSupport) {
        super.build(wizardBuilderSupport);
        wizardBuilderSupport.putRequiredService("win32Service");
    }

    public Dictionary buildCategories() {
        Dictionary dictionary = super.buildCategories();
        dictionary.put("win32ppk", "");
        return dictionary;
    }

    public String defaultName() {
        return "WindowsServiceExists";
    }

    public String describe() {
        if (this.getEvaluate() == 1) {
            return String.valueOf(this.name) + " must exist";
        }
        return String.valueOf(this.name) + " must NOT exist";
    }

    protected boolean evaluateTrueCondition() {
        try {
            WizardServices wizardServices = this.getWizardBean().getWizard().getServices();
            Win32Service win32Service = (Win32Service)wizardServices.getService("win32Service");
            return win32Service.serviceExists(wizardServices.resolveString(this.name));
        }
        catch (ServiceException serviceException) {
            this.logEvent((Object)this, "err", (Object)serviceException);
            return false;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }
}

