/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.win32.win32service;

import com.installshield.wizard.WizardBeanCondition;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizard.platform.win32.Win32Service;
import com.installshield.wizard.platform.win32.win32service.NTServiceStatus;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.WizardServices;
import java.util.Dictionary;

public class WindowsServiceStatusWizardBeanCondition
extends WizardBeanCondition {
    private String name = "";
    private int state = 4;

    public void build(WizardBuilderSupport wizardBuilderSupport) {
        super.build(wizardBuilderSupport);
        wizardBuilderSupport.putRequiredService("win32Service");
    }

    public Dictionary buildCategories() {
        Dictionary dictionary = super.buildCategories();
        dictionary.put("win32ppk", "");
        return dictionary;
    }

    public String defaultName() {
        return "WindowsServiceStatus";
    }

    public String describe() {
        if (this.getEvaluate() == 1) {
            return "state of " + this.name + " must be " + NTServiceStatus.stateToString((int)this.state);
        }
        return "state of " + this.name + " must NOT be " + NTServiceStatus.stateToString((int)this.state);
    }

    protected boolean evaluateTrueCondition() {
        try {
            WizardServices wizardServices = this.getWizardBean().getWizard().getServices();
            Win32Service win32Service = (Win32Service)wizardServices.getService("win32Service");
            NTServiceStatus nTServiceStatus = win32Service.queryNTServiceStatus(wizardServices.resolveString(this.name));
            return nTServiceStatus.getCurrentState() == this.state;
        }
        catch (ServiceException serviceException) {
            this.logEvent((Object)this, "err", (Object)serviceException);
            return false;
        }
    }

    public String getName() {
        return this.name;
    }

    public int getState() {
        return this.state;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setState(int n) {
        this.state = n;
    }
}

