/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizardx.conditions;

import com.installshield.wizard.WizardBeanCondition;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.FileService;

public class FileExistsWizardBeanCondition
extends WizardBeanCondition {
    private String[] pathList = new String[0];

    public void build(WizardBuilderSupport wizardBuilderSupport) {
        if (this.pathList.length == 0) {
            wizardBuilderSupport.logEvent((Object)this, "err", (Object)"No paths specified");
        }
        wizardBuilderSupport.putRequiredService("fileService");
    }

    public String defaultName() {
        return "FileExistsWizardBeanCondition";
    }

    public String describe() {
        String string = "Files must ";
        if (this.getEvaluate() == 2) {
            string = String.valueOf(string) + "not ";
        }
        string = String.valueOf(string) + "exist";
        return string;
    }

    public boolean evaluateTrueCondition() {
        try {
            FileService fileService = (FileService)this.getWizardBean().getServices().getService("fileService");
            int n = 0;
            while (n < this.pathList.length) {
                String string = this.getWizardBean().getServices().resolveString(this.pathList[n]);
                if (fileService.fileExists(string)) {
                    return true;
                }
                ++n;
            }
        }
        catch (ServiceException serviceException) {
            this.logEvent((Object)this, "err", (Object)serviceException);
        }
        return false;
    }

    public String[] getPathList() {
        return this.pathList;
    }

    public void setPathList(String[] stringArray) {
        this.pathList = stringArray;
    }
}

