/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizardx.progress;

import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.Progress;
import com.installshield.util.TTYDisplay;
import com.installshield.wizard.console.ConsoleProgressRendererImpl;

public class StandardProgressRendererConsoleImpl
extends ConsoleProgressRendererImpl {
    private static final int ACCESSIBLE_PERCENT_INTERVAL = 10;
    private int ticksPrinted = 0;
    private boolean printedGaugeToConsole = false;
    private String oldCaption = "";
    private boolean isStart = true;
    private boolean isProgressComplete = false;
    private int currPercentMarker = 0;

    private int calcTickCount(int n, int n2, int n3) {
        return n / n2 - this.ticksPrinted;
    }

    private boolean inAccessibleMode() {
        return this.getConsoleWizardUI().isAccessibilityEnabled();
    }

    private void printAccessibleProgress(int n) {
        TTYDisplay tTYDisplay = this.getConsoleWizardUI().getTTY();
        tTYDisplay.printLine(LocalizedStringResolver.resolve((String)"com.installshield.wizard.i18n.WizardResources", (String)"ConsoleProgressRenderer.accessibleComplete", (String[])new String[]{String.valueOf(n * 10)}));
    }

    public void updateProgress(Progress progress) {
        if (!this.inAccessibleMode() && progress.getRedisplayProgress()) {
            this.printedGaugeToConsole = false;
            this.ticksPrinted = 0;
        }
        TTYDisplay tTYDisplay = this.getConsoleWizardUI().getTTY();
        String string = progress.getStatusDescription();
        if (!this.oldCaption.equals(string) && this.isStart && !this.printedGaugeToConsole) {
            tTYDisplay.printLine();
            tTYDisplay.printLine(string);
            this.oldCaption = string;
            this.isStart = false;
        }
        if (this.inAccessibleMode()) {
            if (!this.printedGaugeToConsole && progress.getPercentComplete() != 0) {
                tTYDisplay.printLine();
                this.printAccessibleProgress(0);
                this.printedGaugeToConsole = true;
            }
        } else if (!this.printedGaugeToConsole && progress.getPercentComplete() != 0) {
            tTYDisplay.printLine();
            tTYDisplay.printLine();
            tTYDisplay.printLine("|-----------|-----------|-----------|------------|");
            tTYDisplay.printLine("0%         25%         50%         75%        100%");
            this.printedGaugeToConsole = true;
        }
        if (this.inAccessibleMode()) {
            int n = progress.getPercentComplete() / 10;
            if (n > this.currPercentMarker) {
                this.printAccessibleProgress(n);
                this.currPercentMarker = n;
            }
        } else {
            int n = this.calcTickCount(progress.getPercentComplete(), 2, this.ticksPrinted);
            int n2 = 0;
            while (n2 < n) {
                tTYDisplay.print("|");
                ++this.ticksPrinted;
                ++n2;
            }
        }
        if (progress.getPercentComplete() >= 100 && !this.oldCaption.equals(string)) {
            this.isProgressComplete = true;
            tTYDisplay.printLine();
            tTYDisplay.printLine();
            tTYDisplay.printLine(string);
            this.oldCaption = string;
        }
        progress.setRedisplayProgress(false);
    }
}

