/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizardx.progress;

import com.installshield.util.Progress;
import com.installshield.util.PropertyUtils;
import com.installshield.wizard.awt.ColumnConstraints;
import com.installshield.wizard.awt.ColumnLayout;
import com.installshield.wizard.awt.ComponentUtils;
import com.installshield.wizard.awt.Spacing;
import com.installshield.wizard.swing.JFlowLabel;
import com.installshield.wizard.swing.SwingProgressRendererImpl;
import com.installshield.wizardx.progress.StandardProgressRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class StandardProgressRendererSwingImpl
extends SwingProgressRendererImpl {
    private JFlowLabel caption = null;
    private JFlowLabel detail = null;
    private JProgressBar progressBar = null;
    private boolean isProgressHidden = false;

    public JComponent getComponent() {
        return this;
    }

    public void initialize() {
        StandardProgressRenderer standardProgressRenderer = (StandardProgressRenderer)this.getProgressRenderer();
        ((Container)((Object)this)).setLayout((LayoutManager)new ColumnLayout());
        ((JComponent)((Object)this)).setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        this.caption = new JFlowLabel(" ");
        ((Container)((Object)this)).add((Component)this.caption, ColumnConstraints.createHorizontalFill());
        ((Container)((Object)this)).add(Spacing.createVerticalSpacing((int)30));
        this.detail = new JFlowLabel(" ");
        ((Container)((Object)this)).add((Component)this.detail, ColumnConstraints.createHorizontalFill());
        ((Container)((Object)this)).add(Spacing.createVerticalSpacing((int)4));
        this.progressBar = new JProgressBar();
        ((Container)((Object)this)).add(this.progressBar, ColumnConstraints.createHorizontalFill());
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(100);
        this.progressBar.setStringPainted(true);
        if (((StandardProgressRenderer)this.getProgressRenderer()).getOverrideSwingColors()) {
            this.progressBar.setForeground(PropertyUtils.createColor((String)standardProgressRenderer.getProgressForeground(), (Color)this.progressBar.getForeground()));
            this.progressBar.setBackground(PropertyUtils.createColor((String)standardProgressRenderer.getProgressBackground(), (Color)this.progressBar.getBackground()));
        }
        ((Container)((Object)this)).add(new JPanel(), ColumnConstraints.createVerticalFill());
    }

    public void starting() {
        this.progressBar.setValue(0);
    }

    public void updateProgress(Progress progress) {
        Object object;
        boolean bl = false;
        String string = progress.getStatusDescription();
        if (!string.equals(this.caption.getText())) {
            if (string.length() > 0) {
                object = this.caption.getFont();
                Font font = new Font(((Font)object).getName(), 1, ((Font)object).getSize());
                this.caption.setFont(font);
                this.caption.setText(string);
            } else {
                this.caption.setText(" ");
            }
            bl = true;
        }
        if (!((String)(object = ((StandardProgressRenderer)this.getProgressRenderer()).getWrapDetail() ? progress.getStatusDetail() : ComponentUtils.spliceFileName((String)progress.getStatusDetail(), (Component)this.detail))).equals(this.detail.getText())) {
            if (((String)object).length() > 0) {
                this.detail.setText((String)object);
            } else {
                this.detail.setText(" ");
            }
            bl = true;
        }
        int n = progress.getPercentComplete();
        this.progressBar.setValue(n);
        if (bl) {
            ((Container)((Object)this)).validate();
            ((Component)((Object)this)).repaint();
        }
    }
}

