/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ismp.ase.wizardbean;

import com.installshield.util.TTYDisplay;
import com.installshield.util.TTYPrompt;
import com.installshield.wizard.console.DefaultConsoleWizardPanelImpl;
import com.sybase.ismp.ase.lang.ASEResourceGetter;
import com.sybase.ismp.ase.wizardbean.ConfigServerInputPanel;
import java.util.ArrayList;

public class ConfigServerInputPanelConsoleImpl
extends DefaultConsoleWizardPanelImpl {
    private String[] items = null;
    private boolean[] selected = null;
    private boolean _isWindows = System.getProperty("os.name").toLowerCase().startsWith("win");

    protected void consoleInteraction(TTYDisplay tTYDisplay) {
        int n;
        super.consoleInteraction(tTYDisplay);
        ArrayList<String> arrayList = new ArrayList<String>();
        ConfigServerInputPanel configServerInputPanel = this.getConfigServerInputPanel();
        if (configServerInputPanel.getConfigOption(0)) {
            arrayList.add(ConfigServerInputPanel.ASE_ITEM);
        }
        if (configServerInputPanel.getConfigOption(1)) {
            arrayList.add(ConfigServerInputPanel.BSRV_ITEM);
        }
        if (configServerInputPanel.getConfigOption(2)) {
            arrayList.add(ConfigServerInputPanel.MSRV_ITEM);
        }
        if (configServerInputPanel.getConfigOption(3) && !this._isWindows) {
            arrayList.add(ConfigServerInputPanel.XP_ITEM);
        }
        if (configServerInputPanel.getConfigOption(4)) {
            arrayList.add(ConfigServerInputPanel.JS_ITEM);
        }
        if (configServerInputPanel.getConfigOption(5)) {
            arrayList.add(ConfigServerInputPanel.WS_ITEM);
        }
        if (configServerInputPanel.getConfigOption(6)) {
            arrayList.add(ConfigServerInputPanel.TXT_ITEM);
        }
        int n2 = arrayList.size();
        this.items = new String[n2];
        this.selected = new boolean[n2];
        for (int i = 0; i < n2; ++i) {
            this.items[i] = arrayList.get(i).toString();
            this.selected[i] = true;
        }
        tTYDisplay.printLine(ASEResourceGetter.getString((String)"configure_new_servers_question"));
        TTYPrompt tTYPrompt = new TTYPrompt(this.resolveString("$L(com.installshield.wizardx.i18n.WizardXResources, ChoiceComponent.caption)"));
        tTYPrompt.setDefaultValue(0);
        tTYPrompt.setMinLegalValue(0);
        tTYPrompt.setMaxLegalValue(n2);
        tTYPrompt.setIndent(6);
        while (true) {
            this.printTable(tTYDisplay);
            n = tTYDisplay.promptInt(tTYPrompt);
            if (n == 0) break;
            this.changeSelection(n);
        }
        for (n = 0; n < n2; ++n) {
            if (this.items[n].equals(ConfigServerInputPanel.ASE_ITEM)) {
                configServerInputPanel.setConfigureAse(this.selected[n]);
            } else if (this.items[n].equals(ConfigServerInputPanel.BSRV_ITEM)) {
                configServerInputPanel.setConfigureBackup(this.selected[n]);
            } else if (this.items[n].equals(ConfigServerInputPanel.MSRV_ITEM)) {
                configServerInputPanel.setConfigureMonitor(this.selected[n]);
            } else if (this.items[n].equals(ConfigServerInputPanel.XP_ITEM)) {
                configServerInputPanel.setConfigureXp(this.selected[n]);
            } else if (this.items[n].equals(ConfigServerInputPanel.JS_ITEM)) {
                configServerInputPanel.setConfigureJobScheduler(this.selected[n]);
            } else if (this.items[n].equals(ConfigServerInputPanel.WS_ITEM)) {
                configServerInputPanel.setConfigureWebServices(this.selected[n]);
            } else if (this.items[n].equals(ConfigServerInputPanel.TXT_ITEM)) {
                configServerInputPanel.setConfigureTextServer(this.selected[n]);
            }
            if (!this._isWindows) continue;
            if (configServerInputPanel.getConfigureAse()) {
                configServerInputPanel.setConfigureXp(true);
                continue;
            }
            configServerInputPanel.setConfigureXp(false);
        }
    }

    private void printTable(TTYDisplay tTYDisplay) {
        String string = null;
        tTYDisplay.printLine("");
        for (int i = 0; i < this.items.length; ++i) {
            string = this.selected[i] ? "[X]  " + String.valueOf(i + 1) + "  -  " + this.items[i] : "[ ]  " + String.valueOf(i + 1) + "  -  " + this.items[i];
            tTYDisplay.printIndentedLine(string);
        }
        tTYDisplay.printLine("");
    }

    private void changeSelection(int n) {
        if (n == 0) {
            return;
        }
        boolean bl = this.selected[n - 1] = !this.selected[n - 1];
        if (this.items[n - 1].equals(ConfigServerInputPanel.ASE_ITEM) && !this.selected[n - 1]) {
            for (int i = 0; i < this.items.length; ++i) {
                if (!this.items[i].equals(ConfigServerInputPanel.BSRV_ITEM) && !this.items[i].equals(ConfigServerInputPanel.MSRV_ITEM) && !this.items[i].equals(ConfigServerInputPanel.XP_ITEM) && !this.items[i].equals(ConfigServerInputPanel.JS_ITEM) && !this.items[i].equals(ConfigServerInputPanel.WS_ITEM) && !this.items[i].equals(ConfigServerInputPanel.TXT_ITEM)) continue;
                this.selected[i] = false;
            }
        }
        if ((this.items[n - 1].equals(ConfigServerInputPanel.BSRV_ITEM) || this.items[n - 1].equals(ConfigServerInputPanel.MSRV_ITEM) || this.items[n - 1].equals(ConfigServerInputPanel.XP_ITEM) || this.items[n - 1].equals(ConfigServerInputPanel.JS_ITEM) || this.items[n - 1].equals(ConfigServerInputPanel.WS_ITEM) || this.items[n - 1].equals(ConfigServerInputPanel.TXT_ITEM)) && this.selected[n - 1]) {
            this.selected[0] = true;
        }
    }

    private ConfigServerInputPanel getConfigServerInputPanel() {
        return (ConfigServerInputPanel)this.getPanel();
    }
}

