/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ismp.ase.wizardbean;

import com.installshield.wizard.WizardAction;
import com.installshield.wizard.WizardBean;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.FileService;
import com.installshield.wizardx.panels.ChoiceInputField;
import com.installshield.wizardx.panels.ChoiceItem;
import com.installshield.wizardx.panels.GenericInputField;
import com.installshield.wizardx.panels.GenericUserInputPanel;
import com.installshield.wizardx.panels.TextInputField;

public class SetDefaultValuesWizardAction
extends WizardAction {
    public void execute(WizardBeanEvent wizardBeanEvent) {
        String[] stringArray = this.retrieveFileContents(this.retrieveOptionsFile());
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                String string = stringArray[i].trim();
                if (!string.startsWith("-W")) continue;
                string = string.substring("-W".length()).trim();
                this.logEvent((Object)this, "dbg", "Parsing:" + string);
                int n = string.indexOf(".");
                String string2 = string.substring(0, n).trim();
                int n2 = string.indexOf("=");
                String string3 = this.stripQuotes(string.substring(n + 1, n2).trim());
                String string4 = this.stripQuotes(string.substring(n2 + 1).trim());
                this.logEvent((Object)this, "dbg", "Setting " + string2 + "." + string3 + "=" + string4);
                WizardBean wizardBean = this.getWizardTree().findWizardBean(string2);
                if (!(wizardBean instanceof GenericUserInputPanel)) continue;
                GenericUserInputPanel genericUserInputPanel = (GenericUserInputPanel)wizardBean;
                GenericInputField genericInputField = genericUserInputPanel.getInputField(string3);
                if (genericInputField instanceof TextInputField) {
                    ((TextInputField)genericInputField).setDefaultValue(string4);
                    ((TextInputField)genericInputField).setValue((Object)new String[]{string4});
                    continue;
                }
                if (genericInputField instanceof ChoiceInputField) {
                    ChoiceItem[] choiceItemArray = ((ChoiceInputField)genericInputField).getChoices();
                    for (int j = 0; j < choiceItemArray.length; ++j) {
                        if (choiceItemArray[j].getValue().equals(string4)) {
                            choiceItemArray[j].setSelected(true);
                            continue;
                        }
                        choiceItemArray[j].setSelected(false);
                    }
                    ((ChoiceInputField)genericInputField).setValue((Object)new String[]{string4});
                    continue;
                }
                this.logEvent((Object)this, "err", "Unrecognized input field type to set default value");
                continue;
            }
            catch (NullPointerException nullPointerException) {
                this.logEvent((Object)this, "err", nullPointerException);
            }
        }
    }

    public void build(WizardBuilderSupport wizardBuilderSupport) {
        try {
            wizardBuilderSupport.putPackage("com.installshield.wizardx.panels");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            wizardBuilderSupport.logEvent((Object)this, "err", (Object)exception.getMessage());
        }
    }

    public String[] retrieveFileContents(String string) {
        try {
            FileService fileService = (FileService)this.getService("fileService");
            if (!string.equals("")) {
                this.logEvent((Object)this, "dbg", "Reading options file: " + string);
                return fileService.readAsciiFile(string);
            }
        }
        catch (ServiceException serviceException) {
            this.logEvent((Object)this, "err", (Object)serviceException);
        }
        return new String[0];
    }

    public String retrieveOptionsFile() {
        String[] stringArray = this.getWizard().getCommandLineArgs();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-options") || i + 1 >= stringArray.length) continue;
            this.logEvent((Object)this, "dbg", "Found options file in command line argument: " + stringArray[i + 1]);
            return stringArray[i + 1];
        }
        return new String("");
    }

    protected String stripQuotes(String string) {
        if (string.startsWith("\"") && string.endsWith("\"") && string.length() > 1) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }
}

