/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.EntryChangeResponseControl;
import com.sun.jndi.ldap.EventSupport;
import com.sun.jndi.ldap.LdapCtx;
import com.sun.jndi.ldap.LdapName;
import com.sun.jndi.ldap.LdapSearchEnumeration;
import com.sun.jndi.ldap.NotifierArgs;
import com.sun.jndi.ldap.Obj;
import com.sun.jndi.ldap.PersistentSearchControl;
import com.sun.jndi.toolkit.ctx.Continuation;
import java.io.IOException;
import java.io.Serializable;
import java.util.EventObject;
import java.util.Vector;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.InterruptedNamingException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchResult;
import javax.naming.event.EventContext;
import javax.naming.event.NamingEvent;
import javax.naming.event.NamingExceptionEvent;
import javax.naming.event.NamingListener;
import javax.naming.ldap.Control;
import javax.naming.ldap.HasControls;

final class NamingEventNotifier
implements Runnable {
    private static final boolean debug = false;
    private Vector namingListeners;
    private Thread worker;
    private LdapCtx context;
    private EventContext eventSrc;
    private EventSupport support;
    private NamingEnumeration results;
    NotifierArgs info;

    NamingEventNotifier(EventSupport eventSupport, LdapCtx ldapCtx, NotifierArgs notifierArgs, NamingListener namingListener) throws NamingException {
        PersistentSearchControl persistentSearchControl;
        this.info = notifierArgs;
        this.support = eventSupport;
        try {
            persistentSearchControl = new PersistentSearchControl(notifierArgs.mask, true, true, true);
        }
        catch (IOException iOException) {
            NamingException namingException = new NamingException("Problem creating persistent search control");
            namingException.setRootCause(iOException);
            throw namingException;
        }
        this.context = (LdapCtx)ldapCtx.newInstance(new Control[]{persistentSearchControl});
        this.eventSrc = ldapCtx;
        this.namingListeners = new Vector();
        this.namingListeners.addElement(namingListener);
        this.worker = Obj.helper.createThread(this);
        this.worker.setDaemon(true);
        this.worker.start();
    }

    void addNamingListener(NamingListener namingListener) {
        this.namingListeners.addElement(namingListener);
    }

    private void cleanup() {
        try {
            if (this.results != null) {
                this.results.close();
                this.results = null;
            }
            if (this.context != null) {
                this.context.close();
                this.context = null;
            }
        }
        catch (NamingException namingException) {}
    }

    private void fireNamingException(NamingException namingException) {
        if (this.namingListeners == null || this.namingListeners.size() == 0) {
            return;
        }
        NamingExceptionEvent namingExceptionEvent = new NamingExceptionEvent(this.eventSrc, namingException);
        this.support.queueEvent(namingExceptionEvent, this.namingListeners);
    }

    private void fireObjectAdded(Binding binding, long l) {
        if (this.namingListeners == null || this.namingListeners.size() == 0) {
            return;
        }
        NamingEvent namingEvent = new NamingEvent(this.eventSrc, 0, binding, null, new Long(l));
        this.support.queueEvent(namingEvent, this.namingListeners);
    }

    private void fireObjectChanged(Binding binding, long l) {
        if (this.namingListeners == null || this.namingListeners.size() == 0) {
            return;
        }
        Binding binding2 = new Binding(binding.getName(), (Object)null, binding.isRelative());
        NamingEvent namingEvent = new NamingEvent(this.eventSrc, 3, binding, binding2, new Long(l));
        this.support.queueEvent(namingEvent, this.namingListeners);
    }

    private void fireObjectRemoved(Binding binding, long l) {
        if (this.namingListeners == null || this.namingListeners.size() == 0) {
            return;
        }
        NamingEvent namingEvent = new NamingEvent(this.eventSrc, 1, null, binding, new Long(l));
        this.support.queueEvent(namingEvent, this.namingListeners);
    }

    private void fireObjectRenamed(Binding binding, String string, long l) {
        Serializable serializable;
        if (this.namingListeners == null || this.namingListeners.size() == 0) {
            return;
        }
        Binding binding2 = null;
        try {
            serializable = new LdapName(string);
            if (serializable.startsWith(this.context.currentParsedDN)) {
                String string2 = serializable.getSuffix(this.context.currentParsedDN.size()).toString();
                binding2 = new Binding(string2, (Object)null);
            }
        }
        catch (NamingException namingException) {}
        if (binding2 == null) {
            binding2 = new Binding(string, (Object)null, false);
        }
        serializable = new NamingEvent(this.eventSrc, 2, binding, binding2, new Long(l));
        this.support.queueEvent((EventObject)serializable, this.namingListeners);
    }

    boolean hasNamingListeners() {
        return this.namingListeners.size() > 0;
    }

    void removeNamingListener(NamingListener namingListener) {
        this.namingListeners.removeElement(namingListener);
    }

    public void run() {
        try {
            try {
                Continuation continuation = new Continuation();
                continuation.setError((Object)this, this.info.name);
                CompositeName compositeName = this.info.name == null || this.info.name.equals("") ? new CompositeName() : new CompositeName().add(this.info.name);
                this.results = this.context.searchAux(compositeName, this.info.filter, this.info.controls, true, false, continuation);
                ((LdapSearchEnumeration)this.results).setStartName(this.context.currentParsedDN);
                block11: while (this.results.hasMore()) {
                    block12: while (true) {
                        SearchResult searchResult;
                        Control[] controlArray;
                        Control[] controlArray2 = controlArray = (searchResult = (SearchResult)this.results.next()) instanceof HasControls ? ((HasControls)((Object)searchResult)).getControls() : null;
                        if (controlArray == null) continue block11;
                        int n = 0;
                        if (n >= controlArray.length) continue block11;
                        if (!(controlArray[n] instanceof EntryChangeResponseControl)) continue block11;
                        EntryChangeResponseControl entryChangeResponseControl = (EntryChangeResponseControl)controlArray[n];
                        long l = entryChangeResponseControl.getChangeNumber();
                        switch (entryChangeResponseControl.getChangeType()) {
                            case 1: {
                                this.fireObjectAdded(searchResult, l);
                                continue block11;
                            }
                            case 2: {
                                this.fireObjectRemoved(searchResult, l);
                                continue block11;
                            }
                            case 4: {
                                this.fireObjectChanged(searchResult, l);
                                continue block11;
                            }
                            case 8: {
                                this.fireObjectRenamed(searchResult, entryChangeResponseControl.getPreviousDN(), l);
                                continue block11;
                            }
                            default: {
                                if (this.results.hasMore()) continue block12;
                            }
                        }
                        break;
                    }
                    break;
                }
            }
            catch (InterruptedNamingException interruptedNamingException) {
            }
            catch (NamingException namingException) {
                this.fireNamingException(namingException);
                this.support.removeDeadNotifier(this.info);
            }
            Object var2_9 = null;
            this.cleanup();
        }
        catch (Throwable throwable) {
            Object var2_10 = null;
            this.cleanup();
            throw throwable;
        }
    }

    void stop() {
        if (this.worker != null) {
            this.worker.interrupt();
            this.worker = null;
        }
    }
}

