/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import javax.naming.directory.SearchControls;
import javax.naming.event.NamespaceChangeListener;
import javax.naming.event.NamingListener;
import javax.naming.event.ObjectChangeListener;

final class NotifierArgs {
    static final int ADDED_MASK = 1;
    static final int REMOVED_MASK = 2;
    static final int CHANGED_MASK = 4;
    static final int RENAMED_MASK = 8;
    String name;
    String filter;
    SearchControls controls;
    int mask;
    private int sum = -1;

    NotifierArgs(String string, int n, NamingListener namingListener) {
        this(string, "(objectclass=*)", null, namingListener);
        if (n != 1) {
            this.controls = new SearchControls();
            this.controls.setSearchScope(n);
        }
    }

    NotifierArgs(String string, String string2, SearchControls searchControls, NamingListener namingListener) {
        this.name = string;
        this.filter = string2;
        this.controls = searchControls;
        if (namingListener instanceof NamespaceChangeListener) {
            this.mask |= 0xB;
        }
        if (namingListener instanceof ObjectChangeListener) {
            this.mask |= 4;
        }
    }

    private boolean checkControls(SearchControls searchControls) {
        if (this.controls == null || searchControls == null) {
            return searchControls == this.controls;
        }
        return this.controls.getSearchScope() == searchControls.getSearchScope() && this.controls.getTimeLimit() == searchControls.getTimeLimit() && this.controls.getDerefLinkFlag() == searchControls.getDerefLinkFlag() && this.controls.getReturningObjFlag() == searchControls.getReturningObjFlag() && this.controls.getCountLimit() == searchControls.getCountLimit() && NotifierArgs.checkStringArrays(this.controls.getReturningAttributes(), searchControls.getReturningAttributes());
    }

    private static boolean checkStringArrays(String[] stringArray, String[] stringArray2) {
        if (stringArray == null || stringArray2 == null) {
            return stringArray == stringArray2;
        }
        if (stringArray.length != stringArray2.length) {
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (!stringArray[n].equals(stringArray2[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private int controlsCode() {
        if (this.controls == null) {
            return 0;
        }
        int n = this.controls.getTimeLimit() + (int)this.controls.getCountLimit() + (this.controls.getDerefLinkFlag() ? 1 : 0) + (this.controls.getReturningObjFlag() ? 1 : 0);
        String[] stringArray = this.controls.getReturningAttributes();
        if (stringArray != null) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                n += stringArray[n2].hashCode();
                ++n2;
            }
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object instanceof NotifierArgs) {
            NotifierArgs notifierArgs = (NotifierArgs)object;
            return this.mask == notifierArgs.mask && this.name.equals(notifierArgs.name) && this.filter.equals(notifierArgs.filter) && this.checkControls(notifierArgs.controls);
        }
        return false;
    }

    public int hashCode() {
        if (this.sum == -1) {
            this.sum = this.mask + this.name.hashCode() + this.filter.hashCode() + this.controlsCode();
        }
        return this.sum;
    }
}

