/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.ui.prefs;

import com.sun.javaws.ConfigProperties;
import com.sun.javaws.Resources;
import com.sun.javaws.debug.Globals;
import com.sun.javaws.ui.prefs.JRESearcher;
import com.sun.javaws.ui.prefs.PrefsPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class JREPanel
extends PrefsPanel.PropertyPanel
implements ActionListener,
ListSelectionListener,
TableModelListener {
    private static Border badBorder = new LineBorder(Color.red);
    private JTable jresTable;
    private JTextField locationTF;
    private JRETableModel tableModel;
    private JButton findButton;
    private JButton removeButton;
    private JButton chooseButton;
    private int _nextAvailableJREIndex = 0;
    private HashSet _hiddenJres = new HashSet();
    static Class class$java$lang$String;
    static Class class$java$lang$Boolean;

    private int getNextAvailableJREIndex() {
        return this._nextAvailableJREIndex++;
    }

    public void apply() {
        if (this.jresTable.isEditing()) {
            this.jresTable.getCellEditor().stopCellEditing();
        }
        ConfigProperties configProperties = ConfigProperties.getInstance();
        ArrayList arrayList = configProperties.getJREInformationList();
        if (this.tableModel.getRowCount() > 0) {
            arrayList.clear();
            for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
                arrayList.add(this.tableModel.getJRE(i));
            }
            Iterator iterator = this._hiddenJres.iterator();
            while (iterator.hasNext()) {
                ConfigProperties.JREInformation jREInformation = (ConfigProperties.JREInformation)iterator.next();
                arrayList.add(jREInformation);
            }
        }
    }

    protected void createPropertyControls() {
        Serializable serializable;
        this.tableModel = new JRETableModel(this);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        TitledBorder titledBorder = new TitledBorder(LineBorder.createBlackLineBorder(), Resources.getString("controlpanel.jre.title"), 1, 2);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(titledBorder);
        this.jresTable = new JTable(this.tableModel);
        Enumeration<TableColumn> enumeration = this.jresTable.getColumnModel().getColumns();
        JRETableCellRenderer jRETableCellRenderer = new JRETableCellRenderer(this, null);
        while (enumeration.hasMoreElements()) {
            serializable = enumeration.nextElement();
            if (((TableColumn)serializable).getModelIndex() >= 4) continue;
            ((TableColumn)serializable).setCellRenderer(jRETableCellRenderer);
        }
        this.jresTable.setPreferredScrollableViewportSize(new Dimension(450, 150));
        this.jresTable.getSelectionModel().addListSelectionListener(this);
        this.jresTable.getColumnModel().getColumn(3).setCellRenderer(new JRETableCellRenderer(this){
            private final JREPanel this$0;
            {
                this.this$0 = jREPanel;
            }

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (component instanceof JComponent && !JREPanel.access$100(this.this$0).isPathValid(n)) {
                    ((JComponent)component).setBorder(JREPanel.access$200());
                }
                return component;
            }
        });
        this.jresTable.getColumnModel().getColumn(3).setCellEditor(new PathEditor(this));
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)new JScrollPane(this.jresTable), gridBagConstraints);
        serializable = Box.createHorizontalBox();
        this.chooseButton = new JButton(Resources.getString("controlpanel.jre.choose"));
        this.chooseButton.setMnemonic(Resources.getVKCode("controlpanel.jre.chooseMnemonic"));
        this.chooseButton.setRequestFocusEnabled(false);
        this.chooseButton.addActionListener(this);
        ((Container)serializable).add(this.chooseButton);
        ((Container)serializable).add(Box.createHorizontalGlue());
        JButton jButton = new JButton(Resources.getString("controlpanel.jre.find"));
        jButton.setRequestFocusEnabled(false);
        jButton.addActionListener(this);
        ((Container)serializable).add(jButton);
        ((Container)serializable).add(Box.createHorizontalStrut(5));
        this.findButton = jButton;
        this.findButton.setMnemonic(Resources.getVKCode("controlpanel.jre.findMnemonic"));
        jButton = new JButton(Resources.getString("controlpanel.jre.add"));
        jButton.setRequestFocusEnabled(false);
        jButton.addActionListener(this);
        jButton.setMnemonic(Resources.getVKCode("controlpanel.jre.addMnemonic"));
        ((Container)serializable).add(jButton);
        ((Container)serializable).add(Box.createHorizontalStrut(5));
        jButton = new JButton(Resources.getString("controlpanel.jre.remove"));
        jButton.setRequestFocusEnabled(false);
        ((Container)serializable).add(jButton);
        this.removeButton = jButton;
        this.removeButton.addActionListener(this);
        this.removeButton.setMnemonic(Resources.getVKCode("controlpanel.jre.removeMnemonic"));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)serializable, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.bottom = 5;
        this.add((Component)jPanel, gridBagConstraints);
        this.updateRemoveButton();
        this.tableModel.addTableModelListener(this);
        this.revert();
    }

    private void findJREs() {
        JFileChooser jFileChooser = new JFileChooser();
        File file = this.getFirstValidParent(this.jresTable.getSelectedRow());
        if (file != null && file.exists()) {
            jFileChooser.setSelectedFile(file);
        }
        jFileChooser.setDialogType(0);
        ConfigProperties.JREInformation[] jREInformationArray = new JRESearcher().search(this.getComponent(), Resources.getResources(), Resources.getString("controlpanel.findJREIntro"));
        if (jREInformationArray != null) {
            for (int i = 0; i < jREInformationArray.length; ++i) {
                this.tableModel.add(jREInformationArray[i]);
            }
        }
    }

    public void revert() {
        this.jresTable.removeEditor();
        this.tableModel.refresh();
    }

    private void updateRemoveButton() {
        int n = this.jresTable.getSelectedRow();
        int n2 = this.jresTable.getRowCount();
        this.removeButton.setEnabled(n != -1 && n2 > 1 && n < n2 && this.tableModel.getJRE(n).getWhereSpecified() == 0);
        this.chooseButton.setEnabled(n != -1 && n2 > 1 && n < n2 && this.tableModel.getJRE(n).getWhereSpecified() == 0);
    }

    private void changePath(int n) {
        JFileChooser jFileChooser = new JFileChooser();
        File file = this.getFirstValidParent(n);
        if (file != null && file.exists()) {
            jFileChooser.setSelectedFile(file);
        }
        if (jFileChooser.showOpenDialog(this) == 0) {
            this.tableModel.setValueAt(jFileChooser.getSelectedFile().getPath(), n, 3);
        }
    }

    private void versionChanged(int n) {
    }

    static int access$500(JREPanel jREPanel) {
        return jREPanel._nextAvailableJREIndex;
    }

    static int access$502(JREPanel jREPanel, int n) {
        jREPanel._nextAvailableJREIndex = n;
        return jREPanel._nextAvailableJREIndex;
    }

    static void access$600(JREPanel jREPanel, int n) {
        jREPanel.versionChanged(n);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JComponent jComponent = (JComponent)actionEvent.getSource();
        if (jComponent == this.removeButton) {
            this.tableModel.remove(this.jresTable.getSelectedRows());
            this.jresTable.clearSelection();
        } else if (jComponent == this.findButton) {
            this.findJREs();
            this.requestFocus();
        } else if (jComponent == this.chooseButton) {
            int n = this.jresTable.getSelectedRow();
            if (n != -1) {
                this.changePath(n);
                this.requestFocus();
            }
        } else {
            this.tableModel.add(new ConfigProperties.JREInformation(null, null, null, null, 0, true, this.getNextAvailableJREIndex(), Globals.osName, Globals.osArch));
            int n = this.tableModel.getRowCount() - 1;
            this.jresTable.requestFocus();
            this.jresTable.setRowSelectionInterval(n, n);
        }
    }

    private File getFirstValidParent(int n) {
        String string;
        if (n != -1 && (string = this.tableModel.getJRE(n).getInstalledPath()) != null) {
            File file = new File(string);
            while (file != null && !file.exists()) {
                string = file.getParent();
                if (string != null) {
                    file = new File(string);
                    continue;
                }
                file = null;
            }
            return file;
        }
        return null;
    }

    private boolean isValidJREPath(String string) {
        if (string != null) {
            File file = new File(string);
            return file.exists() && !file.isDirectory();
        }
        return false;
    }

    static Border access$200() {
        return badBorder;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateRemoveButton();
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        this.updateRemoveButton();
    }

    static JRETableModel access$100(JREPanel jREPanel) {
        return jREPanel.tableModel;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static boolean access$300(JREPanel jREPanel, String string) {
        return jREPanel.isValidJREPath(string);
    }

    static HashSet access$400(JREPanel jREPanel) {
        return jREPanel._hiddenJres;
    }

    private class JRETableCellRenderer
    extends DefaultTableCellRenderer {
        private final JREPanel this$0;

        private JRETableCellRenderer(JREPanel jREPanel) {
            this.this$0 = jREPanel;
        }

        JRETableCellRenderer(JREPanel jREPanel, 1 var2_2) {
            this(jREPanel);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (component instanceof Component) {
                if (((JRETableModel)jTable.getModel()).getJRE(n).getWhereSpecified() != 0 && n2 < 4) {
                    component.setEnabled(false);
                } else {
                    component.setEnabled(true);
                }
            }
            return component;
        }
    }

    private class JRETableModel
    extends AbstractTableModel {
        private ArrayList _jres;
        private ArrayList _validPaths;
        private String[] _columnNames;
        private final JREPanel this$0;

        public int getColumnCount() {
            return 5;
        }

        public int getRowCount() {
            return this._jres.size();
        }

        public void refresh() {
            this._jres.clear();
            this._validPaths.clear();
            JREPanel.access$400(this.this$0).clear();
            ConfigProperties configProperties = ConfigProperties.getInstance();
            ArrayList arrayList = configProperties.getJREInformationList();
            for (int i = 0; i < arrayList.size(); ++i) {
                ConfigProperties.JREInformation jREInformation = (ConfigProperties.JREInformation)arrayList.get(i);
                if (jREInformation.getOsName() == null || jREInformation.getOsArch() == null || jREInformation.getOsName().equals(Globals.osName) && jREInformation.getOsArch().equals(Globals.osArch)) {
                    this.add(jREInformation.copy(), false, false);
                    if (jREInformation.getIndex() < JREPanel.access$500(this.this$0)) continue;
                    JREPanel.access$502(this.this$0, jREInformation.getIndex() + 1);
                    continue;
                }
                JREPanel.access$400(this.this$0).add(jREInformation.copy());
            }
            this.fireTableDataChanged();
        }

        public boolean isPathValid(int n) {
            Boolean bl = (Boolean)this._validPaths.get(n);
            if (bl == null) {
                bl = JREPanel.access$300(this.this$0, this.getJRE(n).getInstalledPath()) ? Boolean.TRUE : Boolean.FALSE;
                this._validPaths.set(n, bl);
            }
            return Boolean.TRUE.equals(bl);
        }

        public boolean isCellEditable(int n, int n2) {
            return this.getJRE(n).getWhereSpecified() == 0 || n2 == 4;
        }

        public void remove(int[] nArray) {
            if (nArray != null) {
                int n = this.getRowCount();
                for (int i = nArray.length - 1; i >= 0; --i) {
                    if (nArray[i] == -1 || nArray[i] >= n) continue;
                    this._jres.remove(nArray[i]);
                    this._validPaths.remove(nArray[i]);
                }
            }
            this.fireTableDataChanged();
        }

        public ConfigProperties.JREInformation getJRE(int n) {
            return (ConfigProperties.JREInformation)this._jres.get(n);
        }

        public void add(ConfigProperties.JREInformation jREInformation) {
            this.add(jREInformation, false, true);
        }

        void add(ConfigProperties.JREInformation jREInformation, boolean bl, boolean bl2) {
            this._jres.add(jREInformation);
            if (bl) {
                this._validPaths.add(Boolean.TRUE);
            } else {
                this._validPaths.add(null);
            }
            if (bl2) {
                this.fireTableRowsInserted(this._jres.size() - 1, this._jres.size() - 1);
            }
        }

        JRETableModel(JREPanel jREPanel) {
            this.this$0 = jREPanel;
            this._jres = new ArrayList();
            this._validPaths = new ArrayList();
            this.refresh();
        }

        public Class getColumnClass(int n) {
            if (n < 4) {
                return class$java$lang$String == null ? (class$java$lang$String = JREPanel.class$("java.lang.String")) : class$java$lang$String;
            }
            return class$java$lang$Boolean == null ? (class$java$lang$Boolean = JREPanel.class$("java.lang.Boolean")) : class$java$lang$Boolean;
        }

        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return this.getJRE(n).getPlatformVersionId();
                }
                case 1: {
                    return this.getJRE(n).getProductVersionId();
                }
                case 2: {
                    return this.getJRE(n).getProductLocation();
                }
                case 3: {
                    return this.getJRE(n).getInstalledPath();
                }
            }
            return new Boolean(this.getJRE(n).isEnabled());
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n >= this._jres.size()) {
                return;
            }
            ConfigProperties.JREInformation jREInformation = this.getJRE(n);
            switch (n2) {
                case 0: {
                    this._jres.set(n, new ConfigProperties.JREInformation((String)object, jREInformation.getProductVersionId(), jREInformation.getProductLocation(), jREInformation.getInstalledPath(), jREInformation.getWhereSpecified(), jREInformation.isEnabled(), jREInformation.getIndex(), jREInformation.getOsName(), jREInformation.getOsArch()));
                    break;
                }
                case 1: {
                    this._jres.set(n, new ConfigProperties.JREInformation(jREInformation.getPlatformVersionId(), (String)object, jREInformation.getProductLocation(), jREInformation.getInstalledPath(), jREInformation.getWhereSpecified(), jREInformation.isEnabled(), jREInformation.getIndex(), jREInformation.getOsName(), jREInformation.getOsArch()));
                    JREPanel.access$600(this.this$0, n);
                    break;
                }
                case 2: {
                    URL uRL = jREInformation.getProductLocation();
                    try {
                        uRL = new URL((String)object);
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                    this._jres.set(n, new ConfigProperties.JREInformation(jREInformation.getPlatformVersionId(), jREInformation.getProductVersionId(), uRL, jREInformation.getInstalledPath(), jREInformation.getWhereSpecified(), jREInformation.isEnabled(), jREInformation.getIndex(), jREInformation.getOsName(), jREInformation.getOsArch()));
                    JREPanel.access$600(this.this$0, n);
                    break;
                }
                case 3: {
                    this._jres.set(n, new ConfigProperties.JREInformation(jREInformation.getPlatformVersionId(), jREInformation.getProductVersionId(), jREInformation.getProductLocation(), (String)object, jREInformation.getWhereSpecified(), jREInformation.isEnabled(), jREInformation.getIndex(), jREInformation.getOsName(), jREInformation.getOsArch()));
                    this._validPaths.set(n, null);
                    break;
                }
                default: {
                    this._jres.set(n, new ConfigProperties.JREInformation(jREInformation.getPlatformVersionId(), jREInformation.getProductVersionId(), jREInformation.getProductLocation(), jREInformation.getInstalledPath(), jREInformation.getWhereSpecified(), (Boolean)object, jREInformation.getIndex(), jREInformation.getOsName(), jREInformation.getOsArch()));
                }
            }
            this.fireTableRowsUpdated(n, n);
        }

        public String getColumnName(int n) {
            if (this._columnNames == null) {
                this._columnNames = new String[]{Resources.getString("controlpanel.jre.platformVersionTableColumnTitle"), Resources.getString("controlpanel.jre.productVersionTableColumnTitle"), Resources.getString("controlpanel.jre.productLocationTableColumnTitle"), Resources.getString("controlpanel.jre.pathTableColumnTitle"), Resources.getString("controlpanel.jre.enabledColumnTitle")};
            }
            return this._columnNames[n];
        }
    }

    private class PathEditor
    extends DefaultCellEditor
    implements DocumentListener {
        private int row;
        private final JREPanel this$0;

        private void updateBorderFromEditor() {
            Object object = this.getCellEditorValue();
            boolean bl = object instanceof String ? JREPanel.access$300(this.this$0, (String)object) : false;
            if (bl) {
                this.editorComponent.setBorder(LineBorder.createBlackLineBorder());
            } else {
                this.editorComponent.setBorder(JREPanel.access$200());
            }
        }

        private void updateBorder(int n) {
            Border border = JREPanel.access$100(this.this$0).isPathValid(n) ? LineBorder.createBlackLineBorder() : JREPanel.access$200();
            this.editorComponent.setBorder(border);
        }

        PathEditor(JREPanel jREPanel) {
            super(new JTextField());
            this.this$0 = jREPanel;
            ((JTextField)this.editorComponent).getDocument().addDocumentListener(this);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.updateBorderFromEditor();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.updateBorderFromEditor();
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.row = n;
            super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            this.updateBorder(n);
            return this.editorComponent;
        }
    }
}

