/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.dns;

import com.sun.jndi.dns.DnsContext;
import com.sun.jndi.dns.DnsUrl;
import com.sun.jndi.toolkit.url.UrlUtil;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import sun.net.dns.ResolverConfiguration;

public class DnsContextFactory
implements InitialContextFactory {
    private static final String DEFAULT_URL = "dns:";

    public static boolean platformServersAvailable() {
        return !ResolverConfiguration.open().nameservers().isEmpty();
    }

    private static boolean platformServersUsed(DnsUrl[] dnsUrlArray) {
        if (!DnsContextFactory.platformServersAvailable()) {
            return false;
        }
        for (int i2 = 0; i2 < dnsUrlArray.length; ++i2) {
            if (dnsUrlArray[i2].getHost() != null || dnsUrlArray[i2].getPort() >= 0) continue;
            return true;
        }
        return false;
    }

    private static String[] serversForUrls(DnsUrl[] dnsUrlArray) throws NamingException {
        if (dnsUrlArray.length == 0) {
            throw new ConfigurationException("DNS pseudo-URL required");
        }
        ArrayList arrayList = new ArrayList();
        for (int i2 = 0; i2 < dnsUrlArray.length; ++i2) {
            List list;
            String string = dnsUrlArray[i2].getHost();
            int n2 = dnsUrlArray[i2].getPort();
            if (string == null && n2 < 0 && !(list = ResolverConfiguration.open().nameservers()).isEmpty()) {
                arrayList.addAll(list);
                continue;
            }
            if (string == null) {
                string = "localhost";
            }
            arrayList.add(n2 < 0 ? string : string + ":" + n2);
        }
        return (String[])arrayList.toArray(new String[arrayList.size()]);
    }

    private static String getInitCtxUrl(Hashtable hashtable) {
        String string = (String)hashtable.get("java.naming.provider.url");
        return string != null ? string : DEFAULT_URL;
    }

    public Context getInitialContext(Hashtable hashtable) throws NamingException {
        if (hashtable == null) {
            hashtable = new Hashtable(5);
        }
        return DnsContextFactory.urlToContext(DnsContextFactory.getInitCtxUrl(hashtable), hashtable);
    }

    private static String constructProviderUrl(String string, String[] stringArray) {
        String string2 = "";
        if (!string.equals(".")) {
            try {
                string2 = "/" + UrlUtil.encode(string, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append("dns://").append(stringArray[i2]).append(string2);
        }
        return stringBuffer.toString();
    }

    private static Context urlToContext(String string, Hashtable hashtable) throws NamingException {
        DnsUrl[] dnsUrlArray;
        try {
            dnsUrlArray = DnsUrl.fromList(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new ConfigurationException(malformedURLException.getMessage());
        }
        if (dnsUrlArray.length == 0) {
            throw new ConfigurationException("Invalid DNS pseudo-URL(s): " + string);
        }
        String string2 = dnsUrlArray[0].getDomain();
        for (int i2 = 1; i2 < dnsUrlArray.length; ++i2) {
            if (string2.equalsIgnoreCase(dnsUrlArray[i2].getDomain())) continue;
            throw new ConfigurationException("Conflicting domains: " + string);
        }
        return DnsContextFactory.getContext(string2, dnsUrlArray, hashtable);
    }

    public static DnsContext getContext(String string, DnsUrl[] dnsUrlArray, Hashtable hashtable) throws NamingException {
        String[] stringArray = DnsContextFactory.serversForUrls(dnsUrlArray);
        DnsContext dnsContext = DnsContextFactory.getContext(string, stringArray, hashtable);
        if (DnsContextFactory.platformServersUsed(dnsUrlArray)) {
            dnsContext.setProviderUrl(DnsContextFactory.constructProviderUrl(string, stringArray));
        }
        return dnsContext;
    }

    public static DnsContext getContext(String string, String[] stringArray, Hashtable hashtable) throws NamingException {
        return new DnsContext(string, stringArray, hashtable);
    }
}

