/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.FastShortMessage;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.SysexMessage;
import javax.sound.midi.Track;

class SMFParser {
    private static final int MTrk_MAGIC = 1297379947;
    int tracks;
    private InputStream stream;
    private int trackLength = 0;
    private byte[] trackData = null;
    private int pos = 0;

    private int readInt() throws IOException {
        int n2 = this.stream.read() << 24;
        int n3 = this.stream.read() << 16;
        int n4 = this.stream.read() << 8;
        int n5 = this.stream.read();
        if (n5 < 0) {
            throw new EOFException();
        }
        return n2 | n3 | n4 | n5;
    }

    public int readUnsigned() throws IOException {
        return this.trackData[this.pos++] & 0xFF;
    }

    public long readVarInt() throws IOException {
        long l2 = 0L;
        int n2 = 0;
        do {
            n2 = this.trackData[this.pos++] & 0xFF;
            l2 = (l2 << 7) + (long)(n2 & 0x7F);
        } while ((n2 & 0x80) != 0);
        return l2;
    }

    public void nextTrack() throws IOException, InvalidMidiDataException {
        int n2;
        this.trackLength = 0;
        do {
            if (this.stream.skip(this.trackLength) != (long)this.trackLength) {
                throw new EOFException();
            }
            n2 = this.readInt();
            this.trackLength = this.readInt();
        } while (n2 != 1297379947);
        this.trackData = new byte[this.trackLength];
        if (this.stream.read(this.trackData) != this.trackLength) {
            throw new EOFException();
        }
        this.pos = 0;
    }

    public boolean trackFinished() {
        return this.pos >= this.trackLength;
    }

    public void read(byte[] byArray) throws IOException {
        System.arraycopy(this.trackData, this.pos, byArray, 0, byArray.length);
        this.pos += byArray.length;
    }

    public SMFParser(InputStream inputStream) {
        this.stream = inputStream;
    }

    public void readTrack(Track track) throws IOException, InvalidMidiDataException {
        try {
            long l2 = 0L;
            int n2 = 0;
            boolean bl2 = false;
            while (!this.trackFinished() && !bl2) {
                MidiMessage midiMessage;
                int n3 = -1;
                int n4 = 0;
                l2 += this.readVarInt();
                int n5 = this.readUnsigned();
                if (n5 >= 128) {
                    n2 = n5;
                } else {
                    n3 = n5;
                }
                block1 : switch (n2 & 0xF0) {
                    case 128: 
                    case 144: 
                    case 160: 
                    case 176: 
                    case 224: {
                        if (n3 == -1) {
                            n3 = this.readUnsigned();
                        }
                        n4 = this.readUnsigned();
                        midiMessage = new FastShortMessage(n2 | n3 << 8 | n4 << 16);
                        break;
                    }
                    case 192: 
                    case 208: {
                        if (n3 == -1) {
                            n3 = this.readUnsigned();
                        }
                        midiMessage = new FastShortMessage(n2 | n3 << 8);
                        break;
                    }
                    case 240: {
                        switch (n2) {
                            case 240: 
                            case 247: {
                                int n6 = (int)this.readVarInt();
                                byte[] byArray = new byte[n6];
                                this.read(byArray);
                                SysexMessage sysexMessage = new SysexMessage();
                                sysexMessage.setMessage(n2, byArray, n6);
                                midiMessage = sysexMessage;
                                break block1;
                            }
                            case 255: {
                                int n7 = this.readUnsigned();
                                int n8 = (int)this.readVarInt();
                                byte[] byArray = new byte[n8];
                                this.read(byArray);
                                MetaMessage metaMessage = new MetaMessage();
                                metaMessage.setMessage(n7, byArray, n8);
                                midiMessage = metaMessage;
                                if (n7 != 47) break block1;
                                bl2 = true;
                                break block1;
                            }
                            default: {
                                throw new InvalidMidiDataException("Invalid status byte: " + n2);
                            }
                        }
                    }
                    default: {
                        throw new InvalidMidiDataException("Invalid status byte: " + n2);
                    }
                }
                track.add(new MidiEvent(midiMessage, l2));
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new EOFException();
        }
    }
}

