/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.io.Serializable;
import java.util.Locale;
import java.util.ResourceBundle;

public final class ComponentOrientation
implements Serializable {
    private static final int UNK_BIT = 1;
    private static final int HORIZ_BIT = 2;
    private static final int LTR_BIT = 4;
    public static final ComponentOrientation LEFT_TO_RIGHT = new ComponentOrientation(6);
    public static final ComponentOrientation RIGHT_TO_LEFT = new ComponentOrientation(2);
    public static final ComponentOrientation UNKNOWN = new ComponentOrientation(7);
    private int orientation;

    public boolean isHorizontal() {
        return (this.orientation & 2) != 0;
    }

    public boolean isLeftToRight() {
        return (this.orientation & 4) != 0;
    }

    private ComponentOrientation(int n2) {
        this.orientation = n2;
    }

    public static ComponentOrientation getOrientation(Locale locale) {
        String string = locale.getLanguage();
        if ("iw".equals(string) || "ar".equals(string) || "fa".equals(string) || "ur".equals(string)) {
            return RIGHT_TO_LEFT;
        }
        return LEFT_TO_RIGHT;
    }

    public static ComponentOrientation getOrientation(ResourceBundle resourceBundle) {
        ComponentOrientation componentOrientation = null;
        try {
            componentOrientation = (ComponentOrientation)resourceBundle.getObject("Orientation");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (componentOrientation == null) {
            componentOrientation = ComponentOrientation.getOrientation(resourceBundle.getLocale());
        }
        if (componentOrientation == null) {
            componentOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
        }
        return componentOrientation;
    }
}

