/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import sun.misc.ClassFileTransformer;
import sun.misc.CompoundEnumeration;
import sun.misc.Launcher;
import sun.misc.Resource;
import sun.misc.URLClassPath;
import sun.reflect.Reflection;
import sun.security.util.SecurityConstants;

public abstract class ClassLoader {
    private boolean initialized = false;
    private ClassLoader parent;
    private Hashtable package2certs = new Hashtable(11);
    Certificate[] nocerts;
    private Vector classes = new Vector();
    private Set domains = new HashSet();
    private HashMap packages = new HashMap();
    private static URLClassPath bootstrapClassPath;
    private static ClassLoader scl;
    private static boolean sclSet;
    private ProtectionDomain defaultDomain = null;
    private static Vector loadedLibraryNames;
    private static Vector systemNativeLibraries;
    private Vector nativeLibraries = new Vector();
    private static Stack nativeLibraryContext;
    private static String[] usr_paths;
    private static String[] sys_paths;
    private boolean defaultAssertionStatus = false;
    private Map packageAssertionStatus = null;
    Map classAssertionStatus = null;

    static {
        ClassLoader.registerNatives();
        loadedLibraryNames = new Vector();
        systemNativeLibraries = new Vector();
        nativeLibraryContext = new Stack();
    }

    protected ClassLoader() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        this.parent = ClassLoader.getSystemClassLoader();
        this.initialized = true;
    }

    private void check() {
        if (!this.initialized) {
            throw new SecurityException("ClassLoader object not initialized");
        }
    }

    public synchronized void clearAssertionStatus() {
        this.classAssertionStatus = new HashMap();
        this.packageAssertionStatus = new HashMap();
        this.defaultAssertionStatus = false;
    }

    private static synchronized void initSystemClassLoader() {
        if (!sclSet) {
            if (scl != null) {
                throw new IllegalStateException("recursive invocation");
            }
            Launcher launcher = Launcher.getLauncher();
            if (launcher != null) {
                Throwable throwable;
                block7: {
                    throwable = null;
                    scl = launcher.getClassLoader();
                    try {
                        SystemClassLoaderAction systemClassLoaderAction = new SystemClassLoaderAction(scl);
                        scl = (ClassLoader)AccessController.doPrivileged(systemClassLoaderAction);
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throwable = privilegedActionException.getCause();
                        if (!(throwable instanceof InvocationTargetException)) break block7;
                        throwable = throwable.getCause();
                    }
                }
                if (throwable != null) {
                    if (throwable instanceof Error) {
                        throw (Error)throwable;
                    }
                    throw new Error(throwable);
                }
            }
            sclSet = true;
        }
    }

    private void initializeJavaAssertionMaps() {
        int n2;
        this.classAssertionStatus = new HashMap();
        this.packageAssertionStatus = new HashMap();
        AssertionStatusDirectives assertionStatusDirectives = ClassLoader.retrieveDirectives();
        for (n2 = 0; n2 < assertionStatusDirectives.classes.length; ++n2) {
            this.classAssertionStatus.put(assertionStatusDirectives.classes[n2], assertionStatusDirectives.classEnabled[n2]);
        }
        for (n2 = 0; n2 < assertionStatusDirectives.packages.length; ++n2) {
            this.packageAssertionStatus.put(assertionStatusDirectives.packages[n2], assertionStatusDirectives.packageEnabled[n2]);
        }
        this.defaultAssertionStatus = assertionStatusDirectives.deflt;
    }

    private static native void registerNatives();

    public synchronized void setDefaultAssertionStatus(boolean bl2) {
        if (this.classAssertionStatus == null) {
            this.initializeJavaAssertionMaps();
        }
        this.defaultAssertionStatus = bl2;
    }

    private static native AssertionStatusDirectives retrieveDirectives();

    void addClass(Class clazz) {
        this.classes.addElement(clazz);
    }

    protected final void resolveClass(Class clazz) {
        this.check();
        this.resolveClass0(clazz);
    }

    private native void resolveClass0(Class var1);

    protected final Class defineClass(byte[] byArray, int n2, int n3) throws ClassFormatError {
        return this.defineClass(null, byArray, n2, n3, null);
    }

    static ClassLoader getCallerClassLoader() {
        Class clazz = Reflection.getCallerClass(3);
        if (clazz == null) {
            return null;
        }
        return clazz.getClassLoader0();
    }

    public final ClassLoader getParent() {
        ClassLoader classLoader;
        if (this.parent == null) {
            return null;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (classLoader = ClassLoader.getCallerClassLoader()) != null && !this.isAncestor(classLoader)) {
            securityManager.checkPermission(SecurityConstants.GET_CLASSLOADER_PERMISSION);
        }
        return this.parent;
    }

    public static ClassLoader getSystemClassLoader() {
        ClassLoader classLoader;
        ClassLoader.initSystemClassLoader();
        if (scl == null) {
            return null;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (classLoader = ClassLoader.getCallerClassLoader()) != null && classLoader != scl && !scl.isAncestor(classLoader)) {
            securityManager.checkPermission(SecurityConstants.GET_CLASSLOADER_PERMISSION);
        }
        return scl;
    }

    protected ClassLoader(ClassLoader classLoader) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        this.parent = classLoader;
        this.initialized = true;
    }

    boolean isAncestor(ClassLoader classLoader) {
        ClassLoader classLoader2 = this;
        do {
            if (classLoader != (classLoader2 = classLoader2.parent)) continue;
            return true;
        } while (classLoader2 != null);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Package[] getPackages() {
        Package[] packageArray = this.packages;
        synchronized (this.packages) {
            Map map = (Map)this.packages.clone();
            // ** MonitorExit[var2_1] (shouldn't be in output)
            packageArray = this.parent != null ? this.parent.getPackages() : Package.getSystemPackages();
            if (packageArray != null) {
                for (int i2 = 0; i2 < packageArray.length; ++i2) {
                    String string = packageArray[i2].getName();
                    if (map.get(string) != null) continue;
                    map.put(string, packageArray[i2]);
                }
            }
            return (Package[])map.values().toArray(new Package[map.size()]);
        }
    }

    synchronized boolean desiredAssertionStatus(String string) {
        Boolean bl2 = (Boolean)this.classAssertionStatus.get(string);
        if (bl2 != null) {
            return bl2;
        }
        int n2 = string.lastIndexOf(".");
        if (n2 < 0 && (bl2 = (Boolean)this.packageAssertionStatus.get(null)) != null) {
            return bl2;
        }
        while (n2 > 0) {
            bl2 = (Boolean)this.packageAssertionStatus.get(string = string.substring(0, n2));
            if (bl2 != null) {
                return bl2;
            }
            n2 = string.lastIndexOf(".", n2 - 1);
        }
        return this.defaultAssertionStatus;
    }

    public synchronized void setClassAssertionStatus(String string, boolean bl2) {
        if (this.classAssertionStatus == null) {
            this.initializeJavaAssertionMaps();
        }
        this.classAssertionStatus.put(string, bl2);
    }

    public synchronized void setPackageAssertionStatus(String string, boolean bl2) {
        if (this.packageAssertionStatus == null) {
            this.initializeJavaAssertionMaps();
        }
        this.packageAssertionStatus.put(string, bl2);
    }

    private synchronized ProtectionDomain getDefaultDomain() {
        if (this.defaultDomain == null) {
            CodeSource codeSource = new CodeSource(null, null);
            this.defaultDomain = new ProtectionDomain(codeSource, null, this, null);
        }
        return this.defaultDomain;
    }

    static Stack access$100() {
        return nativeLibraryContext;
    }

    static Vector access$000() {
        return loadedLibraryNames;
    }

    static URLClassPath getBootstrapClassPath() {
        if (bootstrapClassPath == null) {
            bootstrapClassPath = Launcher.getBootstrapClassPath();
        }
        return bootstrapClassPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean loadLibrary0(Class clazz, File file) {
        Vector vector;
        String string;
        Boolean bl2 = (Boolean)AccessController.doPrivileged(new PrivilegedAction(file){
            private final File val$file;
            {
                this.val$file = file;
            }

            public Object run() {
                return new Boolean(this.val$file.exists());
            }
        });
        if (!bl2.booleanValue()) {
            return false;
        }
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return false;
        }
        ClassLoader classLoader = clazz == null ? null : clazz.getClassLoader();
        Vector vector2 = vector = classLoader != null ? classLoader.nativeLibraries : systemNativeLibraries;
        synchronized (vector2) {
            int n2 = vector.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                NativeLibrary nativeLibrary = (NativeLibrary)vector.elementAt(i2);
                if (!string.equals(nativeLibrary.name)) continue;
                return true;
            }
            Vector vector3 = loadedLibraryNames;
            synchronized (vector3) {
                if (loadedLibraryNames.contains(string)) {
                    throw new UnsatisfiedLinkError("Native Library " + string + " already loaded in another classloader");
                }
                int n3 = nativeLibraryContext.size();
                for (int i3 = 0; i3 < n3; ++i3) {
                    NativeLibrary nativeLibrary = (NativeLibrary)nativeLibraryContext.elementAt(i3);
                    if (!string.equals(nativeLibrary.name)) continue;
                    if (classLoader == NativeLibrary.access$200(nativeLibrary).getClassLoader()) {
                        return true;
                    }
                    throw new UnsatisfiedLinkError("Native Library " + string + " is being loaded in another classloader");
                }
                NativeLibrary nativeLibrary = new NativeLibrary(clazz, string);
                nativeLibraryContext.push(nativeLibrary);
                try {
                    nativeLibrary.load(string);
                }
                finally {
                    nativeLibraryContext.pop();
                }
                if (nativeLibrary.handle != 0L) {
                    loadedLibraryNames.addElement(string);
                    vector.addElement(nativeLibrary);
                    return true;
                }
                return false;
            }
        }
    }

    public InputStream getResourceAsStream(String string) {
        URL uRL = this.getResource(string);
        try {
            return uRL != null ? uRL.openStream() : null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static InputStream getSystemResourceAsStream(String string) {
        URL uRL = ClassLoader.getSystemResource(string);
        try {
            return uRL != null ? uRL.openStream() : null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private native Class findBootstrapClass(String var1) throws ClassNotFoundException;

    private Class findBootstrapClass0(String string) throws ClassNotFoundException {
        this.check();
        return this.findBootstrapClass(string);
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        throw new ClassNotFoundException(string);
    }

    protected final native Class findLoadedClass(String var1);

    protected final Class findSystemClass(String string) throws ClassNotFoundException {
        this.check();
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        if (classLoader == null) {
            return this.findBootstrapClass(string);
        }
        return classLoader.loadClass(string);
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        return this.loadClass(string, false);
    }

    private synchronized Class loadClassInternal(String string) throws ClassNotFoundException {
        return this.loadClass(string);
    }

    protected synchronized Class loadClass(String string, boolean bl2) throws ClassNotFoundException {
        Class clazz = this.findLoadedClass(string);
        if (clazz == null) {
            try {
                clazz = this.parent != null ? this.parent.loadClass(string, false) : this.findBootstrapClass0(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = this.findClass(string);
            }
        }
        if (bl2) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    protected final Class defineClass(String string, byte[] byArray, int n2, int n3) throws ClassFormatError {
        return this.defineClass(string, byArray, n2, n3, null);
    }

    protected final void setSigners(Class clazz, Object[] objectArray) {
        this.check();
        clazz.setSigners(objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Package getPackage(String string) {
        HashMap hashMap = this.packages;
        synchronized (hashMap) {
            Package package_ = (Package)this.packages.get(string);
            if (package_ == null && (package_ = this.parent != null ? this.parent.getPackage(string) : Package.getSystemPackage(string)) != null) {
                this.packages.put(string, package_);
            }
            return package_;
        }
    }

    static void loadLibrary(Class clazz, String string, boolean bl2) {
        File file;
        int n2;
        String string2;
        ClassLoader classLoader;
        ClassLoader classLoader2 = classLoader = clazz == null ? null : clazz.getClassLoader();
        if (sys_paths == null) {
            usr_paths = ClassLoader.initializePath("java.library.path");
            sys_paths = ClassLoader.initializePath("sun.boot.library.path");
        }
        if (bl2) {
            if (ClassLoader.loadLibrary0(clazz, new File(string))) {
                return;
            }
            throw new UnsatisfiedLinkError("Can't load library: " + string);
        }
        if (classLoader != null && (string2 = classLoader.findLibrary(string)) != null) {
            File file2 = new File(string2);
            if (!file2.isAbsolute()) {
                throw new UnsatisfiedLinkError("ClassLoader.findLibrary failed to return an absolute path: " + string2);
            }
            if (ClassLoader.loadLibrary0(clazz, file2)) {
                return;
            }
            throw new UnsatisfiedLinkError("Can't load " + string2);
        }
        for (n2 = 0; n2 < sys_paths.length; ++n2) {
            file = new File(sys_paths[n2], System.mapLibraryName(string));
            if (!ClassLoader.loadLibrary0(clazz, file)) continue;
            return;
        }
        if (classLoader != null) {
            for (n2 = 0; n2 < usr_paths.length; ++n2) {
                file = new File(usr_paths[n2], System.mapLibraryName(string));
                if (!ClassLoader.loadLibrary0(clazz, file)) continue;
                return;
            }
        }
        throw new UnsatisfiedLinkError("no " + string + " in java.library.path");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long findNative(ClassLoader classLoader, String string) {
        Vector vector;
        Vector vector2 = vector = classLoader != null ? classLoader.nativeLibraries : systemNativeLibraries;
        synchronized (vector2) {
            int n2 = vector.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                NativeLibrary nativeLibrary = (NativeLibrary)vector.elementAt(i2);
                long l2 = nativeLibrary.find(string);
                if (l2 == 0L) continue;
                return l2;
            }
        }
        return 0L;
    }

    protected String findLibrary(String string) {
        return null;
    }

    private static String[] initializePath(String string) {
        String string2 = System.getProperty(string, "");
        String string3 = File.pathSeparator;
        int n2 = string2.length();
        int n3 = string2.indexOf(string3);
        int n4 = 0;
        while (n3 >= 0) {
            ++n4;
            n3 = string2.indexOf(string3, n3 + 1);
        }
        String[] stringArray = new String[n4 + 1];
        n3 = 0;
        n4 = 0;
        int n5 = string2.indexOf(string3);
        while (n5 >= 0) {
            if (n5 - n3 > 0) {
                stringArray[n4++] = string2.substring(n3, n5);
            } else if (n5 - n3 == 0) {
                stringArray[n4++] = ".";
            }
            n3 = n5 + 1;
            n5 = string2.indexOf(string3, n3);
        }
        stringArray[n4] = string2.substring(n3, n2);
        return stringArray;
    }

    protected URL findResource(String string) {
        return null;
    }

    private static URL getBootstrapResource(String string) {
        URLClassPath uRLClassPath = ClassLoader.getBootstrapClassPath();
        Resource resource = uRLClassPath.getResource(string);
        return resource != null ? resource.getURL() : null;
    }

    public URL getResource(String string) {
        URL uRL = this.parent != null ? this.parent.getResource(string) : ClassLoader.getBootstrapResource(string);
        if (uRL == null) {
            uRL = this.findResource(string);
        }
        return uRL;
    }

    public static URL getSystemResource(String string) {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        if (classLoader == null) {
            return ClassLoader.getBootstrapResource(string);
        }
        return classLoader.getResource(string);
    }

    private synchronized void checkCerts(String string, CodeSource codeSource) {
        int n2 = string.lastIndexOf(46);
        String string2 = n2 == -1 ? "" : string.substring(0, n2);
        Certificate[] certificateArray = (Certificate[])this.package2certs.get(string2);
        if (certificateArray == null) {
            if (codeSource != null) {
                certificateArray = codeSource.getCertificates();
            }
            if (certificateArray == null) {
                if (this.nocerts == null) {
                    this.nocerts = new Certificate[0];
                }
                certificateArray = this.nocerts;
            }
            this.package2certs.put(string2, certificateArray);
        } else {
            Certificate[] certificateArray2 = null;
            if (codeSource != null) {
                certificateArray2 = codeSource.getCertificates();
            }
            if (!this.compareCerts(certificateArray, certificateArray2)) {
                throw new SecurityException("class \"" + string + "\"'s signer information does not match signer information of other classes in the same package");
            }
        }
    }

    private void checkPackageAccess(Class clazz, ProtectionDomain protectionDomain) {
        String string;
        int n2;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (n2 = (string = clazz.getName()).lastIndexOf(46)) != -1) {
            AccessController.doPrivileged(new PrivilegedAction(this, securityManager, string, n2){
                private final SecurityManager val$sm;
                private final String val$name;
                private final int val$i;
                private final ClassLoader this$0;

                public Object run() {
                    this.val$sm.checkPackageAccess(this.val$name.substring(0, this.val$i));
                    return null;
                }
                {
                    this.this$0 = classLoader;
                    this.val$sm = securityManager;
                    this.val$name = string;
                    this.val$i = n2;
                }
            }, new AccessControlContext(new ProtectionDomain[]{protectionDomain}));
        }
        this.domains.add(protectionDomain);
    }

    private boolean compareCerts(Certificate[] certificateArray, Certificate[] certificateArray2) {
        int n2;
        boolean bl2;
        int n3;
        if (certificateArray2 == null || certificateArray2.length == 0) {
            return certificateArray.length == 0;
        }
        if (certificateArray2.length != certificateArray.length) {
            return false;
        }
        for (n3 = 0; n3 < certificateArray2.length; ++n3) {
            bl2 = false;
            for (n2 = 0; n2 < certificateArray.length; ++n2) {
                if (!certificateArray2[n3].equals(certificateArray[n2])) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            return false;
        }
        for (n3 = 0; n3 < certificateArray.length; ++n3) {
            bl2 = false;
            for (n2 = 0; n2 < certificateArray2.length; ++n2) {
                if (!certificateArray[n3].equals(certificateArray2[n2])) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            return false;
        }
        return true;
    }

    protected Enumeration findResources(String string) throws IOException {
        return new CompoundEnumeration(new Enumeration[0]);
    }

    private static Enumeration getBootstrapResources(String string) throws IOException {
        Enumeration enumeration = ClassLoader.getBootstrapClassPath().getResources(string);
        return new Enumeration(enumeration){
            private final Enumeration val$e;

            public boolean hasMoreElements() {
                return this.val$e.hasMoreElements();
            }

            public Object nextElement() {
                return ((Resource)this.val$e.nextElement()).getURL();
            }
            {
                this.val$e = enumeration;
            }
        };
    }

    public final Enumeration getResources(String string) throws IOException {
        Enumeration[] enumerationArray = new Enumeration[]{this.parent != null ? this.parent.getResources(string) : ClassLoader.getBootstrapResources(string), this.findResources(string)};
        return new CompoundEnumeration(enumerationArray);
    }

    public static Enumeration getSystemResources(String string) throws IOException {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        if (classLoader == null) {
            return ClassLoader.getBootstrapResources(string);
        }
        return classLoader.getResources(string);
    }

    protected final Class defineClass(String string, byte[] byArray, int n2, int n3, ProtectionDomain protectionDomain) throws ClassFormatError {
        Object[] objectArray;
        Class clazz;
        block9: {
            this.check();
            if (string != null && string.startsWith("java.")) {
                throw new SecurityException("Prohibited package name: " + string.substring(0, string.lastIndexOf(46)));
            }
            if (protectionDomain == null) {
                protectionDomain = this.getDefaultDomain();
            }
            if (string != null) {
                this.checkCerts(string, protectionDomain.getCodeSource());
            }
            clazz = null;
            try {
                clazz = this.defineClass0(string, byArray, n2, n3, protectionDomain);
            }
            catch (ClassFormatError classFormatError) {
                Object[] objectArray2 = ClassFileTransformer.getTransformers();
                for (int i2 = 0; objectArray2 != null && i2 < objectArray2.length; ++i2) {
                    try {
                        byte[] byArray2 = ((ClassFileTransformer)objectArray2[i2]).transform(byArray, n2, n3);
                        clazz = this.defineClass0(string, byArray2, 0, byArray2.length, protectionDomain);
                        break;
                    }
                    catch (ClassFormatError classFormatError2) {
                        continue;
                    }
                }
                if (clazz != null) break block9;
                throw classFormatError;
            }
        }
        if (protectionDomain.getCodeSource() != null && (objectArray = protectionDomain.getCodeSource().getCertificates()) != null) {
            this.setSigners(clazz, objectArray);
        }
        return clazz;
    }

    private native Class defineClass0(String var1, byte[] var2, int var3, int var4, ProtectionDomain var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Package definePackage(String string, String string2, String string3, String string4, String string5, String string6, String string7, URL uRL) throws IllegalArgumentException {
        HashMap hashMap = this.packages;
        synchronized (hashMap) {
            Package package_ = this.getPackage(string);
            if (package_ != null) {
                throw new IllegalArgumentException(string);
            }
            package_ = new Package(string, string2, string3, string4, string5, string6, string7, uRL);
            this.packages.put(string, package_);
            return package_;
        }
    }

    static class NativeLibrary {
        long handle;
        private int jniVersion;
        private Class fromClass;
        String name;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() {
            Vector vector = ClassLoader.access$000();
            synchronized (vector) {
                if (this.fromClass.getClassLoader() != null && this.handle != 0L) {
                    int n2 = ClassLoader.access$000().size();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        if (!this.name.equals(ClassLoader.access$000().elementAt(i2))) continue;
                        ClassLoader.access$000().removeElementAt(i2);
                        break;
                    }
                    ClassLoader.access$100().push(this);
                    try {
                        this.unload();
                    }
                    finally {
                        ClassLoader.access$100().pop();
                    }
                }
            }
        }

        native void unload();

        static Class getFromClass() {
            return ((NativeLibrary)ClassLoader.access$100().peek()).fromClass;
        }

        native long find(String var1);

        native void load(String var1);

        static Class access$200(NativeLibrary nativeLibrary) {
            return nativeLibrary.fromClass;
        }

        public NativeLibrary(Class clazz, String string) {
            this.name = string;
            this.fromClass = clazz;
        }
    }
}

