/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import sun.misc.ProxyGenerator;

public class Proxy
implements Serializable {
    private static final String proxyClassNamePrefix = "$Proxy";
    private static final Class[] constructorParams = new Class[]{class$java$lang$reflect$InvocationHandler == null ? (class$java$lang$reflect$InvocationHandler = Proxy.class$("java.lang.reflect.InvocationHandler")) : class$java$lang$reflect$InvocationHandler};
    private static Map loaderToCache = new WeakHashMap(3);
    private static Object pendingGenerationMarker = new Object();
    private static long nextUniqueNumber = 0L;
    private static Object nextUniqueNumberLock = new Object();
    private static Map proxyClasses = Collections.synchronizedMap(new WeakHashMap(3));
    protected InvocationHandler h;
    static Class class$java$lang$reflect$InvocationHandler;

    private Proxy() {
    }

    public static boolean isProxyClass(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        return proxyClasses.containsKey(clazz);
    }

    protected Proxy(InvocationHandler invocationHandler) {
        this.h = invocationHandler;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public static InvocationHandler getInvocationHandler(Object object) throws IllegalArgumentException {
        if (!Proxy.isProxyClass(object.getClass())) {
            throw new IllegalArgumentException("not a proxy instance");
        }
        Proxy proxy = (Proxy)object;
        return proxy.h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class getProxyClass(ClassLoader classLoader, Class[] classArray) throws IllegalArgumentException {
        Object object;
        Object object2;
        Class clazz = null;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            object2 = null;
            try {
                object2 = Class.forName(classArray[i2].getName(), false, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (object2 != classArray[i2]) {
                throw new IllegalArgumentException(classArray[i2] + " is not visible from class loader");
            }
            if (!((Class)object2).isInterface()) {
                throw new IllegalArgumentException(((Class)object2).getName() + " is not an interface");
            }
            stringBuffer.append(classArray[i2].getName()).append(';');
        }
        String string = stringBuffer.toString();
        Object object3 = loaderToCache;
        synchronized (object3) {
            object2 = (Map)loaderToCache.get(classLoader);
            if (object2 == null) {
                object2 = new HashMap(3);
                loaderToCache.put(classLoader, object2);
            }
        }
        object3 = object2;
        synchronized (object3) {
            while (true) {
                Object object4;
                if ((object4 = object2.get(string)) instanceof Reference) {
                    clazz = (Class)((Reference)object4).get();
                }
                if (clazz != null) {
                    return clazz;
                }
                if (object4 != pendingGenerationMarker) break;
                try {
                    object2.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            object2.put(string, pendingGenerationMarker);
        }
        try {
            long l2;
            Object object5;
            object3 = null;
            for (int i3 = 0; i3 < classArray.length; ++i3) {
                String string2;
                int n2 = classArray[i3].getModifiers();
                if (Modifier.isPublic(n2)) continue;
                object5 = classArray[i3].getName();
                int n3 = ((String)object5).lastIndexOf(46);
                String string3 = string2 = n3 == -1 ? "" : ((String)object5).substring(0, n3 + 1);
                if (object3 == null) {
                    object3 = string2;
                    continue;
                }
                if (string2.equals(object3)) continue;
                throw new IllegalArgumentException("non-public interfaces from different packages");
            }
            if (object3 == null) {
                object3 = "";
            }
            object5 = nextUniqueNumberLock;
            synchronized (object5) {
                l2 = nextUniqueNumber++;
            }
            object5 = (String)object3 + proxyClassNamePrefix + l2;
            byte[] byArray = ProxyGenerator.generateProxyClass((String)object5, classArray);
            try {
                clazz = Proxy.defineClass0(classLoader, (String)object5, byArray, 0, byArray.length);
            }
            catch (ClassFormatError classFormatError) {
                throw new IllegalArgumentException(classFormatError.toString());
            }
            proxyClasses.put(clazz, null);
            Object var14_22 = null;
            object = object2;
        }
        catch (Throwable throwable) {
            Object var14_23 = null;
            Object object6 = object2;
            synchronized (object6) {
                if (clazz != null) {
                    object2.put(string, new WeakReference(clazz));
                } else {
                    object2.remove(string);
                }
                object2.notifyAll();
            }
            throw throwable;
        }
        synchronized (object) {
            if (clazz != null) {
                object2.put(string, new WeakReference(clazz));
            } else {
                object2.remove(string);
            }
            object2.notifyAll();
        }
        return clazz;
    }

    private static native Class defineClass0(ClassLoader var0, String var1, byte[] var2, int var3, int var4);

    public static Object newProxyInstance(ClassLoader classLoader, Class[] classArray, InvocationHandler invocationHandler) throws IllegalArgumentException {
        if (invocationHandler == null) {
            throw new NullPointerException();
        }
        Class clazz = Proxy.getProxyClass(classLoader, classArray);
        try {
            Constructor constructor = clazz.getConstructor(constructorParams);
            return constructor.newInstance(new Object[]{invocationHandler});
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new InternalError(noSuchMethodException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InternalError(illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new InternalError(instantiationException.toString());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new InternalError(invocationTargetException.toString());
        }
    }
}

