/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.io.IOException;
import java.io.ObjectOutputStream;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;

public class JButton
extends AbstractButton
implements Accessible {
    private static final String uiClassID = "ButtonUI";
    private boolean defaultCapable = true;

    public JButton() {
        this(null, null);
    }

    public void removeNotify() {
        JRootPane jRootPane = SwingUtilities.getRootPane(this);
        if (jRootPane != null && jRootPane.getDefaultButton() == this) {
            jRootPane.setDefaultButton(null);
        }
        super.removeNotify();
    }

    public void updateUI() {
        this.setUI((ButtonUI)UIManager.getUI(this));
    }

    public boolean isDefaultButton() {
        JRootPane jRootPane = SwingUtilities.getRootPane(this);
        if (jRootPane != null) {
            return jRootPane.getDefaultButton() == this;
        }
        return false;
    }

    public boolean isDefaultCapable() {
        return this.defaultCapable;
    }

    public void setDefaultCapable(boolean bl2) {
        boolean bl3 = this.defaultCapable;
        this.defaultCapable = bl2;
        this.firePropertyChange("defaultCapable", bl3, bl2);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    public String getUIClassID() {
        return uiClassID;
    }

    protected String paramString() {
        String string = this.defaultCapable ? "true" : "false";
        return super.paramString() + ",defaultCapable=" + string;
    }

    public JButton(String string) {
        this(string, null);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJButton(this);
        }
        return this.accessibleContext;
    }

    public JButton(Action action) {
        this();
        this.setAction(action);
    }

    protected void configurePropertiesFromAction(Action action) {
        String[] stringArray = new String[]{"MnemonicKey", "ShortDescription", "SmallIcon", "ActionCommandKey", "enabled"};
        this.configurePropertiesFromAction(action, stringArray);
        Boolean bl2 = (Boolean)this.getClientProperty("hideActionText");
        this.setText(action != null && (bl2 == null || bl2 != Boolean.TRUE) ? (String)action.getValue("Name") : null);
    }

    public JButton(Icon icon) {
        this(null, icon);
    }

    public JButton(String string, Icon icon) {
        this.setModel(new DefaultButtonModel());
        this.init(string, icon);
    }

    protected class AccessibleJButton
    extends AbstractButton.AccessibleAbstractButton {
        private final JButton this$0;

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PUSH_BUTTON;
        }

        protected AccessibleJButton(JButton jButton) {
            this.this$0 = jButton;
            super(jButton);
        }
    }
}

