/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.util.Iterator;
import java.util.Map;
import sun.awt.ConstrainableGraphics;
import sun.awt.SunHints;
import sun.awt.font.FontDesignMetrics;
import sun.awt.font.NativeFontWrapper;
import sun.awt.font.ShapingException;
import sun.awt.font.StandardGlyphVector;
import sun.java2d.InvalidPipeException;
import sun.java2d.NullSurfaceData;
import sun.java2d.SurfaceData;
import sun.java2d.loops.Blit;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.FontInfo;
import sun.java2d.loops.MaskFill;
import sun.java2d.loops.RenderLoops;
import sun.java2d.loops.SurfaceType;
import sun.java2d.loops.XORComposite;
import sun.java2d.pipe.DrawImagePipe;
import sun.java2d.pipe.PixelDrawPipe;
import sun.java2d.pipe.PixelFillPipe;
import sun.java2d.pipe.Region;
import sun.java2d.pipe.ShapeDrawPipe;
import sun.java2d.pipe.ShapeSpanIterator;
import sun.java2d.pipe.TextPipe;
import sun.java2d.pipe.ValidatePipe;
import sun.misc.PerformanceLogger;

public final class SunGraphics2D
extends Graphics2D
implements ConstrainableGraphics,
Cloneable {
    public static final ColorModel XRGBModel = new DirectColorModel(24, 0xFF0000, 65280, 255);
    public static final int PAINT_TILE = 2;
    public static final int PAINT_SINGLECOLOR = 1;
    public static final int PAINT_SOLIDCOLOR = 0;
    public static final int COMP_CUSTOM = 3;
    public static final int COMP_XOR = 2;
    public static final int COMP_ALPHA = 1;
    public static final int COMP_ISCOPY = 0;
    public static final int STROKE_CUSTOM = 2;
    public static final int STROKE_WIDE = 1;
    public static final int STROKE_THIN = 0;
    public static final int TRANSFORM_GENERIC = 3;
    public static final int TRANSFORM_TRANSLATESCALE = 2;
    public static final int TRANSFORM_TRANSLATEONLY = 1;
    public static final int TRANSFORM_ISIDENT = 0;
    public static final int CLIP_SHAPE = 2;
    public static final int CLIP_RECTANGULAR = 1;
    public static final int CLIP_DEVICE = 0;
    public int rgb;
    public int pixel;
    public SurfaceData surfaceData;
    public PixelDrawPipe drawpipe;
    public PixelFillPipe fillpipe;
    public DrawImagePipe imagepipe;
    public ShapeDrawPipe shapepipe;
    public TextPipe textpipe;
    public MaskFill alphafill;
    public RenderLoops loops;
    public CompositeType fillComp;
    public CompositeType imageComp;
    public int paintState;
    public int compositeState;
    public int strokeState;
    public int transformState;
    public int clipState;
    public Color foregroundColor;
    public Color backgroundColor;
    public AffineTransform transform;
    public int transX;
    public int transY;
    public boolean complexTransform;
    protected static final Stroke defaultStroke = new BasicStroke();
    protected static final Composite defaultComposite = AlphaComposite.SrcOver;
    public Paint paint;
    public Stroke stroke;
    public Composite composite;
    protected Font font;
    protected FontMetrics fontMetrics;
    public int renderHint;
    public int antialiasHint;
    public int textAntialiasHint;
    private int fractionalMetricsHint;
    public int interpolationHint;
    public int strokeHint;
    public RenderingHints hints;
    public Region constrainClip;
    public int constrainX;
    public int constrainY;
    public Region clipRegion;
    public Shape usrClip;
    protected Region devClip;
    public FontInfo fontInfo;
    public FontInfo lastGlyphVectorFontInfo;
    private static final int slowTextTransformMask = 120;
    protected static ValidatePipe invalidpipe;
    private static double[] oldTx;
    private static final double[] IDENT_TX;
    public static FontDesignMetrics[] metricsCache;
    static final int NON_UNIFORM_SCALE_MASK = 36;
    public static final double MinPenSizeAASquared = 0.03999999538064003;
    public static final double MinPenSizeSquared = 1.000000001;
    static final int NON_RECTILINEAR_TRANSFORM_MASK = 48;
    Blit lastCAblit;
    Composite lastCAcomp;
    private FontRenderContext cachedFRC;
    static Class class$sun$java2d$SunGraphics2D;

    static {
        if (PerformanceLogger.loggingEnabled()) {
            PerformanceLogger.setTime("SunGraphics2D static initialization");
        }
        invalidpipe = new ValidatePipe();
        IDENT_TX = new double[]{1.0, 0.0, 0.0, 1.0};
        metricsCache = new FontDesignMetrics[5];
    }

    public void dispose() {
        this.surfaceData = NullSurfaceData.theInstance;
        this.invalidatePipe();
    }

    public void finalize() {
    }

    protected void invalidateClip() {
        this.clipRegion = null;
        int n2 = this.clipState;
        this.clipState = this.usrClip == null ? 0 : (this.usrClip instanceof Rectangle2D ? 1 : 2);
        this.getCompClip();
        if (n2 != this.clipState && (this.clipState == 2 || n2 == 2)) {
            this.invalidatePipe();
        }
    }

    protected void invalidatePipe() {
        this.drawpipe = invalidpipe;
        this.fillpipe = invalidpipe;
        this.shapepipe = invalidpipe;
        this.textpipe = invalidpipe;
        this.imagepipe = invalidpipe;
    }

    protected void invalidateTransform() {
        this.complexTransform = true;
        int n2 = this.transform.getType();
        int n3 = this.transformState;
        if (n2 == 0) {
            this.transformState = 0;
            this.complexTransform = false;
            this.transY = 0;
            this.transX = 0;
        } else if (n2 == 1) {
            this.transformState = 1;
            this.transX = (int)this.transform.getTranslateX();
            this.transY = (int)this.transform.getTranslateY();
        } else if ((n2 & 0x78) == 0) {
            this.transformState = 2;
            this.transY = 0;
            this.transX = 0;
        } else {
            this.transformState = 3;
            this.transY = 0;
            this.transX = 0;
        }
        if (this.transformState > 1 || n3 > 1) {
            this.cachedFRC = null;
            if (this.transformState != n3) {
                this.invalidatePipe();
            }
        }
        this.fontInfo = this.checkFontInfo(null, this.font);
        this.fontMetrics = null;
        this.lastGlyphVectorFontInfo = null;
        if (this.strokeState != 2) {
            this.validateBasicStroke((BasicStroke)this.stroke);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void revalidateAll() {
        this.surfaceData = this.surfaceData.getReplacement();
        this.setDevClip(this.surfaceData.getBounds());
        this.pixel = this.surfaceData.pixelFor(this.rgb);
        if (this.composite instanceof XORComposite) {
            Color color = ((XORComposite)this.composite).getXorColor();
            this.setComposite(new XORComposite(color, this.surfaceData));
        }
        this.validatePipe();
    }

    public void setPaintMode() {
        this.setComposite(AlphaComposite.SrcOver);
    }

    public void validatePipe() {
        this.surfaceData.validatePipe(this);
    }

    public void rotate(double d2) {
        this.transform.rotate(d2);
        this.invalidateTransform();
    }

    public void scale(double d2, double d3) {
        this.transform.scale(d2, d3);
        this.invalidateTransform();
    }

    public void shear(double d2, double d3) {
        this.transform.shear(d2, d3);
        this.invalidateTransform();
    }

    public void translate(double d2, double d3) {
        this.transform.translate(d2, d3);
        this.invalidateTransform();
    }

    public void rotate(double d2, double d3, double d4) {
        this.transform.rotate(d2, d3, d4);
        this.invalidateTransform();
    }

    public void translate(int n2, int n3) {
        this.transform.translate(n2, n3);
        if (!this.complexTransform) {
            this.transX += n2;
            this.transY += n3;
            this.transformState = this.transX == 0 && this.transY == 0 ? 0 : 1;
        } else {
            this.invalidateTransform();
        }
    }

    private static int getTileIndex(int n2, int n3, int n4) {
        if ((n2 -= n3) < 0) {
            n2 += 1 - n4;
        }
        return n2 / n4;
    }

    public void clearRect(int n2, int n3, int n4, int n5) {
        Composite composite = this.composite;
        Paint paint = this.paint;
        this.setComposite(AlphaComposite.Src);
        this.setColor(this.getBackground());
        this.validatePipe();
        this.fillRect(n2, n3, n4, n5);
        this.setPaint(paint);
        this.setComposite(composite);
    }

    public void clipRect(int n2, int n3, int n4, int n5) {
        this.clip(new Rectangle(n2, n3, n4, n5));
    }

    public void constrain(int n2, int n3, int n4, int n5) {
        if ((n2 | n3) != 0) {
            this.translate(n2, n3);
        }
        if (this.transformState > 1) {
            this.clipRect(0, 0, n4, n5);
            return;
        }
        n2 = this.constrainX = this.transX;
        n3 = this.constrainY = this.transY;
        n4 = Region.dimAdd(n2, n4);
        n5 = Region.dimAdd(n3, n5);
        Region region = this.constrainClip;
        if (region == null) {
            region = Region.getInstanceXYXY(n2, n3, n4, n5);
        } else if ((region = region.getIntersectionXYXY(n2, n3, n4, n5)) == this.constrainClip) {
            return;
        }
        this.constrainClip = region;
        if (!this.devClip.isInsideQuickCheck(region)) {
            this.devClip = this.devClip.getIntersection(region);
            this.invalidateClip();
        }
    }

    public void drawLine(int n2, int n3, int n4, int n5) {
        try {
            this.drawpipe.drawLine(this, n2, n3, n4, n5);
        }
        catch (InvalidPipeException invalidPipeException) {
            this.revalidateAll();
            try {
                this.drawpipe.drawLine(this, n2, n3, n4, n5);
            }
            catch (InvalidPipeException invalidPipeException2) {
                // empty catch block
            }
        }
    }

    public void drawOval(int n2, int n3, int n4, int n5) {
        try {
            this.drawpipe.drawOval(this, n2, n3, n4, n5);
        }
        catch (InvalidPipeException invalidPipeException) {
            this.revalidateAll();
            try {
                this.drawpipe.drawOval(this, n2, n3, n4, n5);
            }
            catch (InvalidPipeException invalidPipeException2) {
                // empty catch block
            }
        }
    }

    public void drawRect(int n2, int n3, int n4, int n5) {
        try {
            this.drawpipe.drawRect(this, n2, n3, n4, n5);
        }
        catch (InvalidPipeException invalidPipeException) {
            this.revalidateAll();
            try {
                this.drawpipe.drawRect(this, n2, n3, n4, n5);
            }
            catch (InvalidPipeException invalidPipeException2) {
                // empty catch block
            }
        }
    }

    public void fillOval(int n2, int n3, int n4, int n5) {
        try {
            this.fillpipe.fillOval(this, n2, n3, n4, n5);
        }
        catch (InvalidPipeException invalidPipeException) {
            this.revalidateAll();
            try {
                this.fillpipe.fillOval(this, n2, n3, n4, n5);
            }
            catch (InvalidPipeException invalidPipeException2) {
                // empty catch block
            }
        }
    }

    public void fillRect(int n2, int n3, int n4, int n5) {
        try {
            this.fillpipe.fillRect(this, n2, n3, n4, n5);
        }
        catch (InvalidPipeException invalidPipeException) {
            this.revalidateAll();
            try {
                this.fillpipe.fillRect(this, n2, n3, n4, n5);
            }
            catch (InvalidPipeException invalidPipeException2) {
                // empty catch block
            }
        }
    }

    public void setClip(int n2, int n3, int n4, int n5) {
        this.setClip(new Rectangle(n2, n3, n4, n5));
    }

    public void setDevClip(int n2, int n3, int n4, int n5) {
        Region region = this.constrainClip;
        this.devClip = region == null ? Region.getInstanceXYWH(n2, n3, n4, n5) : region.getIntersectionXYWH(n2, n3, n4, n5);
        this.invalidateClip();
    }

    public boolean hitClip(int n2, int n3, int n4, int n5) {
        if (n4 <= 0 || n5 <= 0) {
            return false;
        }
        if (this.transformState > 1) {
            double[] dArray = new double[]{n2, n3, n2 + n4, n3, n2, n3 + n5, n2 + n4, n3 + n5};
            this.transform.transform(dArray, 0, dArray, 0, 4);
            n2 = (int)Math.floor(Math.min(Math.min(dArray[0], dArray[2]), Math.min(dArray[4], dArray[6])));
            n3 = (int)Math.floor(Math.min(Math.min(dArray[1], dArray[3]), Math.min(dArray[5], dArray[7])));
            n4 = (int)Math.ceil(Math.max(Math.max(dArray[0], dArray[2]), Math.max(dArray[4], dArray[6])));
            n5 = (int)Math.ceil(Math.max(Math.max(dArray[1], dArray[3]), Math.max(dArray[5], dArray[7])));
        } else {
            n4 += (n2 += this.transX);
            n5 += (n3 += this.transY);
        }
        return this.getCompClip().intersectsQuickCheckXYXY(n2, n3, n4, n5);
    }

    public void copyArea(int n2, int n3, int n4, int n5, int n6, int n7) {
        Object object;
        if (n4 <= 0 || n5 <= 0) {
            return;
        }
        SurfaceData surfaceData = this.surfaceData;
        if (surfaceData.copyArea(this, n2, n3, n4, n5, n6, n7)) {
            return;
        }
        if (this.transformState > 1) {
            throw new InternalError("transformed copyArea not implemented yet");
        }
        if (this.clipState == 2) {
            throw new InternalError("clipped copyArea not implemented yet");
        }
        Composite composite = this.composite;
        if (this.lastCAcomp != composite) {
            object = surfaceData.getSurfaceType();
            CompositeType compositeType = this.imageComp;
            if (CompositeType.SrcOverNoEa.equals(compositeType) && surfaceData.getTransparency() == 1) {
                compositeType = CompositeType.SrcNoEa;
            }
            this.lastCAblit = Blit.locate((SurfaceType)object, compositeType, (SurfaceType)object);
            this.lastCAcomp = composite;
        }
        n2 += this.transX;
        n3 += this.transY;
        object = this.lastCAblit;
        if (n7 == 0 && n6 > 0 && n6 < n4) {
            while (n4 > 0) {
                int n8 = Math.min(n4, n6);
                int n9 = n2 + (n4 -= n8);
                ((Blit)object).Blit(surfaceData, surfaceData, composite, null, n9, n3, n9 + n6, n3 + n7, n8, n5);
            }
            return;
        }
        if (n7 > 0 && n7 < n5 && n6 > -n4 && n6 < n4) {
            while (n5 > 0) {
                int n10 = Math.min(n5, n7);
                int n11 = n3 + (n5 -= n10);
                ((Blit)object).Blit(surfaceData, surfaceData, composite, null, n2, n11, n2 + n6, n11 + n7, n4, n10);
            }
            return;
        }
        ((Blit)object).Blit(surfaceData, surfaceData, composite, null, n2, n3, n2 + n6, n3 + n7, n4, n5);
    }

    public void drawArc(int n2, int n3, int n4, int n5, int n6, int n7) {
        try {
            this.drawpipe.drawArc(this, n2, n3, n4, n5, n6, n7);
        }
        catch (InvalidPipeException invalidPipeException) {
            this.revalidateAll();
            try {
                this.drawpipe.drawArc(this, n2, n3, n4, n5, n6, n7);
            }
            catch (InvalidPipeException invalidPipeException2) {
                // empty catch block
            }
        }
    }

    public void drawRoundRect(int n2, int n3, int n4, int n5, int n6, int n7) {
        try {
            this.drawpipe.drawRoundRect(this, n2, n3, n4, n5, n6, n7);
        }
        catch (InvalidPipeException invalidPipeException) {
            this.revalidateAll();
            try {
                this.drawpipe.drawRoundRect(this, n2, n3, n4, n5, n6, n7);
            }
            catch (InvalidPipeException invalidPipeException2) {
                // empty catch block
            }
        }
    }

    public void fillArc(int n2, int n3, int n4, int n5, int n6, int n7) {
        try {
            this.fillpipe.fillArc(this, n2, n3, n4, n5, n6, n7);
        }
        catch (InvalidPipeException invalidPipeException) {
            this.revalidateAll();
            try {
                this.fillpipe.fillArc(this, n2, n3, n4, n5, n6, n7);
            }
            catch (InvalidPipeException invalidPipeException2) {
                // empty catch block
            }
        }
    }

    public void fillRoundRect(int n2, int n3, int n4, int n5, int n6, int n7) {
        try {
            this.fillpipe.fillRoundRect(this, n2, n3, n4, n5, n6, n7);
        }
        catch (InvalidPipeException invalidPipeException) {
            this.revalidateAll();
            try {
                this.fillpipe.fillRoundRect(this, n2, n3, n4, n5, n6, n7);
            }
            catch (InvalidPipeException invalidPipeException2) {
                // empty catch block
            }
        }
    }

    public void drawBytes(byte[] byArray, int n2, int n3, int n4, int n5) {
        if (byArray == null) {
            throw new NullPointerException("byte data is null");
        }
        try {
            try {
                this.textpipe.drawBytes(this, byArray, n2, n3, n4, n5);
            }
            catch (InvalidPipeException invalidPipeException) {
                this.revalidateAll();
                try {
                    this.textpipe.drawBytes(this, byArray, n2, n3, n4, n5);
                }
                catch (InvalidPipeException invalidPipeException2) {}
            }
        }
        catch (ShapingException shapingException) {
            TextLayout textLayout = new TextLayout(new String(byArray, 0, n2, n3), this.getFont(), this.getFontRenderContext());
            textLayout.draw(this, n4, n5);
        }
    }

    public void drawChars(char[] cArray, int n2, int n3, int n4, int n5) {
        if (cArray == null) {
            throw new NullPointerException("char data is null");
        }
        try {
            try {
                this.textpipe.drawChars(this, cArray, n2, n3, n4, n5);
            }
            catch (InvalidPipeException invalidPipeException) {
                this.revalidateAll();
                try {
                    this.textpipe.drawChars(this, cArray, n2, n3, n4, n5);
                }
                catch (InvalidPipeException invalidPipeException2) {}
            }
        }
        catch (ShapingException shapingException) {
            TextLayout textLayout = new TextLayout(new String(cArray, n2, n3), this.getFont(), this.getFontRenderContext());
            textLayout.draw(this, n4, n5);
        }
    }

    public static boolean isRotated(double[] dArray) {
        return dArray[0] != dArray[3] || dArray[1] != 0.0 || dArray[2] != 0.0 || !(dArray[0] > 0.0);
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n2) {
        try {
            this.drawpipe.drawPolygon(this, nArray, nArray2, n2);
        }
        catch (InvalidPipeException invalidPipeException) {
            this.revalidateAll();
            try {
                this.drawpipe.drawPolygon(this, nArray, nArray2, n2);
            }
            catch (InvalidPipeException invalidPipeException2) {
                // empty catch block
            }
        }
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n2) {
        try {
            this.drawpipe.drawPolyline(this, nArray, nArray2, n2);
        }
        catch (InvalidPipeException invalidPipeException) {
            this.revalidateAll();
            try {
                this.drawpipe.drawPolyline(this, nArray, nArray2, n2);
            }
            catch (InvalidPipeException invalidPipeException2) {
                // empty catch block
            }
        }
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n2) {
        try {
            this.fillpipe.fillPolygon(this, nArray, nArray2, n2);
        }
        catch (InvalidPipeException invalidPipeException) {
            this.revalidateAll();
            try {
                this.fillpipe.fillPolygon(this, nArray, nArray2, n2);
            }
            catch (InvalidPipeException invalidPipeException2) {
                // empty catch block
            }
        }
    }

    private void validateBasicStroke(BasicStroke basicStroke) {
        boolean bl2;
        boolean bl3 = bl2 = this.antialiasHint == 2;
        if (this.transformState <= 1) {
            this.strokeState = bl2 ? (basicStroke.getLineWidth() <= 0.19999999f && basicStroke.getDashArray() == null ? 0 : 1) : (basicStroke == defaultStroke || basicStroke.getLineWidth() <= 1.0f && basicStroke.getDashArray() == null ? 0 : 1);
        } else {
            double d2;
            if ((this.transform.getType() & 0x24) == 0) {
                d2 = Math.abs(this.transform.getDeterminant());
            } else {
                double d3 = this.transform.getScaleX();
                double d4 = this.transform.getShearX();
                double d5 = this.transform.getShearY();
                double d6 = this.transform.getScaleY();
                double d7 = d3 * d3 + d5 * d5;
                double d8 = 2.0 * (d3 * d4 + d5 * d6);
                double d9 = d4 * d4 + d6 * d6;
                double d10 = Math.sqrt(d8 * d8 + (d7 - d9) * (d7 - d9));
                d2 = (d7 + d9 + d10) / 2.0;
            }
            if (basicStroke != defaultStroke && (d2 *= (double)(basicStroke.getLineWidth() * basicStroke.getLineWidth())) <= 1.0 && basicStroke.getDashArray() != null) {
                d2 = 2.0;
            }
            this.strokeState = d2 <= (bl2 ? 0.03999999538064003 : 1.000000001) ? 0 : 1;
        }
    }

    public Color getBackground() {
        return this.backgroundColor;
    }

    public Color getColor() {
        return this.foregroundColor;
    }

    public void setBackground(Color color) {
        this.backgroundColor = color;
    }

    public void setColor(Color color) {
        int n2;
        if (color == null || color == this.paint) {
            return;
        }
        this.foregroundColor = color;
        this.paint = this.foregroundColor;
        this.rgb = n2 = this.foregroundColor.getRGB();
        this.pixel = this.surfaceData.pixelFor(n2);
        if (n2 >> 24 == -1) {
            if (this.paintState == 0) {
                return;
            }
            this.paintState = 0;
            if (this.imageComp == CompositeType.SrcOverNoEa) {
                this.compositeState = 0;
                this.fillComp = CompositeType.SrcNoEa;
                this.alphafill = null;
            }
        } else {
            if (this.paintState == 1) {
                return;
            }
            this.paintState = 1;
            if (this.imageComp == CompositeType.SrcOverNoEa) {
                this.compositeState = 1;
                this.fillComp = CompositeType.SrcOverNoEa;
                this.alphafill = null;
            }
        }
        this.invalidatePipe();
    }

    public void setXORMode(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("null XORColor");
        }
        this.setComposite(new XORComposite(color, this.surfaceData));
    }

    public Composite getComposite() {
        return this.composite;
    }

    public void setComposite(Composite composite) {
        int n2;
        CompositeType compositeType;
        if (this.composite == composite) {
            return;
        }
        if (composite instanceof AlphaComposite) {
            AlphaComposite alphaComposite = (AlphaComposite)composite;
            this.imageComp = compositeType = CompositeType.forAlphaComposite(alphaComposite);
            if (compositeType == CompositeType.SrcOverNoEa && (this.paintState == 0 || this.paintState == 2 && this.paint.getTransparency() == 1)) {
                compositeType = CompositeType.SrcNoEa;
                n2 = 0;
            } else {
                n2 = compositeType == CompositeType.SrcNoEa ? 0 : 1;
            }
        } else if (composite instanceof XORComposite) {
            n2 = 2;
            this.imageComp = compositeType = CompositeType.Xor;
        } else {
            if (composite == null) {
                throw new IllegalArgumentException("null Composite");
            }
            this.surfaceData.checkCustomComposite();
            n2 = 3;
            this.imageComp = compositeType = CompositeType.General;
        }
        if (this.compositeState != n2 || this.fillComp != compositeType) {
            this.compositeState = n2;
            this.fillComp = compositeType;
            this.alphafill = null;
            this.invalidatePipe();
        }
        this.composite = composite;
    }

    public Font getFont() {
        if (this.font == null) {
            this.font = new Font("Dialog", 10, 0);
        }
        return this.font;
    }

    public void setFont(Font font) {
        if (font != null && font != this.font) {
            this.font = font;
            this.fontMetrics = null;
            this.fontInfo = this.checkFontInfo(this.fontInfo, font);
        }
    }

    public Graphics create() {
        return (Graphics)this.clone();
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return this.surfaceData.getDeviceConfiguration();
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setPaint(Paint paint) {
        if (paint instanceof Color) {
            this.setColor((Color)paint);
            return;
        }
        if (paint == null || this.paint == paint) {
            return;
        }
        this.paint = paint;
        boolean bl2 = false;
        if (this.imageComp == CompositeType.SrcOverNoEa) {
            if (paint.getTransparency() == 1) {
                if (this.compositeState != 0) {
                    this.compositeState = 0;
                    this.fillComp = CompositeType.SrcNoEa;
                    this.alphafill = null;
                    bl2 = true;
                }
            } else if (this.compositeState == 0) {
                this.compositeState = 1;
                this.fillComp = CompositeType.SrcOverNoEa;
                this.alphafill = null;
                bl2 = true;
            }
        }
        if (bl2 || this.paintState != 2) {
            this.paintState = 2;
            this.invalidatePipe();
        }
    }

    public Rectangle getClipBounds() {
        Rectangle rectangle;
        if (this.clipState == 0) {
            rectangle = null;
        } else if (this.transformState < 2) {
            rectangle = this.usrClip instanceof Rectangle ? new Rectangle((Rectangle)this.usrClip) : this.usrClip.getBounds();
            rectangle.translate(-this.transX, -this.transY);
        } else {
            rectangle = this.getClip().getBounds();
        }
        return rectangle;
    }

    public void setDevClip(Rectangle rectangle) {
        this.setDevClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public RenderingHints getRenderingHints() {
        if (this.hints == null) {
            return this.makeHints(null);
        }
        return (RenderingHints)this.hints.clone();
    }

    public Shape getClip() {
        return this.untransformShape(this.usrClip);
    }

    public void clip(Shape shape) {
        shape = this.transformShape(shape);
        if (this.usrClip != null) {
            shape = this.intersectShapes(this.usrClip, shape, true, true);
        }
        this.usrClip = shape;
        this.invalidateClip();
    }

    public void draw(Shape shape) {
        try {
            this.shapepipe.draw(this, shape);
        }
        catch (InvalidPipeException invalidPipeException) {
            this.revalidateAll();
            try {
                this.shapepipe.draw(this, shape);
            }
            catch (InvalidPipeException invalidPipeException2) {
                // empty catch block
            }
        }
    }

    public void fill(Shape shape) {
        try {
            this.shapepipe.fill(this, shape);
        }
        catch (InvalidPipeException invalidPipeException) {
            this.revalidateAll();
            try {
                this.shapepipe.fill(this, shape);
            }
            catch (InvalidPipeException invalidPipeException2) {
                // empty catch block
            }
        }
    }

    public void setClip(Shape shape) {
        this.usrClip = this.transformShape(shape);
        this.invalidateClip();
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("null Stroke");
        }
        int n2 = this.strokeState;
        this.stroke = stroke;
        if (stroke instanceof BasicStroke) {
            this.validateBasicStroke((BasicStroke)stroke);
        } else {
            this.strokeState = 2;
        }
        if (this.strokeState != n2) {
            this.invalidatePipe();
        }
    }

    public FontRenderContext getFontRenderContext() {
        if (this.cachedFRC == null) {
            int n2 = this.textAntialiasHint == 0 ? this.antialiasHint : this.textAntialiasHint;
            this.cachedFRC = new FontRenderContext(this.transformState < 2 ? null : this.transform, n2 == 2, this.fractionalMetricsHint == 2);
        }
        return this.cachedFRC;
    }

    public void drawGlyphVector(GlyphVector glyphVector, float f2, float f3) {
        if (glyphVector == null) {
            throw new NullPointerException("glyphvector is null");
        }
        StandardGlyphVector standardGlyphVector = StandardGlyphVector.getStandardGV(glyphVector);
        if (standardGlyphVector.positions == null && !standardGlyphVector.getFontRenderContext().equals(this.getFontRenderContext())) {
            standardGlyphVector.performDefaultLayout();
        }
        try {
            this.textpipe.drawGlyphVector(this, standardGlyphVector, f2, f3);
        }
        catch (InvalidPipeException invalidPipeException) {
            this.revalidateAll();
            try {
                this.textpipe.drawGlyphVector(this, standardGlyphVector, f2, f3);
            }
            catch (InvalidPipeException invalidPipeException2) {
                // empty catch block
            }
        }
    }

    public AffineTransform cloneTransform() {
        return new AffineTransform(this.transform);
    }

    public AffineTransform getTransform() {
        if ((this.constrainX | this.constrainY) == 0) {
            return new AffineTransform(this.transform);
        }
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(-this.constrainX, -this.constrainY);
        affineTransform.concatenate(this.transform);
        return affineTransform;
    }

    public void setTransform(AffineTransform affineTransform) {
        if ((this.constrainX | this.constrainY) == 0) {
            this.transform.setTransform(affineTransform);
        } else {
            this.transform.setToTranslation(this.constrainX, this.constrainY);
            this.transform.concatenate(affineTransform);
        }
        this.invalidateTransform();
    }

    public void transform(AffineTransform affineTransform) {
        this.transform.concatenate(affineTransform);
        this.invalidateTransform();
    }

    private static boolean isIntegerTranslation(AffineTransform affineTransform) {
        if (affineTransform.isIdentity()) {
            return true;
        }
        if (affineTransform.getType() == 1) {
            double d2 = affineTransform.getTranslateX();
            double d3 = affineTransform.getTranslateY();
            return d2 == (double)((int)d2) && d3 == (double)((int)d3);
        }
        return false;
    }

    public ColorModel getDeviceColorModel() {
        return this.surfaceData.getColorModel();
    }

    protected Object clone() {
        try {
            SunGraphics2D sunGraphics2D = (SunGraphics2D)super.clone();
            sunGraphics2D.transform = new AffineTransform(this.transform);
            if (this.hints != null) {
                sunGraphics2D.hints = (RenderingHints)this.hints.clone();
            }
            return sunGraphics2D;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void drawString(String string, float f2, float f3) {
        if (string == null) {
            throw new NullPointerException("string is null");
        }
        try {
            try {
                this.textpipe.drawString(this, string, f2, f3);
            }
            catch (InvalidPipeException invalidPipeException) {
                this.revalidateAll();
                try {
                    this.textpipe.drawString(this, string, f2, f3);
                }
                catch (InvalidPipeException invalidPipeException2) {}
            }
        }
        catch (ShapingException shapingException) {
            TextLayout textLayout = new TextLayout(string, this.getFont(), this.getFontRenderContext());
            textLayout.draw(this, f2, f3);
        }
    }

    public void drawString(String string, int n2, int n3) {
        if (string == null) {
            throw new NullPointerException("string is null");
        }
        try {
            try {
                this.textpipe.drawString(this, string, n2, n3);
            }
            catch (InvalidPipeException invalidPipeException) {
                this.revalidateAll();
                try {
                    this.textpipe.drawString(this, string, n2, n3);
                }
                catch (InvalidPipeException invalidPipeException2) {}
            }
        }
        catch (ShapingException shapingException) {
            TextLayout textLayout = new TextLayout(string, this.getFont(), this.getFontRenderContext());
            textLayout.draw(this, n2, n3);
        }
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f2, float f3) {
        if (attributedCharacterIterator == null) {
            throw new NullPointerException("attributedcharacteriterator is null");
        }
        TextLayout textLayout = new TextLayout(attributedCharacterIterator, this.getFontRenderContext());
        textLayout.draw(this, f2, f3);
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n2, int n3) {
        if (attributedCharacterIterator == null) {
            throw new NullPointerException("attributedcharacteriterator is null");
        }
        TextLayout textLayout = new TextLayout(attributedCharacterIterator, this.getFontRenderContext());
        textLayout.draw(this, n2, n3);
    }

    public void addRenderingHints(Map map) {
        boolean bl2 = false;
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object == SunHints.KEY_RENDERING || object == SunHints.KEY_ANTIALIASING || object == SunHints.KEY_TEXT_ANTIALIASING || object == SunHints.KEY_FRACTIONALMETRICS || object == SunHints.KEY_STROKE_CONTROL || object == SunHints.KEY_INTERPOLATION) {
                this.setRenderingHint((RenderingHints.Key)object, map.get(object));
                continue;
            }
            bl2 = true;
        }
        if (bl2) {
            if (this.hints == null) {
                this.hints = this.makeHints(map);
            } else {
                this.hints.putAll(map);
            }
        }
    }

    public void setRenderingHints(Map map) {
        this.hints = null;
        this.renderHint = 0;
        this.antialiasHint = 1;
        this.textAntialiasHint = 0;
        this.fractionalMetricsHint = 1;
        this.interpolationHint = -1;
        boolean bl2 = false;
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object == SunHints.KEY_RENDERING || object == SunHints.KEY_ANTIALIASING || object == SunHints.KEY_TEXT_ANTIALIASING || object == SunHints.KEY_FRACTIONALMETRICS || object == SunHints.KEY_STROKE_CONTROL || object == SunHints.KEY_INTERPOLATION) {
                this.setRenderingHint((RenderingHints.Key)object, map.get(object));
                continue;
            }
            bl2 = true;
        }
        if (bl2) {
            this.hints = this.makeHints(map);
        }
        this.invalidatePipe();
    }

    public final SurfaceData getSurfaceData() {
        return this.surfaceData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Region getCompClip() {
        if (!this.surfaceData.isValid()) {
            this.revalidateAll();
        }
        if (this.clipRegion == null) {
            switch (this.clipState) {
                case 0: {
                    this.clipRegion = this.devClip;
                    break;
                }
                case 1: {
                    if (this.usrClip instanceof Rectangle) {
                        this.clipRegion = this.devClip.getIntersection((Rectangle)this.usrClip);
                        break;
                    }
                    this.clipRegion = this.devClip.getIntersection(this.usrClip.getBounds());
                    break;
                }
                case 2: {
                    PathIterator pathIterator = this.usrClip.getPathIterator(null);
                    int[] nArray = new int[4];
                    ShapeSpanIterator shapeSpanIterator = new ShapeSpanIterator(this, false);
                    try {
                        shapeSpanIterator.setOutputArea(this.devClip);
                        shapeSpanIterator.appendPath(pathIterator);
                        shapeSpanIterator.getPathBox(nArray);
                        Region region = Region.getInstance(nArray);
                        region.appendSpans(shapeSpanIterator);
                        this.clipRegion = region;
                        if (!region.isRectangular()) break;
                        this.clipState = 1;
                        break;
                    }
                    finally {
                        shapeSpanIterator.dispose();
                    }
                }
            }
        }
        return this.clipRegion;
    }

    public FontMetrics getFontMetrics(Font font) {
        if (this.fontMetrics != null && font == this.font) {
            return this.fontMetrics;
        }
        FontMetrics fontMetrics = NativeFontWrapper.usePlatformFontMetrics() ? Toolkit.getDefaultToolkit().getFontMetrics(font) : SunGraphics2D.makeFontMetrics(font, this.getFontRenderContext());
        if (this.font == font) {
            this.fontMetrics = fontMetrics;
        }
        return fontMetrics;
    }

    public Rectangle getClipBounds(Rectangle rectangle) {
        if (this.clipState != 0) {
            if (this.transformState < 2) {
                if (this.usrClip instanceof Rectangle) {
                    rectangle.setBounds((Rectangle)this.usrClip);
                } else {
                    rectangle.setBounds(this.usrClip.getBounds());
                }
                rectangle.translate(-this.transX, -this.transY);
            } else {
                rectangle.setBounds(this.getClip().getBounds());
            }
        } else if (rectangle == null) {
            throw new NullPointerException("null rectangle parameter");
        }
        return rectangle;
    }

    private boolean clipTo(Rectangle rectangle, Rectangle rectangle2) {
        int n2 = Math.max(rectangle.x, rectangle2.x);
        int n3 = Math.min(rectangle.x + rectangle.width, rectangle2.x + rectangle2.width);
        int n4 = Math.max(rectangle.y, rectangle2.y);
        int n5 = Math.min(rectangle.y + rectangle.height, rectangle2.y + rectangle2.height);
        if (n3 - n2 < 0 || n5 - n4 < 0) {
            rectangle.width = -1;
            rectangle.height = -1;
            return false;
        }
        rectangle.x = n2;
        rectangle.y = n4;
        rectangle.width = n3 - n2;
        rectangle.height = n5 - n4;
        return true;
    }

    private void drawTranslatedRenderedImage(RenderedImage renderedImage, Rectangle rectangle, int n2, int n3) {
        int n4 = renderedImage.getTileGridXOffset();
        int n5 = renderedImage.getTileGridYOffset();
        int n6 = renderedImage.getTileWidth();
        int n7 = renderedImage.getTileHeight();
        int n8 = SunGraphics2D.getTileIndex(rectangle.x, n4, n6);
        int n9 = SunGraphics2D.getTileIndex(rectangle.y, n5, n7);
        int n10 = SunGraphics2D.getTileIndex(rectangle.x + rectangle.width - 1, n4, n6);
        int n11 = SunGraphics2D.getTileIndex(rectangle.y + rectangle.height - 1, n5, n7);
        ColorModel colorModel = renderedImage.getColorModel();
        Rectangle rectangle2 = new Rectangle();
        for (int i2 = n9; i2 <= n11; ++i2) {
            for (int i3 = n8; i3 <= n10; ++i3) {
                Raster raster = renderedImage.getTile(i3, i2);
                rectangle2.x = i3 * n6 + n4;
                rectangle2.y = i2 * n7 + n5;
                rectangle2.width = n6;
                rectangle2.height = n7;
                this.clipTo(rectangle2, rectangle);
                WritableRaster writableRaster = null;
                writableRaster = raster instanceof WritableRaster ? (WritableRaster)raster : Raster.createWritableRaster(raster.getSampleModel(), raster.getDataBuffer(), null);
                writableRaster = writableRaster.createWritableChild(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, 0, 0, null);
                BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
                this.copyImage(bufferedImage, rectangle2.x + n2, rectangle2.y + n3, 0, 0, rectangle2.width, rectangle2.height, null, null);
            }
        }
    }

    RenderingHints makeHints(Map map) {
        Object object;
        RenderingHints renderingHints = new RenderingHints(map);
        renderingHints.put(SunHints.KEY_RENDERING, SunHints.Value.get(0, this.renderHint));
        renderingHints.put(SunHints.KEY_ANTIALIASING, SunHints.Value.get(1, this.antialiasHint));
        renderingHints.put(SunHints.KEY_TEXT_ANTIALIASING, SunHints.Value.get(2, this.textAntialiasHint));
        renderingHints.put(SunHints.KEY_FRACTIONALMETRICS, SunHints.Value.get(3, this.fractionalMetricsHint));
        switch (this.interpolationHint) {
            case 1: {
                object = SunHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
                break;
            }
            case 2: {
                object = SunHints.VALUE_INTERPOLATION_BILINEAR;
                break;
            }
            default: {
                object = null;
            }
        }
        if (object != null) {
            renderingHints.put(SunHints.KEY_INTERPOLATION, object);
        }
        renderingHints.put(SunHints.KEY_STROKE_CONTROL, SunHints.Value.get(8, this.strokeHint));
        return renderingHints;
    }

    public boolean hit(Rectangle rectangle, Shape shape, boolean bl2) {
        if (bl2) {
            shape = this.stroke.createStrokedShape(shape);
        }
        shape = this.transformShape(shape);
        if ((this.constrainX | this.constrainY) != 0) {
            rectangle = new Rectangle(rectangle);
            rectangle.translate(this.constrainX, this.constrainY);
        }
        return shape.intersects(rectangle);
    }

    protected static Shape transformShape(int n2, int n3, Shape shape) {
        if (shape == null) {
            return null;
        }
        if (shape instanceof Rectangle) {
            Rectangle rectangle = shape.getBounds();
            rectangle.translate(n2, n3);
            return rectangle;
        }
        if (shape instanceof Rectangle2D) {
            Rectangle2D rectangle2D = (Rectangle2D)shape;
            return new Rectangle2D.Double(rectangle2D.getX() + (double)n2, rectangle2D.getY() + (double)n3, rectangle2D.getWidth(), rectangle2D.getHeight());
        }
        if (n2 == 0 && n3 == 0) {
            return SunGraphics2D.cloneShape(shape);
        }
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(n2, n3);
        return affineTransform.createTransformedShape(shape);
    }

    protected static Shape cloneShape(Shape shape) {
        return new GeneralPath(shape);
    }

    protected Shape transformShape(Shape shape) {
        if (shape == null) {
            return null;
        }
        if (this.complexTransform) {
            return SunGraphics2D.transformShape(this.transform, shape);
        }
        return SunGraphics2D.transformShape(this.transX, this.transY, shape);
    }

    public Shape untransformShape(Shape shape) {
        if (shape == null) {
            return null;
        }
        if (this.complexTransform) {
            try {
                return SunGraphics2D.transformShape(this.transform.createInverse(), shape);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                return null;
            }
        }
        return SunGraphics2D.transformShape(-this.transX, -this.transY, shape);
    }

    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        if (renderedImage instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)renderedImage;
            this.drawImage(bufferedImage, affineTransform, null);
            return;
        }
        boolean bl2 = (this.transformState == 0 || this.transformState == 1 && this.transform.getTranslateX() == (double)this.transX && this.transform.getTranslateY() == (double)this.transY) && SunGraphics2D.isIntegerTranslation(affineTransform);
        int n2 = bl2 ? 0 : 3;
        Rectangle rectangle = SunGraphics2D.getImageRegion(renderedImage, this.getCompClip(), this.transform, affineTransform, n2, n2);
        if (rectangle.width <= 0 || rectangle.height <= 0) {
            return;
        }
        if (bl2) {
            this.drawTranslatedRenderedImage(renderedImage, rectangle, (int)affineTransform.getTranslateX(), (int)affineTransform.getTranslateY());
            return;
        }
        Raster raster = renderedImage.getData(rectangle);
        WritableRaster writableRaster = Raster.createWritableRaster(raster.getSampleModel(), raster.getDataBuffer(), null);
        int n3 = raster.getMinX();
        int n4 = raster.getMinY();
        int n5 = raster.getWidth();
        int n6 = raster.getHeight();
        int n7 = n3 - raster.getSampleModelTranslateX();
        int n8 = n4 - raster.getSampleModelTranslateY();
        if (n7 != 0 || n8 != 0 || n5 != writableRaster.getWidth() || n6 != writableRaster.getHeight()) {
            writableRaster = writableRaster.createWritableChild(n7, n8, n5, n6, 0, 0, null);
        }
        AffineTransform affineTransform2 = (AffineTransform)affineTransform.clone();
        affineTransform2.translate(n3, n4);
        ColorModel colorModel = renderedImage.getColorModel();
        BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
        this.drawImage(bufferedImage, affineTransform2, null);
    }

    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
        AffineTransform affineTransform2;
        AffineTransform affineTransform3 = this.transform;
        AffineTransform affineTransform4 = new AffineTransform(affineTransform);
        affineTransform4.concatenate(affineTransform3);
        RenderContext renderContext = new RenderContext(affineTransform4);
        try {
            affineTransform2 = affineTransform3.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            renderContext = new RenderContext(affineTransform3);
            affineTransform2 = new AffineTransform();
        }
        RenderedImage renderedImage = renderableImage.createRendering(renderContext);
        this.drawRenderedImage(renderedImage, affineTransform2);
    }

    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n2, int n3) {
        try {
            this.imagepipe.transformImage(this, bufferedImage, bufferedImageOp, n2, n3);
        }
        catch (InvalidPipeException invalidPipeException) {
            this.revalidateAll();
            try {
                this.imagepipe.transformImage(this, bufferedImage, bufferedImageOp, n2, n3);
            }
            catch (InvalidPipeException invalidPipeException2) {
                // empty catch block
            }
        }
    }

    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, ImageObserver imageObserver) {
        return this.drawImage(image, n2, n3, n4, n5, n6, n7, n8, n9, null, imageObserver);
    }

    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, ImageObserver imageObserver) {
        return this.drawImage(image, n2, n3, n4, n5, null, imageObserver);
    }

    public boolean drawImage(Image image, int n2, int n3, ImageObserver imageObserver) {
        return this.drawImage(image, n2, n3, null, imageObserver);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public Object getRenderingHint(RenderingHints.Key key) {
        if (this.hints != null) {
            return this.hints.get(key);
        }
        if (!(key instanceof SunHints.Key)) {
            return null;
        }
        int n2 = ((SunHints.Key)key).getIndex();
        switch (n2) {
            case 0: {
                return SunHints.Value.get(0, this.renderHint);
            }
            case 1: {
                return SunHints.Value.get(1, this.antialiasHint);
            }
            case 2: {
                return SunHints.Value.get(2, this.textAntialiasHint);
            }
            case 3: {
                return SunHints.Value.get(3, this.fractionalMetricsHint);
            }
            case 5: {
                switch (this.interpolationHint) {
                    case 1: {
                        return SunHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
                    }
                    case 2: {
                        return SunHints.VALUE_INTERPOLATION_BILINEAR;
                    }
                }
                return null;
            }
            case 8: {
                return SunHints.Value.get(8, this.strokeHint);
            }
        }
        return null;
    }

    public void setRenderingHint(RenderingHints.Key key, Object object) {
        if (!key.isCompatibleValue(object)) {
            throw new IllegalArgumentException(object + " is not compatible with " + key);
        }
        if (key instanceof SunHints.Key) {
            boolean bl2;
            boolean bl3 = false;
            boolean bl4 = true;
            SunHints.Key key2 = (SunHints.Key)key;
            int n2 = ((SunHints.Value)object).getIndex();
            switch (key2.getIndex()) {
                case 0: {
                    bl2 = this.renderHint != n2;
                    this.renderHint = n2;
                    break;
                }
                case 1: {
                    bl2 = this.antialiasHint != n2;
                    this.antialiasHint = n2;
                    if (!bl2) break;
                    boolean bl5 = bl3 = this.textAntialiasHint == 0;
                    if (this.strokeState == 2) break;
                    this.validateBasicStroke((BasicStroke)this.stroke);
                    break;
                }
                case 2: {
                    bl3 = bl2 = this.textAntialiasHint != n2;
                    this.textAntialiasHint = n2;
                    break;
                }
                case 3: {
                    bl3 = bl2 = this.fractionalMetricsHint != n2;
                    this.fractionalMetricsHint = n2;
                    break;
                }
                case 5: {
                    switch (n2) {
                        case 1: 
                        case 2: {
                            n2 = 2;
                            break;
                        }
                        default: {
                            n2 = 1;
                        }
                    }
                    bl2 = this.interpolationHint != n2;
                    this.interpolationHint = n2;
                    break;
                }
                case 8: {
                    bl2 = this.strokeHint != n2;
                    this.strokeHint = n2;
                    break;
                }
                default: {
                    bl4 = false;
                    bl2 = false;
                }
            }
            if (bl4) {
                if (bl2) {
                    this.invalidatePipe();
                    if (bl3) {
                        this.fontMetrics = null;
                        this.cachedFRC = null;
                        this.fontInfo = this.checkFontInfo(null, this.font);
                        this.lastGlyphVectorFontInfo = null;
                    }
                }
                if (this.hints != null) {
                    this.hints.put(key, object);
                }
                return;
            }
        }
        if (this.hints == null) {
            this.hints = this.makeHints(null);
        }
        this.hints.put(key, object);
    }

    public static synchronized FontMetrics makeFontMetrics(Font font, FontRenderContext fontRenderContext) {
        FontDesignMetrics fontDesignMetrics;
        int n2;
        FontDesignMetrics fontDesignMetrics2 = null;
        for (n2 = 0; n2 < metricsCache.length && (fontDesignMetrics = metricsCache[n2]) != null; ++n2) {
            if (!fontDesignMetrics.getFont().equals(font) || !fontDesignMetrics.getFRC().equals(fontRenderContext)) continue;
            fontDesignMetrics2 = fontDesignMetrics;
            break;
        }
        if (fontDesignMetrics2 == null) {
            fontDesignMetrics2 = new FontDesignMetrics(font, fontRenderContext);
            if (n2 == metricsCache.length) {
                --n2;
            }
        }
        if (n2 > 0) {
            System.arraycopy(metricsCache, 0, metricsCache, 1, n2);
        }
        SunGraphics2D.metricsCache[0] = fontDesignMetrics2;
        return fontDesignMetrics2;
    }

    protected Rectangle transformBounds(Rectangle rectangle, AffineTransform affineTransform) {
        if (affineTransform.isIdentity()) {
            return rectangle;
        }
        Shape shape = SunGraphics2D.transformShape(affineTransform, rectangle);
        return shape.getBounds();
    }

    Shape intersectByArea(Shape shape, Shape shape2, boolean bl2, boolean bl3) {
        Area area;
        if (!bl2 && shape instanceof Area) {
            area = (Area)shape;
        } else if (!bl3 && shape2 instanceof Area) {
            area = (Area)shape2;
            shape2 = shape;
        } else {
            area = new Area(shape);
        }
        Area area2 = shape2 instanceof Area ? (Area)shape2 : new Area(shape2);
        area.intersect(area2);
        if (area.isRectangular()) {
            return area.getBounds();
        }
        return area;
    }

    Shape intersectShapes(Shape shape, Shape shape2, boolean bl2, boolean bl3) {
        if (shape instanceof Rectangle && shape2 instanceof Rectangle) {
            return ((Rectangle)shape).intersection((Rectangle)shape2);
        }
        if (shape instanceof Rectangle2D) {
            return this.intersectRectShape((Rectangle2D)shape, shape2, bl2, bl3);
        }
        if (shape2 instanceof Rectangle2D) {
            return this.intersectRectShape((Rectangle2D)shape2, shape, bl3, bl2);
        }
        return this.intersectByArea(shape, shape2, bl2, bl3);
    }

    protected static Shape transformShape(AffineTransform affineTransform, Shape shape) {
        if (shape == null) {
            return null;
        }
        if (shape instanceof Rectangle2D && (affineTransform.getType() & 0x30) == 0) {
            double[] dArray;
            Rectangle2D rectangle2D = (Rectangle2D)shape;
            dArray = new double[]{rectangle2D.getX(), rectangle2D.getY(), dArray[0] + rectangle2D.getWidth(), dArray[1] + rectangle2D.getHeight()};
            affineTransform.transform(dArray, 0, dArray, 0, 2);
            rectangle2D = new Rectangle2D.Float();
            rectangle2D.setFrameFromDiagonal(dArray[0], dArray[1], dArray[2], dArray[3]);
            return rectangle2D;
        }
        if (affineTransform.isIdentity()) {
            return SunGraphics2D.cloneShape(shape);
        }
        return affineTransform.createTransformedShape(shape);
    }

    Shape intersectRectShape(Rectangle2D rectangle2D, Shape shape, boolean bl2, boolean bl3) {
        if (shape instanceof Rectangle2D) {
            Rectangle2D rectangle2D2 = (Rectangle2D)shape;
            Rectangle2D rectangle2D3 = !bl2 ? rectangle2D : (!bl3 ? rectangle2D2 : new Rectangle2D.Float());
            double d2 = Math.max(rectangle2D.getX(), rectangle2D2.getX());
            double d3 = Math.min(rectangle2D.getX() + rectangle2D.getWidth(), rectangle2D2.getX() + rectangle2D2.getWidth());
            double d4 = Math.max(rectangle2D.getY(), rectangle2D2.getY());
            double d5 = Math.min(rectangle2D.getY() + rectangle2D.getHeight(), rectangle2D2.getY() + rectangle2D2.getHeight());
            if (d3 - d2 < 0.0 || d5 - d4 < 0.0) {
                rectangle2D3.setFrameFromDiagonal(0.0, 0.0, 0.0, 0.0);
            } else {
                rectangle2D3.setFrameFromDiagonal(d2, d4, d3, d5);
            }
            return rectangle2D3;
        }
        if (rectangle2D.contains(shape.getBounds2D())) {
            if (bl3) {
                shape = SunGraphics2D.cloneShape(shape);
            }
            return shape;
        }
        return this.intersectByArea(rectangle2D, shape, bl2, bl3);
    }

    protected BufferedImage convertCM(BufferedImage bufferedImage, ColorModel colorModel) {
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(bufferedImage.getWidth(), bufferedImage.getHeight());
        BufferedImage bufferedImage2 = new BufferedImage(colorModel, writableRaster, bufferedImage.isAlphaPremultiplied(), null);
        for (int i2 = 0; i2 < bufferedImage.getHeight(); ++i2) {
            for (int i3 = 0; i3 < bufferedImage.getWidth(); ++i3) {
                bufferedImage2.setRGB(i3, i2, bufferedImage.getRGB(i3, i2));
            }
        }
        return bufferedImage2;
    }

    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Color color, ImageObserver imageObserver) {
        if (n2 == n4 || n3 == n5 || n6 == n8 || n7 == n9) {
            return true;
        }
        if (this.transformState < 2 && n8 - n6 == n4 - n2 && n9 - n7 == n5 - n3) {
            int n10;
            int n11;
            int n12;
            int n13;
            int n14;
            int n15;
            if (n8 > n6) {
                n15 = n8 - n6;
                n14 = n6;
                n13 = n2;
            } else {
                n15 = n6 - n8;
                n14 = n8;
                n13 = n4;
            }
            if (n9 > n7) {
                n12 = n9 - n7;
                n11 = n7;
                n10 = n3;
            } else {
                n12 = n7 - n9;
                n11 = n9;
                n10 = n5;
            }
            return this.copyImage(image, n13, n10, n14, n11, n15, n12, color, imageObserver);
        }
        try {
            return this.imagepipe.scaleImage(this, image, n2, n3, n4, n5, n6, n7, n8, n9, color, imageObserver);
        }
        catch (InvalidPipeException invalidPipeException) {
            this.revalidateAll();
            try {
                return this.imagepipe.scaleImage(this, image, n2, n3, n4, n5, n6, n7, n8, n9, color, imageObserver);
            }
            catch (InvalidPipeException invalidPipeException2) {
                return false;
            }
        }
    }

    public boolean copyImage(Image image, int n2, int n3, int n4, int n5, int n6, int n7, Color color, ImageObserver imageObserver) {
        try {
            return this.imagepipe.copyImage(this, image, n2, n3, n4, n5, n6, n7, color, imageObserver);
        }
        catch (InvalidPipeException invalidPipeException) {
            this.revalidateAll();
            try {
                return this.imagepipe.copyImage(this, image, n2, n3, n4, n5, n6, n7, color, imageObserver);
            }
            catch (InvalidPipeException invalidPipeException2) {
                return false;
            }
        }
    }

    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, Color color, ImageObserver imageObserver) {
        if (n4 == 0 || n5 == 0) {
            return true;
        }
        if (n4 == image.getWidth(null) && n5 == image.getHeight(null) && this.transformState < 2) {
            return this.copyImage(image, n2, n3, 0, 0, n4, n5, color, imageObserver);
        }
        try {
            return this.imagepipe.scaleImage(this, image, n2, n3, n4, n5, color, imageObserver);
        }
        catch (InvalidPipeException invalidPipeException) {
            this.revalidateAll();
            try {
                return this.imagepipe.scaleImage(this, image, n2, n3, n4, n5, color, imageObserver);
            }
            catch (InvalidPipeException invalidPipeException2) {
                return false;
            }
        }
    }

    public boolean drawImage(Image image, int n2, int n3, Color color, ImageObserver imageObserver) {
        try {
            return this.imagepipe.copyImage(this, image, n2, n3, color, imageObserver);
        }
        catch (InvalidPipeException invalidPipeException) {
            this.revalidateAll();
            try {
                return this.imagepipe.copyImage(this, image, n2, n3, color, imageObserver);
            }
            catch (InvalidPipeException invalidPipeException2) {
                return false;
            }
        }
    }

    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        if (this.transformState < 2 && (affineTransform == null || affineTransform.isIdentity())) {
            return this.drawImage(image, 0, 0, null, imageObserver);
        }
        try {
            return this.imagepipe.transformImage(this, image, affineTransform, imageObserver);
        }
        catch (InvalidPipeException invalidPipeException) {
            this.revalidateAll();
            try {
                return this.imagepipe.transformImage(this, image, affineTransform, imageObserver);
            }
            catch (InvalidPipeException invalidPipeException2) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FontInfo checkFontInfo(FontInfo fontInfo, Font font) {
        if (fontInfo == null || fontInfo.font != font) {
            Serializable serializable;
            boolean bl2;
            FontInfo fontInfo2 = new FontInfo();
            fontInfo2.font = font;
            float f2 = font.getSize2D();
            if (font.isTransformed()) {
                bl2 = true;
                serializable = font.getTransform();
                ((AffineTransform)serializable).scale(f2, f2);
                int n2 = ((AffineTransform)serializable).getType();
                fontInfo2.originX = (float)((AffineTransform)serializable).getTranslateX();
                fontInfo2.originY = (float)((AffineTransform)serializable).getTranslateY();
                if (this.transformState > 1) {
                    ((AffineTransform)serializable).preConcatenate(this.transform);
                    fontInfo2.devTx = new double[4];
                    this.transform.getMatrix(fontInfo2.devTx);
                } else {
                    fontInfo2.devTx = IDENT_TX;
                }
                fontInfo2.glyphTx = new double[4];
                ((AffineTransform)serializable).getMatrix(fontInfo2.glyphTx);
            } else {
                boolean bl3 = false;
                if (this.transformState > 1) {
                    bl2 = true;
                    fontInfo2.devTx = new double[4];
                    this.transform.getMatrix(fontInfo2.devTx);
                    fontInfo2.glyphTx = new double[4];
                    for (int i2 = 0; i2 < 4; ++i2) {
                        fontInfo2.glyphTx[i2] = fontInfo2.devTx[i2] * (double)f2;
                    }
                    fontInfo2.pixelHeight = (int)Math.abs(this.transform.getScaleY() * (double)f2);
                } else {
                    bl2 = false;
                    serializable = class$sun$java2d$SunGraphics2D == null ? (class$sun$java2d$SunGraphics2D = SunGraphics2D.class$("sun.java2d.SunGraphics2D")) : class$sun$java2d$SunGraphics2D;
                    synchronized (serializable) {
                        if (oldTx == null || oldTx[0] != (double)f2) {
                            oldTx = new double[]{f2, 0.0, 0.0, f2};
                        }
                        fontInfo2.glyphTx = oldTx;
                    }
                    fontInfo2.pixelHeight = (int)f2;
                    fontInfo2.devTx = IDENT_TX;
                }
            }
            fontInfo2.rotate = bl2 && SunGraphics2D.isRotated(fontInfo2.glyphTx) ? NativeFontWrapper.fontCanRotate(font) : 1;
            int n3 = this.textAntialiasHint;
            if (n3 == 0) {
                n3 = this.antialiasHint;
            }
            fontInfo2.doAntiAlias = n3 == 2;
            fontInfo2.doFractEnable = this.fractionalMetricsHint == 2;
            fontInfo = fontInfo2;
        }
        return fontInfo;
    }

    public SunGraphics2D(SurfaceData surfaceData, Color color, Color color2, Font font) {
        int n2;
        this.foregroundColor = color;
        this.backgroundColor = color2;
        this.rgb = n2 = color.getRGB();
        this.pixel = surfaceData.pixelFor(n2);
        this.transform = new AffineTransform();
        this.stroke = defaultStroke;
        this.composite = defaultComposite;
        this.paint = this.foregroundColor;
        this.fillComp = CompositeType.SrcNoEa;
        this.imageComp = CompositeType.SrcOverNoEa;
        this.renderHint = 0;
        this.antialiasHint = 1;
        this.textAntialiasHint = 0;
        this.fractionalMetricsHint = 1;
        this.interpolationHint = -1;
        this.strokeHint = 0;
        this.font = font;
        if (this.font == null) {
            this.font = new Font("Dialog", 10, 0);
        }
        this.fontInfo = this.checkFontInfo(null, this.font);
        this.surfaceData = surfaceData;
        this.loops = surfaceData.getRenderLoops(this);
        this.setDevClip(surfaceData.getBounds());
        this.invalidatePipe();
    }

    public WritableRaster convertRaster(Raster raster, ColorModel colorModel, ColorModel colorModel2) {
        if (colorModel instanceof IndexColorModel && (colorModel2.equals(ColorModel.getRGBdefault()) || colorModel2.equals(XRGBModel))) {
            IndexColorModel indexColorModel = (IndexColorModel)colorModel;
            BufferedImage bufferedImage = indexColorModel.convertToIntDiscrete(raster, false);
            return bufferedImage.getRaster();
        }
        BufferedImage bufferedImage = new BufferedImage(colorModel2, colorModel2.createCompatibleWritableRaster(raster.getWidth(), raster.getHeight()), colorModel2.isAlphaPremultiplied(), null);
        Object object = raster.getDataElements(0, 0, null);
        for (int i2 = 0; i2 < bufferedImage.getHeight(); ++i2) {
            for (int i3 = 0; i3 < bufferedImage.getWidth(); ++i3) {
                bufferedImage.setRGB(i3, i2, colorModel.getRGB(raster.getDataElements(i3, i2, object)));
            }
        }
        return bufferedImage.getRaster();
    }

    private static Rectangle getImageRegion(RenderedImage renderedImage, Region region, AffineTransform affineTransform, AffineTransform affineTransform2, int n2, int n3) {
        Rectangle rectangle = new Rectangle(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight());
        Rectangle rectangle2 = null;
        try {
            double d2;
            double d3;
            double[] dArray = new double[8];
            dArray[0] = dArray[2] = (double)region.getLoX();
            dArray[4] = dArray[6] = (double)region.getHiX();
            dArray[1] = dArray[5] = (double)region.getLoY();
            dArray[3] = dArray[7] = (double)region.getHiY();
            affineTransform.inverseTransform(dArray, 0, dArray, 0, 4);
            affineTransform2.inverseTransform(dArray, 0, dArray, 0, 4);
            double d4 = d3 = dArray[0];
            double d5 = d2 = dArray[1];
            int n4 = 2;
            while (n4 < 8) {
                int n5 = n4++;
                double d6 = dArray[n5];
                if (d6 < d4) {
                    d4 = d6;
                } else if (d6 > d3) {
                    d3 = d6;
                }
                d6 = dArray[n4++];
                if (d6 < d5) {
                    d5 = d6;
                    continue;
                }
                if (!(d6 > d2)) continue;
                d2 = d6;
            }
            n4 = (int)d4 - n2;
            int n6 = (int)(d3 - d4 + (double)(2 * n2));
            int n7 = (int)d5 - n3;
            int n8 = (int)(d2 - d5 + (double)(2 * n3));
            Rectangle rectangle3 = new Rectangle(n4, n7, n6, n8);
            rectangle2 = rectangle3.intersection(rectangle);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            rectangle2 = rectangle;
        }
        return rectangle2;
    }
}

