/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;
import sun.nio.ch.IOUtil;
import sun.security.action.LoadLibraryAction;

class Util {
    private static final int TEMP_BUF_POOL_SIZE = 3;
    private static ThreadLocal[] bufferPool;
    private static ThreadLocal localSelector;
    private static Unsafe unsafe;
    private static int pageSize;
    private static Constructor directByteBufferConstructor;
    private static Constructor directByteBufferRConstructor;
    private static boolean loaded;
    static final boolean $assertionsDisabled;
    static Class class$sun$nio$ch$Util;
    static Class class$java$lang$Runnable;

    static int pageSize() {
        if (pageSize == -1) {
            pageSize = Util.unsafe().pageSize();
        }
        return pageSize;
    }

    static {
        $assertionsDisabled = !(class$sun$nio$ch$Util == null ? (class$sun$nio$ch$Util = Util.class$("sun.nio.ch.Util")) : class$sun$nio$ch$Util).desiredAssertionStatus();
        bufferPool = new ThreadLocal[3];
        for (int i2 = 0; i2 < 3; ++i2) {
            Util.bufferPool[i2] = new ThreadLocal();
        }
        localSelector = new ThreadLocal();
        unsafe = Unsafe.getUnsafe();
        pageSize = -1;
        directByteBufferConstructor = null;
        directByteBufferRConstructor = null;
        loaded = false;
    }

    Util() {
    }

    private static void initDBBConstructor() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Class clazz = Class.forName("java.nio.DirectByteBuffer");
                    Util.access$002(clazz.getDeclaredConstructor(new Class[]{Integer.TYPE, Long.TYPE, class$java$lang$Runnable == null ? (class$java$lang$Runnable = Util.class$("java.lang.Runnable")) : class$java$lang$Runnable}));
                    Util.access$000().setAccessible(true);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new InternalError();
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new InternalError();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new InternalError();
                }
                catch (ClassCastException classCastException) {
                    throw new InternalError();
                }
                return null;
            }
        });
    }

    private static void initDBBRConstructor() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Class clazz = Class.forName("java.nio.DirectByteBufferR");
                    Util.access$102(clazz.getDeclaredConstructor(new Class[]{Integer.TYPE, Long.TYPE, class$java$lang$Runnable == null ? (class$java$lang$Runnable = Util.class$("java.lang.Runnable")) : class$java$lang$Runnable}));
                    Util.access$100().setAccessible(true);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new InternalError();
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new InternalError();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new InternalError();
                }
                catch (ClassCastException classCastException) {
                    throw new InternalError();
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void load() {
        Class clazz = class$sun$nio$ch$Util == null ? (class$sun$nio$ch$Util = Util.class$("sun.nio.ch.Util")) : class$sun$nio$ch$Util;
        synchronized (clazz) {
            if (loaded) {
                return;
            }
            loaded = true;
            AccessController.doPrivileged(new LoadLibraryAction("net"));
            AccessController.doPrivileged(new LoadLibraryAction("nio"));
            IOUtil.initIDs();
        }
    }

    private static byte _get(long l2) {
        return unsafe.getByte(l2);
    }

    private static void _put(long l2, byte by) {
        unsafe.putByte(l2, by);
    }

    static Constructor access$000() {
        return directByteBufferConstructor;
    }

    static Constructor access$100() {
        return directByteBufferRConstructor;
    }

    static ByteBuffer getTemporaryDirectBuffer(int n2) {
        ByteBuffer byteBuffer = null;
        for (int i2 = 0; i2 < 3; ++i2) {
            SoftReference softReference = (SoftReference)bufferPool[i2].get();
            if (softReference == null || (byteBuffer = (ByteBuffer)softReference.get()) == null || byteBuffer.capacity() < n2) continue;
            byteBuffer.rewind();
            byteBuffer.limit(n2);
            bufferPool[i2].set(null);
            return byteBuffer;
        }
        return ByteBuffer.allocateDirect(n2);
    }

    static void erase(ByteBuffer byteBuffer) {
        unsafe.setMemory(((DirectBuffer)((Object)byteBuffer)).address(), byteBuffer.capacity(), (byte)0);
    }

    static void releaseTemporaryDirectBuffer(ByteBuffer byteBuffer) {
        SoftReference softReference;
        int n2;
        for (n2 = 0; n2 < 3; ++n2) {
            softReference = (SoftReference)bufferPool[n2].get();
            if (softReference != null && softReference.get() != null) continue;
            bufferPool[n2].set(new SoftReference(byteBuffer));
            return;
        }
        for (n2 = 0; n2 < 3; ++n2) {
            softReference = (SoftReference)bufferPool[n2].get();
            ByteBuffer byteBuffer2 = (ByteBuffer)softReference.get();
            if (byteBuffer.capacity() <= byteBuffer2.capacity()) continue;
            bufferPool[n2].set(new SoftReference(byteBuffer));
            return;
        }
    }

    static Unsafe unsafe() {
        return unsafe;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static Constructor access$002(Constructor constructor) {
        directByteBufferConstructor = constructor;
        return directByteBufferConstructor;
    }

    static Constructor access$102(Constructor constructor) {
        directByteBufferRConstructor = constructor;
        return directByteBufferRConstructor;
    }

    static ByteBuffer[] subsequence(ByteBuffer[] byteBufferArray, int n2, int n3) {
        if (n2 == 0 && n3 == byteBufferArray.length) {
            return byteBufferArray;
        }
        int n4 = n3;
        ByteBuffer[] byteBufferArray2 = new ByteBuffer[n4];
        for (int i2 = 0; i2 < n4; ++i2) {
            byteBufferArray2[i2] = byteBufferArray[n2 + i2];
        }
        return byteBufferArray2;
    }

    static MappedByteBuffer newMappedByteBuffer(int n2, long l2, Runnable runnable) {
        MappedByteBuffer mappedByteBuffer;
        if (directByteBufferConstructor == null) {
            Util.initDBBConstructor();
        }
        try {
            mappedByteBuffer = (MappedByteBuffer)directByteBufferConstructor.newInstance(new Object[]{new Integer(n2), new Long(l2), runnable});
        }
        catch (InstantiationException instantiationException) {
            throw new InternalError();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InternalError();
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new InternalError();
        }
        return mappedByteBuffer;
    }

    static MappedByteBuffer newMappedByteBufferR(int n2, long l2, Runnable runnable) {
        MappedByteBuffer mappedByteBuffer;
        if (directByteBufferRConstructor == null) {
            Util.initDBBRConstructor();
        }
        try {
            mappedByteBuffer = (MappedByteBuffer)directByteBufferRConstructor.newInstance(new Object[]{new Integer(n2), new Long(l2), runnable});
        }
        catch (InstantiationException instantiationException) {
            throw new InternalError();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InternalError();
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new InternalError();
        }
        return mappedByteBuffer;
    }

    static Selector getTemporarySelector(SelectableChannel selectableChannel) throws IOException {
        SoftReference softReference = (SoftReference)localSelector.get();
        Selector selector = null;
        if (softReference == null || (selector = (Selector)softReference.get()) == null || selector.provider() != selectableChannel.provider()) {
            selector = selectableChannel.provider().openSelector();
            localSelector.set(new SoftReference(selector));
        } else {
            selector.selectNow();
            if (!$assertionsDisabled && !selector.keys().isEmpty()) {
                throw new AssertionError((Object)"Temporary selector not empty");
            }
        }
        return selector;
    }
}

